/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl;

import java.lang.reflect.Field;
import java.nio.ByteOrder;
import org.cojen.tupl.Utils;
import sun.misc.Unsafe;

class Hasher {
    private static final Hasher INSTANCE;

    Hasher() {
    }

    public static long hash(long hash, byte[] b) {
        return INSTANCE.doHash(hash, b);
    }

    long doHash(long hash, byte[] b) {
        int len = b.length;
        hash ^= (long)len;
        if (len < 8) {
            long v = 0L;
            switch (len) {
                case 7: {
                    v = v << 8 | (long)b[6] & 0xFFL;
                }
                case 6: {
                    v = v << 8 | (long)b[5] & 0xFFL;
                }
                case 5: {
                    v = v << 8 | (long)b[4] & 0xFFL;
                }
                case 4: {
                    v = v << 8 | (long)b[3] & 0xFFL;
                }
                case 3: {
                    v = v << 8 | (long)b[2] & 0xFFL;
                }
                case 2: {
                    v = v << 8 | (long)b[1] & 0xFFL;
                }
                case 1: {
                    v = v << 8 | (long)b[0] & 0xFFL;
                }
            }
            hash = (hash << 5) - hash + Utils.scramble(v);
            return hash;
        }
        int end = len & 0xFFFFFFF8;
        for (int i = 0; i < end; i += 8) {
            hash = (hash << 5) - hash + Utils.scramble(Utils.decodeLongLE(b, i));
        }
        if ((len & 7) != 0) {
            hash = (hash << 5) - hash + Utils.scramble(Utils.decodeLongLE(b, len - 8));
        }
        return hash;
    }

    static Unsafe getUnsafe() {
        if (INSTANCE instanceof UnsafeLE) {
            return UnsafeLE.UNSAFE;
        }
        return null;
    }

    static {
        String arch;
        Hasher instance = null;
        if (ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN && ((arch = System.getProperty("os.arch")).equals("i386") || arch.equals("x86") || arch.equals("amd64") || arch.equals("x86_64"))) {
            try {
                instance = new UnsafeLE();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        INSTANCE = instance == null ? new Hasher() : instance;
    }

    private static class UnsafeLE
    extends Hasher {
        static final Unsafe UNSAFE;
        private static final long BYTE_ARRAY_OFFSET;

        private UnsafeLE() {
        }

        @Override
        long doHash(long hash, byte[] b) {
            int len = b.length;
            hash ^= (long)len;
            if (len < 8) {
                long v = 0L;
                switch (len) {
                    case 7: {
                        v = v << 8 | (long)b[6] & 0xFFL;
                    }
                    case 6: {
                        v = v << 8 | (long)b[5] & 0xFFL;
                    }
                    case 5: {
                        v = v << 8 | (long)b[4] & 0xFFL;
                    }
                    case 4: {
                        v = v << 8 | (long)b[3] & 0xFFL;
                    }
                    case 3: {
                        v = v << 8 | (long)b[2] & 0xFFL;
                    }
                    case 2: {
                        v = v << 8 | (long)b[1] & 0xFFL;
                    }
                    case 1: {
                        v = v << 8 | (long)b[0] & 0xFFL;
                    }
                }
                hash = (hash << 5) - hash ^ Utils.scramble(v);
                return hash;
            }
            int end = len & 0xFFFFFFF8;
            for (int i = 0; i < end; i += 8) {
                hash = (hash << 5) - hash ^ Utils.scramble(UNSAFE.getLong(b, BYTE_ARRAY_OFFSET + (long)i));
            }
            if ((len & 7) != 0) {
                hash = (hash << 5) - hash ^ Utils.scramble(UNSAFE.getLong(b, BYTE_ARRAY_OFFSET + (long)len - 8L));
            }
            return hash;
        }

        static {
            try {
                Field theUnsafe = Unsafe.class.getDeclaredField("theUnsafe");
                theUnsafe.setAccessible(true);
                UNSAFE = (Unsafe)theUnsafe.get(null);
                BYTE_ARRAY_OFFSET = UNSAFE.arrayBaseOffset(byte[].class);
            }
            catch (Throwable e) {
                throw new ExceptionInInitializerError();
            }
        }
    }
}

