/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl;

import java.io.IOException;
import org.cojen.tupl.CommitLock;
import org.cojen.tupl.EventListener;
import org.cojen.tupl.EventType;
import org.cojen.tupl.LocalDatabase;
import org.cojen.tupl.LocalTransaction;
import org.cojen.tupl.Node;
import org.cojen.tupl.PageOps;
import org.cojen.tupl.Transaction;
import org.cojen.tupl.Tree;
import org.cojen.tupl.TreeCursor;
import org.cojen.tupl.Utils;

final class FragmentedTrash {
    final Tree mTrash;

    FragmentedTrash(Tree trash) {
        this.mTrash = trash;
    }

    void add(LocalTransaction txn, long indexId, byte[] entry, int keyStart, int keyLen, int valueStart, int valueLen) throws IOException {
        byte[] payload = new byte[valueLen];
        PageOps.p_copyToArray(entry, valueStart, payload, 0, valueLen);
        TreeCursor cursor = this.prepareEntry(txn.txnId());
        byte[] key = cursor.key();
        try {
            txn.setHasTrash();
            cursor.store(payload);
            cursor.reset();
        }
        catch (Throwable e) {
            txn.borked(e, false);
            throw Utils.closeOnFailure(cursor, e);
        }
        int tidLen = key.length - 8;
        int payloadLen = keyLen + tidLen;
        if (payloadLen > payload.length) {
            payload = new byte[payloadLen];
        }
        PageOps.p_copyToArray(entry, keyStart, payload, 0, keyLen);
        System.arraycopy(key, 8, payload, keyLen, tidLen);
        txn.pushUndeleteFragmented(indexId, payload, 0, payloadLen);
    }

    private TreeCursor prepareEntry(long txnId) throws IOException {
        byte[] prefix = new byte[8];
        Utils.encodeLongBE(prefix, 0, txnId);
        TreeCursor cursor = new TreeCursor(this.mTrash, Transaction.BOGUS);
        try {
            cursor.autoload(false);
            cursor.findGt(prefix);
            byte[] key = cursor.key();
            if (key == null || Utils.compareUnsigned(key, 0, 8, prefix, 0, 8) != 0) {
                key = new byte[9];
                System.arraycopy(prefix, 0, key, 0, 8);
                key[8] = -1;
                cursor.findNearby(key);
            } else {
                cursor.findNearby(Utils.decrementReverseUnsignedVar(key, 8));
            }
            return cursor;
        }
        catch (Throwable e) {
            throw Utils.closeOnFailure(cursor, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void remove(long txnId, Tree index, byte[] undoEntry) throws IOException {
        byte[] fragmented;
        byte[] trashKey;
        byte[] indexKey;
        byte[] undo = PageOps.p_transfer(undoEntry);
        try {
            Node dbAccess = this.mTrash.mRoot;
            indexKey = Node.retrieveKeyAtLoc(dbAccess, undo, 0);
            int tidLoc = Node.keyLengthAtLoc(undo, 0);
            int tidLen = undoEntry.length - tidLoc;
            trashKey = new byte[8 + tidLen];
            Utils.encodeLongBE(trashKey, 0, txnId);
            PageOps.p_copyToArray(undo, tidLoc, trashKey, 8, tidLen);
        }
        finally {
            PageOps.p_delete(undo);
        }
        TreeCursor cursor = new TreeCursor(this.mTrash, Transaction.BOGUS);
        try {
            cursor.find(trashKey);
            fragmented = cursor.value();
            if (fragmented == null) {
                cursor.reset();
                return;
            }
            cursor.store(null);
            cursor.reset();
        }
        catch (Throwable e) {
            throw Utils.closeOnFailure(cursor, e);
        }
        cursor = new TreeCursor(index, Transaction.BOGUS);
        try {
            cursor.find(indexKey);
            cursor.storeFragmented(fragmented);
            cursor.reset();
        }
        catch (Throwable e) {
            throw Utils.closeOnFailure(cursor, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void emptyTrash(long txnId) throws IOException {
        byte[] prefix = new byte[8];
        Utils.encodeLongBE(prefix, 0, txnId);
        LocalDatabase db = this.mTrash.mDatabase;
        CommitLock commitLock = db.commitLock();
        TreeCursor cursor = new TreeCursor(this.mTrash, Transaction.BOGUS);
        try {
            byte[] key;
            cursor.autoload(false);
            cursor.findGt(prefix);
            while ((key = cursor.key()) != null && Utils.compareUnsigned(key, 0, 8, prefix, 0, 8) == 0) {
                cursor.load();
                byte[] value = cursor.value();
                byte[] fragmented = PageOps.p_transfer(value);
                commitLock.acquireShared();
                try {
                    db.deleteFragments(fragmented, 0, value.length);
                    cursor.store(null);
                }
                finally {
                    commitLock.releaseShared();
                    PageOps.p_delete(fragmented);
                }
                cursor.next();
            }
            cursor.reset();
        }
        catch (Throwable e) {
            throw Utils.closeOnFailure(cursor, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean emptyAllTrash(EventListener listener) throws IOException {
        boolean found = false;
        LocalDatabase db = this.mTrash.mDatabase;
        CommitLock commitLock = db.commitLock();
        TreeCursor cursor = new TreeCursor(this.mTrash, Transaction.BOGUS);
        try {
            cursor.first();
            if (cursor.key() != null) {
                if (listener != null) {
                    listener.notify(EventType.RECOVERY_DELETE_FRAGMENTS, "Deleting unused large fragments", new Object[0]);
                }
                found = true;
                do {
                    byte[] value = cursor.value();
                    byte[] fragmented = PageOps.p_transfer(value);
                    try {
                        commitLock.acquireShared();
                        try {
                            db.deleteFragments(fragmented, 0, value.length);
                            cursor.store(null);
                        }
                        finally {
                            commitLock.releaseShared();
                        }
                    }
                    finally {
                        PageOps.p_delete(fragmented);
                    }
                    cursor.next();
                } while (cursor.key() != null);
            }
            cursor.reset();
        }
        catch (Throwable e) {
            throw Utils.closeOnFailure(cursor, e);
        }
        return found;
    }
}

