/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl;

import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.util.BitSet;
import java.util.EnumSet;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.cojen.tupl.CorruptDatabaseException;
import org.cojen.tupl.Crypto;
import org.cojen.tupl.CryptoPageArray;
import org.cojen.tupl.DatabaseException;
import org.cojen.tupl.LocalDatabase;
import org.cojen.tupl.Node;
import org.cojen.tupl.PageCache;
import org.cojen.tupl.PageDb;
import org.cojen.tupl.PageManager;
import org.cojen.tupl.PageOps;
import org.cojen.tupl.Snapshot;
import org.cojen.tupl.SnapshotPageArray;
import org.cojen.tupl.Utils;
import org.cojen.tupl.WrongPageSize;
import org.cojen.tupl.io.FileFactory;
import org.cojen.tupl.io.FilePageArray;
import org.cojen.tupl.io.OpenOption;
import org.cojen.tupl.io.PageArray;
import org.cojen.tupl.io.StripedPageArray;
import org.cojen.tupl.util.Latch;

final class DurablePageDb
extends PageDb {
    private static final long MAGIC_NUMBER = 6529720411368701212L;
    private static final int I_MAGIC_NUMBER = 0;
    private static final int I_PAGE_SIZE = 8;
    private static final int I_COMMIT_NUMBER = 12;
    private static final int I_CHECKSUM = 16;
    private static final int I_MANAGER_HEADER = 20;
    private static final int I_EXTRA_DATA = 256;
    private static final int MINIMUM_PAGE_SIZE = 512;
    private final Crypto mCrypto;
    private final SnapshotPageArray mPageArray;
    private final PageManager mPageManager;
    private final Latch mHeaderLatch;
    private int mCommitNumber;

    static DurablePageDb open(boolean explicitPageSize, int pageSize, File[] files, FileFactory factory, EnumSet<OpenOption> options, PageCache cache, Crypto crypto, boolean destroy) throws IOException {
        while (true) {
            try {
                return new DurablePageDb(DurablePageDb.openPageArray(pageSize, files, factory, options), cache, crypto, destroy);
            }
            catch (WrongPageSize e) {
                if (explicitPageSize) {
                    throw e.rethrow();
                }
                pageSize = e.mActual;
                explicitPageSize = true;
                continue;
            }
            break;
        }
    }

    static DurablePageDb open(PageArray rawArray, PageCache cache, Crypto crypto, boolean destroy) throws IOException {
        try {
            return new DurablePageDb(rawArray, cache, crypto, destroy);
        }
        catch (WrongPageSize e) {
            throw e.rethrow();
        }
    }

    private static PageArray openPageArray(int pageSize, File[] files, FileFactory factory, EnumSet<OpenOption> options) throws IOException {
        DurablePageDb.checkPageSize(pageSize);
        if (!options.contains((Object)OpenOption.CREATE)) {
            for (File file : files) {
                if (file.exists()) continue;
                throw new DatabaseException("File does not exist: " + file);
            }
        }
        if (files.length == 0) {
            throw new IllegalArgumentException("No files provided");
        }
        if (files.length == 1) {
            return new FilePageArray(pageSize, files[0], factory, options);
        }
        PageArray[] arrays = new PageArray[files.length];
        for (int i = 0; i < files.length; ++i) {
            arrays[i] = new FilePageArray(pageSize, files[i], factory, options);
        }
        return new StripedPageArray(arrays);
    }

    private static void checkPageSize(int pageSize) {
        if (pageSize < 512) {
            throw new IllegalArgumentException("Page size is too small: " + pageSize + " < " + 512);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DurablePageDb(PageArray rawArray, PageCache cache, Crypto crypto, boolean destroy) throws IOException, WrongPageSize {
        block24: {
            this.mCrypto = crypto;
            PageArray array = crypto == null ? rawArray : new CryptoPageArray(rawArray, crypto);
            this.mPageArray = new SnapshotPageArray(array, rawArray, cache);
            this.mHeaderLatch = new Latch();
            try {
                int pageSize = this.mPageArray.pageSize();
                DurablePageDb.checkPageSize(pageSize);
                if (destroy || this.mPageArray.isEmpty()) {
                    this.mPageManager = new PageManager(this.mPageArray);
                    this.mCommitNumber = -1;
                    byte[] header = PageOps.p_calloc(pageSize);
                    try {
                        this.commit(false, header, null);
                        this.commit(false, header, null);
                    }
                    finally {
                        PageOps.p_delete(header);
                    }
                    this.mPageArray.setPageCount(2L);
                    break block24;
                }
                this.mPageArray.sync(false);
                byte[] header0 = PageOps.p_null();
                byte[] header1 = PageOps.p_null();
                try {
                    int commitNumber;
                    byte[] header;
                    block25: {
                        int commitNumber1;
                        CorruptDatabaseException ex0;
                        int pageSize0;
                        int commitNumber0;
                        try {
                            header0 = this.readHeader(0);
                            commitNumber0 = PageOps.p_intGetLE(header0, 12);
                            pageSize0 = PageOps.p_intGetLE(header0, 8);
                            ex0 = null;
                        }
                        catch (CorruptDatabaseException e) {
                            header0 = PageOps.p_null();
                            commitNumber0 = -1;
                            pageSize0 = pageSize;
                            ex0 = e;
                        }
                        if (pageSize0 != pageSize) {
                            throw new WrongPageSize(pageSize, pageSize0);
                        }
                        try {
                            header1 = this.readHeader(1);
                            commitNumber1 = PageOps.p_intGetLE(header1, 12);
                        }
                        catch (CorruptDatabaseException e) {
                            if (ex0 != null) {
                                throw ex0;
                            }
                            header = header0;
                            commitNumber = commitNumber0;
                            break block25;
                        }
                        int pageSize1 = PageOps.p_intGetLE(header1, 8);
                        if (pageSize0 != pageSize1) {
                            throw new CorruptDatabaseException("Mismatched page sizes: " + pageSize0 + " != " + pageSize1);
                        }
                        if (header0 == PageOps.p_null()) {
                            header = header1;
                            commitNumber = commitNumber1;
                        } else {
                            int diff = commitNumber1 - commitNumber0;
                            if (diff > 0) {
                                header = header1;
                                commitNumber = commitNumber1;
                            } else if (diff < 0) {
                                header = header0;
                                commitNumber = commitNumber0;
                            } else {
                                throw new CorruptDatabaseException("Both headers have same commit number: " + commitNumber0);
                            }
                        }
                    }
                    this.mHeaderLatch.acquireExclusive();
                    this.mCommitNumber = commitNumber;
                    this.mHeaderLatch.releaseExclusive();
                    this.mPageManager = new PageManager(this.mPageArray, header, 20);
                }
                finally {
                    PageOps.p_delete(header0);
                    PageOps.p_delete(header1);
                }
            }
            catch (WrongPageSize e) {
                this.delete();
                Utils.closeQuietly(null, this);
                throw e;
            }
            catch (Throwable e) {
                this.delete();
                throw this.closeOnFailure(e);
            }
        }
    }

    @Override
    void delete() {
        if (this.mPageManager != null) {
            this.mPageManager.delete();
        }
    }

    @Override
    public boolean isDurable() {
        return true;
    }

    @Override
    public int allocMode() {
        return 0;
    }

    @Override
    public Node allocLatchedNode(LocalDatabase db, int mode) throws IOException {
        long nodeId = this.allocPage();
        try {
            Node node = db.allocLatchedNode(nodeId, mode);
            node.mId = nodeId;
            return node;
        }
        catch (Throwable e) {
            try {
                this.recyclePage(nodeId);
            }
            catch (Throwable e2) {
                e.addSuppressed(e2);
            }
            throw e;
        }
    }

    @Override
    public int pageSize() {
        return this.mPageArray.pageSize();
    }

    @Override
    public long pageCount() throws IOException {
        return this.mPageArray.getPageCount();
    }

    @Override
    public void pageLimit(long limit) {
        this.mPageManager.pageLimit(limit);
    }

    @Override
    public long pageLimit() {
        return this.mPageManager.pageLimit();
    }

    @Override
    public void pageLimitOverride(long bytes) {
        this.mPageManager.pageLimitOverride(bytes);
    }

    @Override
    public PageDb.Stats stats() {
        PageDb.Stats stats = new PageDb.Stats();
        this.mPageManager.addTo(stats);
        return stats;
    }

    @Override
    public BitSet tracePages() throws IOException {
        BitSet pages = new BitSet();
        this.mPageManager.markAllPages(pages);
        this.mPageManager.traceFreePages(pages);
        return pages;
    }

    @Override
    public void readPage(long id, byte[] page) throws IOException {
        try {
            this.mPageArray.readPage(id, page, 0, this.pageSize());
        }
        catch (Throwable e) {
            throw this.closeOnFailure(e);
        }
    }

    @Override
    public long allocPage() throws IOException {
        this.mCommitLock.acquireShared();
        try {
            long l = this.mPageManager.allocPage();
            return l;
        }
        catch (DatabaseException e) {
            if (e.isRecoverable()) {
                throw e;
            }
            throw this.closeOnFailure(e);
        }
        catch (Throwable e) {
            throw this.closeOnFailure(e);
        }
        finally {
            this.mCommitLock.releaseShared();
        }
    }

    @Override
    public void writePage(long id, byte[] page) throws IOException {
        DurablePageDb.checkId(id);
        this.mPageArray.writePage(id, page, 0);
    }

    @Override
    public byte[] evictPage(long id, byte[] page) throws IOException {
        DurablePageDb.checkId(id);
        return this.mPageArray.evictPage(id, page);
    }

    @Override
    public void cachePage(long id, byte[] page) throws IOException {
        this.mPageArray.cachePage(id, page);
    }

    @Override
    public void uncachePage(long id) throws IOException {
        this.mPageArray.uncachePage(id);
    }

    @Override
    public void deletePage(long id) throws IOException {
        DurablePageDb.checkId(id);
        this.mCommitLock.acquireShared();
        try {
            this.mPageManager.deletePage(id);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Throwable e) {
            throw this.closeOnFailure(e);
        }
        finally {
            this.mCommitLock.releaseShared();
        }
        this.mPageArray.uncachePage(id);
    }

    @Override
    public void recyclePage(long id) throws IOException {
        DurablePageDb.checkId(id);
        this.mCommitLock.acquireShared();
        try {
            try {
                this.mPageManager.recyclePage(id);
            }
            catch (IOException e) {
                this.mPageManager.deletePage(id);
            }
        }
        catch (IOException e) {
            throw e;
        }
        catch (Throwable e) {
            throw this.closeOnFailure(e);
        }
        finally {
            this.mCommitLock.releaseShared();
        }
    }

    @Override
    public long allocatePages(long pageCount) throws IOException {
        if (pageCount <= 0L) {
            return 0L;
        }
        PageDb.Stats stats = new PageDb.Stats();
        this.mPageManager.addTo(stats);
        if ((pageCount -= stats.freePages) <= 0L) {
            return 0L;
        }
        ReentrantReadWriteLock.ReadLock lock = this.mCommitLock.readLock();
        int i = 0;
        while ((long)i < pageCount) {
            lock.lock();
            try {
                this.mPageManager.allocAndRecyclePage();
            }
            catch (Throwable e) {
                throw this.closeOnFailure(e);
            }
            finally {
                lock.unlock();
            }
            ++i;
        }
        return pageCount;
    }

    @Override
    public long directPagePointer(long id) throws IOException {
        return this.mPageArray.directPagePointer(id);
    }

    @Override
    public long copyPage(long srcId, long dstId) throws IOException {
        return this.mPageArray.copyPage(srcId, dstId);
    }

    @Override
    public boolean compactionStart(long targetPageCount) throws IOException {
        this.mCommitLock.acquireExclusive();
        try {
            boolean bl = this.mPageManager.compactionStart(targetPageCount);
            return bl;
        }
        catch (Throwable e) {
            throw this.closeOnFailure(e);
        }
        finally {
            this.mCommitLock.releaseExclusive();
        }
    }

    @Override
    public boolean compactionScanFreeList() throws IOException {
        try {
            return this.mPageManager.compactionScanFreeList(this.mCommitLock);
        }
        catch (Throwable e) {
            throw this.closeOnFailure(e);
        }
    }

    @Override
    public boolean compactionVerify() throws IOException {
        return this.mPageManager.compactionVerify();
    }

    @Override
    public boolean compactionEnd() throws IOException {
        try {
            return this.mPageManager.compactionEnd(this.mCommitLock);
        }
        catch (Throwable e) {
            throw this.closeOnFailure(e);
        }
    }

    @Override
    public boolean truncatePages() throws IOException {
        return this.mPageManager.truncatePages();
    }

    @Override
    public int extraCommitDataOffset() {
        return 256;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit(boolean resume, byte[] header, PageDb.CommitCallback callback) throws IOException {
        this.mCommitLock.acquireExclusive();
        this.mCommitLock.acquireShared();
        this.mHeaderLatch.acquireShared();
        int commitNumber = this.mCommitNumber + 1;
        this.mHeaderLatch.releaseShared();
        this.mCommitLock.releaseExclusive();
        try {
            try {
                if (!resume) {
                    this.mPageManager.commitStart(header, 20);
                }
                if (callback != null) {
                    callback.prepare(resume, header);
                }
            }
            catch (DatabaseException e) {
                if (e.isRecoverable()) {
                    throw e;
                }
                throw this.closeOnFailure(e);
            }
            try {
                this.commitHeader(header, commitNumber);
                this.mPageManager.commitEnd(header, 20);
            }
            catch (Throwable e) {
                throw this.closeOnFailure(e);
            }
        }
        finally {
            this.mCommitLock.releaseShared();
        }
    }

    @Override
    public void readExtraCommitData(byte[] extra) throws IOException {
        try {
            this.mHeaderLatch.acquireShared();
            try {
                this.readPartial(this.mCommitNumber & 1, 256, extra, 0, extra.length);
            }
            finally {
                this.mHeaderLatch.releaseShared();
            }
        }
        catch (Throwable e) {
            throw this.closeOnFailure(e);
        }
    }

    @Override
    public void close() throws IOException {
        this.close(null);
    }

    @Override
    public void close(Throwable cause) throws IOException {
        if (this.mPageArray != null) {
            this.mPageArray.close(cause);
        }
    }

    OutputStream encrypt(OutputStream out) throws IOException {
        if (this.mCrypto != null) {
            try {
                out = this.mCrypto.newEncryptingStream(0L, out);
            }
            catch (GeneralSecurityException e) {
                throw new DatabaseException(e);
            }
        }
        return out;
    }

    InputStream decrypt(InputStream in) throws IOException {
        if (this.mCrypto != null) {
            try {
                in = this.mCrypto.newDecryptingStream(0L, in);
            }
            catch (GeneralSecurityException e) {
                throw new DatabaseException(e);
            }
        }
        return in;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Snapshot beginSnapshot(LocalDatabase db) throws IOException {
        this.mHeaderLatch.acquireShared();
        try {
            long redoPos;
            long pageCount;
            byte[] header = PageOps.p_alloc(512);
            try {
                this.mPageArray.readPage((long)(this.mCommitNumber & 1), header, 0, 512);
                pageCount = PageManager.readTotalPageCount(header, 20);
                redoPos = LocalDatabase.readRedoPosition(header, 256);
            }
            finally {
                PageOps.p_delete(header);
            }
            Snapshot snapshot = this.mPageArray.beginSnapshot(db, pageCount, redoPos);
            return snapshot;
        }
        finally {
            this.mHeaderLatch.releaseShared();
        }
    }

    static PageDb restoreFromSnapshot(int pageSize, File[] files, FileFactory factory, EnumSet<OpenOption> options, PageCache cache, Crypto crypto, InputStream in) throws IOException {
        PageArray pa;
        byte[] bufferPage;
        byte[] buffer;
        if (options.contains((Object)OpenOption.READ_ONLY)) {
            throw new DatabaseException("Cannot restore into a read-only file");
        }
        long index = 0L;
        if (crypto != null) {
            buffer = new byte[pageSize];
            bufferPage = PageOps.p_transfer(buffer);
            pa = DurablePageDb.openPageArray(pageSize, files, factory, options);
            if (!pa.isEmpty()) {
                throw new DatabaseException("Cannot restore into a non-empty file");
            }
        } else {
            buffer = new byte[512];
            Utils.readFully(in, buffer, 0, buffer.length);
            long magic = Utils.decodeLongLE(buffer, 0);
            if (magic != 6529720411368701212L) {
                throw new CorruptDatabaseException("Wrong magic number: " + magic);
            }
            pageSize = Utils.decodeIntLE(buffer, 8);
            pa = DurablePageDb.openPageArray(pageSize, files, factory, options);
            if (!pa.isEmpty()) {
                throw new DatabaseException("Cannot restore into a non-empty file");
            }
            if (pageSize != buffer.length) {
                byte[] newBuffer = new byte[pageSize];
                System.arraycopy(buffer, 0, newBuffer, 0, buffer.length);
                Utils.readFully(in, newBuffer, buffer.length, pageSize - buffer.length);
                buffer = newBuffer;
            }
            bufferPage = PageOps.p_transfer(buffer);
            try {
                pa.writePage(index, bufferPage);
                ++index;
            }
            catch (Throwable e) {
                PageOps.p_delete(bufferPage);
                throw e;
            }
        }
        return DurablePageDb.restoreFromSnapshot(cache, crypto, in, buffer, bufferPage, pa, index);
    }

    static PageDb restoreFromSnapshot(PageArray pa, PageCache cache, Crypto crypto, InputStream in) throws IOException {
        if (!pa.isEmpty()) {
            throw new DatabaseException("Cannot restore into a non-empty file");
        }
        byte[] buffer = new byte[pa.pageSize()];
        byte[] bufferPage = PageOps.p_transfer(buffer);
        return DurablePageDb.restoreFromSnapshot(cache, crypto, in, buffer, bufferPage, pa, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static PageDb restoreFromSnapshot(PageCache cache, Crypto crypto, InputStream in, byte[] buffer, byte[] bufferPage, PageArray pa, long index) throws IOException {
        try {
            while (true) {
                try {
                    Utils.readFully(in, buffer, 0, buffer.length);
                }
                catch (EOFException e) {
                    break;
                }
                pa.writePage(index, PageOps.p_transferTo(buffer, bufferPage));
                ++index;
            }
            pa.sync(true);
        }
        finally {
            PageOps.p_delete(bufferPage);
            Utils.closeQuietly(null, in);
        }
        try {
            return new DurablePageDb(pa, cache, crypto, false);
        }
        catch (WrongPageSize e) {
            throw e.rethrow();
        }
    }

    private IOException closeOnFailure(Throwable e) throws IOException {
        throw Utils.closeOnFailure(this, e);
    }

    private static void checkId(long id) {
        if (id <= 1L) {
            throw new IllegalArgumentException("Illegal page id: " + id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commitHeader(byte[] header, int commitNumber) throws IOException {
        SnapshotPageArray array = this.mPageArray;
        PageOps.p_longPutLE(header, 0, 6529720411368701212L);
        PageOps.p_intPutLE(header, 8, array.pageSize());
        PageOps.p_intPutLE(header, 12, commitNumber);
        DurablePageDb.setHeaderChecksum(header);
        int dupCount = this.pageSize() / 512;
        for (int i = 1; i < dupCount; ++i) {
            PageOps.p_copy(header, 0, header, i * 512, 512);
        }
        ((PageArray)array).sync(true);
        this.mHeaderLatch.acquireExclusive();
        try {
            array.writePage((long)(commitNumber & 1), header);
            this.mCommitNumber = commitNumber;
        }
        finally {
            this.mHeaderLatch.releaseExclusive();
        }
        array.syncPage(commitNumber & 1);
    }

    private static int setHeaderChecksum(byte[] header) {
        PageOps.p_intPutLE(header, 16, 0);
        int checksum = PageOps.p_crc32(header, 0, 512);
        PageOps.p_intPutLE(header, 16, checksum);
        return checksum;
    }

    private byte[] readHeader(int id) throws IOException {
        byte[] header = PageOps.p_alloc(512);
        try {
            try {
                this.mPageArray.readPage((long)id, header, 0, 512);
            }
            catch (EOFException e) {
                throw new CorruptDatabaseException("File is smaller than expected");
            }
            long magic = PageOps.p_longGetLE(header, 0);
            if (magic != 6529720411368701212L) {
                throw new CorruptDatabaseException("Wrong magic number: " + magic);
            }
            int checksum = PageOps.p_intGetLE(header, 16);
            int newChecksum = DurablePageDb.setHeaderChecksum(header);
            if (newChecksum != checksum) {
                throw new CorruptDatabaseException("Header checksum mismatch: " + newChecksum + " != " + checksum);
            }
            return header;
        }
        catch (Throwable e) {
            PageOps.p_delete(header);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readPartial(long index, int start, byte[] buf, int offset, int length) throws IOException {
        byte[] page = PageOps.p_alloc(start + length);
        try {
            this.mPageArray.readPage(index, page, 0, start + length);
            PageOps.p_copyToArray(page, start, buf, offset, length);
        }
        finally {
            PageOps.p_delete(page);
        }
    }
}

