/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl;

import org.cojen.tupl.DeadlockSet;
import org.cojen.tupl.LockTimeoutException;

public class DeadlockException
extends LockTimeoutException {
    private static final long serialVersionUID = 1L;
    private final boolean mGuilty;
    private final DeadlockSet mSet;

    DeadlockException(long nanosTimeout, boolean guilty, DeadlockSet set) {
        super(nanosTimeout);
        this.mGuilty = guilty;
        this.mSet = set;
    }

    public boolean isGuilty() {
        return this.mGuilty;
    }

    public DeadlockSet getDeadlockSet() {
        return this.mSet;
    }

    @Override
    public String getMessage() {
        return this.getMessage(true);
    }

    public String getShortMessage() {
        return this.getMessage(false);
    }

    private String getMessage(boolean full) {
        StringBuilder b = new StringBuilder(super.getMessage());
        b.append("; caller ");
        if (this.mGuilty) {
            b.append("helped cause the deadlock");
        } else {
            b.append("might be innocent");
        }
        b.append('.');
        if (full) {
            b.append(" Deadlock set: ");
            this.mSet.appendMembers(b);
        }
        return b.toString();
    }
}

