/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl;

import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.cojen.tupl.Node;

final class CursorFrame
extends AtomicReference<CursorFrame> {
    private static final int SPIN_LIMIT = Runtime.getRuntime().availableProcessors();
    private static final CursorFrame REBIND_FRAME = new CursorFrame();
    static final AtomicReferenceFieldUpdater<Node, CursorFrame> cLastUpdater = AtomicReferenceFieldUpdater.newUpdater(Node.class, CursorFrame.class, "mLastCursorFrame");
    volatile CursorFrame mPrevCousin;
    Node mNode;
    int mNodePos;
    CursorFrame mParentFrame;
    byte[] mNotFoundKey;

    CursorFrame() {
    }

    CursorFrame(CursorFrame parentFrame) {
        this.mParentFrame = parentFrame;
    }

    Node acquireShared() {
        Node node = this.mNode;
        while (true) {
            node.acquireShared();
            Node actualNode = this.mNode;
            if (actualNode == node) {
                return actualNode;
            }
            node.releaseShared();
            node = actualNode;
        }
    }

    Node tryAcquireShared() {
        Node node = this.mNode;
        while (node.tryAcquireShared()) {
            Node actualNode = this.mNode;
            if (actualNode == node) {
                return actualNode;
            }
            node.releaseShared();
            node = actualNode;
        }
        return null;
    }

    Node acquireExclusive() {
        Node node = this.mNode;
        while (true) {
            node.acquireExclusive();
            Node actualNode = this.mNode;
            if (actualNode == node) {
                return actualNode;
            }
            node.releaseExclusive();
            node = actualNode;
        }
    }

    Node tryAcquireExclusive() {
        Node node = this.mNode;
        while (node.tryAcquireExclusive()) {
            Node actualNode = this.mNode;
            if (actualNode == node) {
                return actualNode;
            }
            node.releaseExclusive();
            node = actualNode;
        }
        return null;
    }

    void adjustParentPosition(int amount) {
        CursorFrame parent = this.mParentFrame;
        if (parent != null) {
            parent.mNodePos += amount;
        }
    }

    void bind(Node node, int nodePos) {
        this.mNode = node;
        this.mNodePos = nodePos;
        this.set(this);
        int trials = 0;
        while (true) {
            CursorFrame last;
            this.mPrevCousin = last = node.mLastCursorFrame;
            if (last == null) {
                if (cLastUpdater.compareAndSet(node, null, this)) {
                    return;
                }
            } else if (last.get() == last && last.compareAndSet(last, this)) {
                while (node.mLastCursorFrame != last) {
                }
                node.mLastCursorFrame = this;
                return;
            }
            if (++trials < SPIN_LIMIT) continue;
            Thread.yield();
            trials = 0;
        }
    }

    void bindOrReposition(Node node, int nodePos) {
        if (this.mNode == null) {
            this.bind(node, nodePos);
        } else if (this.mNode == node) {
            this.mNodePos = nodePos;
        } else {
            throw new IllegalStateException();
        }
    }

    void rebind(Node node, int nodePos) {
        if (this.unbind(REBIND_FRAME)) {
            this.bind(node, nodePos);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean unbind(CursorFrame to) {
        int trials = 0;
        CursorFrame n;
        while ((n = (CursorFrame)this.get()) != null) {
            if (n == this) {
                Node node = this.mNode;
                if (node != null && node.mLastCursorFrame == this && this.compareAndSet(n, to)) {
                    if (node != this.mNode || node.mLastCursorFrame != this) {
                        this.set(n);
                    } else {
                        CursorFrame p;
                        while (!((p = this.mPrevCousin) == null || p.get() == this && p.compareAndSet(this, p))) {
                        }
                        node.mLastCursorFrame = p;
                        return true;
                    }
                }
            } else if (n.mPrevCousin == this && this.compareAndSet(n, to)) {
                CursorFrame p;
                while (!((p = this.mPrevCousin) == null || p.get() == this && p.compareAndSet(this, n))) {
                }
                n.mPrevCousin = p;
                return true;
            }
            if (++trials < SPIN_LIMIT) continue;
            Thread.yield();
            trials = 0;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    CursorFrame tryLock(CursorFrame lock) {
        int trials = 0;
        CursorFrame n;
        while ((n = (CursorFrame)this.get()) != null) {
            if (n == this) {
                Node node = this.mNode;
                if (node != null && node.mLastCursorFrame == this && this.compareAndSet(n, lock)) {
                    if (node == this.mNode && node.mLastCursorFrame == this) return n;
                    this.set(n);
                }
            } else if (n.mPrevCousin == this && this.compareAndSet(n, lock)) {
                return n;
            }
            if (++trials < SPIN_LIMIT) continue;
            Thread.yield();
            trials = 0;
        }
        return null;
    }

    CursorFrame tryLockPrevious(CursorFrame lock) {
        CursorFrame p;
        while (!((p = this.mPrevCousin) == null || p.get() == this && p.compareAndSet(this, lock))) {
        }
        return p;
    }

    void unlock(CursorFrame n) {
        this.set(n);
    }

    CursorFrame peek() {
        return this.mParentFrame;
    }

    CursorFrame pop() {
        this.unbind(null);
        CursorFrame parent = this.mParentFrame;
        this.mNode = null;
        this.mParentFrame = null;
        this.mNotFoundKey = null;
        return parent;
    }

    void popv() {
        this.unbind(null);
        this.mNode = null;
        this.mParentFrame = null;
        this.mNotFoundKey = null;
    }

    static void popAll(CursorFrame frame) {
        while ((frame = frame.mNode == null ? frame.mParentFrame : frame.pop()) != null) {
        }
    }

    void copyInto(CursorFrame dest) {
        Node node = this.acquireShared();
        CursorFrame parent = this.mParentFrame;
        if (parent != null) {
            node.releaseShared();
            CursorFrame parentCopy = new CursorFrame();
            while (true) {
                if (parent != null) {
                    parent.copyInto(parentCopy);
                }
                node = this.acquireShared();
                CursorFrame actualParent = this.mParentFrame;
                if (actualParent == parent) {
                    if (parent == null) break;
                    dest.mParentFrame = parentCopy;
                    break;
                }
                node.releaseShared();
                CursorFrame.popAll(parentCopy);
                parent = actualParent;
            }
        }
        dest.mNotFoundKey = this.mNotFoundKey;
        dest.bind(node, this.mNodePos);
        node.releaseShared();
    }

    @Override
    public String toString() {
        return this.getClass().getName() + '@' + Integer.toHexString(this.hashCode());
    }
}

