/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl;

import java.util.concurrent.TimeUnit;
import org.cojen.tupl.ConfirmationFailureException;
import org.cojen.tupl.Utils;

public class ConfirmationTimeoutException
extends ConfirmationFailureException {
    private static final long serialVersionUID = 1L;
    private final long mNanosTimeout;
    private TimeUnit mUnit;

    public ConfirmationTimeoutException(long nanosTimeout) {
        super((String)null);
        this.mNanosTimeout = nanosTimeout;
    }

    @Override
    public String getMessage() {
        return Utils.timeoutMessage(this.mNanosTimeout, this);
    }

    @Override
    public long getTimeout() {
        return this.getUnit().convert(this.mNanosTimeout, TimeUnit.NANOSECONDS);
    }

    @Override
    public TimeUnit getUnit() {
        TimeUnit unit = this.mUnit;
        if (unit != null) {
            return unit;
        }
        this.mUnit = Utils.inferUnit(TimeUnit.NANOSECONDS, this.mNanosTimeout);
        return this.mUnit;
    }

    @Override
    boolean isRecoverable() {
        return true;
    }
}

