/*
 * Decompiled with CFR 0.152.
 */
package org.readium.r2.shared;

import java.util.List;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.joda.time.DateTime;
import org.json.JSONArray;
import org.json.JSONObject;
import org.readium.r2.shared.Collection;
import org.readium.r2.shared.CollectionKt;
import org.readium.r2.shared.Contributor;
import org.readium.r2.shared.ContributorKt;
import org.readium.r2.shared.Metadata;
import org.readium.r2.shared.MultilanguageString;
import org.readium.r2.shared.Subject;
import org.readium.r2.shared.metadata.BelongsTo;

@kotlin.Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u00a8\u0006\u0004"}, d2={"parseMetadata", "Lorg/readium/r2/shared/Metadata;", "metadataDict", "Lorg/json/JSONObject;", "r2-shared-kotlin_devFolioReaderRelease"})
public final class MetadataKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Metadata parseMetadata(@NotNull JSONObject metadataDict) {
        int i;
        Intrinsics.checkParameterIsNotNull((Object)metadataDict, (String)"metadataDict");
        Metadata m = new Metadata();
        if (metadataDict.has("title")) {
            m.setMultilanguageTitle(new MultilanguageString());
            MultilanguageString multilanguageString = m.getMultilanguageTitle();
            if (multilanguageString != null) {
                multilanguageString.setSingleString(metadataDict.getString("title"));
            }
        }
        if (metadataDict.has("identifier")) {
            String string = metadataDict.getString("identifier");
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"metadataDict.getString(\"identifier\")");
            m.setIdentifier(string);
        }
        if (metadataDict.has("@type")) {
            m.setRdfType(metadataDict.getString("@type"));
        } else if (metadataDict.has("type")) {
            m.setRdfType(metadataDict.getString("type"));
        }
        if (metadataDict.has("modified")) {
            m.setModified(new DateTime((Object)metadataDict.getString("modified")).toDate());
        }
        if (metadataDict.has("author")) {
            List<Contributor> list = m.getAuthors();
            Object object = metadataDict.get("author");
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"metadataDict.get(\"author\")");
            list.addAll((java.util.Collection<Contributor>)ContributorKt.parseContributors(object));
        }
        if (metadataDict.has("translator")) {
            List<Contributor> list = m.getTranslators();
            Object object = metadataDict.get("translator");
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"metadataDict.get(\"translator\")");
            list.addAll((java.util.Collection<Contributor>)ContributorKt.parseContributors(object));
        }
        if (metadataDict.has("editor")) {
            List<Contributor> list = m.getEditors();
            Object object = metadataDict.get("editor");
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"metadataDict.get(\"editor\")");
            list.addAll((java.util.Collection<Contributor>)ContributorKt.parseContributors(object));
        }
        if (metadataDict.has("artist")) {
            List<Contributor> list = m.getArtists();
            Object object = metadataDict.get("artist");
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"metadataDict.get(\"artist\")");
            list.addAll((java.util.Collection<Contributor>)ContributorKt.parseContributors(object));
        }
        if (metadataDict.has("illustrator")) {
            List<Contributor> list = m.getIllustrators();
            Object object = metadataDict.get("illustrator");
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"metadataDict.get(\"illustrator\")");
            list.addAll((java.util.Collection<Contributor>)ContributorKt.parseContributors(object));
        }
        if (metadataDict.has("letterer")) {
            List<Contributor> list = m.getLetterers();
            Object object = metadataDict.get("letterer");
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"metadataDict.get(\"letterer\")");
            list.addAll((java.util.Collection<Contributor>)ContributorKt.parseContributors(object));
        }
        if (metadataDict.has("penciler")) {
            List<Contributor> list = m.getPencilers();
            Object object = metadataDict.get("penciler");
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"metadataDict.get(\"penciler\")");
            list.addAll((java.util.Collection<Contributor>)ContributorKt.parseContributors(object));
        }
        if (metadataDict.has("colorist")) {
            List<Contributor> list = m.getColorists();
            Object object = metadataDict.get("colorist");
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"metadataDict.get(\"colorist\")");
            list.addAll((java.util.Collection<Contributor>)ContributorKt.parseContributors(object));
        }
        if (metadataDict.has("inker")) {
            List<Contributor> list = m.getInkers();
            Object object = metadataDict.get("inker");
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"metadataDict.get(\"inker\")");
            list.addAll((java.util.Collection<Contributor>)ContributorKt.parseContributors(object));
        }
        if (metadataDict.has("narrator")) {
            List<Contributor> list = m.getNarrators();
            Object object = metadataDict.get("narrator");
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"metadataDict.get(\"narrator\")");
            list.addAll((java.util.Collection<Contributor>)ContributorKt.parseContributors(object));
        }
        if (metadataDict.has("contributor")) {
            List<Contributor> list = m.getContributors();
            Object object = metadataDict.get("contributor");
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"metadataDict.get(\"contributor\")");
            list.addAll((java.util.Collection<Contributor>)ContributorKt.parseContributors(object));
        }
        if (metadataDict.has("publisher")) {
            List<Contributor> list = m.getPublishers();
            Object object = metadataDict.get("publisher");
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"metadataDict.get(\"publisher\")");
            list.addAll((java.util.Collection<Contributor>)ContributorKt.parseContributors(object));
        }
        if (metadataDict.has("imprint")) {
            List<Contributor> list = m.getImprints();
            Object object = metadataDict.get("imprint");
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"metadataDict.get(\"imprint\")");
            list.addAll((java.util.Collection<Contributor>)ContributorKt.parseContributors(object));
        }
        if (metadataDict.has("published")) {
            m.setPublicationDate(metadataDict.getString("published"));
        }
        if (metadataDict.has("description")) {
            m.setDescription(metadataDict.getString("description"));
        }
        if (metadataDict.has("source")) {
            m.setSource(metadataDict.getString("source"));
        }
        if (metadataDict.has("rights")) {
            m.setRights(metadataDict.getString("rights"));
        }
        if (metadataDict.has("subject")) {
            JSONArray subjDict;
            int n;
            int n2;
            Object subjectDictUntyped = metadataDict.get("subject");
            Object object = subjectDictUntyped;
            if (object instanceof String) {
                Subject subject = new Subject();
                subject.setName((String)subjectDictUntyped);
                m.getSubjects().add(subject);
            } else if (object instanceof Object[]) {
                int subject = 0;
                n2 = ((Object[])subjectDictUntyped).length - 1;
                while (subject < n2) {
                    void i2;
                    Subject subject2 = new Subject();
                    Object object2 = ((Object[])subjectDictUntyped)[i2];
                    if (object2 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
                    }
                    subject2.setName((String)object2);
                    m.getSubjects().add(subject2);
                    ++i2;
                }
            } else if (object instanceof JSONArray && (n2 = 0) <= (n = (subjDict = metadataDict.getJSONArray("subject")).length() - 1)) {
                while (true) {
                    Object subObject;
                    Object object3;
                    if ((object3 = (subObject = subjDict.get(i))) instanceof String) {
                        Subject subject = new Subject();
                        subject.setName((String)subObject);
                        m.getSubjects().add(subject);
                    } else if (object3 instanceof JSONObject) {
                        JSONObject sub = subjDict.getJSONObject(i);
                        Subject subject = new Subject();
                        if (sub.has("name")) {
                            subject.setName(sub.getString("name"));
                        }
                        if (sub.has("sort_as")) {
                            subject.setSortAs(sub.getString("sort_as"));
                        }
                        if (sub.has("scheme")) {
                            subject.setScheme(sub.getString("scheme"));
                        }
                        if (sub.has("code")) {
                            subject.setCode(sub.getString("code"));
                        }
                        m.getSubjects().add(subject);
                    }
                    if (i == n) break;
                    ++i;
                }
            }
        }
        if (metadataDict.has("belongs_to")) {
            JSONArray array;
            JSONObject belongsDict = metadataDict.getJSONObject("belongs_to");
            BelongsTo belongs = new BelongsTo();
            if (belongsDict.has("series")) {
                int n;
                if (belongsDict.get("series") instanceof JSONObject) {
                    Object object = m.getBelongsTo();
                    if (object != null && (object = ((BelongsTo)object).getSeries()) != null) {
                        String string = belongsDict.getString("series");
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"belongsDict.getString(\"series\")");
                        object.add(new Collection(string));
                    }
                } else if (belongsDict.get("series") instanceof JSONArray && (i = 0) <= (n = (array = belongsDict.getJSONArray("series")).length() - 1)) {
                    while (true) {
                        String string = array.getString(i);
                        Object object = m.getBelongsTo();
                        if (object != null && (object = ((BelongsTo)object).getSeries()) != null) {
                            String string2 = string;
                            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"string");
                            object.add(new Collection(string2));
                        }
                        if (i == n) break;
                        ++i;
                    }
                }
            }
            if (belongsDict.has("collection")) {
                int n;
                if (belongsDict.get("collection") instanceof String) {
                    Object object = m.getBelongsTo();
                    if (object != null && (object = ((BelongsTo)object).getCollection()) != null) {
                        String string = belongsDict.getString("collection");
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"belongsDict.getString(\"collection\")");
                        object.add(new Collection(string));
                    }
                } else if (belongsDict.get("collection") instanceof JSONObject) {
                    List<Collection> list = belongs.getSeries();
                    JSONObject jSONObject = belongsDict.getJSONObject("collection");
                    Intrinsics.checkExpressionValueIsNotNull((Object)jSONObject, (String)"belongsDict.getJSONObject(\"collection\")");
                    list.add(CollectionKt.parseCollection(jSONObject));
                } else if (belongsDict.get("collection") instanceof JSONArray && (i = 0) <= (n = (array = belongsDict.getJSONArray("collection")).length() - 1)) {
                    while (true) {
                        JSONObject obj = array.getJSONObject(i);
                        List<Collection> list = belongs.getSeries();
                        JSONObject jSONObject = obj;
                        Intrinsics.checkExpressionValueIsNotNull((Object)jSONObject, (String)"obj");
                        list.add(CollectionKt.parseCollection(jSONObject));
                        if (i == n) break;
                        ++i;
                    }
                }
            }
            m.setBelongsTo(belongs);
        }
        if (metadataDict.has("duration")) {
            m.setDuration(metadataDict.getInt("duration"));
        }
        if (metadataDict.has("language")) {
            JSONArray array;
            int n;
            int belongs;
            if (metadataDict.get("language") instanceof JSONObject) {
                List<String> list = m.getLanguages();
                String string = metadataDict.getString("language");
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"metadataDict.getString(\"language\")");
                list.add(string);
            } else if (metadataDict.get("language") instanceof JSONArray && (belongs = 0) <= (n = (array = metadataDict.getJSONArray("language")).length() - 1)) {
                while (true) {
                    void i3;
                    String string = array.getString((int)i3);
                    List<String> list = m.getLanguages();
                    String string3 = string;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"string");
                    list.add(string3);
                    if (i3 == n) break;
                    ++i3;
                }
            }
        }
        return m;
    }
}

