/*
 * Decompiled with CFR 0.152.
 */
package redis.embedded.core;

import java.io.IOException;
import java.net.ServerSocket;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicInteger;

public interface PortProvider {
    public int get();

    public static PortProvider newEphemeralPortProvider() {
        return () -> {
            int n;
            ServerSocket socket = new ServerSocket(0);
            try {
                socket.setReuseAddress(false);
                n = socket.getLocalPort();
            }
            catch (Throwable throwable) {
                try {
                    try {
                        socket.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new IllegalArgumentException("Could not provide ephemeral port", e);
                }
            }
            socket.close();
            return n;
        };
    }

    public static PortProvider newPredefinedPortProvider(Collection<Integer> ports) {
        Iterator<Integer> iterator = ports.iterator();
        return () -> {
            if (!iterator.hasNext()) {
                throw new IllegalArgumentException("Ran out of Redis ports");
            }
            return (Integer)iterator.next();
        };
    }

    public static PortProvider newSequencePortProvider() {
        return PortProvider.newSequencePortProvider(26379);
    }

    public static PortProvider newSequencePortProvider(int start) {
        AtomicInteger currentPort = new AtomicInteger(start);
        return currentPort::getAndIncrement;
    }
}

