/*
 * Decompiled with CFR 0.152.
 */
package com.codekidlabs.storagechooser.fragments;

import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.os.Environment;
import android.support.annotation.Nullable;
import android.support.v4.app.DialogFragment;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.ListAdapter;
import android.widget.ListView;
import com.codekidlabs.storagechooser.R;
import com.codekidlabs.storagechooser.StorageChooserBuilder;
import com.codekidlabs.storagechooser.adapters.StorageChooserListAdapter;
import com.codekidlabs.storagechooser.models.Storages;
import com.codekidlabs.storagechooser.utils.DiskUtil;
import com.codekidlabs.storagechooser.utils.MemoryUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class ChooserDialogFragment
extends DialogFragment {
    private View mLayout;
    private ViewGroup mContainer;
    private static final String INTERNAL_STORAGE_TITLE = "Internal Storage";
    private static final String EXTERNAL_STORAGE_TITLE = "External Storage";
    private static final String EXTERNAL_STORAGE_PATH_KITKAT = "/storage/extSdCard";
    private List<Storages> storagesList;

    @Nullable
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        this.mContainer = container;
        if (this.getShowsDialog()) {
            return super.onCreateView(inflater, container, savedInstanceState);
        }
        return this.getLayout(inflater, container);
    }

    private View getLayout(LayoutInflater inflater, ViewGroup container) {
        this.mLayout = inflater.inflate(R.layout.storage_list, container, false);
        this.initListView(this.getContext(), this.mLayout, StorageChooserBuilder.sConfig.isShowMemoryBar());
        return this.mLayout;
    }

    private void initListView(Context context, View view, boolean shouldShowMemoryBar) {
        ListView listView = (ListView)view.findViewById(R.id.storage_list_view);
        this.populateList();
        listView.setAdapter((ListAdapter)new StorageChooserListAdapter(this.storagesList, context, shouldShowMemoryBar));
        listView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> adapterView, View view, int i, long l) {
                if (i == 0) {
                    String thePath = Environment.getExternalStorageDirectory().getAbsolutePath() + StorageChooserBuilder.sConfig.getPredefinedPath();
                    DiskUtil.saveChooserPathPreference(StorageChooserBuilder.sConfig.getPreference(), thePath);
                } else {
                    String thePath = "/storage/" + ((Storages)ChooserDialogFragment.this.storagesList.get(i)).getStorageTitle() + StorageChooserBuilder.sConfig.getPredefinedPath();
                    DiskUtil.saveChooserPathPreference(StorageChooserBuilder.sConfig.getPreference(), thePath);
                }
                ChooserDialogFragment.this.dismiss();
            }
        });
    }

    private void populateList() {
        this.storagesList = new ArrayList<Storages>();
        File storageDir = new File("/storage");
        File internalStorageDir = Environment.getExternalStorageDirectory();
        File[] volumeList = storageDir.listFiles();
        Storages storages = new Storages();
        storages.setStorageTitle(INTERNAL_STORAGE_TITLE);
        storages.setMemoryTotalSize(MemoryUtil.getTotalMemorySize(internalStorageDir));
        storages.setMemoryAvailableSize(MemoryUtil.getAvailableMemorySize(internalStorageDir));
        this.storagesList.add(storages);
        for (File f : volumeList) {
            if (f.getName().equals("self") || f.getName().equals("emulated") || f.getName().equals("sdcard0")) continue;
            Storages sharedStorage = new Storages();
            sharedStorage.setStorageTitle(f.getName());
            sharedStorage.setMemoryTotalSize(MemoryUtil.getTotalMemorySize(f));
            sharedStorage.setMemoryAvailableSize(MemoryUtil.getAvailableMemorySize(f));
            this.storagesList.add(sharedStorage);
        }
    }

    public Dialog onCreateDialog(Bundle savedInstanceState) {
        Dialog d = StorageChooserBuilder.dialog;
        d.setContentView(this.getLayout(LayoutInflater.from((Context)this.getContext()), this.mContainer));
        return d;
    }

    public void onDismiss(DialogInterface dialog) {
        super.onDismiss(dialog);
    }
}

