/*
 * Decompiled with CFR 0.152.
 */
package com.codekidlabs.storagechooser;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.content.SharedPreferences;
import android.support.v4.app.FragmentManager;
import com.codekidlabs.storagechooser.fragments.ChooserDialogFragment;

public class StorageChooserBuilder {
    public static Dialog dialog;
    public static String STORAGE_STATIC_PATH;
    private Activity chooserActivity;
    private static boolean showMemoryBar;
    private FragmentManager fragmentManager;
    private static String preDefinedPath;
    private static SharedPreferences userSharedPreference;
    private static String userSharedPreferenceKey;

    private StorageChooserBuilder(Activity activity, FragmentManager mFragmentManager, boolean mShowMemoryBar, SharedPreferences sharedPreferences, String key, String mPath) {
        this.setChooserActivity(activity);
        this.setShowMemoryBar(mShowMemoryBar);
        this.setFragmentManager(mFragmentManager);
        StorageChooserBuilder.setPreDefinedPath(mPath);
        StorageChooserBuilder.setUserSharedPreference(sharedPreferences);
        StorageChooserBuilder.setUserSharedPreferenceKey(key);
    }

    private void init() {
        dialog = StorageChooserBuilder.getStorageChooserDialog(this.getChooserActivity());
        ChooserDialogFragment chooserDialogFragment = new ChooserDialogFragment();
        chooserDialogFragment.show(this.getFragmentManager(), "storagechooser_dialog");
    }

    private Activity getChooserActivity() {
        return this.chooserActivity;
    }

    private void setChooserActivity(Activity chooserActivity) {
        this.chooserActivity = chooserActivity;
    }

    public static boolean isShowMemoryBar() {
        return showMemoryBar;
    }

    private void setShowMemoryBar(boolean showMemoryBar) {
        StorageChooserBuilder.showMemoryBar = showMemoryBar;
    }

    private FragmentManager getFragmentManager() {
        return this.fragmentManager;
    }

    private void setFragmentManager(FragmentManager fragmentManager) {
        this.fragmentManager = fragmentManager;
    }

    public static String getPreDefinedPath() {
        return preDefinedPath;
    }

    public static void setPreDefinedPath(String preDefinedPath) {
        StorageChooserBuilder.preDefinedPath = preDefinedPath;
    }

    private static Dialog getStorageChooserDialog(Activity activity) {
        return new Dialog((Context)activity);
    }

    public static SharedPreferences getUserSharedPreference() {
        return userSharedPreference;
    }

    public static void setUserSharedPreference(SharedPreferences userSharedPreference) {
        StorageChooserBuilder.userSharedPreference = userSharedPreference;
    }

    public static String getUserSharedPreferenceKey() {
        return userSharedPreferenceKey;
    }

    public static void setUserSharedPreferenceKey(String userSharedPreferenceKey) {
        StorageChooserBuilder.userSharedPreferenceKey = userSharedPreferenceKey;
    }

    public static class Builder {
        private Activity mActivity;
        private FragmentManager mFragmentManager;
        private boolean mShowMemoryBar;
        private String mPath;
        private SharedPreferences mSharedPreferences;
        private String mSharedPreferencesKey;

        public Builder withActivity(Activity activity) {
            this.mActivity = activity;
            return this;
        }

        public Builder withFragmentManager(FragmentManager fragmentManager) {
            this.mFragmentManager = fragmentManager;
            return this;
        }

        public Builder withMemoryBar(boolean memoryBarBoolean) {
            this.mShowMemoryBar = memoryBarBoolean;
            return this;
        }

        public Builder withPredefinedPath(String path) {
            this.mPath = path;
            return this;
        }

        public Builder actionSave(SharedPreferences sharedPreferences, String spKey) {
            this.mSharedPreferences = sharedPreferences;
            this.mSharedPreferencesKey = spKey;
            return this;
        }

        public Builder build() {
            return this;
        }

        public void show() {
            new StorageChooserBuilder(this.mActivity, this.mFragmentManager, this.mShowMemoryBar, this.mSharedPreferences, this.mSharedPreferencesKey, this.mPath).init();
        }
    }
}

