/*
 * Decompiled with CFR 0.152.
 */
package com.codekidlabs.storagechooser;

import android.app.Activity;
import android.app.Dialog;
import android.app.FragmentManager;
import android.content.Context;
import android.content.SharedPreferences;
import android.os.Environment;
import android.util.Log;
import androidx.annotation.Nullable;
import com.codekidlabs.storagechooser.Content;
import com.codekidlabs.storagechooser.R;
import com.codekidlabs.storagechooser.fragments.ChooserDialogFragment;
import com.codekidlabs.storagechooser.models.Config;
import com.codekidlabs.storagechooser.utils.DiskUtil;
import java.util.ArrayList;
import java.util.List;

public class StorageChooser {
    public static final String NONE = "none";
    public static final String DIRECTORY_CHOOSER = "dir";
    public static final String FILE_PICKER = "file";
    public static Dialog dialog;
    public static Config sConfig;
    public static OnSelectListener onSelectListener;
    public static OnCancelListener onCancelListener;
    public static OnMultipleSelectListener onMultipleSelectListener;
    public static String LAST_SESSION_PATH;
    private final String TAG = this.getClass().getName();
    private Activity chooserActivity;

    StorageChooser(Activity activity, Config config) {
        StorageChooser.setsConfig(config);
        this.setChooserActivity(activity);
    }

    public StorageChooser() {
    }

    public static Config getsConfig() {
        return sConfig;
    }

    public static void setsConfig(Config sConfig) {
        StorageChooser.sConfig = sConfig;
    }

    private static Dialog getStorageChooserDialog(Activity activity) {
        return new Dialog((Context)activity, R.style.DialogTheme);
    }

    public void show() {
        this.init();
    }

    private void init() {
        dialog = StorageChooser.getStorageChooserDialog(this.getChooserActivity());
        if (onSelectListener == null) {
            onSelectListener = this.getDefaultOnSelectListener();
        }
        if (onCancelListener == null) {
            onCancelListener = this.getDefaultOnCancelListener();
        }
        if (onMultipleSelectListener == null) {
            onMultipleSelectListener = this.getDefaultMultipleSelectionListener();
        }
        if (sConfig.isResumeSession() && LAST_SESSION_PATH != null) {
            DiskUtil.showSecondaryChooser(LAST_SESSION_PATH, sConfig);
        } else if (sConfig.isSkipOverview()) {
            if (sConfig.getPrimaryPath() == null) {
                String dirPath = Environment.getExternalStorageDirectory().getAbsolutePath();
                DiskUtil.showSecondaryChooser(dirPath, sConfig);
            } else {
                DiskUtil.showSecondaryChooser(sConfig.getPrimaryPath(), sConfig);
            }
        } else {
            ChooserDialogFragment chooserDialogFragment = new ChooserDialogFragment();
            chooserDialogFragment.show(sConfig.getFragmentManager(), "storagechooser_dialog");
        }
    }

    public void setOnSelectListener(OnSelectListener onSelectListener) {
        StorageChooser.onSelectListener = onSelectListener;
    }

    public void setOnCancelListener(OnCancelListener onCancelListener) {
        StorageChooser.onCancelListener = onCancelListener;
    }

    public void setOnMultipleSelectListener(OnMultipleSelectListener onMultipleSelectListener) {
        StorageChooser.onMultipleSelectListener = onMultipleSelectListener;
    }

    private Activity getChooserActivity() {
        return this.chooserActivity;
    }

    private void setChooserActivity(Activity chooserActivity) {
        this.chooserActivity = chooserActivity;
    }

    private OnSelectListener getDefaultOnSelectListener() {
        return new OnSelectListener(){

            @Override
            public void onSelect(String path) {
                Log.e((String)StorageChooser.this.TAG, (String)("You need to setup OnSelectListener from your side. OUTPUT: " + path));
            }
        };
    }

    private OnCancelListener getDefaultOnCancelListener() {
        return new OnCancelListener(){

            @Override
            public void onCancel() {
                Log.e((String)StorageChooser.this.TAG, (String)"You need to setup OnCancelListener from your side. This is default OnCancelListener fired.");
            }
        };
    }

    private OnMultipleSelectListener getDefaultMultipleSelectionListener() {
        return new OnMultipleSelectListener(){

            @Override
            public void onDone(ArrayList<String> selectedFilePaths) {
                Log.e((String)StorageChooser.this.TAG, (String)"You need to setup OnMultipleSelectListener from your side. This is default OnMultipleSelectListener fired.");
            }
        };
    }

    static {
        LAST_SESSION_PATH = null;
    }

    public static class Theme {
        public static final int OVERVIEW_HEADER_INDEX = 0;
        public static final int OVERVIEW_TEXT_INDEX = 1;
        public static final int OVERVIEW_BG_INDEX = 2;
        public static final int OVERVIEW_STORAGE_TEXT_INDEX = 3;
        public static final int OVERVIEW_INDICATOR_INDEX = 4;
        public static final int OVERVIEW_MEMORYBAR_INDEX = 5;
        public static final int SEC_FOLDER_TINT_INDEX = 6;
        public static final int SEC_BG_INDEX = 7;
        public static final int SEC_TEXT_INDEX = 8;
        public static final int SEC_ADDRESS_TINT_INDEX = 9;
        public static final int SEC_HINT_TINT_INDEX = 10;
        public static final int SEC_SELECT_LABEL_INDEX = 11;
        public static final int SEC_FOLDER_CREATION_BG_INDEX = 12;
        public static final int SEC_DONE_FAB_INDEX = 13;
        public static final int SEC_ADDRESS_BAR_BG = 14;
        Context context;
        int[] scheme;

        public Theme(Context context) {
            this.context = context;
        }

        public int[] getDefaultScheme() {
            return this.context.getResources().getIntArray(R.array.default_light);
        }

        public int[] getDefaultDarkScheme() {
            return this.context.getResources().getIntArray(R.array.default_dark);
        }

        public int[] getScheme() {
            return this.scheme;
        }

        public void setScheme(int[] scheme) {
            this.scheme = scheme;
        }
    }

    public static class Builder {
        Config devConfig = new Config();
        private Activity mActivity;
        private boolean mActionSave = false;
        private boolean mShowMemoryBar = false;
        private boolean mHideFreeSpaceLabel = false;
        private boolean mAllowCustomPath = false;
        private boolean mAllowAddFolder = false;
        private boolean mShowHidden = false;
        private boolean mSkipOverview = false;
        private boolean mApplyMemoryThreshold = false;
        private boolean mShowInGrid = false;
        private boolean mResumeSession = false;
        private boolean mHeadingFromAssets = false;
        private boolean mListFromAssets = false;
        private float mMemorybarHeight = 2.0f;
        private String type;
        private Content content;
        private Theme theme;
        private FileType filter;
        private ArrayList<FileType> multipleFilter;

        public Builder withActivity(Activity activity) {
            this.mActivity = activity;
            return this;
        }

        public Builder withFragmentManager(FragmentManager fragmentManager) {
            this.devConfig.setFragmentManager(fragmentManager);
            return this;
        }

        public Builder withMemoryBar(boolean memoryBarBoolean) {
            this.mShowMemoryBar = memoryBarBoolean;
            return this;
        }

        public Builder hideFreeSpaceLabel(boolean hideFreeSpaceLabel) {
            this.mHideFreeSpaceLabel = hideFreeSpaceLabel;
            return this;
        }

        public Builder setMemoryBarHeight(float height) {
            this.mMemorybarHeight = height;
            return this;
        }

        public Builder withPredefinedPath(String path) {
            this.devConfig.setPredefinedPath(path);
            return this;
        }

        public Builder applyMemoryThreshold(boolean applyThreshold) {
            this.mApplyMemoryThreshold = applyThreshold;
            return this;
        }

        public Builder withThreshold(int size, String suffix) {
            this.devConfig.setMemoryThreshold(size);
            this.devConfig.setThresholdSuffix(suffix);
            return this;
        }

        public Builder withPreference(SharedPreferences sharedPreferences) {
            this.devConfig.setPreference(sharedPreferences);
            return this;
        }

        public Builder actionSave(boolean save) {
            this.mActionSave = save;
            return this;
        }

        public Builder setDialogTitle(String title) {
            this.devConfig.setDialogTitle(title);
            return this;
        }

        public Builder setInternalStorageText(String storageNameText) {
            this.devConfig.setInternalStorageText(storageNameText);
            return this;
        }

        public Builder allowCustomPath(boolean allowCustomPath) {
            this.mAllowCustomPath = allowCustomPath;
            return this;
        }

        public Builder allowAddFolder(boolean addFolder) {
            this.mAllowAddFolder = addFolder;
            return this;
        }

        public Builder showHidden(boolean showHiddenFolders) {
            this.mShowHidden = showHiddenFolders;
            return this;
        }

        public Builder setType(String action) {
            this.type = action;
            return this;
        }

        public Builder setTheme(Theme theme) {
            this.theme = theme;
            return this;
        }

        public Builder skipOverview(boolean skip, String primaryPath) {
            this.mSkipOverview = skip;
            this.devConfig.setPrimaryPath(primaryPath);
            return this;
        }

        public Builder skipOverview(boolean skip) {
            this.mSkipOverview = skip;
            return this;
        }

        public Builder withContent(Content content) {
            this.content = content;
            return this;
        }

        public Builder filter(@Nullable FileType filter) {
            this.filter = filter;
            return this;
        }

        public Builder crunch() {
            this.devConfig.setCustomFilter(false);
            return this;
        }

        public Builder customFilter(List<String> formats) {
            this.devConfig.setCustomFilter(true);
            this.devConfig.setCustomEnum(formats);
            return this;
        }

        public Builder showFoldersInGrid(boolean showInGrid) {
            this.devConfig.setGridView(showInGrid);
            return this;
        }

        public Builder shouldResumeSession(boolean resumeSession) {
            this.mResumeSession = resumeSession;
            return this;
        }

        public Builder setHeadingTypeface(String path, boolean fromAssets) {
            this.devConfig.setHeadingFont(path);
            this.mHeadingFromAssets = fromAssets;
            return this;
        }

        public Builder setListTypeface(String path, boolean fromAssets) {
            this.devConfig.setListFont(path);
            this.mListFromAssets = fromAssets;
            return this;
        }

        public Builder disableMultiSelect() {
            this.devConfig.setMultiSelect(false);
            return this;
        }

        public StorageChooser build() {
            this.devConfig.setActionSave(this.mActionSave);
            this.devConfig.setShowMemoryBar(this.mShowMemoryBar);
            this.devConfig.setHideFreeSpaceLabel(this.mHideFreeSpaceLabel);
            this.devConfig.setAllowCustomPath(this.mAllowCustomPath);
            this.devConfig.setAllowAddFolder(this.mAllowAddFolder);
            this.devConfig.setShowHidden(this.mShowHidden);
            this.devConfig.setSkipOverview(this.mSkipOverview);
            this.devConfig.setApplyThreshold(this.mApplyMemoryThreshold);
            this.devConfig.setResumeSession(this.mResumeSession);
            this.devConfig.setGridView(this.mShowInGrid);
            this.devConfig.setContent(this.content);
            this.devConfig.setSingleFilter(this.filter);
            this.devConfig.setMemorybarHeight(this.mMemorybarHeight);
            this.devConfig.setHeadingFromAssets(this.mHeadingFromAssets);
            this.devConfig.setListFromAssets(this.mListFromAssets);
            this.type = this.type == null ? StorageChooser.NONE : this.type;
            this.devConfig.setSecondaryAction(this.type);
            if (this.theme == null || this.theme.getScheme() == null) {
                this.theme = new Theme((Context)this.mActivity);
                this.devConfig.setScheme(this.theme.getDefaultScheme());
            } else {
                this.devConfig.setScheme(this.theme.getScheme());
            }
            return new StorageChooser(this.mActivity, this.devConfig);
        }
    }

    public static interface OnMultipleSelectListener {
        public void onDone(ArrayList<String> var1);
    }

    public static interface OnCancelListener {
        public void onCancel();
    }

    public static interface OnSelectListener {
        public void onSelect(String var1);
    }

    public static enum FileType {
        VIDEO,
        AUDIO,
        DOCS,
        IMAGES,
        ARCHIVE;

    }
}

