/*
 * Decompiled with CFR 0.152.
 */
package com.codekidlabs.storagechooser.fragments;

import android.app.Dialog;
import android.app.DialogFragment;
import android.content.Context;
import android.content.DialogInterface;
import android.graphics.drawable.Animatable;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.content.ContextCompat;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.TypedValue;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.view.inputmethod.InputMethodManager;
import android.widget.AdapterView;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.Toast;
import com.codekidlabs.storagechooser.Content;
import com.codekidlabs.storagechooser.R;
import com.codekidlabs.storagechooser.StorageChooser;
import com.codekidlabs.storagechooser.adapters.SecondaryChooserAdapter;
import com.codekidlabs.storagechooser.fragments.ChooserDialogFragment;
import com.codekidlabs.storagechooser.models.Config;
import com.codekidlabs.storagechooser.utils.DiskUtil;
import com.codekidlabs.storagechooser.utils.FileUtil;
import com.codekidlabs.storagechooser.utils.ResourceUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class SecondaryChooserFragment
extends DialogFragment {
    private View mLayout;
    private View mInactiveGradient;
    private ViewGroup mContainer;
    private TextView mPathChosen;
    private ImageButton mBackButton;
    private Button mSelectButton;
    private Button mCreateButton;
    private ImageView mNewFolderImageView;
    private EditText mFolderNameEditText;
    private RelativeLayout mNewFolderView;
    private String mBundlePath;
    private ListView listView;
    private static final String INTERNAL_STORAGE_TITLE = "Internal Storage";
    private static final String EXTERNAL_STORAGE_TITLE = "ExtSD";
    private static final int FLAG_DISSMISS_NORMAL = 0;
    private static final int FLAG_DISSMISS_INIT_DIALOG = 1;
    private boolean isOpen;
    private static String theSelectedPath = "";
    private static String mAddressClippedPath = "";
    private List<String> customStoragesList;
    private SecondaryChooserAdapter secondaryChooserAdapter;
    private FileUtil fileUtil;
    private Config mConfig;
    private Content mContent;
    private Context mContext;
    private Handler mHandler;
    private ResourceUtil mResourceUtil;
    private View.OnClickListener mSelectButtonClickListener = new View.OnClickListener(){

        public void onClick(View view) {
            if (SecondaryChooserFragment.this.mConfig.isActionSave()) {
                DiskUtil.saveChooserPathPreference(SecondaryChooserFragment.this.mConfig.getPreference(), theSelectedPath);
            } else {
                Log.d((String)"StorageChooser", (String)("Chosen path: " + theSelectedPath));
            }
            StorageChooser.onSelectListener.onSelect(theSelectedPath);
            SecondaryChooserFragment.this.dissmissDialog(0);
        }
    };
    private View.OnClickListener mBackButtonClickListener = new View.OnClickListener(){

        public void onClick(View view) {
            SecondaryChooserFragment.this.performBackAction();
        }
    };
    private View.OnClickListener mNewFolderButtonClickListener = new View.OnClickListener(){

        public void onClick(View view) {
            SecondaryChooserFragment.this.showAddFolderView();
        }
    };
    private View.OnClickListener mNewFolderButtonCloseListener = new View.OnClickListener(){

        public void onClick(View view) {
            SecondaryChooserFragment.this.hideAddFolderView();
            SecondaryChooserFragment.this.hideKeyboard();
        }
    };
    private View.OnClickListener mCreateButtonClickListener = new View.OnClickListener(){

        public void onClick(View view) {
            if (SecondaryChooserFragment.this.validateFolderName()) {
                boolean success = FileUtil.createDirectory(SecondaryChooserFragment.this.mFolderNameEditText.getText().toString().trim(), theSelectedPath);
                if (success) {
                    Toast.makeText((Context)SecondaryChooserFragment.this.mContext, (CharSequence)SecondaryChooserFragment.this.mContent.getFolderCreatedToastText(), (int)0).show();
                    SecondaryChooserFragment.this.trimPopulate(theSelectedPath);
                    SecondaryChooserFragment.this.hideKeyboard();
                    SecondaryChooserFragment.this.hideAddFolderView();
                } else {
                    Toast.makeText((Context)SecondaryChooserFragment.this.mContext, (CharSequence)SecondaryChooserFragment.this.mContent.getFolderErrorToastText(), (int)0).show();
                }
            }
        }
    };
    private boolean keyboardToggle;
    private String TAG = "StorageChooser";
    private boolean isFilePicker;

    private void showAddFolderView() {
        this.mNewFolderView.setVisibility(0);
        Animation anim2 = AnimationUtils.loadAnimation((Context)this.mContext, (int)R.anim.anim_new_folder_view);
        this.mNewFolderView.startAnimation(anim2);
        this.mInactiveGradient.startAnimation(anim2);
        if (DiskUtil.isLollipopAndAbove()) {
            this.mNewFolderImageView.setImageDrawable(ContextCompat.getDrawable((Context)this.mContext, (int)R.drawable.drawable_plus_to_close));
            Animatable animatable = (Animatable)this.mNewFolderImageView.getDrawable();
            animatable.start();
        }
        this.mNewFolderImageView.setOnClickListener(this.mNewFolderButtonCloseListener);
        SecondaryChooserAdapter.shouldEnable = false;
    }

    private void hideAddFolderView() {
        Animation anim2 = AnimationUtils.loadAnimation((Context)this.mContext, (int)R.anim.anim_close_folder_view);
        this.mNewFolderView.startAnimation(anim2);
        this.mNewFolderView.setVisibility(4);
        if (DiskUtil.isLollipopAndAbove()) {
            this.mNewFolderImageView.setImageDrawable(ContextCompat.getDrawable((Context)this.mContext, (int)R.drawable.drawable_close_to_plus));
            Animatable animatable = (Animatable)this.mNewFolderImageView.getDrawable();
            animatable.start();
        }
        this.mNewFolderImageView.setOnClickListener(this.mNewFolderButtonClickListener);
        SecondaryChooserAdapter.shouldEnable = true;
        this.mInactiveGradient.startAnimation(anim2);
        this.mInactiveGradient.setVisibility(4);
    }

    private boolean isFolderViewVisible() {
        return this.mNewFolderView.getVisibility() == 0;
    }

    public void hideKeyboard() {
        InputMethodManager imm = (InputMethodManager)this.getActivity().getSystemService("input_method");
        imm.hideSoftInputFromWindow(this.mFolderNameEditText.getWindowToken(), 0);
    }

    private void performBackAction() {
        int slashIndex = theSelectedPath.lastIndexOf("/");
        if (!this.mConfig.isSkipOverview()) {
            if (theSelectedPath.equals(this.mBundlePath)) {
                this.dismiss();
                this.mHandler.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        SecondaryChooserFragment.this.dissmissDialog(1);
                    }
                }, 200L);
            } else {
                theSelectedPath = theSelectedPath.substring(0, slashIndex);
                Log.e((String)"SCLib", (String)("Performing back action: " + theSelectedPath));
                this.populateList("");
            }
        } else {
            this.dissmissDialog(0);
        }
    }

    private void dissmissDialog(int flag) {
        theSelectedPath = "";
        mAddressClippedPath = "";
        switch (flag) {
            case 1: {
                ChooserDialogFragment c = new ChooserDialogFragment();
                c.show(this.mConfig.getFragmentManager(), "storagechooser_dialog");
                break;
            }
            case 0: {
                this.dismiss();
            }
        }
    }

    @Nullable
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        this.mContainer = container;
        if (this.getShowsDialog()) {
            return super.onCreateView(inflater, container, savedInstanceState);
        }
        return this.getLayout(inflater, container);
    }

    private View getLayout(LayoutInflater inflater, ViewGroup container) {
        this.mConfig = StorageChooser.sConfig;
        this.mHandler = new Handler();
        this.mContent = this.mConfig.getContent() == null ? new Content() : this.mConfig.getContent();
        this.mContext = this.getActivity().getApplicationContext();
        this.mResourceUtil = new ResourceUtil(this.mContext);
        this.mLayout = inflater.inflate(R.layout.custom_storage_list, container, false);
        this.initListView(this.mContext, this.mLayout, this.mConfig.isShowMemoryBar());
        this.initUI();
        this.initNewFolderView();
        this.updateUI();
        return this.mLayout;
    }

    private void initUI() {
        this.mBackButton = (ImageButton)this.mLayout.findViewById(R.id.back_button);
        this.mSelectButton = (Button)this.mLayout.findViewById(R.id.select_button);
        this.mCreateButton = (Button)this.mLayout.findViewById(R.id.create_folder_button);
        this.mNewFolderView = (RelativeLayout)this.mLayout.findViewById(R.id.new_folder_view);
        this.mFolderNameEditText = (EditText)this.mLayout.findViewById(R.id.et_folder_name);
        this.mInactiveGradient = this.mLayout.findViewById(R.id.inactive_gradient);
    }

    private void updateUI() {
        this.mNewFolderView.setVisibility(4);
        this.mInactiveGradient.setVisibility(4);
        this.mFolderNameEditText.setHint((CharSequence)this.mContent.getTextfieldHintText());
        if (Build.VERSION.SDK_INT >= 21) {
            this.mFolderNameEditText.setHintTextColor(this.mResourceUtil.getColor(this.mContent.getTextfieldHintColor()));
        }
        this.mSelectButton.setText((CharSequence)this.mContent.getSelectLabel());
        this.mCreateButton.setText((CharSequence)this.mContent.getCreateLabel());
        this.mSelectButton.setTextColor(this.mResourceUtil.getColor(R.color.select_color));
        this.mBackButton.setOnClickListener(this.mBackButtonClickListener);
        this.mSelectButton.setOnClickListener(this.mSelectButtonClickListener);
        this.mCreateButton.setOnClickListener(this.mCreateButtonClickListener);
        if (this.mConfig.getSecondaryAction() == "file") {
            this.mSelectButton.setVisibility(8);
            this.setBottomNewFolderView();
        }
    }

    private void setBottomNewFolderView() {
        int height = (int)TypedValue.applyDimension((int)1, (float)80.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
        RelativeLayout.LayoutParams lp = new RelativeLayout.LayoutParams(-1, height);
        lp.addRule(12);
        this.mNewFolderView.setLayoutParams((ViewGroup.LayoutParams)lp);
    }

    private void initNewFolderView() {
        RelativeLayout mNewFolderButtonHolder = (RelativeLayout)this.mLayout.findViewById(R.id.new_folder_button_holder);
        this.mNewFolderImageView = (ImageView)this.mLayout.findViewById(R.id.new_folder_iv);
        this.mNewFolderImageView.setOnClickListener(this.mNewFolderButtonClickListener);
        if (!this.mConfig.isAllowAddFolder()) {
            mNewFolderButtonHolder.setVisibility(8);
        }
    }

    private void initListView(Context context, View view, boolean shouldShowMemoryBar) {
        this.listView = (ListView)view.findViewById(R.id.storage_list_view);
        this.mPathChosen = (TextView)view.findViewById(R.id.path_chosen);
        this.mBundlePath = this.getArguments().getString("storage_chooser_path");
        this.isFilePicker = this.getArguments().getBoolean(DiskUtil.SC_CHOOSER_FLAG, false);
        this.populateList(this.mBundlePath);
        this.secondaryChooserAdapter = new SecondaryChooserAdapter(this.customStoragesList, context, this.mContent.getListTextColor());
        this.secondaryChooserAdapter.setPrefixPath(theSelectedPath);
        this.listView.setAdapter((ListAdapter)this.secondaryChooserAdapter);
        SecondaryChooserAdapter.shouldEnable = true;
        this.listView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> adapterView, View view, final int i, long l) {
                SecondaryChooserFragment.this.mHandler.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        String jointPath = theSelectedPath + "/" + (String)SecondaryChooserFragment.this.customStoragesList.get(i);
                        if (FileUtil.isDir(jointPath)) {
                            SecondaryChooserFragment.this.populateList("/" + (String)SecondaryChooserFragment.this.customStoragesList.get(i));
                        } else {
                            StorageChooser.onSelectListener.onSelect(jointPath);
                            SecondaryChooserFragment.this.dissmissDialog(0);
                        }
                    }
                }, 300L);
            }
        });
    }

    private void evaluateAction(int i) {
        String preDefPath = this.mConfig.getPredefinedPath();
        boolean isCustom = this.mConfig.isAllowCustomPath();
        if (preDefPath == null) {
            Log.w((String)this.TAG, (String)"No predefined path set");
        } else if (isCustom) {
            this.populateList("/" + this.customStoragesList.get(i));
        }
    }

    private boolean doesPassMemoryThreshold(long threshold, String memorySuffix, long availableSpace) {
        return true;
    }

    private void populateList(String path) {
        int pathLength;
        if (this.customStoragesList == null) {
            this.customStoragesList = new ArrayList<String>();
        } else {
            this.customStoragesList.clear();
        }
        this.fileUtil = new FileUtil();
        theSelectedPath = theSelectedPath + path;
        if (this.secondaryChooserAdapter != null && this.secondaryChooserAdapter.getPrefixPath() != null) {
            this.secondaryChooserAdapter.setPrefixPath(theSelectedPath);
        }
        if ((pathLength = theSelectedPath.length()) >= 25) {
            int slashCount = this.getSlashCount(theSelectedPath);
            if (slashCount > 2) {
                mAddressClippedPath = theSelectedPath.substring(theSelectedPath.indexOf("/", theSelectedPath.indexOf("/") + 2), pathLength);
            } else if (slashCount <= 2) {
                mAddressClippedPath = theSelectedPath.substring(theSelectedPath.indexOf("/", theSelectedPath.indexOf("/") + 2), pathLength);
            }
        } else {
            mAddressClippedPath = theSelectedPath;
        }
        File[] volumeList = this.isFilePicker ? this.fileUtil.listFilesInDir(theSelectedPath) : this.fileUtil.listFilesAsDir(theSelectedPath);
        Log.e((String)"SCLib", (String)theSelectedPath);
        if (volumeList != null) {
            for (File f : volumeList) {
                if (this.mConfig.isShowHidden()) {
                    this.customStoragesList.add(f.getName());
                    continue;
                }
                if (f.getName().startsWith(".")) continue;
                this.customStoragesList.add(f.getName());
            }
            Collections.sort(this.customStoragesList, new Comparator<String>(){

                @Override
                public int compare(String s1, String s2) {
                    return s1.compareToIgnoreCase(s2);
                }
            });
        } else {
            this.customStoragesList.clear();
        }
        if (this.secondaryChooserAdapter != null) {
            this.secondaryChooserAdapter.notifyDataSetChanged();
        }
        this.playTheAddressBarAnimation();
    }

    private void trimPopulate(String s) {
        if (this.customStoragesList == null) {
            this.customStoragesList = new ArrayList<String>();
        } else {
            this.customStoragesList.clear();
        }
        File[] volumeList = this.fileUtil.listFilesInDir(theSelectedPath);
        Log.e((String)"SCLib", (String)theSelectedPath);
        if (volumeList != null) {
            for (File f : volumeList) {
                if (f.getName().startsWith(".")) continue;
                this.customStoragesList.add(f.getName());
            }
            Collections.sort(this.customStoragesList, new Comparator<String>(){

                @Override
                public int compare(String s1, String s2) {
                    return s1.compareToIgnoreCase(s2);
                }
            });
        } else {
            this.customStoragesList.clear();
        }
        if (this.secondaryChooserAdapter != null) {
            this.secondaryChooserAdapter.setPrefixPath(s);
            this.secondaryChooserAdapter.notifyDataSetChanged();
        }
    }

    private void playTheAddressBarAnimation() {
        this.mPathChosen.setText((CharSequence)mAddressClippedPath);
        Animation animation = AnimationUtils.loadAnimation((Context)this.mContext, (int)R.anim.anim_address_bar);
        this.mPathChosen.startAnimation(animation);
    }

    @NonNull
    public Dialog onCreateDialog(Bundle savedInstanceState) {
        Dialog d = StorageChooser.dialog;
        d.setContentView(this.getLayout(LayoutInflater.from((Context)this.getActivity().getApplicationContext()), this.mContainer));
        WindowManager.LayoutParams lp = new WindowManager.LayoutParams();
        lp.copyFrom(d.getWindow().getAttributes());
        lp.width = -1;
        lp.height = -1;
        d.getWindow().setAttributes(lp);
        return d;
    }

    public void onCancel(DialogInterface dialog) {
        super.onCancel(dialog);
        theSelectedPath = "";
        mAddressClippedPath = "";
    }

    private int getSlashCount(String path) {
        int count = 0;
        for (char s : path.toCharArray()) {
            if (s != '/') continue;
            ++count;
        }
        return count;
    }

    private boolean validateFolderName() {
        if (this.mFolderNameEditText.getText().toString().trim().isEmpty()) {
            this.mFolderNameEditText.setError((CharSequence)this.mContent.getTextfieldErrorText());
            return false;
        }
        return true;
    }
}

