/*
 * Decompiled with CFR 0.152.
 */
package com.example.dynamikseekbar;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.PointF;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.widget.ProgressBar;
import com.example.dynamikseekbar.CreateFieldsAndBords;
import com.example.dynamikseekbar.DrawContent;
import com.example.dynamikseekbar.DrawFieldsAndBords;
import com.example.dynamikseekbar.R;
import com.example.dynamikseekbar.TouchEvent;

public class DynamicSeekBar
extends ProgressBar {
    public static final String GRAVITY_TOP = "top";
    public static final String GRAVITY_BOTTOM = "bottom";
    public static final String GRAVITY_LEFT = "left";
    public static final String GRAVITY_RIGHT = "right";
    public static final String ROUND_CIRCLE = "circle";
    public static final String ROUND_RECT = "rect";
    public static final String ORIENTATION_VERTICAL = "vertical";
    public static final String ORIENTATION_HORIZONTAL = "horizontal";
    public static final String DIRECT_STRAIGHT = "straight";
    public static final String DIRECT_BACK = "back";
    private OnSeekBarChangeListener dListener;
    private CreateFieldsAndBords dFields;
    private TouchEvent dTouch;
    private DrawFieldsAndBords dDrawFields;
    private DrawContent dDrawContent;
    private String dRoundMarc;
    private boolean dVisibleBackground;
    private boolean dReversText;
    private float dProgressValue;
    private float dPointTouchMark;
    private int dMaxValue;
    private int dMinValue;
    private float dStepValue;
    private boolean dExit;

    public DynamicSeekBar(Context context) {
        super(context);
        this.initDefaultVar();
    }

    public DynamicSeekBar(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initDefaultVar();
        TypedArray t = context.obtainStyledAttributes(attrs, R.styleable.DynamicSeekBar);
        if (this.check(t, R.styleable.DynamicSeekBar_orientation)) {
            this.setOrientation(t.getString(R.styleable.DynamicSeekBar_orientation));
        }
        if (this.check(t, R.styleable.DynamicSeekBar_gravity_text)) {
            this.setGravityText(t.getString(R.styleable.DynamicSeekBar_gravity_text));
        }
        if (this.check(t, R.styleable.DynamicSeekBar_rounded)) {
            this.setRound(t.getString(R.styleable.DynamicSeekBar_rounded));
        }
        if (this.check(t, R.styleable.DynamicSeekBar_direct)) {
            this.setDirect(t.getString(R.styleable.DynamicSeekBar_direct));
        }
        if (this.check(t, R.styleable.DynamicSeekBar_color_mark)) {
            this.setColorMark(t.getInt(R.styleable.DynamicSeekBar_color_mark, this.dDrawFields.getColorMark()));
        }
        if (this.check(t, R.styleable.DynamicSeekBar_color_way)) {
            this.setColorWay(t.getInt(R.styleable.DynamicSeekBar_color_way, this.dDrawFields.getColorWay()));
        }
        if (this.check(t, R.styleable.DynamicSeekBar_color_progress)) {
            this.setColorProgress(t.getInt(R.styleable.DynamicSeekBar_color_progress, this.dDrawFields.getColorProgress()));
        }
        if (this.check(t, R.styleable.DynamicSeekBar_color_background)) {
            this.setColorBackground(t.getInt(R.styleable.DynamicSeekBar_color_background, this.dDrawFields.getColorBackground()));
        }
        if (this.check(t, R.styleable.DynamicSeekBar_color_content)) {
            this.setColorContent(t.getInt(R.styleable.DynamicSeekBar_color_content, -1));
        }
        if (this.check(t, R.styleable.DynamicSeekBar_min_value)) {
            this.setMinValue(t.getInt(R.styleable.DynamicSeekBar_min_value, this.dMinValue));
        }
        if (this.check(t, R.styleable.DynamicSeekBar_max_value)) {
            this.setMaxValue(t.getInt(R.styleable.DynamicSeekBar_max_value, this.dMaxValue));
        }
        if (this.check(t, R.styleable.DynamicSeekBar_progress_value)) {
            this.setProgress(t.getInt(R.styleable.DynamicSeekBar_progress_value, 0));
        }
        if (this.check(t, R.styleable.DynamicSeekBar_step_value)) {
            this.setStepValue(t.getFloat(R.styleable.DynamicSeekBar_step_value, this.dStepValue));
        }
        if (this.check(t, R.styleable.DynamicSeekBar_text_size)) {
            this.setTextSize((float)t.getInt(R.styleable.DynamicSeekBar_text_size, 10) * context.getApplicationContext().getResources().getDisplayMetrics().density);
        }
        if (this.check(t, R.styleable.DynamicSeekBar_radius_way)) {
            this.setRadiusWay(t.getFloat(R.styleable.DynamicSeekBar_radius_way, 10.0f) * context.getApplicationContext().getResources().getDisplayMetrics().density);
        }
        if (this.check(t, R.styleable.DynamicSeekBar_visible_background)) {
            this.setVisibleBackground(t.getBoolean(R.styleable.DynamicSeekBar_visible_background, false));
        }
        if (this.check(t, R.styleable.DynamicSeekBar_visible_text)) {
            this.setVisibleText(t.getBoolean(R.styleable.DynamicSeekBar_visible_text, false));
        }
        if (this.check(t, R.styleable.DynamicSeekBar_visible_buttons)) {
            this.setVisibleButtons(t.getBoolean(R.styleable.DynamicSeekBar_visible_buttons, false));
        }
        if (this.check(t, R.styleable.DynamicSeekBar_revers_text)) {
            this.setReversText(t.getBoolean(R.styleable.DynamicSeekBar_revers_text, false));
        }
        if (this.check(t, R.styleable.DynamicSeekBar_drw_mark)) {
            this.setDrawableMark(this.extDrawable(t.getString(R.styleable.DynamicSeekBar_drw_mark)));
        }
        if (this.check(t, R.styleable.DynamicSeekBar_drw_b1)) {
            this.setDrawableB1(this.extDrawable(t.getString(R.styleable.DynamicSeekBar_drw_b1)));
        }
        if (this.check(t, R.styleable.DynamicSeekBar_drw_b2)) {
            this.setDrawableB2(this.extDrawable(t.getString(R.styleable.DynamicSeekBar_drw_b2)));
        }
        if (this.check(t, R.styleable.DynamicSeekBar_visible_bord_background)) {
            this.visibleBordBackground(t.getBoolean(R.styleable.DynamicSeekBar_visible_bord_background, false));
        }
        if (this.check(t, R.styleable.DynamicSeekBar_visible_bord_buttons)) {
            this.visibleBordButtons(t.getBoolean(R.styleable.DynamicSeekBar_visible_bord_buttons, false));
        }
        if (this.check(t, R.styleable.DynamicSeekBar_visible_bord_mark)) {
            this.visibleBordMark(t.getBoolean(R.styleable.DynamicSeekBar_visible_bord_mark, false));
        }
        if (this.check(t, R.styleable.DynamicSeekBar_width_bord)) {
            this.setWidthBord(t.getFloat(R.styleable.DynamicSeekBar_width_bord, 0.0f) * context.getApplicationContext().getResources().getDisplayMetrics().density);
        }
        if (this.check(t, R.styleable.DynamicSeekBar_color_bord_mark)) {
            this.setColorBordMark(t.getInt(R.styleable.DynamicSeekBar_color_bord_mark, 0));
        }
        if (this.check(t, R.styleable.DynamicSeekBar_color_bord_background)) {
            this.setColorBordBackground(t.getInt(R.styleable.DynamicSeekBar_color_bord_background, 0));
        }
    }

    private boolean check(TypedArray t, int id) {
        return t.hasValue(id);
    }

    public void setOnSeekBarChangeListener(OnSeekBarChangeListener listener) {
        this.dListener = listener;
    }

    protected void onDraw(Canvas canvas) {
        this.dFields.setParams(canvas);
        if (this.checkParams()) {
            this.drawBackground(canvas);
            this.drawWay(canvas);
            this.drawProgress(canvas);
            this.drawMark(canvas);
            this.drawButtons(canvas);
            this.drawBord(canvas);
        } else {
            this.drawError(canvas);
        }
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    public boolean onTouchEvent(MotionEvent event) {
        int touch = this.dTouch.touch(event);
        if (event.getAction() == 0) {
            this.actionDown(event, touch);
        } else if (event.getAction() == 1) {
            this.actionUp(event, touch);
            this.dDrawContent.reversText(false);
        } else if (event.getAction() == 2) {
            this.actionMove(event, touch);
        }
        this.invalidate();
        return true;
    }

    private void actionDown(MotionEvent event, int touch) {
        if (touch == 3) {
            this.touchButton1();
        } else if (touch == 4) {
            this.touchButton2();
        } else if (touch == 2) {
            this.touchMark(new PointF(event.getX(), event.getY()));
        } else if (touch == 1) {
            this.touchWay(new PointF(event.getX(), event.getY()));
        }
    }

    private void actionUp(MotionEvent event, int touch) {
        if (touch == 1 || touch == 2 || touch == 3 || touch == 4) {
            this.correctPosition();
        }
    }

    private void actionMove(MotionEvent event, int touch) {
        if (touch == 1 || touch == 2) {
            this.translatePosition(new PointF(event.getX(), event.getY()));
        } else if (touch == 0) {
            this.exit();
        }
    }

    public void setDrawableMark(Drawable d) {
        this.dDrawContent.srcMark(d);
    }

    public void setDrawableButtons(Drawable b1, Drawable b2) {
        this.dDrawContent.srcButtons(b1 != null ? b1 : this.dDrawContent.getButton1(), b2 != null ? b2 : this.dDrawContent.getButton2());
    }

    public void setDrawableB1(Drawable d) {
        this.dDrawContent.srcButton1(d);
    }

    public void setDrawableB2(Drawable d) {
        this.dDrawContent.srcButton2(d);
    }

    public void setReversText(boolean revers) {
        this.dReversText = revers;
    }

    public boolean isReversText() {
        return this.dReversText;
    }

    public void setRadiusWay(float r) {
        this.dFields.radiusWay(r);
        this.invalidate();
    }

    public float getRadiusWay() {
        return this.dFields.getRadiusWay();
    }

    public void setColorBordMark(int color2) {
        this.dDrawFields.setColorBordMark(color2);
    }

    public void setColorBordBackground(int color2) {
        this.dDrawFields.setColorBordBackground(color2);
    }

    public void setWidthBord(float width) {
        this.dFields.widthBord(width);
        this.dDrawFields.width(width);
    }

    public void visibleBordButtons(boolean visible) {
        this.dDrawFields.setVisibleBordButtons(visible);
    }

    public void visibleBordBackground(boolean visible) {
        this.dFields.visibleBord(visible);
        this.dDrawFields.setVisibleBordBackground(visible);
    }

    public void visibleBordMark(boolean visible) {
        this.dDrawFields.setVisibleBordMark(visible);
    }

    public void setVisibleBackground(boolean visible) {
        this.dVisibleBackground = visible;
        this.dDrawFields.visibilityBackground(this.dVisibleBackground);
        this.invalidate();
    }

    public boolean isVisibleBackground() {
        return this.dVisibleBackground;
    }

    public void setVisibleButtons(boolean visible) {
        this.dFields.buttons(visible);
        this.invalidate();
    }

    public boolean isVisibleButtons() {
        return this.dFields.isVisibleButtons();
    }

    public void setDirect(String direct) {
        this.dFields.direct(direct);
        this.invalidate();
    }

    public String getDirect() {
        return this.dFields.getDirect();
    }

    public void setOrientation(String orientation) {
        this.dFields.orientation(orientation);
        this.invalidate();
    }

    public String getOrientation() {
        return this.dFields.getOrientation();
    }

    public void setStepValue(float value) {
        this.dStepValue = value;
        this.invalidate();
    }

    public float getStepValue() {
        return this.dStepValue;
    }

    public void setMaxValue(int value) {
        this.dMaxValue = value;
        this.invalidate();
    }

    public void setMinValue(int value) {
        this.dMinValue = value;
        this.setProgressValue(this.getProgressValue() - (float)this.getMinValue());
        this.report(false);
        this.invalidate();
    }

    public int getMaxValue() {
        return this.dMaxValue;
    }

    public int getMinValue() {
        return this.dMinValue;
    }

    public void setRound(String round) {
        this.dRoundMarc = round;
        this.dDrawFields.rounded(this.dRoundMarc);
        this.dDrawContent.rounded(this.dRoundMarc);
        this.invalidate();
    }

    public String getRound() {
        return this.dRoundMarc;
    }

    public void setVisibleText(boolean visible) {
        this.dDrawContent.visibleText(visible);
        this.invalidate();
    }

    public boolean isVisibleText() {
        return this.dDrawContent.isVisibleText();
    }

    public void setTextSize(float size) {
        this.dDrawContent.textSize(size);
        this.invalidate();
    }

    public float getTextSize() {
        return this.dDrawContent.getTextSize();
    }

    public void setGravityText(String gravity) {
        this.dDrawContent.gravityText(gravity);
        this.invalidate();
    }

    public String getGravityText() {
        return this.dDrawContent.getGravity();
    }

    public void setColorContent(int color2) {
        this.dDrawContent.colorContent(color2);
        this.invalidate();
    }

    public int getColorContent() {
        return this.dDrawContent.getColorContent();
    }

    public void setColorProgress(int color2) {
        this.dDrawFields.setColorProgress(color2);
        this.invalidate();
    }

    public int getColorProgress() {
        return this.dDrawFields.getColorProgress();
    }

    public void setColorWay(int color2) {
        this.dDrawFields.setColorWay(color2);
        this.invalidate();
    }

    public int getColorWay() {
        return this.dDrawFields.getColorWay();
    }

    public void setColorBackground(int color2) {
        this.dDrawFields.setColorBackground(color2);
        this.invalidate();
    }

    public int getColorBackground() {
        return this.dDrawFields.getColorBackground();
    }

    public void setColorMark(int color2) {
        this.dDrawFields.setColorMark(color2);
        this.invalidate();
    }

    public int getColorMark() {
        return this.dDrawFields.getColorMark();
    }

    public synchronized void setProgress(int progress) {
        this.setProgressValue(progress - this.getMinValue());
        this.report(false);
        this.invalidate();
    }

    public void setProgress(int progress, boolean animate) {
        this.setProgress(progress);
        this.report(false);
    }

    public synchronized int getProgress() {
        return Math.round(this.getProgressValue() + (float)this.getMinValue());
    }

    private void drawError(Canvas canvas) {
        canvas.drawColor(-65536);
    }

    private void drawBord(Canvas canvas) {
        this.dDrawFields.bordButtons(canvas);
        this.dDrawFields.bordMark(canvas);
        this.dDrawFields.bordBackground(canvas);
    }

    private void drawButtons(Canvas canvas) {
        if (!this.dFields.isVisibleButtons()) {
            return;
        }
        this.dDrawFields.drawButtons(canvas);
        this.dDrawContent.drawContentButtons(this.getProgress(), canvas);
    }

    private void drawMark(Canvas canvas) {
        this.dDrawFields.drawMark(canvas, this.getLocation());
        this.dDrawContent.drawContentMark(this.getProgress(), canvas);
    }

    private void drawProgress(Canvas canvas) {
        this.dDrawFields.drawProgress(canvas, this.getLocation());
    }

    private void drawWay(Canvas canvas) {
        this.dDrawFields.drawWay(canvas);
    }

    private void drawBackground(Canvas canvas) {
        this.dDrawFields.drawBackground(canvas);
    }

    private long getLocation() {
        long loc = (long)(this.dFields.indent() + this.getPositionPixel());
        if (this.dFields.getDirect().equals(DIRECT_BACK)) {
            return this.getLength() - loc;
        }
        return loc;
    }

    private float getSegment(PointF p) {
        return this.dFields.getOrientation().equals(ORIENTATION_VERTICAL) ? p.y : p.x;
    }

    private void exit() {
        if (this.dExit) {
            this.correctPosition();
            this.dExit = false;
        }
    }

    private void correctPosition() {
        if (this.getProgressValue() != (float)Math.round(this.getProgressValue()) || this.dExit) {
            this.setProgressValue(Math.round(this.getProgressValue()));
            this.report(true);
            this.reportFin();
            this.dDrawContent.reversText(false);
        }
    }

    private void touchWay(PointF p) {
        this.dExit = true;
        float step = this.dFields.getLengthWay() / (float)this.getSegmentValue();
        float pix = p.x;
        if (this.dFields.getOrientation().equals(ORIENTATION_VERTICAL)) {
            pix = p.y;
        }
        float value = (pix - this.dFields.indent()) / step;
        if (this.dFields.getDirect().equals(DIRECT_BACK)) {
            value = ((float)this.getLength() - (pix + this.dFields.indent())) / step;
        }
        this.setProgressValue(value);
        this.dPointTouchMark = this.getSegment(p);
        this.reportStart();
        this.dDrawContent.reversText(this.dReversText);
    }

    private void touchMark(PointF p) {
        this.dExit = true;
        this.dPointTouchMark = this.getSegment(p);
        this.reportStart();
        this.dDrawContent.reversText(this.dReversText);
    }

    private void translatePosition(PointF point) {
        if (this.dExit) {
            float step = this.getSegment(point) - this.dPointTouchMark;
            float loc = (float)this.getLocation() + step;
            float stepPix = this.dFields.getLengthWay() / (float)this.getSegmentValue();
            float value = (loc - this.dFields.indent()) / stepPix;
            if (this.dFields.getDirect().equals(DIRECT_BACK)) {
                value = ((float)this.getLength() - (loc + this.dFields.indent())) / stepPix;
            }
            int old = Math.round(this.getProgressValue());
            this.setProgressValue(value);
            if (old != Math.round(this.getProgressValue())) {
                this.report(true);
            }
            this.dPointTouchMark = this.getSegment(point);
            this.dDrawContent.reversText(this.dReversText);
        }
    }

    private void touchButton1() {
        this.dExit = true;
        float step = this.getProgressValue() - this.getStepValue();
        if (this.dFields.getDirect().equals(DIRECT_BACK)) {
            step = this.getProgressValue() + this.getStepValue();
        }
        this.setProgressValue(step);
        this.report(true);
    }

    private void touchButton2() {
        this.dExit = true;
        float step = this.getProgressValue() + this.getStepValue();
        if (this.dFields.getDirect().equals(DIRECT_BACK)) {
            step = this.getProgressValue() - this.getStepValue();
        }
        this.setProgressValue(step);
        this.report(true);
    }

    private void report(boolean user) {
        if (this.dListener != null) {
            this.dListener.onProgressChanged(this, this.getProgress(), user);
        }
    }

    private void reportStart() {
        if (this.dListener != null) {
            this.dListener.onStartTrackingTouch(this);
        }
    }

    private void reportFin() {
        if (this.dListener != null) {
            this.dListener.onStopTrackingTouch(this);
        }
    }

    private float getPositionPixel() {
        return this.getProgressValue() * this.getStepPixels();
    }

    private float getStepPixels() {
        return this.dFields.getLengthWay() / (float)this.getSegmentValue();
    }

    private long getLength() {
        return this.dFields.getLength();
    }

    private void setProgressValue(float progress) {
        this.dProgressValue = progress < 0.0f ? 0.0f : (progress > (float)this.getSegmentValue() ? (float)this.getSegmentValue() : progress);
    }

    private float getProgressValue() {
        if (this.dProgressValue < 0.0f) {
            this.dProgressValue = 0.0f;
        }
        if (this.dProgressValue > (float)this.getSegmentValue()) {
            this.dProgressValue = this.getSegmentValue();
        }
        return this.dProgressValue;
    }

    private int getSegmentValue() {
        return this.getMaxValue() - this.getMinValue();
    }

    private boolean checkParams() {
        if (this.dFields.isVisibleButtons()) {
            if (this.dFields.getOrientation().equals(ORIENTATION_VERTICAL)) {
                return this.getHeight() >= this.getWidth() * 3;
            }
            if (this.dFields.getOrientation().equals(ORIENTATION_HORIZONTAL)) {
                return this.getWidth() >= this.getHeight() * 3;
            }
        } else {
            if (this.dFields.getOrientation().equals(ORIENTATION_VERTICAL)) {
                return this.getHeight() >= this.getWidth();
            }
            if (this.dFields.getOrientation().equals(ORIENTATION_HORIZONTAL)) {
                return this.getWidth() >= this.getHeight();
            }
        }
        return false;
    }

    private Drawable extDrawable(String path) {
        String[] names = this.getNames(path);
        int i = this.getContext().getResources().getIdentifier(names[0], names[1], this.getContext().getPackageName());
        return this.getContext().getDrawable(i);
    }

    private String[] getNames(String path) {
        String[] arr = path.split("[./-]");
        return new String[]{arr[arr.length - 2], arr[1]};
    }

    private void initDefaultVar() {
        this.dFields = CreateFieldsAndBords.get();
        this.dTouch = new TouchEvent(this.dFields);
        this.dDrawFields = new DrawFieldsAndBords(this.dFields);
        this.dDrawFields.initDefColors(this.getContext());
        this.dDrawContent = new DrawContent(this.dFields);
        this.dFields.buttons(false).radiusWay(10.0f);
        this.dVisibleBackground = true;
        this.dRoundMarc = ROUND_CIRCLE;
        this.dMaxValue = 100;
        this.dMinValue = 0;
        this.dProgressValue = 0.0f;
        this.dStepValue = 1.0f;
    }

    public static void MASSAGE(String t) {
        Log.d((String)"________DYNAMIK", (String)t);
    }

    public static interface OnSeekBarChangeListener {
        public void onProgressChanged(DynamicSeekBar var1, int var2, boolean var3);

        public void onStartTrackingTouch(DynamicSeekBar var1);

        public void onStopTrackingTouch(DynamicSeekBar var1);
    }
}

