/*
 * Decompiled with CFR 0.152.
 */
package com.github.cloudyrock.spring.v5;

import com.github.cloudyrock.mongock.MongockConnectionDriver;
import com.github.cloudyrock.mongock.driver.mongodb.springdata.v3.SpringDataMongo3Driver;
import com.github.cloudyrock.spring.v5.ConfigErrorMessageUtils;
import com.github.cloudyrock.spring.v5.MongockConfiguration;
import com.github.cloudyrock.spring.v5.MongockSpring5;
import com.github.cloudyrock.spring.v5.MongockSpringDataCoreContextBase;
import io.changock.migration.api.exception.ChangockException;
import java.util.Optional;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.mongodb.MongoTransactionManager;
import org.springframework.data.mongodb.core.MongoTemplate;

@Configuration
@ConditionalOnProperty(prefix="mongock", name={"enabled"}, matchIfMissing=true, havingValue="true")
public class MongockSpringDataV3CoreContext
extends MongockSpringDataCoreContextBase {
    @Bean
    public SpringDataMongo3Driver mongockConnectionDriver(MongoTemplate mongoTemplate, MongockConfiguration mongockConfiguration, Optional<MongoTransactionManager> txManagerOpt) {
        try {
            SpringDataMongo3Driver driver = SpringDataMongo3Driver.withLockSetting((MongoTemplate)mongoTemplate, (long)mongockConfiguration.getLockAcquiredForMinutes(), (long)mongockConfiguration.getMaxWaitingForLockMinutes(), (int)mongockConfiguration.getMaxTries());
            if (mongockConfiguration.isTransactionEnabled() && txManagerOpt.isPresent()) {
                txManagerOpt.ifPresent(arg_0 -> ((SpringDataMongo3Driver)driver).enableTransactionWithTxManager(arg_0));
            } else {
                driver.disableTransaction();
            }
            this.setUpMongockConnectionDriver(mongockConfiguration, (MongockConnectionDriver)driver);
            return driver;
        }
        catch (NoClassDefFoundError driver3NotFoundError) {
            throw new ChangockException("\n\n" + ConfigErrorMessageUtils.getDriverNotFoundErrorMessage() + "\n\n");
        }
    }

    @Bean
    public MongockSpring5.Builder mongockBuilder(SpringDataMongo3Driver mongockConnectionDriver, MongockConfiguration mongockConfiguration, ApplicationContext springContext) {
        return super.mongockBuilder((MongockConnectionDriver)mongockConnectionDriver, mongockConfiguration, springContext);
    }
}

