/*
 * Decompiled with CFR 0.152.
 */
package com.github.cloudyrock.spring.util;

import com.github.cloudyrock.mongock.runner.core.event.EventPublisher;
import com.github.cloudyrock.mongock.runner.core.event.MigrationResult;
import com.github.cloudyrock.spring.util.events.SpringMigrationFailureEvent;
import com.github.cloudyrock.spring.util.events.SpringMigrationStartedEvent;
import com.github.cloudyrock.spring.util.events.SpringMigrationSuccessEvent;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;

public class SpringEventPublisher
implements EventPublisher {
    private final ApplicationEventPublisher applicationEventPublisher;

    public SpringEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }

    public void publishMigrationStarted() {
        this.runIfPublisherNotNull(() -> this.applicationEventPublisher.publishEvent((ApplicationEvent)new SpringMigrationStartedEvent(this)));
    }

    public void publishMigrationSuccessEvent(MigrationResult migrationResult) {
        this.runIfPublisherNotNull(() -> this.applicationEventPublisher.publishEvent((ApplicationEvent)new SpringMigrationSuccessEvent(this, migrationResult)));
    }

    public void publishMigrationFailedEvent(Exception ex) {
        this.runIfPublisherNotNull(() -> this.applicationEventPublisher.publishEvent((ApplicationEvent)new SpringMigrationFailureEvent(this, ex)));
    }

    private void runIfPublisherNotNull(Runnable op) {
        if (this.applicationEventPublisher != null) {
            op.run();
        }
    }
}

