/*
 * Decompiled with CFR 0.152.
 */
package com.github.cloudyrock.spring.util;

import java.lang.reflect.AnnotatedElement;
import java.util.List;
import javax.annotation.Nonnull;
import org.springframework.context.annotation.Profile;
import org.springframework.util.StringUtils;

public final class ProfileUtil {
    private ProfileUtil() {
    }

    private static boolean isNegativeProfile(@Nonnull String profile) {
        return profile.charAt(0) == '!';
    }

    private static boolean containsProfile(@Nonnull List<String> activeProfiles, @Nonnull String profile) {
        return activeProfiles.contains(profile);
    }

    private static boolean containsNegativeProfile(@Nonnull List<String> activeProfiles, @Nonnull String profile) {
        return ProfileUtil.containsProfile(activeProfiles, profile.substring(1));
    }

    public static <T extends AnnotatedElement> boolean matchesActiveSpringProfile(@Nonnull List<String> activeProfiles, @Nonnull T element) {
        if (!element.isAnnotationPresent(Profile.class)) {
            return true;
        }
        boolean containsActiveProfile = false;
        for (String profile : element.getAnnotation(Profile.class).value()) {
            if (StringUtils.isEmpty((Object)profile)) continue;
            if (ProfileUtil.isNegativeProfile(profile)) {
                if (!ProfileUtil.containsNegativeProfile(activeProfiles, profile)) continue;
                return false;
            }
            containsActiveProfile = true;
            if (!ProfileUtil.containsProfile(activeProfiles, profile)) continue;
            return true;
        }
        return !containsActiveProfile;
    }
}

