/*
 * Decompiled with CFR 0.152.
 */
package io.changock.driver.api.lock.guard.proxy;

import io.changock.driver.api.lock.LockManager;
import io.changock.driver.api.lock.guard.proxy.LockGuardProxyFactory;
import io.changock.migration.api.annotations.NonLockGuarded;
import io.changock.migration.api.annotations.NonLockGuardedType;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class LockGuardProxy<T>
implements InvocationHandler {
    private final LockManager lockManager;
    private final T implementation;
    private final LockGuardProxyFactory proxyFactory;

    public LockGuardProxy(T implementation, LockManager lockManager, LockGuardProxyFactory proxyFactory) {
        this.implementation = implementation;
        this.lockManager = lockManager;
        this.proxyFactory = proxyFactory;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        List<NonLockGuardedType> noGuardedLockTypes;
        NonLockGuarded nonLockGuarded = method.getAnnotation(NonLockGuarded.class);
        List<NonLockGuardedType> list = noGuardedLockTypes = nonLockGuarded != null ? Arrays.asList(nonLockGuarded.value()) : Collections.emptyList();
        if (LockGuardProxy.shouldMethodBeLockGuarded(noGuardedLockTypes)) {
            this.lockManager.ensureLockDefault();
        }
        return LockGuardProxy.shouldTryProxyReturn(noGuardedLockTypes) ? this.proxyFactory.getRawProxy(method.invoke(this.implementation, args), method.getReturnType()) : method.invoke(this.implementation, args);
    }

    private static boolean shouldTryProxyReturn(List<NonLockGuardedType> methodNoGuardedLockTypes) {
        return !methodNoGuardedLockTypes.contains(NonLockGuardedType.RETURN) && !methodNoGuardedLockTypes.contains(NonLockGuardedType.NONE);
    }

    private static boolean shouldMethodBeLockGuarded(List<NonLockGuardedType> noGuardedLockTypes) {
        return !noGuardedLockTypes.contains(NonLockGuardedType.METHOD) && !noGuardedLockTypes.contains(NonLockGuardedType.NONE);
    }
}

