/*
 * Decompiled with CFR 0.152.
 */
package org.json.simple;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.json.simple.Jsonable;
import org.json.simple.Jsoner;

public class JsonObject
extends HashMap<String, Object>
implements Jsonable {
    private static final long serialVersionUID = 1L;

    public JsonObject() {
    }

    public JsonObject(Map<String, ?> map) {
        super(map);
    }

    public BigDecimal getBigDecimal(String key) {
        Object returnable = this.get(key);
        if (!(returnable instanceof BigDecimal)) {
            if (returnable instanceof Number) {
                returnable = new BigDecimal(returnable.toString());
            } else if (returnable instanceof String) {
                returnable = new BigDecimal((String)returnable);
            }
        }
        return (BigDecimal)returnable;
    }

    public BigDecimal getBigDecimalOrDefault(String key, BigDecimal defaultValue) {
        BigDecimal returnable = this.containsKey(key) ? this.get(key) : defaultValue;
        if (!(returnable instanceof BigDecimal)) {
            if (returnable instanceof Number) {
                returnable = new BigDecimal(((Object)returnable).toString());
            } else if (returnable instanceof String) {
                returnable = new BigDecimal((String)((Object)returnable));
            }
        }
        return returnable;
    }

    public Boolean getBoolean(String key) {
        return (Boolean)this.get(key);
    }

    public Boolean getBooleanOrDefault(String key, boolean defaultValue) {
        Boolean returnable = this.containsKey(key) ? this.get(key) : Boolean.valueOf(defaultValue);
        return returnable;
    }

    public Byte getByte(String key) {
        Object returnable = this.get(key);
        if (returnable == null) {
            return (Byte)returnable;
        }
        return ((Number)returnable).byteValue();
    }

    public Byte getByteOrDefault(String key, byte defaultValue) {
        Byte returnable = this.containsKey(key) ? this.get(key) : Byte.valueOf(defaultValue);
        return ((Number)returnable).byteValue();
    }

    public <T extends Collection<?>> T getCollection(String key) {
        return (T)((Collection)this.get(key));
    }

    public <T extends Collection<?>> T getCollectionOrDefault(String key, T defaultValue) {
        Object returnable = this.containsKey(key) ? this.get(key) : defaultValue;
        return returnable;
    }

    public Double getDouble(String key) {
        Object returnable = this.get(key);
        if (returnable == null) {
            return (Double)returnable;
        }
        return ((Number)returnable).doubleValue();
    }

    public Double getDoubleOrDefault(String key, double defaultValue) {
        Double returnable = this.containsKey(key) ? this.get(key) : Double.valueOf(defaultValue);
        return ((Number)returnable).doubleValue();
    }

    public <T extends Enum<T>> T getEnum(String key) throws ClassNotFoundException {
        String value = this.getStringOrDefault(key, "");
        String[] splitValues = value.split("\\.");
        int numberOfSplitValues = splitValues.length;
        StringBuilder returnTypeName = new StringBuilder();
        StringBuilder enumName = new StringBuilder();
        for (int i = 0; i < numberOfSplitValues; ++i) {
            if (i == numberOfSplitValues - 1) {
                enumName.append(splitValues[i]);
                continue;
            }
            if (i == numberOfSplitValues - 2) {
                returnTypeName.append(splitValues[i]);
                continue;
            }
            returnTypeName.append(splitValues[i]);
            returnTypeName.append(".");
        }
        Class<?> returnType = Class.forName(returnTypeName.toString());
        Object returnable = Enum.valueOf(returnType, enumName.toString());
        return (T)returnable;
    }

    public <T extends Enum<T>> T getEnumOrDefault(String key, T defaultValue) throws ClassNotFoundException {
        if (this.containsKey(key)) {
            String value = this.getStringOrDefault(key, "");
            String[] splitValues = value.split("\\.");
            int numberOfSplitValues = splitValues.length;
            StringBuilder returnTypeName = new StringBuilder();
            StringBuilder enumName = new StringBuilder();
            for (int i = 0; i < numberOfSplitValues; ++i) {
                if (i == numberOfSplitValues - 1) {
                    enumName.append(splitValues[i]);
                    continue;
                }
                if (i == numberOfSplitValues - 2) {
                    returnTypeName.append(splitValues[i]);
                    continue;
                }
                returnTypeName.append(splitValues[i]);
                returnTypeName.append(".");
            }
            Class<?> returnType = Class.forName(returnTypeName.toString());
            Object returnable = Enum.valueOf(returnType, enumName.toString());
            return (T)returnable;
        }
        T returnable = defaultValue;
        return returnable;
    }

    public Float getFloat(String key) {
        Object returnable = this.get(key);
        if (returnable == null) {
            return (Float)returnable;
        }
        return Float.valueOf(((Number)returnable).floatValue());
    }

    public Float getFloatOrDefault(String key, float defaultValue) {
        Float returnable = this.containsKey(key) ? this.get(key) : Float.valueOf(defaultValue);
        return Float.valueOf(((Number)returnable).floatValue());
    }

    public Integer getInteger(String key) {
        Object returnable = this.get(key);
        if (returnable == null) {
            return (Integer)returnable;
        }
        return ((Number)returnable).intValue();
    }

    public Integer getIntegerOrDefault(String key, int defaultValue) {
        Integer returnable = this.containsKey(key) ? this.get(key) : Integer.valueOf(defaultValue);
        return ((Number)returnable).intValue();
    }

    public Long getLong(String key) {
        Object returnable = this.get(key);
        if (returnable == null) {
            return (Long)returnable;
        }
        return ((Number)returnable).longValue();
    }

    public Long getLongOrDefault(String key, long defaultValue) {
        Long returnable = this.containsKey(key) ? this.get(key) : Long.valueOf(defaultValue);
        return ((Number)returnable).longValue();
    }

    public <T extends Map<?, ?>> T getMap(String key) {
        return (T)((Map)this.get(key));
    }

    public <T extends Map<?, ?>> T getMapOrDefault(String key, T defaultValue) {
        Object returnable = this.containsKey(key) ? this.get(key) : defaultValue;
        return returnable;
    }

    public Short getShort(String key) {
        Object returnable = this.get(key);
        if (returnable == null) {
            return (Short)returnable;
        }
        return ((Number)returnable).shortValue();
    }

    public Short getShortOrDefault(String key, short defaultValue) {
        Short returnable = this.containsKey(key) ? this.get(key) : Short.valueOf(defaultValue);
        return ((Number)returnable).shortValue();
    }

    public String getString(String key) {
        return (String)this.get(key);
    }

    public String getStringOrDefault(String key, String defaultValue) {
        String returnable = this.containsKey(key) ? this.get(key) : defaultValue;
        return returnable;
    }

    @Override
    public String toJson() {
        StringWriter writable = new StringWriter();
        try {
            this.toJson(writable);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return writable.toString();
    }

    @Override
    public void toJson(Writer writable) throws IOException {
        boolean isFirstEntry = true;
        Iterator entries = this.entrySet().iterator();
        writable.write(123);
        while (entries.hasNext()) {
            if (isFirstEntry) {
                isFirstEntry = false;
            } else {
                writable.write(44);
            }
            Map.Entry entry = entries.next();
            writable.write(Jsoner.serialize(entry.getKey()));
            writable.write(58);
            writable.write(Jsoner.serialize(entry.getValue()));
        }
        writable.write(125);
    }
}

