/*
 * Decompiled with CFR 0.152.
 */
package com.claudiodegio.msv.adapter;

import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Filter;
import android.widget.Filterable;
import android.widget.ImageView;
import android.widget.TextView;
import com.claudiodegio.msv.R;
import com.claudiodegio.msv.model.BaseElement;
import com.claudiodegio.msv.model.Section;
import de.hdodenhof.circleimageview.CircleImageView;
import java.util.ArrayList;
import java.util.List;

public class SelectFilterRvAdapter
extends RecyclerView.Adapter<BaseViewHolder>
implements Filterable {
    private List<BaseElement> mList;
    private List<BaseElement> mListFiltered;
    private boolean isContain;
    private Context mCtx;
    private LayoutInflater mInflater;

    public SelectFilterRvAdapter(Context context, boolean isContain) {
        this.mCtx = context;
        this.mInflater = LayoutInflater.from((Context)context);
        this.mList = new ArrayList<BaseElement>();
        this.mListFiltered = this.mList;
        this.setHasStableIds(false);
        this.isContain = isContain;
    }

    public void addElement(BaseElement element) {
        this.mList.add(element);
        this.notifyDataSetChanged();
    }

    public void swapList(List<BaseElement> list) {
        this.mList = list;
        this.mListFiltered = list;
        this.notifyDataSetChanged();
    }

    public BaseElement getItem(int position) {
        return this.mListFiltered.get(position);
    }

    public BaseViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        BaseViewHolder holder = null;
        switch (viewType) {
            case 0: {
                View view = this.mInflater.inflate(R.layout.msv_select_filter_section, parent, false);
                holder = new SectionViewHolder(view);
                break;
            }
            case 1: {
                View view = this.mInflater.inflate(R.layout.msv_select_filter_item, parent, false);
                holder = new ItemViewHolder(view);
            }
        }
        return holder;
    }

    public void onBindViewHolder(BaseViewHolder holder, int position) {
        BaseElement element = this.mListFiltered.get(position);
        holder.bind(element);
    }

    public int getItemCount() {
        if (this.mListFiltered == null) {
            return 0;
        }
        return this.mListFiltered.size();
    }

    public int getItemViewType(int position) {
        BaseElement baseElement = this.mListFiltered.get(position);
        if (baseElement instanceof Section) {
            return 0;
        }
        return 1;
    }

    public Filter getFilter() {
        return new SelectFilter();
    }

    class SectionViewHolder
    extends BaseViewHolder {
        TextView mTextView;

        public SectionViewHolder(View itemView) {
            super(itemView);
            this.mTextView = (TextView)itemView;
        }

        @Override
        public void bind(BaseElement element) {
            this.mTextView.setText((CharSequence)element.getName());
        }
    }

    class ItemViewHolder
    extends BaseViewHolder {
        TextView mTextView;
        CircleImageView mCiv;
        ImageView mIv;

        public ItemViewHolder(View itemView) {
            super(itemView);
            this.mTextView = (TextView)itemView.findViewById(R.id.tv_name);
            this.mCiv = (CircleImageView)itemView.findViewById(R.id.civ_icon);
            this.mIv = (ImageView)itemView.findViewById(R.id.iv_icon);
        }

        @Override
        public void bind(BaseElement element) {
            this.mTextView.setText((CharSequence)element.getName());
            com.claudiodegio.msv.model.Filter filter = (com.claudiodegio.msv.model.Filter)element;
            int color = filter.getIconBgColor();
            if (color != -1) {
                this.mIv.setVisibility(8);
                this.mCiv.setVisibility(0);
                this.mCiv.setFillColor(color);
                if (filter.hasIconRefId()) {
                    this.mCiv.setImageResource(filter.getIconRefId());
                } else {
                    this.mCiv.setImageDrawable(filter.getIconDrawable());
                }
            } else {
                this.mIv.setVisibility(0);
                this.mCiv.setVisibility(8);
                if (filter.hasIconRefId()) {
                    this.mIv.setImageResource(filter.getIconRefId());
                } else {
                    this.mIv.setImageDrawable(filter.getIconDrawable());
                }
            }
        }
    }

    class BaseViewHolder
    extends RecyclerView.ViewHolder {
        public BaseViewHolder(View itemView) {
            super(itemView);
        }

        public void bind(BaseElement element) {
        }
    }

    class SelectFilter
    extends Filter {
        SelectFilter() {
        }

        protected Filter.FilterResults performFiltering(CharSequence charSequence) {
            ArrayList<BaseElement> filteredList;
            if (SelectFilterRvAdapter.this.mList == null) {
                return null;
            }
            Filter.FilterResults result = new Filter.FilterResults();
            if (!TextUtils.isEmpty((CharSequence)charSequence)) {
                Section sezione = null;
                filteredList = new ArrayList<BaseElement>();
                for (BaseElement filter : SelectFilterRvAdapter.this.mList) {
                    if (filter instanceof com.claudiodegio.msv.model.Filter) {
                        String charSequenceLowerCase = charSequence.toString().toLowerCase();
                        String filterNameLowerCase = filter.getName().toLowerCase();
                        if ((SelectFilterRvAdapter.this.isContain || !filterNameLowerCase.startsWith(charSequenceLowerCase)) && (!SelectFilterRvAdapter.this.isContain || !filterNameLowerCase.contains(charSequenceLowerCase))) continue;
                        if (sezione != null) {
                            filteredList.add(sezione);
                            sezione = null;
                        }
                        filteredList.add(filter);
                        continue;
                    }
                    sezione = (Section)filter;
                }
            } else {
                filteredList = SelectFilterRvAdapter.this.mList;
            }
            result.values = filteredList;
            return result;
        }

        protected void publishResults(CharSequence charSequence, Filter.FilterResults filterResults) {
            SelectFilterRvAdapter.this.mListFiltered = (List)filterResults.values;
            SelectFilterRvAdapter.this.notifyDataSetChanged();
        }
    }
}

