/*
 * Decompiled with CFR 0.152.
 */
package com.claudiodegio.msv;

import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.widget.Filter;
import android.widget.Filterable;
import com.claudiodegio.msv.BaseMaterialSearchView;
import com.claudiodegio.msv.R;
import com.claudiodegio.msv.adapter.SearchSuggestRvAdapter;
import com.claudiodegio.msv.recycleview.RecyclerItemClickListener;
import java.util.Arrays;
import java.util.List;

public class SuggestionMaterialSearchView
extends BaseMaterialSearchView
implements RecyclerItemClickListener.OnItemClickListener,
Filter.FilterListener {
    private RecyclerView mRvSuggestion;
    private View mVOverlay;
    private RecyclerView.Adapter mSuggestsAdapter;

    public SuggestionMaterialSearchView(Context context) {
        this(context, null);
    }

    public SuggestionMaterialSearchView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public SuggestionMaterialSearchView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initView();
    }

    private void initView() {
        this.mRvSuggestion = (RecyclerView)this.findViewById(R.id.rv_suggestions);
        this.mVOverlay = this.findViewById(R.id.v_overlay);
        this.mVOverlay.setOnClickListener((View.OnClickListener)this);
        this.mRvSuggestion.addOnItemTouchListener((RecyclerView.OnItemTouchListener)new RecyclerItemClickListener(this.getContext(), this));
    }

    @Override
    protected int getLayoutId() {
        return R.layout.msv_suggestions;
    }

    @Override
    public void showSearch(boolean animate) {
        super.showSearch(animate);
        this.showKeyboard((View)this.mETSearchText);
        this.mVOverlay.setVisibility(0);
    }

    public void setSuggestion(String[] suggestions) {
        this.setSuggestion(suggestions, (Boolean)false);
    }

    public void setSuggestion(String[] suggestions, Boolean isContain) {
        if (suggestions != null) {
            this.setSuggestion(Arrays.asList(suggestions), isContain);
        }
    }

    public void setSuggestion(List<String> suggestions) {
        this.setSuggestion(suggestions, (Boolean)false);
    }

    public void setSuggestion(List<String> suggestions, Boolean isContain) {
        if (suggestions != null && !suggestions.isEmpty()) {
            SearchSuggestRvAdapter adapter = new SearchSuggestRvAdapter(this.getContext(), suggestions, isContain);
            this.setSuggestAdapter(adapter);
        }
    }

    @Override
    public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {
        super.onTextChanged(charSequence, i, i1, i2);
        if (!this.mIgnoreNextTextChange) {
            this.mVOverlay.setVisibility(0);
            this.startFilter(this.mETSearchText.getText().toString());
        }
    }

    public void setSuggestAdapter(RecyclerView.Adapter<? extends RecyclerView.ViewHolder> adapter) {
        this.mSuggestsAdapter = adapter;
        this.mRvSuggestion.setAdapter(adapter);
        this.mVOverlay.setVisibility(0);
    }

    public void showSuggestion() {
        this.mRvSuggestion.setVisibility(0);
    }

    public void hideSuggestion() {
        this.mRvSuggestion.setVisibility(8);
    }

    private void startFilter(String text) {
        if (this.mSuggestsAdapter != null && this.mSuggestsAdapter instanceof Filterable) {
            ((Filterable)this.mSuggestsAdapter).getFilter().filter((CharSequence)text, (Filter.FilterListener)this);
        }
    }

    @Override
    public void onItemClick(RecyclerView rv, View view, int position) {
        Log.d((String)"BMSV", (String)("onItemClick: " + position));
        this.mIgnoreNextTextChange = true;
        if (this.mSuggestsAdapter instanceof SearchSuggestRvAdapter) {
            String suggestion = ((SearchSuggestRvAdapter)this.mSuggestsAdapter).getItem(position);
            this.setQuery(suggestion, true);
            if (this.mETSearchText.getText().length() > 0) {
                this.mETSearchText.setSelection(this.mETSearchText.getText().toString().length());
            }
        }
        this.mIgnoreNextTextChange = false;
        this.hideSuggestion();
        this.mVOverlay.setVisibility(8);
    }

    public void onFilterComplete(int count) {
        if (count > 0) {
            this.showSuggestion();
        } else {
            this.hideSuggestion();
        }
    }

    @Override
    public void onClick(View view) {
        super.onClick(view);
        int i = view.getId();
        if (i == R.id.bt_back) {
            this.closeSearch();
        } else if (i == R.id.ed_search_text) {
            this.mVOverlay.setVisibility(0);
        } else if (i == R.id.v_overlay) {
            this.closeSearch();
        }
    }
}

