/*
 * Decompiled with CFR 0.152.
 */
package com.claudiodegio.msv.adapter;

import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Filter;
import android.widget.Filterable;
import android.widget.TextView;
import com.claudiodegio.msv.R;
import java.util.ArrayList;
import java.util.List;

public class SearchSuggestRvAdapter
extends RecyclerView.Adapter<ViewHolder>
implements Filterable {
    private Context mCtx;
    private List<String> mSuggestions;
    private List<String> mSuggestionsFiltered;
    private LayoutInflater mInflater;

    public SearchSuggestRvAdapter(Context context, List<String> suggestions) {
        this.mCtx = context;
        this.mSuggestionsFiltered = suggestions;
        this.mSuggestions = suggestions;
        this.mInflater = LayoutInflater.from((Context)context);
    }

    public ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View view = this.mInflater.inflate(R.layout.msv_item_suggestion, parent, false);
        return new ViewHolder(view);
    }

    public void onBindViewHolder(ViewHolder holder, int position) {
        String suggestion = this.mSuggestionsFiltered.get(position);
        holder.mTextView.setText((CharSequence)suggestion);
    }

    public int getItemCount() {
        if (this.mSuggestionsFiltered == null || this.mSuggestionsFiltered.isEmpty()) {
            return 0;
        }
        return this.mSuggestionsFiltered.size();
    }

    public String getItem(int position) {
        return this.mSuggestionsFiltered.get(position);
    }

    public Filter getFilter() {
        Filter filter = new Filter(){

            protected Filter.FilterResults performFiltering(CharSequence constraint) {
                Filter.FilterResults filterResults = new Filter.FilterResults();
                if (!TextUtils.isEmpty((CharSequence)constraint)) {
                    ArrayList<String> searchData = new ArrayList<String>();
                    for (String string : SearchSuggestRvAdapter.this.mSuggestions) {
                        if (!string.toLowerCase().startsWith(constraint.toString().toLowerCase())) continue;
                        searchData.add(string);
                    }
                    filterResults.values = searchData;
                    filterResults.count = searchData.size();
                }
                return filterResults;
            }

            protected void publishResults(CharSequence constraint, Filter.FilterResults results) {
                if (results.values != null) {
                    SearchSuggestRvAdapter.this.mSuggestionsFiltered = (ArrayList)results.values;
                    SearchSuggestRvAdapter.this.notifyDataSetChanged();
                }
            }
        };
        return filter;
    }

    class ViewHolder
    extends RecyclerView.ViewHolder {
        public TextView mTextView;

        public ViewHolder(View itemView) {
            super(itemView);
            this.mTextView = (TextView)itemView.findViewById(R.id.suggestion_text);
        }
    }
}

