/*
 * Decompiled with CFR 0.152.
 */
package com.chuckerteam.chucker.internal.ui.transaction;

import androidx.lifecycle.LiveData;
import androidx.lifecycle.MutableLiveData;
import androidx.lifecycle.Transformations;
import androidx.lifecycle.ViewModel;
import com.chuckerteam.chucker.internal.data.entity.HttpTransaction;
import com.chuckerteam.chucker.internal.data.repository.RepositoryProvider;
import com.chuckerteam.chucker.internal.support.LiveDataUtilsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u0019\u001a\u00020\u001aJ\u000e\u0010\t\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\bR\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\fR\u0017\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\fR\u0017\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\fR\u0019\u0010\u0014\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00150\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\fR\u0017\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\f\u00a8\u0006\u001c"}, d2={"Lcom/chuckerteam/chucker/internal/ui/transaction/TransactionViewModel;", "Landroidx/lifecycle/ViewModel;", "transactionId", "", "<init>", "(J)V", "mutableEncodeUrl", "Landroidx/lifecycle/MutableLiveData;", "", "encodeUrl", "Landroidx/lifecycle/LiveData;", "getEncodeUrl", "()Landroidx/lifecycle/LiveData;", "transactionTitle", "", "getTransactionTitle", "doesUrlRequireEncoding", "getDoesUrlRequireEncoding", "doesRequestBodyRequireEncoding", "getDoesRequestBodyRequireEncoding", "transaction", "Lcom/chuckerteam/chucker/internal/data/entity/HttpTransaction;", "getTransaction", "formatRequestBody", "getFormatRequestBody", "switchUrlEncoding", "", "encode", "com.github.ChuckerTeam.Chucker.library"})
public final class TransactionViewModel
extends ViewModel {
    @NotNull
    private final MutableLiveData<Boolean> mutableEncodeUrl = new MutableLiveData((Object)false);
    @NotNull
    private final LiveData<Boolean> encodeUrl = (LiveData)this.mutableEncodeUrl;
    @NotNull
    private final LiveData<String> transactionTitle;
    @NotNull
    private final LiveData<Boolean> doesUrlRequireEncoding;
    @NotNull
    private final LiveData<Boolean> doesRequestBodyRequireEncoding;
    @NotNull
    private final LiveData<HttpTransaction> transaction;
    @NotNull
    private final LiveData<Boolean> formatRequestBody;

    public TransactionViewModel(long transactionId) {
        this.transactionTitle = LiveDataUtilsKt.combineLatest(RepositoryProvider.INSTANCE.transaction().getTransaction(transactionId), this.encodeUrl, TransactionViewModel::transactionTitle$lambda$0);
        this.doesUrlRequireEncoding = Transformations.map(RepositoryProvider.INSTANCE.transaction().getTransaction(transactionId), TransactionViewModel::doesUrlRequireEncoding$lambda$1);
        this.doesRequestBodyRequireEncoding = Transformations.map(RepositoryProvider.INSTANCE.transaction().getTransaction(transactionId), TransactionViewModel::doesRequestBodyRequireEncoding$lambda$2);
        this.transaction = RepositoryProvider.INSTANCE.transaction().getTransaction(transactionId);
        this.formatRequestBody = LiveDataUtilsKt.combineLatest(this.doesRequestBodyRequireEncoding, this.encodeUrl, TransactionViewModel::formatRequestBody$lambda$3);
    }

    @NotNull
    public final LiveData<Boolean> getEncodeUrl() {
        return this.encodeUrl;
    }

    @NotNull
    public final LiveData<String> getTransactionTitle() {
        return this.transactionTitle;
    }

    @NotNull
    public final LiveData<Boolean> getDoesUrlRequireEncoding() {
        return this.doesUrlRequireEncoding;
    }

    @NotNull
    public final LiveData<Boolean> getDoesRequestBodyRequireEncoding() {
        return this.doesRequestBodyRequireEncoding;
    }

    @NotNull
    public final LiveData<HttpTransaction> getTransaction() {
        return this.transaction;
    }

    @NotNull
    public final LiveData<Boolean> getFormatRequestBody() {
        return this.formatRequestBody;
    }

    public final void switchUrlEncoding() {
        Object object = this.encodeUrl.getValue();
        Intrinsics.checkNotNull((Object)object);
        this.encodeUrl((Boolean)object == false);
    }

    public final void encodeUrl(boolean encode) {
        this.mutableEncodeUrl.setValue((Object)encode);
    }

    private static final String transactionTitle$lambda$0(HttpTransaction transaction, boolean encodeUrl) {
        return transaction != null ? transaction.getMethod() + " " + transaction.getFormattedPath(encodeUrl) : "";
    }

    private static final boolean doesUrlRequireEncoding$lambda$1(HttpTransaction transaction) {
        return transaction == null ? false : !Intrinsics.areEqual((Object)transaction.getFormattedPath(true), (Object)transaction.getFormattedPath(false));
    }

    private static final boolean doesRequestBodyRequireEncoding$lambda$2(HttpTransaction transaction) {
        Object object = transaction;
        return object != null && (object = ((HttpTransaction)object).getRequestContentType()) != null ? StringsKt.contains((CharSequence)((CharSequence)object), (CharSequence)"x-www-form-urlencoded", (boolean)true) : false;
    }

    private static final boolean formatRequestBody$lambda$3(boolean requiresEncoding, boolean encodeUrl) {
        return !requiresEncoding || !encodeUrl;
    }
}

