/*
 * Decompiled with CFR 0.152.
 */
package com.chuckerteam.chucker.internal.ui;

import android.app.Activity;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.text.method.LinkMovementMethod;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.widget.Toast;
import androidx.activity.ComponentActivity;
import androidx.activity.result.ActivityResultLauncher;
import androidx.activity.result.contract.ActivityResultContract;
import androidx.activity.result.contract.ActivityResultContracts;
import androidx.annotation.RequiresApi;
import androidx.annotation.StringRes;
import androidx.appcompat.widget.SearchView;
import androidx.appcompat.widget.Toolbar;
import androidx.constraintlayout.widget.Group;
import androidx.core.content.ContextCompat;
import androidx.core.view.MenuCompat;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.LifecycleOwnerKt;
import androidx.lifecycle.Observer;
import androidx.lifecycle.ViewModelLazy;
import androidx.lifecycle.ViewModelProvider;
import androidx.lifecycle.ViewModelStore;
import androidx.lifecycle.viewmodel.CreationExtras;
import androidx.recyclerview.widget.DividerItemDecoration;
import androidx.recyclerview.widget.RecyclerView;
import com.chuckerteam.chucker.R;
import com.chuckerteam.chucker.api.Chucker;
import com.chuckerteam.chucker.databinding.ChuckerActivityMainBinding;
import com.chuckerteam.chucker.internal.data.entity.HttpTransaction;
import com.chuckerteam.chucker.internal.data.model.DialogData;
import com.chuckerteam.chucker.internal.support.ContextExtKt;
import com.chuckerteam.chucker.internal.support.FileSaver;
import com.chuckerteam.chucker.internal.support.HarUtils;
import com.chuckerteam.chucker.internal.support.Logger;
import com.chuckerteam.chucker.internal.support.Sharable;
import com.chuckerteam.chucker.internal.support.SharableKt;
import com.chuckerteam.chucker.internal.support.TransactionDetailsHarSharable;
import com.chuckerteam.chucker.internal.support.TransactionListDetailsSharable;
import com.chuckerteam.chucker.internal.ui.BaseChuckerActivity;
import com.chuckerteam.chucker.internal.ui.MainActivity;
import com.chuckerteam.chucker.internal.ui.MainViewModel;
import com.chuckerteam.chucker.internal.ui.transaction.TransactionActivity;
import com.chuckerteam.chucker.internal.ui.transaction.TransactionAdapter;
import com.google.android.material.snackbar.Snackbar;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;
import kotlin.Function;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.FunctionAdapter;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import okio.Okio;
import okio.Source;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u009e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 C2\u00020\u00012\u00020\u0002:\u0002BCB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0012\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0014J\b\u0010\u001c\u001a\u00020\u0019H\u0003J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010!\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0010\u0010\"\u001a\u00020\u001e2\u0006\u0010#\u001a\u00020$H\u0016J\u0010\u0010%\u001a\u00020\u001e2\u0006\u0010&\u001a\u00020\u0015H\u0016J\u0010\u0010'\u001a\u00020\u001e2\u0006\u0010(\u001a\u00020\u0015H\u0016J?\u0010)\u001a\u00020\u00192\u0006\u0010*\u001a\u00020\u00152(\u0010+\u001a$\b\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u00020.0-\u0012\n\u0012\b\u0012\u0004\u0012\u0002000/\u0012\u0006\u0012\u0004\u0018\u0001010,H\u0002\u00a2\u0006\u0002\u00102J\b\u00103\u001a\u000204H\u0002J\u0012\u00105\u001a\u0002042\b\b\u0001\u00106\u001a\u000207H\u0002J\u0012\u00108\u001a\u0002042\b\b\u0001\u00106\u001a\u000207H\u0002J\u0010\u00109\u001a\u00020\u00192\u0006\u0010:\u001a\u00020;H\u0002J\u001a\u0010<\u001a\u00020\u00192\b\u0010=\u001a\u0004\u0018\u00010>2\u0006\u0010:\u001a\u00020;H\u0002J\u0018\u0010?\u001a\u0004\u0018\u00010@2\u0006\u0010:\u001a\u00020;H\u0082@\u00a2\u0006\u0002\u0010AR\u001b\u0010\u0005\u001a\u00020\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u000b\u001a\u00020\fX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\u00108BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006D"}, d2={"Lcom/chuckerteam/chucker/internal/ui/MainActivity;", "Lcom/chuckerteam/chucker/internal/ui/BaseChuckerActivity;", "Landroidx/appcompat/widget/SearchView$OnQueryTextListener;", "<init>", "()V", "viewModel", "Lcom/chuckerteam/chucker/internal/ui/MainViewModel;", "getViewModel", "()Lcom/chuckerteam/chucker/internal/ui/MainViewModel;", "viewModel$delegate", "Lkotlin/Lazy;", "mainBinding", "Lcom/chuckerteam/chucker/databinding/ChuckerActivityMainBinding;", "transactionsAdapter", "Lcom/chuckerteam/chucker/internal/ui/transaction/TransactionAdapter;", "applicationName", "", "getApplicationName", "()Ljava/lang/CharSequence;", "permissionRequest", "Landroidx/activity/result/ActivityResultLauncher;", "", "saveTextToFile", "saveHarToFile", "onCreate", "", "savedInstanceState", "Landroid/os/Bundle;", "handleNotificationsPermission", "onCreateOptionsMenu", "", "menu", "Landroid/view/Menu;", "setUpSearch", "onOptionsItemSelected", "item", "Landroid/view/MenuItem;", "onQueryTextSubmit", "query", "onQueryTextChange", "newText", "exportTransactions", "fileName", "block", "Lkotlin/Function2;", "", "Lcom/chuckerteam/chucker/internal/data/entity/HttpTransaction;", "Lkotlin/coroutines/Continuation;", "Lcom/chuckerteam/chucker/internal/support/Sharable;", "", "(Ljava/lang/String;Lkotlin/jvm/functions/Function2;)V", "getClearDialogData", "Lcom/chuckerteam/chucker/internal/data/model/DialogData;", "getExportDialogData", "dialogMessage", "", "getSaveDialogData", "showSaveDialog", "exportType", "Lcom/chuckerteam/chucker/internal/ui/MainActivity$ExportType;", "onSaveToFileActivityResult", "uri", "Landroid/net/Uri;", "prepareDataToSave", "Lokio/Source;", "(Lcom/chuckerteam/chucker/internal/ui/MainActivity$ExportType;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "ExportType", "Companion", "com.github.ChuckerTeam.Chucker.library"})
@SourceDebugExtension(value={"SMAP\nMainActivity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MainActivity.kt\ncom/chuckerteam/chucker/internal/ui/MainActivity\n+ 2 ActivityViewModelLazy.kt\nandroidx/activity/ActivityViewModelLazyKt\n+ 3 View.kt\nandroidx/core/view/ViewKt\n*L\n1#1,376:1\n75#2,13:377\n256#3,2:390\n*S KotlinDebug\n*F\n+ 1 MainActivity.kt\ncom/chuckerteam/chucker/internal/ui/MainActivity\n*L\n52#1:377,13\n114#1:390,2\n*E\n"})
public final class MainActivity
extends BaseChuckerActivity
implements SearchView.OnQueryTextListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lazy viewModel$delegate;
    private ChuckerActivityMainBinding mainBinding;
    private TransactionAdapter transactionsAdapter;
    @NotNull
    private final ActivityResultLauncher<String> permissionRequest;
    @NotNull
    private final ActivityResultLauncher<String> saveTextToFile;
    @NotNull
    private final ActivityResultLauncher<String> saveHarToFile;
    @NotNull
    private static final String EXPORT_TXT_FILE_NAME = "transactions.txt";
    @NotNull
    private static final String EXPORT_HAR_FILE_NAME = "transactions.har";

    public MainActivity() {
        ComponentActivity $this$viewModels_u24default$iv = (ComponentActivity)this;
        Function0 extrasProducer$iv = null;
        Object factoryProducer$iv = null;
        boolean $i$f$viewModels = false;
        Function0 factoryPromise$iv = (Function0)new Function0<ViewModelProvider.Factory>($this$viewModels_u24default$iv){
            final /* synthetic */ ComponentActivity $this_viewModels;
            {
                this.$this_viewModels = $receiver;
                super(0);
            }

            @NotNull
            public final ViewModelProvider.Factory invoke() {
                return this.$this_viewModels.getDefaultViewModelProviderFactory();
            }
        };
        this.viewModel$delegate = (Lazy)new ViewModelLazy(Reflection.getOrCreateKotlinClass(MainViewModel.class), (Function0)new Function0<ViewModelStore>($this$viewModels_u24default$iv){
            final /* synthetic */ ComponentActivity $this_viewModels;
            {
                this.$this_viewModels = $receiver;
                super(0);
            }

            @NotNull
            public final ViewModelStore invoke() {
                return this.$this_viewModels.getViewModelStore();
            }
        }, factoryPromise$iv, (Function0)new Function0<CreationExtras>(extrasProducer$iv, $this$viewModels_u24default$iv){
            final /* synthetic */ Function0 $extrasProducer;
            final /* synthetic */ ComponentActivity $this_viewModels;
            {
                this.$extrasProducer = $extrasProducer;
                this.$this_viewModels = $receiver;
                super(0);
            }

            @NotNull
            public final CreationExtras invoke() {
                Function0 function0 = this.$extrasProducer;
                if (function0 == null || (function0 = (CreationExtras)function0.invoke()) == null) {
                    function0 = this.$this_viewModels.getDefaultViewModelCreationExtras();
                }
                return function0;
            }
        });
        this.permissionRequest = this.registerForActivityResult((ActivityResultContract)new ActivityResultContracts.RequestPermission(), arg_0 -> MainActivity.permissionRequest$lambda$0(this, arg_0));
        this.saveTextToFile = this.registerForActivityResult((ActivityResultContract)new ActivityResultContracts.CreateDocument(ExportType.TEXT.getMimeType()), arg_0 -> MainActivity.saveTextToFile$lambda$1(this, arg_0));
        this.saveHarToFile = this.registerForActivityResult((ActivityResultContract)new ActivityResultContracts.CreateDocument(ExportType.HAR.getMimeType()), arg_0 -> MainActivity.saveHarToFile$lambda$2(this, arg_0));
    }

    private final MainViewModel getViewModel() {
        Lazy lazy = this.viewModel$delegate;
        return (MainViewModel)((Object)lazy.getValue());
    }

    private final CharSequence getApplicationName() {
        CharSequence charSequence = this.getApplicationInfo().loadLabel(this.getPackageManager());
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"loadLabel(...)");
        return charSequence;
    }

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        RecyclerView recyclerView;
        super.onCreate(savedInstanceState);
        this.mainBinding = ChuckerActivityMainBinding.inflate(this.getLayoutInflater());
        this.transactionsAdapter = new TransactionAdapter((Context)this, (Function1<? super Long, Unit>)((Function1)arg_0 -> MainActivity.onCreate$lambda$3(this, arg_0)));
        ChuckerActivityMainBinding chuckerActivityMainBinding = this.mainBinding;
        if (chuckerActivityMainBinding == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mainBinding");
            chuckerActivityMainBinding = null;
        }
        ChuckerActivityMainBinding $this$onCreate_u24lambda_u245 = chuckerActivityMainBinding;
        boolean bl = false;
        this.setContentView((View)$this$onCreate_u24lambda_u245.getRoot());
        this.setSupportActionBar((Toolbar)$this$onCreate_u24lambda_u245.toolbar);
        $this$onCreate_u24lambda_u245.toolbar.setSubtitle(this.getApplicationName());
        $this$onCreate_u24lambda_u245.tutorialLink.setMovementMethod(LinkMovementMethod.getInstance());
        RecyclerView $this$onCreate_u24lambda_u245_u24lambda_u244 = recyclerView = $this$onCreate_u24lambda_u245.transactionsRecyclerView;
        boolean bl2 = false;
        $this$onCreate_u24lambda_u245_u24lambda_u244.setHasFixedSize(true);
        $this$onCreate_u24lambda_u245_u24lambda_u244.addItemDecoration((RecyclerView.ItemDecoration)new DividerItemDecoration((Context)this, 1));
        TransactionAdapter transactionAdapter = this.transactionsAdapter;
        if (transactionAdapter == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"transactionsAdapter");
            transactionAdapter = null;
        }
        $this$onCreate_u24lambda_u245_u24lambda_u244.setAdapter((RecyclerView.Adapter)transactionAdapter);
        Function1 function1 = arg_0 -> MainActivity.onCreate$lambda$6(this, arg_0);
        this.getViewModel().getTransactions().observe((LifecycleOwner)this, new Observer(function1){
            private final /* synthetic */ Function1 function;
            {
                Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                this.function = function;
            }

            public final /* synthetic */ void onChanged(Object value) {
                this.function.invoke(value);
            }

            @NotNull
            public final Function<?> getFunctionDelegate() {
                return (Function)this.function;
            }

            public final boolean equals(@Nullable Object other) {
                return other instanceof Observer ? (other instanceof FunctionAdapter ? Intrinsics.areEqual((Object)((FunctionAdapter)this).getFunctionDelegate(), (Object)((FunctionAdapter)other).getFunctionDelegate()) : false) : false;
            }

            public final int hashCode() {
                return ((FunctionAdapter)this).getFunctionDelegate().hashCode();
            }
        });
        if (Chucker.INSTANCE.getShowNotifications$com_github_ChuckerTeam_Chucker_library() && Build.VERSION.SDK_INT >= 33) {
            this.handleNotificationsPermission();
        }
    }

    @RequiresApi(value=33)
    private final void handleNotificationsPermission() {
        if (ContextCompat.checkSelfPermission((Context)((Context)this), (String)"android.permission.POST_NOTIFICATIONS") != 0) {
            if (this.shouldShowRequestPermissionRationale("android.permission.POST_NOTIFICATIONS")) {
                ChuckerActivityMainBinding chuckerActivityMainBinding = this.mainBinding;
                if (chuckerActivityMainBinding == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"mainBinding");
                    chuckerActivityMainBinding = null;
                }
                Snackbar.make((View)((View)chuckerActivityMainBinding.getRoot()), (CharSequence)this.getApplicationContext().getString(R.string.chucker_notifications_permission_not_granted), (int)0).setAction((CharSequence)this.getApplicationContext().getString(R.string.chucker_change), arg_0 -> MainActivity.handleNotificationsPermission$lambda$9(this, arg_0)).show();
            } else {
                this.permissionRequest.launch((Object)"android.permission.POST_NOTIFICATIONS");
            }
        }
    }

    public boolean onCreateOptionsMenu(@NotNull Menu menu2) {
        Intrinsics.checkNotNullParameter((Object)menu2, (String)"menu");
        this.getMenuInflater().inflate(R.menu.chucker_transactions_list, menu2);
        MenuCompat.setGroupDividerEnabled((Menu)menu2, (boolean)true);
        this.setUpSearch(menu2);
        return super.onCreateOptionsMenu(menu2);
    }

    private final void setUpSearch(Menu menu2) {
        MenuItem searchMenuItem = menu2.findItem(R.id.search);
        View view = searchMenuItem.getActionView();
        Intrinsics.checkNotNull((Object)view, (String)"null cannot be cast to non-null type androidx.appcompat.widget.SearchView");
        SearchView searchView = (SearchView)view;
        searchView.setOnQueryTextListener((SearchView.OnQueryTextListener)this);
        searchView.setIconifiedByDefault(true);
    }

    public boolean onOptionsItemSelected(@NotNull MenuItem item) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        int n = item.getItemId();
        if (n == R.id.clear) {
            ContextExtKt.showDialog((Context)this, this.getClearDialogData(), (Function0<Unit>)((Function0)() -> MainActivity.onOptionsItemSelected$lambda$10(this)), null);
            bl = true;
        } else if (n == R.id.share_text) {
            ContextExtKt.showDialog((Context)this, this.getExportDialogData(R.string.chucker_export_text_http_confirmation), (Function0<Unit>)((Function0)() -> MainActivity.onOptionsItemSelected$lambda$11(this)), null);
            bl = true;
        } else if (n == R.id.share_har) {
            ContextExtKt.showDialog((Context)this, this.getExportDialogData(R.string.chucker_export_har_http_confirmation), (Function0<Unit>)((Function0)() -> MainActivity.onOptionsItemSelected$lambda$12(this)), null);
            bl = true;
        } else if (n == R.id.save_text) {
            this.showSaveDialog(ExportType.TEXT);
            bl = true;
        } else if (n == R.id.save_har) {
            this.showSaveDialog(ExportType.HAR);
            bl = true;
        } else {
            bl = super.onOptionsItemSelected(item);
        }
        return bl;
    }

    public boolean onQueryTextSubmit(@NotNull String query) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        return true;
    }

    public boolean onQueryTextChange(@NotNull String newText) {
        Intrinsics.checkNotNullParameter((Object)newText, (String)"newText");
        this.getViewModel().updateItemsFilter(newText);
        return true;
    }

    private final void exportTransactions(String fileName, Function2<? super List<HttpTransaction>, ? super Continuation<? super Sharable>, ? extends Object> block) {
        Context applicationContext = this.getApplicationContext();
        BuildersKt.launch$default((CoroutineScope)((CoroutineScope)LifecycleOwnerKt.getLifecycleScope((LifecycleOwner)((LifecycleOwner)this))), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, applicationContext, block, fileName, null){
            int label;
            final /* synthetic */ MainActivity this$0;
            final /* synthetic */ Context $applicationContext;
            final /* synthetic */ Function2<List<HttpTransaction>, Continuation<? super Sharable>, Object> $block;
            final /* synthetic */ String $fileName;
            {
                this.this$0 = $receiver;
                this.$applicationContext = $applicationContext;
                this.$block = $block;
                this.$fileName = $fileName;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object var1_1) {
                var5_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        this.label = 1;
                        v0 = MainActivity.access$getViewModel(this.this$0).getAllTransactions((Continuation<? super List<HttpTransaction>>)((Continuation)this));
                        if (v0 == var5_2) {
                            return var5_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        if ((transactions = (List)v0).isEmpty()) {
                            v1 = this.this$0;
                            v2 = this.$applicationContext.getString(R.string.chucker_export_empty_text);
                            Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"getString(...)");
                            BaseChuckerActivity.showToast$default(v1, v2, 0, 2, null);
                            return Unit.INSTANCE;
                        }
                        this.label = 2;
                        v3 = this.$block.invoke((Object)transactions, (Object)this);
                        if (v3 == var5_2) {
                            return var5_2;
                        }
                        ** GOTO lbl27
                    }
                    case 2: {
                        ResultKt.throwOnFailure((Object)$result);
                        v3 = $result;
lbl27:
                        // 2 sources

                        sharableTransactions = (Sharable)v3;
                        this.label = 3;
                        v4 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Intent>, Object>(sharableTransactions, this.this$0, this.$fileName, null){
                            int label;
                            final /* synthetic */ Sharable $sharableTransactions;
                            final /* synthetic */ MainActivity this$0;
                            final /* synthetic */ String $fileName;
                            {
                                this.$sharableTransactions = $sharableTransactions;
                                this.this$0 = $receiver;
                                this.$fileName = $fileName;
                                super(2, $completion);
                            }

                            public final Object invokeSuspend(Object object) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        Activity activity = (Activity)this.this$0;
                                        String string2 = this.this$0.getString(R.string.chucker_share_all_transactions_title);
                                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(...)");
                                        String string3 = this.this$0.getString(R.string.chucker_share_all_transactions_subject);
                                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getString(...)");
                                        return SharableKt.shareAsFile(this.$sharableTransactions, activity, this.$fileName, string2, string3, "transactions");
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Intent> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (v4 == var5_2) {
                            return var5_2;
                        }
                        ** GOTO lbl36
                    }
                    case 3: {
                        ResultKt.throwOnFailure((Object)$result);
                        v4 = $result;
lbl36:
                        // 2 sources

                        if ((shareIntent = (Intent)v4) != null) {
                            this.this$0.startActivity(shareIntent);
                        } else {
                            v5 = this.this$0;
                            v6 = this.$applicationContext.getString(R.string.chucker_export_no_file);
                            Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"getString(...)");
                            BaseChuckerActivity.showToast$default(v5, v6, 0, 2, null);
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private final DialogData getClearDialogData() {
        String string2 = this.getString(R.string.chucker_clear);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(...)");
        String string3 = this.getString(R.string.chucker_clear_http_confirmation);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getString(...)");
        return new DialogData(string2, string3, this.getString(R.string.chucker_clear), this.getString(R.string.chucker_cancel));
    }

    private final DialogData getExportDialogData(@StringRes int dialogMessage) {
        String string2 = this.getString(R.string.chucker_export);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(...)");
        String string3 = this.getString(dialogMessage);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getString(...)");
        return new DialogData(string2, string3, this.getString(R.string.chucker_export), this.getString(R.string.chucker_cancel));
    }

    private final DialogData getSaveDialogData(@StringRes int dialogMessage) {
        String string2 = this.getString(R.string.chucker_save);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(...)");
        String string3 = this.getString(dialogMessage);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getString(...)");
        return new DialogData(string2, string3, this.getString(R.string.chucker_save), this.getString(R.string.chucker_cancel));
    }

    private final void showSaveDialog(ExportType exportType) {
        int n;
        Context context = (Context)this;
        switch (WhenMappings.$EnumSwitchMapping$0[exportType.ordinal()]) {
            case 1: {
                n = R.string.chucker_save_text_http_confirmation;
                break;
            }
            case 2: {
                n = R.string.chucker_save_har_http_confirmation;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        ContextExtKt.showDialog(context, this.getSaveDialogData(n), (Function0<Unit>)((Function0)() -> MainActivity.showSaveDialog$lambda$13(exportType, this)), null);
    }

    private final void onSaveToFileActivityResult(Uri uri, ExportType exportType) {
        if (uri == null) {
            Toast.makeText((Context)this.getApplicationContext(), (int)R.string.chucker_save_failed_to_open_document, (int)0).show();
            return;
        }
        BuildersKt.launch$default((CoroutineScope)((CoroutineScope)LifecycleOwnerKt.getLifecycleScope((LifecycleOwner)((LifecycleOwner)this))), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(uri, this, exportType, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ Uri $uri;
            final /* synthetic */ MainActivity this$0;
            final /* synthetic */ ExportType $exportType;
            {
                this.$uri = $uri;
                this.this$0 = $receiver;
                this.$exportType = $exportType;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object var1_1) {
                var10_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        var5_4 = $this$launch = (CoroutineScope)this.L$0;
                        var6_6 = this.this$0;
                        var7_7 = this.$exportType;
                        $i$a$-runCatching-MainActivity$onSaveToFileActivityResult$1$source$1 = false;
                        this.label = 1;
                        v0 = MainActivity.access$prepareDataToSave(var6_6, var7_7, (Continuation)this);
                        ** if (v0 != var10_2) goto lbl16
lbl15:
                        // 1 sources

                        return var10_2;
lbl16:
                        // 1 sources

                        ** GOTO lbl23
                    }
                    case 1: {
                        $i$a$-runCatching-MainActivity$onSaveToFileActivityResult$1$source$1 = false;
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl23:
                            // 2 sources

                            var8_11 = Result.constructor-impl((Object)((Source)v0));
                        }
                        catch (Throwable var9_10) {
                            var8_11 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)var9_10));
                        }
                        var5_4 = var8_11;
                        v1 = (Source)(Result.isFailure-impl((Object)var5_4) != false ? null : var5_4);
                        if (v1 == null) {
                            return Unit.INSTANCE;
                        }
                        source = v1;
                        var5_4 = this.this$0.getContentResolver();
                        Intrinsics.checkNotNullExpressionValue((Object)var5_4, (String)"getContentResolver(...)");
                        this.label = 2;
                        v2 = FileSaver.INSTANCE.saveFile(source, this.$uri, (ContentResolver)var5_4, (Continuation<? super Boolean>)((Continuation)this));
                        if (v2 == var10_2) {
                            return var10_2;
                        }
                        ** GOTO lbl43
                    }
                    case 2: {
                        ResultKt.throwOnFailure((Object)$result);
                        v2 = $result;
lbl43:
                        // 2 sources

                        toastMessageId = (result = ((Boolean)v2).booleanValue()) != false ? R.string.chucker_file_saved : R.string.chucker_file_not_saved;
                        Toast.makeText((Context)this.this$0.getApplicationContext(), (int)toastMessageId, (int)0).show();
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    /*
     * Unable to fully structure code
     */
    private final Object prepareDataToSave(ExportType var1_1, Continuation<? super Source> $completion) {
        if (!($completion instanceof prepareDataToSave.1)) ** GOTO lbl-1000
        var6_3 = $completion;
        if ((var6_3.label & -2147483648) != 0) {
            var6_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ MainActivity this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return MainActivity.access$prepareDataToSave(this.this$0, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var7_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = this;
                $continuation.L$1 = exportType;
                $continuation.label = 1;
                v0 = this.getViewModel().getAllTransactions((Continuation<? super List<HttpTransaction>>)$continuation);
                if (v0 == var7_5) {
                    return var7_5;
                }
                ** GOTO lbl24
            }
            case 1: {
                exportType = (ExportType)$continuation.L$1;
                this = (MainActivity)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl24:
                // 2 sources

                if ((transactions = (List)v0).isEmpty()) {
                    v1 = this;
                    var4_7 = this.getApplicationContext().getString(R.string.chucker_save_empty_text);
                    Intrinsics.checkNotNullExpressionValue((Object)var4_7, (String)"getString(...)");
                    BaseChuckerActivity.showToast$default(v1, var4_7, 0, 2, null);
                    return null;
                }
                $continuation.L$0 = null;
                $continuation.L$1 = null;
                $continuation.label = 2;
                v2 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Source>, Object>(exportType, (List<HttpTransaction>)transactions, this, null){
                    int label;
                    final /* synthetic */ ExportType $exportType;
                    final /* synthetic */ List<HttpTransaction> $transactions;
                    final /* synthetic */ MainActivity this$0;
                    {
                        this.$exportType = $exportType;
                        this.$transactions = $transactions;
                        this.this$0 = $receiver;
                        super(2, $completion);
                    }

                    /*
                     * Unable to fully structure code
                     * Enabled aggressive block sorting
                     */
                    public final Object invokeSuspend(Object var1_1) {
                        var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)var1_1);
                                switch (prepareDataToSave.WhenMappings.$EnumSwitchMapping$0[this.$exportType.ordinal()]) {
                                    case 1: {
                                        v0 = new TransactionListDetailsSharable(this.$transactions, false).toSharableContent((Context)this.this$0);
                                        return v0;
                                    }
                                    case 2: {
                                        v1 = this.this$0.getString(R.string.chucker_name);
                                        Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getString(...)");
                                        v2 = this.this$0.getString(R.string.chucker_version);
                                        Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"getString(...)");
                                        this.label = 1;
                                        v3 = HarUtils.INSTANCE.harStringFromTransactions(this.$transactions, v1, v2, (Continuation<? super String>)((Continuation)this));
                                        if (v3 == var4_2) {
                                            return var4_2;
                                        }
                                        ** GOTO lbl24
                                    }
                                    default: {
                                        throw new NoWhenBranchMatchedException();
                                    }
                                }
                            }
                            case 1: {
                                ResultKt.throwOnFailure((Object)$result);
                                v3 = $result;
lbl24:
                                // 2 sources

                                var2_3 = (String)v3;
                                var3_4 = Charsets.UTF_8;
                                v4 = var2_3.getBytes(var3_4);
                                Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"getBytes(...)");
                                v0 = (Source)Okio.buffer((Source)Okio.source((InputStream)new ByteArrayInputStream(v4)));
                                return v0;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Source> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation);
                if (v2 == var7_5) {
                    return var7_5;
                }
                ** GOTO lbl40
            }
            case 2: {
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl40:
                // 2 sources

                return v2;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private static final void permissionRequest$lambda$0(MainActivity this$0, boolean isPermissionGranted) {
        if (!isPermissionGranted) {
            String string2 = this$0.getApplicationContext().getString(R.string.chucker_notifications_permission_not_granted);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(...)");
            this$0.showToast(string2, 1);
            Logger.DefaultImpls.error$default(Logger.Companion, "Notification permission denied. Can't show transactions info", null, 2, null);
        }
    }

    private static final void saveTextToFile$lambda$1(MainActivity this$0, Uri uri) {
        this$0.onSaveToFileActivityResult(uri, ExportType.TEXT);
    }

    private static final void saveHarToFile$lambda$2(MainActivity this$0, Uri uri) {
        this$0.onSaveToFileActivityResult(uri, ExportType.HAR);
    }

    private static final Unit onCreate$lambda$3(MainActivity this$0, long transactionId) {
        TransactionActivity.Companion.start((Context)this$0, transactionId);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit onCreate$lambda$6(MainActivity this$0, List transactionTuples) {
        void $this$isVisible$iv;
        TransactionAdapter transactionAdapter = this$0.transactionsAdapter;
        if (transactionAdapter == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"transactionsAdapter");
            transactionAdapter = null;
        }
        transactionAdapter.submitList(transactionTuples);
        ChuckerActivityMainBinding chuckerActivityMainBinding = this$0.mainBinding;
        if (chuckerActivityMainBinding == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mainBinding");
            chuckerActivityMainBinding = null;
        }
        Group group = chuckerActivityMainBinding.tutorialGroup;
        Intrinsics.checkNotNullExpressionValue((Object)group, (String)"tutorialGroup");
        View view = (View)group;
        boolean value$iv = transactionTuples.isEmpty();
        boolean $i$f$setVisible = false;
        $this$isVisible$iv.setVisibility(value$iv ? 0 : 8);
        return Unit.INSTANCE;
    }

    private static final void handleNotificationsPermission$lambda$9(MainActivity this$0, View it) {
        Intent intent;
        Intent $this$handleNotificationsPermission_u24lambda_u249_u24lambda_u247 = intent = new Intent("android.settings.APPLICATION_DETAILS_SETTINGS");
        boolean bl = false;
        $this$handleNotificationsPermission_u24lambda_u249_u24lambda_u247.addFlags(0x10000000);
        $this$handleNotificationsPermission_u24lambda_u249_u24lambda_u247.setData(Uri.fromParts((String)"package", (String)this$0.getPackageName(), null));
        Intent intent2 = intent;
        boolean bl2 = false;
        this$0.startActivity(intent2);
    }

    private static final Unit onOptionsItemSelected$lambda$10(MainActivity this$0) {
        this$0.getViewModel().clearTransactions();
        return Unit.INSTANCE;
    }

    private static final Unit onOptionsItemSelected$lambda$11(MainActivity this$0) {
        this$0.exportTransactions(EXPORT_TXT_FILE_NAME, (Function2<? super List<HttpTransaction>, ? super Continuation<? super Sharable>, ? extends Object>)((Function2)new Function2<List<? extends HttpTransaction>, Continuation<? super Sharable>, Object>(null){
            int label;
            /* synthetic */ Object L$0;

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        List transactions = (List)this.L$0;
                        return new TransactionListDetailsSharable(transactions, false);
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(List<HttpTransaction> p1, Continuation<? super Sharable> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
        return Unit.INSTANCE;
    }

    private static final Unit onOptionsItemSelected$lambda$12(MainActivity this$0) {
        this$0.exportTransactions(EXPORT_HAR_FILE_NAME, (Function2<? super List<HttpTransaction>, ? super Continuation<? super Sharable>, ? extends Object>)((Function2)new Function2<List<? extends HttpTransaction>, Continuation<? super Sharable>, Object>(this$0, null){
            int label;
            /* synthetic */ Object L$0;
            final /* synthetic */ MainActivity this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object var1_1) {
                var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        transactions = (List)this.L$0;
                        v0 = this.this$0.getString(R.string.chucker_name);
                        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getString(...)");
                        v1 = this.this$0.getString(R.string.chucker_version);
                        Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getString(...)");
                        this.label = 1;
                        v2 = HarUtils.INSTANCE.harStringFromTransactions((List<HttpTransaction>)var2_3, v0, v1, (Continuation<? super String>)((Continuation)this));
                        if (v2 == var4_2) {
                            return var4_2;
                        }
                        ** GOTO lbl18
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v2 = $result;
lbl18:
                        // 2 sources

                        var3_4 = (String)v2;
                        return new TransactionDetailsHarSharable(var3_4);
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(List<HttpTransaction> p1, Continuation<? super Sharable> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
        return Unit.INSTANCE;
    }

    private static final Unit showSaveDialog$lambda$13(ExportType $exportType, MainActivity this$0) {
        switch (WhenMappings.$EnumSwitchMapping$0[$exportType.ordinal()]) {
            case 1: {
                this$0.saveTextToFile.launch((Object)EXPORT_TXT_FILE_NAME);
                break;
            }
            case 2: {
                this$0.saveHarToFile.launch((Object)EXPORT_HAR_FILE_NAME);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ MainViewModel access$getViewModel(MainActivity $this) {
        return $this.getViewModel();
    }

    public static final /* synthetic */ Object access$prepareDataToSave(MainActivity $this, ExportType exportType, Continuation $completion) {
        return $this.prepareDataToSave(exportType, (Continuation<? super Source>)$completion);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/chuckerteam/chucker/internal/ui/MainActivity$Companion;", "", "<init>", "()V", "EXPORT_TXT_FILE_NAME", "", "EXPORT_HAR_FILE_NAME", "com.github.ChuckerTeam.Chucker.library"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007j\u0002\b\bj\u0002\b\t\u00a8\u0006\n"}, d2={"Lcom/chuckerteam/chucker/internal/ui/MainActivity$ExportType;", "", "mimeType", "", "<init>", "(Ljava/lang/String;ILjava/lang/String;)V", "getMimeType", "()Ljava/lang/String;", "TEXT", "HAR", "com.github.ChuckerTeam.Chucker.library"})
    private static final class ExportType
    extends Enum<ExportType> {
        @NotNull
        private final String mimeType;
        public static final /* enum */ ExportType TEXT = new ExportType("text/plain");
        public static final /* enum */ ExportType HAR = new ExportType("application/har+json");
        private static final /* synthetic */ ExportType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private ExportType(String mimeType) {
            this.mimeType = mimeType;
        }

        @NotNull
        public final String getMimeType() {
            return this.mimeType;
        }

        public static ExportType[] values() {
            return (ExportType[])$VALUES.clone();
        }

        public static ExportType valueOf(String value) {
            return Enum.valueOf(ExportType.class, value);
        }

        @NotNull
        public static EnumEntries<ExportType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = exportTypeArray = new ExportType[]{ExportType.TEXT, ExportType.HAR};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ExportType.values().length];
            try {
                nArray[ExportType.TEXT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ExportType.HAR.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

