/*
 * Decompiled with CFR 0.152.
 */
package com.chuckerteam.chucker.internal.support;

import com.chuckerteam.chucker.api.BodyDecoder;
import com.chuckerteam.chucker.api.ChuckerCollector;
import com.chuckerteam.chucker.internal.data.entity.HttpTransaction;
import com.chuckerteam.chucker.internal.support.CacheDirectoryProvider;
import com.chuckerteam.chucker.internal.support.DepletingSource;
import com.chuckerteam.chucker.internal.support.FileFactory;
import com.chuckerteam.chucker.internal.support.Logger;
import com.chuckerteam.chucker.internal.support.OkHttpUtilsKt;
import com.chuckerteam.chucker.internal.support.ReportingSink;
import com.chuckerteam.chucker.internal.support.TeeSource;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import okhttp3.Handshake;
import okhttp3.MediaType;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.Buffer;
import okio.ByteString;
import okio.Okio;
import okio.Source;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 #2\u00020\u0001:\u0002\"#BC\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0016\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0016J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0018\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\n\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0002J \u0010\u001c\u001a\u00020\u00182\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u001a\u0010\u001f\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010 \u001a\u00020!H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/chuckerteam/chucker/internal/support/ResponseProcessor;", "", "collector", "Lcom/chuckerteam/chucker/api/ChuckerCollector;", "cacheDirectoryProvider", "Lcom/chuckerteam/chucker/internal/support/CacheDirectoryProvider;", "maxContentLength", "", "headersToRedact", "", "", "alwaysReadResponseBody", "", "bodyDecoders", "", "Lcom/chuckerteam/chucker/api/BodyDecoder;", "<init>", "(Lcom/chuckerteam/chucker/api/ChuckerCollector;Lcom/chuckerteam/chucker/internal/support/CacheDirectoryProvider;JLjava/util/Set;ZLjava/util/List;)V", "process", "Lokhttp3/Response;", "response", "transaction", "Lcom/chuckerteam/chucker/internal/data/entity/HttpTransaction;", "processResponseMetadata", "", "multiCastResponse", "createTempTransactionFile", "Ljava/io/File;", "processPayload", "payload", "Lokio/Buffer;", "decodePayload", "body", "Lokio/ByteString;", "ResponseReportingSinkCallback", "Companion", "com.github.ChuckerTeam.Chucker.library"})
public final class ResponseProcessor {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final ChuckerCollector collector;
    @NotNull
    private final CacheDirectoryProvider cacheDirectoryProvider;
    private final long maxContentLength;
    @NotNull
    private final Set<String> headersToRedact;
    private final boolean alwaysReadResponseBody;
    @NotNull
    private final List<BodyDecoder> bodyDecoders;
    @Deprecated
    public static final long MAX_BLOB_SIZE = 1000000L;
    @Deprecated
    @NotNull
    public static final String CONTENT_TYPE_IMAGE = "image";

    public ResponseProcessor(@NotNull ChuckerCollector collector, @NotNull CacheDirectoryProvider cacheDirectoryProvider, long maxContentLength, @NotNull Set<String> headersToRedact, boolean alwaysReadResponseBody, @NotNull List<? extends BodyDecoder> bodyDecoders) {
        Intrinsics.checkNotNullParameter((Object)collector, (String)"collector");
        Intrinsics.checkNotNullParameter((Object)cacheDirectoryProvider, (String)"cacheDirectoryProvider");
        Intrinsics.checkNotNullParameter(headersToRedact, (String)"headersToRedact");
        Intrinsics.checkNotNullParameter(bodyDecoders, (String)"bodyDecoders");
        this.collector = collector;
        this.cacheDirectoryProvider = cacheDirectoryProvider;
        this.maxContentLength = maxContentLength;
        this.headersToRedact = headersToRedact;
        this.alwaysReadResponseBody = alwaysReadResponseBody;
        this.bodyDecoders = bodyDecoders;
    }

    @NotNull
    public final Response process(@NotNull Response response, @NotNull HttpTransaction transaction) {
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        this.processResponseMetadata(response, transaction);
        return this.multiCastResponse(response, transaction);
    }

    private final void processResponseMetadata(Response response, HttpTransaction transaction) {
        HttpTransaction httpTransaction;
        HttpTransaction $this$processResponseMetadata_u24lambda_u241 = httpTransaction = transaction;
        boolean bl = false;
        $this$processResponseMetadata_u24lambda_u241.setRequestHeadersSize(response.request().headers().byteCount());
        $this$processResponseMetadata_u24lambda_u241.setRequestHeaders(OkHttpUtilsKt.redact(response.request().headers(), (Iterable<String>)this.headersToRedact));
        $this$processResponseMetadata_u24lambda_u241.setResponseHeadersSize(response.headers().byteCount());
        $this$processResponseMetadata_u24lambda_u241.setResponseHeaders(OkHttpUtilsKt.redact(response.headers(), (Iterable<String>)this.headersToRedact));
        $this$processResponseMetadata_u24lambda_u241.setRequestDate(response.sentRequestAtMillis());
        $this$processResponseMetadata_u24lambda_u241.setResponseDate(response.receivedResponseAtMillis());
        $this$processResponseMetadata_u24lambda_u241.setProtocol(response.protocol().toString());
        $this$processResponseMetadata_u24lambda_u241.setResponseCode(response.code());
        $this$processResponseMetadata_u24lambda_u241.setResponseMessage(response.message());
        Handshake handshake = response.handshake();
        if (handshake != null) {
            Handshake handshake2 = handshake;
            boolean bl2 = false;
            $this$processResponseMetadata_u24lambda_u241.setResponseTlsVersion(handshake2.tlsVersion().javaName());
            $this$processResponseMetadata_u24lambda_u241.setResponseCipherSuite(handshake2.cipherSuite().javaName());
        }
        $this$processResponseMetadata_u24lambda_u241.setResponseContentType(OkHttpUtilsKt.getContentType(response));
        $this$processResponseMetadata_u24lambda_u241.setTookMs(response.receivedResponseAtMillis() - response.sentRequestAtMillis());
    }

    private final Response multiCastResponse(Response response, HttpTransaction transaction) {
        ResponseBody responseBody = response.body();
        if (!OkHttpUtilsKt.hasBody(response) || responseBody == null) {
            this.collector.onResponseReceived$com_github_ChuckerTeam_Chucker_library(transaction);
            return response;
        }
        MediaType contentType = responseBody.contentType();
        long contentLength = responseBody.contentLength();
        ReportingSink sideStream = new ReportingSink(this.createTempTransactionFile(), new ResponseReportingSinkCallback(response, transaction), this.maxContentLength);
        Source upstream = new TeeSource((Source)responseBody.source(), sideStream);
        if (this.alwaysReadResponseBody) {
            upstream = (Source)new DepletingSource(upstream);
        }
        return response.newBuilder().body(ResponseBody.Companion.create(Okio.buffer((Source)upstream), contentType, contentLength)).build();
    }

    private final File createTempTransactionFile() {
        File file;
        File cache = this.cacheDirectoryProvider.provide();
        if (cache == null) {
            Logger.DefaultImpls.warn$default(Logger.Companion, "Failed to obtain a valid cache directory for transaction files", null, 2, null);
            file = null;
        } else {
            file = FileFactory.INSTANCE.create(cache);
        }
        return file;
    }

    private final void processPayload(Response response, Buffer payload, HttpTransaction transaction) {
        boolean isImageContentType;
        ResponseBody responseBody = response.body();
        if (responseBody == null) {
            return;
        }
        ResponseBody responseBody2 = responseBody;
        MediaType contentType = responseBody2.contentType();
        Object object = contentType;
        boolean bl = object != null && (object = object.toString()) != null ? StringsKt.contains((CharSequence)((CharSequence)object), (CharSequence)CONTENT_TYPE_IMAGE, (boolean)true) : (isImageContentType = false);
        if (isImageContentType) {
            if (payload.size() < 1000000L) {
                transaction.setResponseImageData(payload.readByteArray());
            }
        } else if (payload.size() != 0L) {
            String decodedContent = this.decodePayload(response, payload.readByteString());
            transaction.setResponseBody(decodedContent);
            transaction.setResponseBodyEncoded(decodedContent == null);
        }
    }

    private final String decodePayload(Response response, ByteString body) {
        return (String)SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)this.bodyDecoders), arg_0 -> ResponseProcessor.decodePayload$lambda$2(response, body, arg_0)));
    }

    private static final String decodePayload$lambda$2(Response $response, ByteString $body, BodyDecoder decoder) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)decoder, (String)"decoder");
        try {
            string2 = decoder.decodeResponse($response, $body);
        }
        catch (IOException e) {
            Logger.Companion.warn("Decoder " + decoder + " failed to process response payload", e);
            string2 = null;
        }
        return string2;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/chuckerteam/chucker/internal/support/ResponseProcessor$Companion;", "", "<init>", "()V", "MAX_BLOB_SIZE", "", "CONTENT_TYPE_IMAGE", "", "com.github.ChuckerTeam.Chucker.library"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001a\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u001a\u0010\u000e\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u000e\u0010\u0011\u001a\u0004\u0018\u00010\u0012*\u00020\u000bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/chuckerteam/chucker/internal/support/ResponseProcessor$ResponseReportingSinkCallback;", "Lcom/chuckerteam/chucker/internal/support/ReportingSink$Callback;", "response", "Lokhttp3/Response;", "transaction", "Lcom/chuckerteam/chucker/internal/data/entity/HttpTransaction;", "<init>", "(Lcom/chuckerteam/chucker/internal/support/ResponseProcessor;Lokhttp3/Response;Lcom/chuckerteam/chucker/internal/data/entity/HttpTransaction;)V", "onClosed", "", "file", "Ljava/io/File;", "sourceByteCount", "", "onFailure", "exception", "Ljava/io/IOException;", "readResponsePayload", "Lokio/Buffer;", "com.github.ChuckerTeam.Chucker.library"})
    @SourceDebugExtension(value={"SMAP\nResponseProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ResponseProcessor.kt\ncom/chuckerteam/chucker/internal/support/ResponseProcessor$ResponseReportingSinkCallback\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,171:1\n1#2:172\n*E\n"})
    private final class ResponseReportingSinkCallback
    implements ReportingSink.Callback {
        @NotNull
        private final Response response;
        @NotNull
        private final HttpTransaction transaction;

        public ResponseReportingSinkCallback(@NotNull Response response, HttpTransaction transaction) {
            Intrinsics.checkNotNullParameter((Object)response, (String)"response");
            Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
            this.response = response;
            this.transaction = transaction;
        }

        @Override
        public void onClosed(@Nullable File file, long sourceByteCount) {
            block1: {
                File file2 = file;
                if (file2 != null && (file2 = this.readResponsePayload(file2)) != null) {
                    File file3 = file2;
                    ResponseProcessor responseProcessor = ResponseProcessor.this;
                    File payload = file3;
                    boolean bl = false;
                    responseProcessor.processPayload(this.response, (Buffer)payload, this.transaction);
                }
                this.transaction.setResponsePayloadSize(sourceByteCount);
                ResponseProcessor.this.collector.onResponseReceived$com_github_ChuckerTeam_Chucker_library(this.transaction);
                File file4 = file;
                if (file4 == null) break block1;
                file4.delete();
            }
        }

        @Override
        public void onFailure(@Nullable File file, @NotNull IOException exception) {
            Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
            Logger.Companion.error("Failed to read response payload", exception);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final Buffer readResponsePayload(File $this$readResponsePayload) {
            Closeable closeable;
            try {
                Buffer buffer;
                closeable = (Closeable)OkHttpUtilsKt.uncompress(Okio.source((File)$this$readResponsePayload), this.response.headers());
                Throwable throwable = null;
                try {
                    Buffer buffer2;
                    Source source = (Source)closeable;
                    boolean bl = false;
                    Buffer $this$readResponsePayload_u24lambda_u242_u24lambda_u241 = buffer2 = new Buffer();
                    boolean bl2 = false;
                    $this$readResponsePayload_u24lambda_u242_u24lambda_u241.writeAll(source);
                    buffer = buffer2;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
                closeable = buffer;
            }
            catch (IOException e) {
                Logger.Companion.error("Response payload couldn't be processed", e);
                closeable = null;
            }
            return closeable;
        }
    }
}

