/*
 * Decompiled with CFR 0.152.
 */
package com.chuckerteam.chucker.internal.data.entity;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.text.SpannableStringBuilder;
import androidx.room.ColumnInfo;
import androidx.room.Entity;
import androidx.room.Ignore;
import androidx.room.PrimaryKey;
import com.chuckerteam.chucker.internal.data.entity.HttpHeader;
import com.chuckerteam.chucker.internal.support.FormatUtils;
import com.chuckerteam.chucker.internal.support.FormattedUrl;
import com.chuckerteam.chucker.internal.support.JsonConverter;
import com.chuckerteam.chucker.internal.support.SpanTextUtil;
import com.google.gson.reflect.TypeToken;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u0012\n\u0002\bG\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0001\u0018\u00002\u00020\u0001:\u0002\u00ab\u0001B\u0007\b\u0017\u00a2\u0006\u0002\u0010\u0002B\u00b1\u0002\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\t\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\t\u0012\b\u0010\f\u001a\u0004\u0018\u00010\t\u0012\b\u0010\r\u001a\u0004\u0018\u00010\t\u0012\b\u0010\u000e\u001a\u0004\u0018\u00010\t\u0012\b\u0010\u000f\u001a\u0004\u0018\u00010\t\u0012\b\u0010\u0010\u001a\u0004\u0018\u00010\t\u0012\b\u0010\u0011\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010\u0012\u001a\u0004\u0018\u00010\t\u0012\b\u0010\u0013\u001a\u0004\u0018\u00010\t\u0012\b\u0010\u0014\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010\u0015\u001a\u0004\u0018\u00010\t\u0012\b\b\u0002\u0010\u0016\u001a\u00020\u0017\u0012\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019\u0012\b\u0010\u001a\u001a\u0004\u0018\u00010\t\u0012\b\u0010\u001b\u001a\u0004\u0018\u00010\t\u0012\b\u0010\u001c\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010\u001d\u001a\u0004\u0018\u00010\t\u0012\b\u0010\u001e\u001a\u0004\u0018\u00010\t\u0012\b\u0010\u001f\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010 \u001a\u0004\u0018\u00010\t\u0012\b\b\u0002\u0010!\u001a\u00020\u0017\u0012\b\u0010\"\u001a\u0004\u0018\u00010#\u0012\b\b\u0002\u0010$\u001a\u00020\u0017\u0012\b\u0010%\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010&J\u001d\u0010\u0088\u0001\u001a\u00020\t2\u0007\u0010\u0089\u0001\u001a\u00020\t2\t\u0010\u008a\u0001\u001a\u0004\u0018\u00010\tH\u0002J\u0012\u0010\u008b\u0001\u001a\u00020\t2\u0007\u0010\u008c\u0001\u001a\u00020\u0004H\u0002J\u0010\u0010\u008d\u0001\u001a\u00020\t2\u0007\u0010\u008e\u0001\u001a\u00020\u0017J\u0007\u0010\u008f\u0001\u001a\u00020\tJ\u0007\u0010\u0090\u0001\u001a\u00020\tJ\u0010\u0010\u0091\u0001\u001a\u00020\t2\u0007\u0010\u008e\u0001\u001a\u00020\u0017J\u0007\u0010\u0092\u0001\u001a\u00020\u0004J\u0011\u0010\u0093\u0001\u001a\f\u0012\u0005\u0012\u00030\u0095\u0001\u0018\u00010\u0094\u0001J\u0011\u0010\u0096\u0001\u001a\f\u0012\u0005\u0012\u00030\u0095\u0001\u0018\u00010\u0094\u0001J\u0010\u0010\u0097\u0001\u001a\u00020\t2\u0007\u0010\u0098\u0001\u001a\u00020\u0017J\u0007\u0010\u0099\u0001\u001a\u00020\u0004J\u0010\u0010\u009a\u0001\u001a\u00020\t2\u0007\u0010\u0098\u0001\u001a\u00020\u0017J\u0007\u0010\u009b\u0001\u001a\u00020\u0004J\u0014\u0010\u009c\u0001\u001a\u00030\u009d\u00012\n\u0010\u009e\u0001\u001a\u0005\u0018\u00010\u009f\u0001J\u0014\u0010\u00a0\u0001\u001a\u00030\u009d\u00012\n\u0010\u009e\u0001\u001a\u0005\u0018\u00010\u009f\u0001J\u0012\u0010\u00a1\u0001\u001a\u00020\u00172\t\u0010\u00a2\u0001\u001a\u0004\u0018\u00010\u0000J\u0011\u0010\u00a3\u0001\u001a\u00020\u00002\b\u0010\u00a4\u0001\u001a\u00030\u00a5\u0001J\u0011\u00102\u001a\u00030\u00a6\u00012\b\u0010\u00a7\u0001\u001a\u00030\u00a8\u0001J\u0018\u0010P\u001a\u00030\u00a6\u00012\u000f\u0010\u00a7\u0001\u001a\n\u0012\u0005\u0012\u00030\u0095\u00010\u0094\u0001J\u0011\u0010P\u001a\u00030\u00a6\u00012\b\u0010\u00a7\u0001\u001a\u00030\u00a8\u0001J\u0018\u0010g\u001a\u00030\u00a6\u00012\u000f\u0010\u00a7\u0001\u001a\n\u0012\u0005\u0012\u00030\u0095\u00010\u0094\u0001J\u0011\u0010g\u001a\u00030\u00a6\u00012\b\u0010\u00a7\u0001\u001a\u00030\u00a8\u0001J+\u0010\u00a9\u0001\u001a\u00030\u009d\u00012\b\u0010\u0089\u0001\u001a\u00030\u009d\u00012\t\u0010\u008a\u0001\u001a\u0004\u0018\u00010\t2\n\u0010\u009e\u0001\u001a\u0005\u0018\u00010\u009f\u0001H\u0002J\u001b\u0010\u00aa\u0001\u001a\n\u0012\u0005\u0012\u00030\u0095\u00010\u0094\u00012\b\u0010\u00a7\u0001\u001a\u00030\u00a8\u0001H\u0002R\u0013\u0010'\u001a\u0004\u0018\u00010\t8F\u00a2\u0006\u0006\u001a\u0004\b(\u0010)R \u0010\u001b\u001a\u0004\u0018\u00010\t8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010)\"\u0004\b+\u0010,R\u001e\u0010$\u001a\u00020\u00178\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010.\"\u0004\b/\u00100R \u0010%\u001a\u0004\u0018\u00010\t8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b1\u0010)\"\u0004\b2\u0010,R \u0010\f\u001a\u0004\u0018\u00010\t8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b3\u0010)\"\u0004\b4\u0010,R\u001e\u0010\u0003\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b5\u00106\"\u0004\b7\u00108R\u001e\u0010\u0016\u001a\u00020\u00178\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010.\"\u0004\b9\u00100R\u001e\u0010!\u001a\u00020\u00178\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010.\"\u0004\b:\u00100R\u0011\u0010;\u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b;\u0010.R \u0010\n\u001a\u0004\u0018\u00010\t8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b<\u0010)\"\u0004\b=\u0010,R\u0011\u0010>\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b?\u0010)R \u0010\r\u001a\u0004\u0018\u00010\t8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b@\u0010)\"\u0004\bA\u0010,R \u0010\b\u001a\u0004\u0018\u00010\t8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bB\u0010)\"\u0004\bC\u0010,R \u0010\u0015\u001a\u0004\u0018\u00010\t8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bD\u0010)\"\u0004\bE\u0010,R \u0010\u0012\u001a\u0004\u0018\u00010\t8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bF\u0010)\"\u0004\bG\u0010,R\"\u0010\u0005\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0010\n\u0002\u0010L\u001a\u0004\bH\u0010I\"\u0004\bJ\u0010KR\u0013\u0010M\u001a\u0004\u0018\u00010\t8F\u00a2\u0006\u0006\u001a\u0004\bN\u0010)R \u0010\u0013\u001a\u0004\u0018\u00010\t8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bO\u0010)\"\u0004\bP\u0010,R\"\u0010\u0014\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0010\n\u0002\u0010L\u001a\u0004\bQ\u0010I\"\u0004\bR\u0010KR\"\u0010\u0011\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0010\n\u0002\u0010L\u001a\u0004\bS\u0010I\"\u0004\bT\u0010KR\u0011\u0010U\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\bV\u0010)R \u0010 \u001a\u0004\u0018\u00010\t8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bW\u0010)\"\u0004\bX\u0010,R \u0010\u0010\u001a\u0004\u0018\u00010\t8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bY\u0010)\"\u0004\bZ\u0010,R\"\u0010\u0018\u001a\u0004\u0018\u00010\u00198\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0010\n\u0002\u0010_\u001a\u0004\b[\u0010\\\"\u0004\b]\u0010^R \u0010\u001d\u001a\u0004\u0018\u00010\t8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b`\u0010)\"\u0004\ba\u0010,R\"\u0010\u0006\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0010\n\u0002\u0010L\u001a\u0004\bb\u0010I\"\u0004\bc\u0010KR\u0013\u0010d\u001a\u0004\u0018\u00010\t8F\u00a2\u0006\u0006\u001a\u0004\be\u0010)R \u0010\u001e\u001a\u0004\u0018\u00010\t8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bf\u0010)\"\u0004\bg\u0010,R\"\u0010\u001f\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0010\n\u0002\u0010L\u001a\u0004\bh\u0010I\"\u0004\bi\u0010KR\u0013\u0010j\u001a\u0004\u0018\u00010k8F\u00a2\u0006\u0006\u001a\u0004\bl\u0010mR \u0010\"\u001a\u0004\u0018\u00010#8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bn\u0010o\"\u0004\bp\u0010qR \u0010\u001a\u001a\u0004\u0018\u00010\t8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\br\u0010)\"\u0004\bs\u0010,R\"\u0010\u001c\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0010\n\u0002\u0010L\u001a\u0004\bt\u0010I\"\u0004\bu\u0010KR\u0013\u0010v\u001a\u0004\u0018\u00010\t8F\u00a2\u0006\u0006\u001a\u0004\bw\u0010)R\u0013\u0010x\u001a\u0004\u0018\u00010\t8F\u00a2\u0006\u0006\u001a\u0004\by\u0010)R \u0010\u000f\u001a\u0004\u0018\u00010\t8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bz\u0010)\"\u0004\b{\u0010,R \u0010\u000e\u001a\u0004\u0018\u00010\t8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b|\u0010)\"\u0004\b}\u0010,R\u0013\u0010~\u001a\u00020\u007f8F\u00a2\u0006\b\u001a\u0006\b\u0080\u0001\u0010\u0081\u0001R$\u0010\u0007\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0012\n\u0002\u0010L\u001a\u0005\b\u0082\u0001\u0010I\"\u0005\b\u0083\u0001\u0010KR\u0013\u0010\u0084\u0001\u001a\u00020\t8F\u00a2\u0006\u0007\u001a\u0005\b\u0085\u0001\u0010)R\"\u0010\u000b\u001a\u0004\u0018\u00010\t8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0010\n\u0000\u001a\u0005\b\u0086\u0001\u0010)\"\u0005\b\u0087\u0001\u0010,\u00a8\u0006\u00ac\u0001"}, d2={"Lcom/chuckerteam/chucker/internal/data/entity/HttpTransaction;", "", "()V", "id", "", "requestDate", "responseDate", "tookMs", "protocol", "", "method", "url", "host", "path", "scheme", "responseTlsVersion", "responseCipherSuite", "requestPayloadSize", "requestContentType", "requestHeaders", "requestHeadersSize", "requestBody", "isRequestBodyEncoded", "", "responseCode", "", "responseMessage", "error", "responsePayloadSize", "responseContentType", "responseHeaders", "responseHeadersSize", "responseBody", "isResponseBodyEncoded", "responseImageData", "", "graphQlDetected", "graphQlOperationName", "(JLjava/lang/Long;Ljava/lang/Long;Ljava/lang/Long;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Long;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Long;Ljava/lang/String;ZLjava/lang/Integer;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Long;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Long;Ljava/lang/String;Z[BZLjava/lang/String;)V", "durationString", "getDurationString", "()Ljava/lang/String;", "getError", "setError", "(Ljava/lang/String;)V", "getGraphQlDetected", "()Z", "setGraphQlDetected", "(Z)V", "getGraphQlOperationName", "setGraphQlOperationName", "getHost", "setHost", "getId", "()J", "setId", "(J)V", "setRequestBodyEncoded", "setResponseBodyEncoded", "isSsl", "getMethod", "setMethod", "notificationText", "getNotificationText", "getPath", "setPath", "getProtocol", "setProtocol", "getRequestBody", "setRequestBody", "getRequestContentType", "setRequestContentType", "getRequestDate", "()Ljava/lang/Long;", "setRequestDate", "(Ljava/lang/Long;)V", "Ljava/lang/Long;", "requestDateString", "getRequestDateString", "getRequestHeaders", "setRequestHeaders", "getRequestHeadersSize", "setRequestHeadersSize", "getRequestPayloadSize", "setRequestPayloadSize", "requestSizeString", "getRequestSizeString", "getResponseBody", "setResponseBody", "getResponseCipherSuite", "setResponseCipherSuite", "getResponseCode", "()Ljava/lang/Integer;", "setResponseCode", "(Ljava/lang/Integer;)V", "Ljava/lang/Integer;", "getResponseContentType", "setResponseContentType", "getResponseDate", "setResponseDate", "responseDateString", "getResponseDateString", "getResponseHeaders", "setResponseHeaders", "getResponseHeadersSize", "setResponseHeadersSize", "responseImageBitmap", "Landroid/graphics/Bitmap;", "getResponseImageBitmap", "()Landroid/graphics/Bitmap;", "getResponseImageData", "()[B", "setResponseImageData", "([B)V", "getResponseMessage", "setResponseMessage", "getResponsePayloadSize", "setResponsePayloadSize", "responseSizeString", "getResponseSizeString", "responseSummaryText", "getResponseSummaryText", "getResponseTlsVersion", "setResponseTlsVersion", "getScheme", "setScheme", "status", "Lcom/chuckerteam/chucker/internal/data/entity/HttpTransaction$Status;", "getStatus", "()Lcom/chuckerteam/chucker/internal/data/entity/HttpTransaction$Status;", "getTookMs", "setTookMs", "totalSizeString", "getTotalSizeString", "getUrl", "setUrl", "formatBody", "body", "contentType", "formatBytes", "bytes", "getFormattedPath", "encode", "getFormattedRequestBody", "getFormattedResponseBody", "getFormattedUrl", "getHarResponseBodySize", "getParsedRequestHeaders", "", "Lcom/chuckerteam/chucker/internal/data/entity/HttpHeader;", "getParsedResponseHeaders", "getRequestHeadersString", "withMarkup", "getRequestTotalSize", "getResponseHeadersString", "getResponseTotalSize", "getSpannedRequestBody", "", "context", "Landroid/content/Context;", "getSpannedResponseBody", "hasTheSameContent", "other", "populateUrl", "httpUrl", "Lokhttp3/HttpUrl;", "", "headers", "Lokhttp3/Headers;", "spanBody", "toHttpHeaderList", "Status", "com.github.ChuckerTeam.Chucker.library"})
@Entity(tableName="transactions")
@SourceDebugExtension(value={"SMAP\nHttpTransaction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HttpTransaction.kt\ncom/chuckerteam/chucker/internal/data/entity/HttpTransaction\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,339:1\n1#2:340\n*E\n"})
public final class HttpTransaction {
    @PrimaryKey(autoGenerate=true)
    @ColumnInfo(name="id")
    private long id;
    @ColumnInfo(name="requestDate")
    @Nullable
    private Long requestDate;
    @ColumnInfo(name="responseDate")
    @Nullable
    private Long responseDate;
    @ColumnInfo(name="tookMs")
    @Nullable
    private Long tookMs;
    @ColumnInfo(name="protocol")
    @Nullable
    private String protocol;
    @ColumnInfo(name="method")
    @Nullable
    private String method;
    @ColumnInfo(name="url")
    @Nullable
    private String url;
    @ColumnInfo(name="host")
    @Nullable
    private String host;
    @ColumnInfo(name="path")
    @Nullable
    private String path;
    @ColumnInfo(name="scheme")
    @Nullable
    private String scheme;
    @ColumnInfo(name="responseTlsVersion")
    @Nullable
    private String responseTlsVersion;
    @ColumnInfo(name="responseCipherSuite")
    @Nullable
    private String responseCipherSuite;
    @ColumnInfo(name="requestPayloadSize")
    @Nullable
    private Long requestPayloadSize;
    @ColumnInfo(name="requestContentType")
    @Nullable
    private String requestContentType;
    @ColumnInfo(name="requestHeaders")
    @Nullable
    private String requestHeaders;
    @ColumnInfo(name="requestHeadersSize")
    @Nullable
    private Long requestHeadersSize;
    @ColumnInfo(name="requestBody")
    @Nullable
    private String requestBody;
    @ColumnInfo(name="isRequestBodyEncoded")
    private boolean isRequestBodyEncoded;
    @ColumnInfo(name="responseCode")
    @Nullable
    private Integer responseCode;
    @ColumnInfo(name="responseMessage")
    @Nullable
    private String responseMessage;
    @ColumnInfo(name="error")
    @Nullable
    private String error;
    @ColumnInfo(name="responsePayloadSize")
    @Nullable
    private Long responsePayloadSize;
    @ColumnInfo(name="responseContentType")
    @Nullable
    private String responseContentType;
    @ColumnInfo(name="responseHeaders")
    @Nullable
    private String responseHeaders;
    @ColumnInfo(name="responseHeadersSize")
    @Nullable
    private Long responseHeadersSize;
    @ColumnInfo(name="responseBody")
    @Nullable
    private String responseBody;
    @ColumnInfo(name="isResponseBodyEncoded")
    private boolean isResponseBodyEncoded;
    @ColumnInfo(name="responseImageData")
    @Nullable
    private byte[] responseImageData;
    @ColumnInfo(name="graphQlDetected")
    private boolean graphQlDetected;
    @ColumnInfo(name="graphQlOperationName")
    @Nullable
    private String graphQlOperationName;

    public HttpTransaction(long id, @Nullable Long requestDate, @Nullable Long responseDate, @Nullable Long tookMs, @Nullable String protocol, @Nullable String method, @Nullable String url, @Nullable String host, @Nullable String path, @Nullable String scheme, @Nullable String responseTlsVersion, @Nullable String responseCipherSuite, @Nullable Long requestPayloadSize, @Nullable String requestContentType, @Nullable String requestHeaders, @Nullable Long requestHeadersSize, @Nullable String requestBody, boolean isRequestBodyEncoded, @Nullable Integer responseCode, @Nullable String responseMessage, @Nullable String error, @Nullable Long responsePayloadSize, @Nullable String responseContentType, @Nullable String responseHeaders, @Nullable Long responseHeadersSize, @Nullable String responseBody, boolean isResponseBodyEncoded, @Nullable byte[] responseImageData, boolean graphQlDetected, @Nullable String graphQlOperationName) {
        this.id = id;
        this.requestDate = requestDate;
        this.responseDate = responseDate;
        this.tookMs = tookMs;
        this.protocol = protocol;
        this.method = method;
        this.url = url;
        this.host = host;
        this.path = path;
        this.scheme = scheme;
        this.responseTlsVersion = responseTlsVersion;
        this.responseCipherSuite = responseCipherSuite;
        this.requestPayloadSize = requestPayloadSize;
        this.requestContentType = requestContentType;
        this.requestHeaders = requestHeaders;
        this.requestHeadersSize = requestHeadersSize;
        this.requestBody = requestBody;
        this.isRequestBodyEncoded = isRequestBodyEncoded;
        this.responseCode = responseCode;
        this.responseMessage = responseMessage;
        this.error = error;
        this.responsePayloadSize = responsePayloadSize;
        this.responseContentType = responseContentType;
        this.responseHeaders = responseHeaders;
        this.responseHeadersSize = responseHeadersSize;
        this.responseBody = responseBody;
        this.isResponseBodyEncoded = isResponseBodyEncoded;
        this.responseImageData = responseImageData;
        this.graphQlDetected = graphQlDetected;
        this.graphQlOperationName = graphQlOperationName;
    }

    public /* synthetic */ HttpTransaction(long l, Long l2, Long l3, Long l4, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, Long l5, String string10, String string11, Long l6, String string12, boolean bl, Integer n, String string13, String string14, Long l7, String string15, String string16, Long l8, String string17, boolean bl2, byte[] byArray, boolean bl3, String string18, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            l = 0L;
        }
        if ((n2 & 0x20000) != 0) {
            bl = false;
        }
        if ((n2 & 0x4000000) != 0) {
            bl2 = false;
        }
        if ((n2 & 0x10000000) != 0) {
            bl3 = false;
        }
        this(l, l2, l3, l4, string2, string3, string4, string5, string6, string7, string8, string9, l5, string10, string11, l6, string12, bl, n, string13, string14, l7, string15, string16, l8, string17, bl2, byArray, bl3, string18);
    }

    public final long getId() {
        return this.id;
    }

    public final void setId(long l) {
        this.id = l;
    }

    @Nullable
    public final Long getRequestDate() {
        return this.requestDate;
    }

    public final void setRequestDate(@Nullable Long l) {
        this.requestDate = l;
    }

    @Nullable
    public final Long getResponseDate() {
        return this.responseDate;
    }

    public final void setResponseDate(@Nullable Long l) {
        this.responseDate = l;
    }

    @Nullable
    public final Long getTookMs() {
        return this.tookMs;
    }

    public final void setTookMs(@Nullable Long l) {
        this.tookMs = l;
    }

    @Nullable
    public final String getProtocol() {
        return this.protocol;
    }

    public final void setProtocol(@Nullable String string2) {
        this.protocol = string2;
    }

    @Nullable
    public final String getMethod() {
        return this.method;
    }

    public final void setMethod(@Nullable String string2) {
        this.method = string2;
    }

    @Nullable
    public final String getUrl() {
        return this.url;
    }

    public final void setUrl(@Nullable String string2) {
        this.url = string2;
    }

    @Nullable
    public final String getHost() {
        return this.host;
    }

    public final void setHost(@Nullable String string2) {
        this.host = string2;
    }

    @Nullable
    public final String getPath() {
        return this.path;
    }

    public final void setPath(@Nullable String string2) {
        this.path = string2;
    }

    @Nullable
    public final String getScheme() {
        return this.scheme;
    }

    public final void setScheme(@Nullable String string2) {
        this.scheme = string2;
    }

    @Nullable
    public final String getResponseTlsVersion() {
        return this.responseTlsVersion;
    }

    public final void setResponseTlsVersion(@Nullable String string2) {
        this.responseTlsVersion = string2;
    }

    @Nullable
    public final String getResponseCipherSuite() {
        return this.responseCipherSuite;
    }

    public final void setResponseCipherSuite(@Nullable String string2) {
        this.responseCipherSuite = string2;
    }

    @Nullable
    public final Long getRequestPayloadSize() {
        return this.requestPayloadSize;
    }

    public final void setRequestPayloadSize(@Nullable Long l) {
        this.requestPayloadSize = l;
    }

    @Nullable
    public final String getRequestContentType() {
        return this.requestContentType;
    }

    public final void setRequestContentType(@Nullable String string2) {
        this.requestContentType = string2;
    }

    @Nullable
    public final String getRequestHeaders() {
        return this.requestHeaders;
    }

    public final void setRequestHeaders(@Nullable String string2) {
        this.requestHeaders = string2;
    }

    @Nullable
    public final Long getRequestHeadersSize() {
        return this.requestHeadersSize;
    }

    public final void setRequestHeadersSize(@Nullable Long l) {
        this.requestHeadersSize = l;
    }

    @Nullable
    public final String getRequestBody() {
        return this.requestBody;
    }

    public final void setRequestBody(@Nullable String string2) {
        this.requestBody = string2;
    }

    public final boolean isRequestBodyEncoded() {
        return this.isRequestBodyEncoded;
    }

    public final void setRequestBodyEncoded(boolean bl) {
        this.isRequestBodyEncoded = bl;
    }

    @Nullable
    public final Integer getResponseCode() {
        return this.responseCode;
    }

    public final void setResponseCode(@Nullable Integer n) {
        this.responseCode = n;
    }

    @Nullable
    public final String getResponseMessage() {
        return this.responseMessage;
    }

    public final void setResponseMessage(@Nullable String string2) {
        this.responseMessage = string2;
    }

    @Nullable
    public final String getError() {
        return this.error;
    }

    public final void setError(@Nullable String string2) {
        this.error = string2;
    }

    @Nullable
    public final Long getResponsePayloadSize() {
        return this.responsePayloadSize;
    }

    public final void setResponsePayloadSize(@Nullable Long l) {
        this.responsePayloadSize = l;
    }

    @Nullable
    public final String getResponseContentType() {
        return this.responseContentType;
    }

    public final void setResponseContentType(@Nullable String string2) {
        this.responseContentType = string2;
    }

    @Nullable
    public final String getResponseHeaders() {
        return this.responseHeaders;
    }

    public final void setResponseHeaders(@Nullable String string2) {
        this.responseHeaders = string2;
    }

    @Nullable
    public final Long getResponseHeadersSize() {
        return this.responseHeadersSize;
    }

    public final void setResponseHeadersSize(@Nullable Long l) {
        this.responseHeadersSize = l;
    }

    @Nullable
    public final String getResponseBody() {
        return this.responseBody;
    }

    public final void setResponseBody(@Nullable String string2) {
        this.responseBody = string2;
    }

    public final boolean isResponseBodyEncoded() {
        return this.isResponseBodyEncoded;
    }

    public final void setResponseBodyEncoded(boolean bl) {
        this.isResponseBodyEncoded = bl;
    }

    @Nullable
    public final byte[] getResponseImageData() {
        return this.responseImageData;
    }

    public final void setResponseImageData(@Nullable byte[] byArray) {
        this.responseImageData = byArray;
    }

    public final boolean getGraphQlDetected() {
        return this.graphQlDetected;
    }

    public final void setGraphQlDetected(boolean bl) {
        this.graphQlDetected = bl;
    }

    @Nullable
    public final String getGraphQlOperationName() {
        return this.graphQlOperationName;
    }

    public final void setGraphQlOperationName(@Nullable String string2) {
        this.graphQlOperationName = string2;
    }

    @Ignore
    public HttpTransaction() {
        this(0L, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, false, null, null, null, null, null, null, null, null, false, null, false, null, 335675393, null);
    }

    @NotNull
    public final Status getStatus() {
        return this.error != null ? Status.Failed : (this.responseCode == null ? Status.Requested : Status.Complete);
    }

    @Nullable
    public final String getRequestDateString() {
        String string2;
        Long l = this.requestDate;
        if (l != null) {
            long it = ((Number)l).longValue();
            boolean bl = false;
            string2 = new Date(it).toString();
        } else {
            string2 = null;
        }
        return string2;
    }

    @Nullable
    public final String getResponseDateString() {
        String string2;
        Long l = this.responseDate;
        if (l != null) {
            long it = ((Number)l).longValue();
            boolean bl = false;
            string2 = new Date(it).toString();
        } else {
            string2 = null;
        }
        return string2;
    }

    @Nullable
    public final String getDurationString() {
        String string2;
        Long l = this.tookMs;
        if (l != null) {
            long it = ((Number)l).longValue();
            boolean bl = false;
            string2 = it + " ms";
        } else {
            string2 = null;
        }
        return string2;
    }

    @NotNull
    public final String getRequestSizeString() {
        Long l = this.requestPayloadSize;
        return this.formatBytes(l != null ? l : 0L);
    }

    @Nullable
    public final String getResponseSizeString() {
        String string2;
        Long l = this.responsePayloadSize;
        if (l != null) {
            long it = ((Number)l).longValue();
            boolean bl = false;
            string2 = this.formatBytes(it);
        } else {
            string2 = null;
        }
        return string2;
    }

    @NotNull
    public final String getTotalSizeString() {
        Long l = this.requestPayloadSize;
        long reqBytes = l != null ? l : 0L;
        Long l2 = this.responsePayloadSize;
        long resBytes = l2 != null ? l2 : 0L;
        return this.formatBytes(reqBytes + resBytes);
    }

    @Nullable
    public final String getResponseSummaryText() {
        Object object;
        switch (WhenMappings.$EnumSwitchMapping$0[this.getStatus().ordinal()]) {
            case 1: {
                object = this.error;
                break;
            }
            case 2: {
                object = null;
                break;
            }
            default: {
                object = this.responseCode + " " + this.responseMessage;
            }
        }
        return object;
    }

    @NotNull
    public final String getNotificationText() {
        String string2;
        switch (WhenMappings.$EnumSwitchMapping$0[this.getStatus().ordinal()]) {
            case 1: {
                string2 = " ! ! !  " + this.method + " " + this.path;
                break;
            }
            case 2: {
                string2 = " . . .  " + this.method + " " + this.path;
                break;
            }
            default: {
                string2 = this.responseCode + " " + this.method + " " + this.path;
            }
        }
        return string2;
    }

    public final boolean isSsl() {
        return StringsKt.equals((String)this.scheme, (String)"https", (boolean)true);
    }

    @Nullable
    public final Bitmap getResponseImageBitmap() {
        Bitmap bitmap;
        if (this.responseImageData != null) {
            byte[] it = this.responseImageData;
            boolean bl = false;
            bitmap = BitmapFactory.decodeByteArray((byte[])it, (int)0, (int)it.length);
        } else {
            bitmap = null;
        }
        return bitmap;
    }

    public final void setRequestHeaders(@NotNull Headers headers) {
        Intrinsics.checkNotNullParameter((Object)headers, (String)"headers");
        this.setRequestHeaders(this.toHttpHeaderList(headers));
    }

    public final void setRequestHeaders(@NotNull List<HttpHeader> headers) {
        Intrinsics.checkNotNullParameter(headers, (String)"headers");
        this.requestHeaders = JsonConverter.INSTANCE.getInstance().toJson(headers);
    }

    public final void setGraphQlOperationName(@NotNull Headers headers) {
        Object v1;
        block1: {
            Intrinsics.checkNotNullParameter((Object)headers, (String)"headers");
            Iterable iterable = this.toHttpHeaderList(headers);
            HttpTransaction httpTransaction = this;
            Iterable iterable2 = iterable;
            for (Object t : iterable2) {
                HttpHeader it = (HttpHeader)t;
                boolean bl = false;
                String string2 = it.getName().toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
                if (!StringsKt.contains$default((CharSequence)string2, (CharSequence)"operation-name", (boolean)false, (int)2, null)) continue;
                v1 = t;
                break block1;
            }
            v1 = null;
        }
        HttpHeader httpHeader = v1;
        httpTransaction.graphQlOperationName = httpHeader != null ? httpHeader.getValue() : null;
    }

    @Nullable
    public final List<HttpHeader> getParsedRequestHeaders() {
        return (List)JsonConverter.INSTANCE.getInstance().fromJson(this.requestHeaders, new TypeToken<List<? extends HttpHeader>>(){}.getType());
    }

    @Nullable
    public final List<HttpHeader> getParsedResponseHeaders() {
        return (List)JsonConverter.INSTANCE.getInstance().fromJson(this.responseHeaders, new TypeToken<List<? extends HttpHeader>>(){}.getType());
    }

    @NotNull
    public final String getRequestHeadersString(boolean withMarkup) {
        return FormatUtils.INSTANCE.formatHeaders(this.getParsedRequestHeaders(), withMarkup);
    }

    public final void setResponseHeaders(@NotNull Headers headers) {
        Intrinsics.checkNotNullParameter((Object)headers, (String)"headers");
        this.setResponseHeaders(this.toHttpHeaderList(headers));
    }

    public final void setResponseHeaders(@NotNull List<HttpHeader> headers) {
        Intrinsics.checkNotNullParameter(headers, (String)"headers");
        this.responseHeaders = JsonConverter.INSTANCE.getInstance().toJson(headers);
    }

    @NotNull
    public final String getResponseHeadersString(boolean withMarkup) {
        return FormatUtils.INSTANCE.formatHeaders(this.getParsedResponseHeaders(), withMarkup);
    }

    private final List<HttpHeader> toHttpHeaderList(Headers headers) {
        ArrayList<HttpHeader> httpHeaders = new ArrayList<HttpHeader>();
        int n = headers.size();
        for (int i = 0; i < n; ++i) {
            httpHeaders.add(new HttpHeader(headers.name(i), headers.value(i)));
        }
        return httpHeaders;
    }

    private final String formatBody(String body, String contentType) {
        CharSequence charSequence = contentType;
        return charSequence == null || StringsKt.isBlank((CharSequence)charSequence) ? body : (StringsKt.contains((CharSequence)contentType, (CharSequence)"json", (boolean)true) ? FormatUtils.INSTANCE.formatJson(body) : (StringsKt.contains((CharSequence)contentType, (CharSequence)"xml", (boolean)true) ? FormatUtils.INSTANCE.formatXml(body) : (StringsKt.contains((CharSequence)contentType, (CharSequence)"x-www-form-urlencoded", (boolean)true) ? FormatUtils.INSTANCE.formatUrlEncodedForm(body) : body)));
    }

    private final CharSequence spanBody(CharSequence body, String contentType, Context context) {
        CharSequence charSequence = contentType;
        return charSequence == null || StringsKt.isBlank((CharSequence)charSequence) ? body : (StringsKt.contains((CharSequence)contentType, (CharSequence)"json", (boolean)true) && context != null ? (CharSequence)new SpanTextUtil(context).spanJson(body) : (CharSequence)this.formatBody(((Object)body).toString(), contentType));
    }

    private final String formatBytes(long bytes) {
        return FormatUtils.INSTANCE.formatByteCount(bytes, true);
    }

    @NotNull
    public final String getFormattedRequestBody() {
        String string2;
        block3: {
            block2: {
                string2 = this.requestBody;
                if (string2 == null) break block2;
                String it = string2;
                boolean bl = false;
                String string3 = this.formatBody(it, this.requestContentType);
                string2 = string3;
                if (string3 != null) break block3;
            }
            string2 = "";
        }
        return string2;
    }

    @NotNull
    public final CharSequence getSpannedRequestBody(@Nullable Context context) {
        CharSequence charSequence;
        block3: {
            block2: {
                charSequence = this.requestBody;
                if (charSequence == null) break block2;
                String it = charSequence;
                boolean bl = false;
                CharSequence charSequence2 = this.spanBody(it, this.requestContentType, context);
                charSequence = charSequence2;
                if (charSequence2 != null) break block3;
            }
            SpannableStringBuilder spannableStringBuilder = SpannableStringBuilder.valueOf((CharSequence)"");
            Intrinsics.checkNotNullExpressionValue((Object)spannableStringBuilder, (String)"valueOf(\"\")");
            charSequence = (CharSequence)spannableStringBuilder;
        }
        return charSequence;
    }

    @NotNull
    public final String getFormattedResponseBody() {
        String string2;
        block3: {
            block2: {
                string2 = this.responseBody;
                if (string2 == null) break block2;
                String it = string2;
                boolean bl = false;
                String string3 = this.formatBody(it, this.responseContentType);
                string2 = string3;
                if (string3 != null) break block3;
            }
            string2 = "";
        }
        return string2;
    }

    @NotNull
    public final CharSequence getSpannedResponseBody(@Nullable Context context) {
        CharSequence charSequence;
        block3: {
            block2: {
                charSequence = this.responseBody;
                if (charSequence == null) break block2;
                String it = charSequence;
                boolean bl = false;
                CharSequence charSequence2 = this.spanBody(it, this.responseContentType, context);
                charSequence = charSequence2;
                if (charSequence2 != null) break block3;
            }
            SpannableStringBuilder spannableStringBuilder = SpannableStringBuilder.valueOf((CharSequence)"");
            Intrinsics.checkNotNullExpressionValue((Object)spannableStringBuilder, (String)"valueOf(\"\")");
            charSequence = (CharSequence)spannableStringBuilder;
        }
        return charSequence;
    }

    @NotNull
    public final HttpTransaction populateUrl(@NotNull HttpUrl httpUrl) {
        Intrinsics.checkNotNullParameter((Object)httpUrl, (String)"httpUrl");
        FormattedUrl formattedUrl = FormattedUrl.Companion.fromHttpUrl(httpUrl, false);
        this.url = formattedUrl.getUrl();
        this.host = formattedUrl.getHost();
        this.path = formattedUrl.getPathWithQuery();
        this.scheme = formattedUrl.getScheme();
        return this;
    }

    @NotNull
    public final String getFormattedUrl(boolean encode) {
        String string2 = this.url;
        if (string2 == null || (string2 = HttpUrl.Companion.get(string2)) == null) {
            return "";
        }
        String httpUrl = string2;
        return FormattedUrl.Companion.fromHttpUrl((HttpUrl)httpUrl, encode).getUrl();
    }

    @NotNull
    public final String getFormattedPath(boolean encode) {
        String string2 = this.url;
        if (string2 == null || (string2 = HttpUrl.Companion.get(string2)) == null) {
            return "";
        }
        String httpUrl = string2;
        return FormattedUrl.Companion.fromHttpUrl((HttpUrl)httpUrl, encode).getPathWithQuery();
    }

    public final long getRequestTotalSize() {
        Long l = this.requestHeadersSize;
        Long l2 = this.requestPayloadSize;
        return (l != null ? l : 0L) + (l2 != null ? l2 : 0L);
    }

    public final long getResponseTotalSize() {
        Long l = this.responseHeadersSize;
        return (l != null ? l : 0L) + this.getHarResponseBodySize();
    }

    public final long getHarResponseBodySize() {
        long l;
        Integer n = this.responseCode;
        int n2 = 304;
        if (n != null && n == n2) {
            l = 0L;
        } else {
            Long l2 = this.responsePayloadSize;
            l = l2 != null ? l2 : 0L;
        }
        return l;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean hasTheSameContent(@Nullable HttpTransaction other) {
        boolean bl;
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.id != other.id) return false;
        if (!Intrinsics.areEqual((Object)this.requestDate, (Object)other.requestDate)) return false;
        if (!Intrinsics.areEqual((Object)this.responseDate, (Object)other.responseDate)) return false;
        if (!Intrinsics.areEqual((Object)this.tookMs, (Object)other.tookMs)) return false;
        if (!Intrinsics.areEqual((Object)this.protocol, (Object)other.protocol)) return false;
        if (!Intrinsics.areEqual((Object)this.method, (Object)other.method)) return false;
        if (!Intrinsics.areEqual((Object)this.url, (Object)other.url)) return false;
        if (!Intrinsics.areEqual((Object)this.host, (Object)other.host)) return false;
        if (!Intrinsics.areEqual((Object)this.path, (Object)other.path)) return false;
        if (!Intrinsics.areEqual((Object)this.scheme, (Object)other.scheme)) return false;
        if (!Intrinsics.areEqual((Object)this.responseTlsVersion, (Object)other.responseTlsVersion)) return false;
        if (!Intrinsics.areEqual((Object)this.responseCipherSuite, (Object)other.responseCipherSuite)) return false;
        if (!Intrinsics.areEqual((Object)this.requestPayloadSize, (Object)other.requestPayloadSize)) return false;
        if (!Intrinsics.areEqual((Object)this.requestContentType, (Object)other.requestContentType)) return false;
        if (!Intrinsics.areEqual((Object)this.requestHeaders, (Object)other.requestHeaders)) return false;
        if (!Intrinsics.areEqual((Object)this.requestHeadersSize, (Object)other.requestHeadersSize)) return false;
        if (!Intrinsics.areEqual((Object)this.requestBody, (Object)other.requestBody)) return false;
        if (this.isRequestBodyEncoded != other.isRequestBodyEncoded) return false;
        if (!Intrinsics.areEqual((Object)this.responseCode, (Object)other.responseCode)) return false;
        if (!Intrinsics.areEqual((Object)this.responseMessage, (Object)other.responseMessage)) return false;
        if (!Intrinsics.areEqual((Object)this.error, (Object)other.error)) return false;
        if (!Intrinsics.areEqual((Object)this.responsePayloadSize, (Object)other.responsePayloadSize)) return false;
        if (!Intrinsics.areEqual((Object)this.responseContentType, (Object)other.responseContentType)) return false;
        if (!Intrinsics.areEqual((Object)this.responseHeaders, (Object)other.responseHeaders)) return false;
        if (!Intrinsics.areEqual((Object)this.responseHeadersSize, (Object)other.responseHeadersSize)) return false;
        if (!Intrinsics.areEqual((Object)this.responseBody, (Object)other.responseBody)) return false;
        if (this.isResponseBodyEncoded != other.isResponseBodyEncoded) return false;
        if (this.responseImageData != null) {
            byte[] byArray = this.responseImageData;
            byte[] byArray2 = other.responseImageData;
            if (other.responseImageData == null) {
                byArray2 = new byte[]{};
            }
            if (!Arrays.equals(byArray, byArray2)) {
                return false;
            }
            bl = false;
        } else {
            bl = false;
        }
        if (bl) return false;
        if (!Intrinsics.areEqual((Object)this.graphQlOperationName, (Object)other.graphQlOperationName)) return false;
        if (this.graphQlDetected != other.graphQlDetected) return false;
        return true;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/chuckerteam/chucker/internal/data/entity/HttpTransaction$Status;", "", "(Ljava/lang/String;I)V", "Requested", "Complete", "Failed", "com.github.ChuckerTeam.Chucker.library"})
    public static final class Status
    extends Enum<Status> {
        public static final /* enum */ Status Requested = new Status();
        public static final /* enum */ Status Complete = new Status();
        public static final /* enum */ Status Failed = new Status();
        private static final /* synthetic */ Status[] $VALUES;

        public static Status[] values() {
            return (Status[])$VALUES.clone();
        }

        public static Status valueOf(String value) {
            return Enum.valueOf(Status.class, value);
        }

        static {
            $VALUES = statusArray = new Status[]{Status.Requested, Status.Complete, Status.Failed};
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Status.values().length];
            try {
                nArray[Status.Failed.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Status.Requested.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

