/*
 * Decompiled with CFR 0.152.
 */
package com.chuckerteam.chucker.api;

import android.content.Context;
import android.content.SharedPreferences;
import com.chuckerteam.chucker.api.RetentionManager;
import com.chuckerteam.chucker.internal.data.repository.RepositoryProvider;
import com.chuckerteam.chucker.internal.support.Logger;
import java.util.concurrent.TimeUnit;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.sync.Mutex;
import kotlinx.coroutines.sync.MutexKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0006\u0018\u0000 \"2\u00020\u0001:\u0002\"#B\u0019\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0019\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\bH\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0015J\u0013\u0010\u0016\u001a\u00020\u0013H\u0080@\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0010\u0010\u0019\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\bH\u0002J\u0010\u0010\u001b\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\bH\u0002J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001c\u001a\u00020\bH\u0002J\u0010\u0010\u001f\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\u0005H\u0002J\u0010\u0010 \u001a\u00020\u00132\u0006\u0010!\u001a\u00020\bH\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\f\u001a\u00020\r8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u000e\u0010\u000f\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006$"}, d2={"Lcom/chuckerteam/chucker/api/RetentionManager;", "", "context", "Landroid/content/Context;", "retentionPeriod", "Lcom/chuckerteam/chucker/api/RetentionManager$Period;", "(Landroid/content/Context;Lcom/chuckerteam/chucker/api/RetentionManager$Period;)V", "cleanupFrequency", "", "maintenanceMutex", "Lkotlinx/coroutines/sync/Mutex;", "period", "prefs", "Landroid/content/SharedPreferences;", "getPrefs", "()Landroid/content/SharedPreferences;", "prefs$delegate", "Lkotlin/Lazy;", "deleteSince", "", "threshold", "(JLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "doMaintenance", "doMaintenance$com_github_ChuckerTeam_Chucker_library", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getLastCleanup", "fallback", "getThreshold", "now", "isCleanupDue", "", "toMillis", "updateLastCleanup", "time", "Companion", "Period", "com.github.ChuckerTeam.Chucker.library"})
@SourceDebugExtension(value={"SMAP\nRetentionManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RetentionManager.kt\ncom/chuckerteam/chucker/api/RetentionManager\n+ 2 Mutex.kt\nkotlinx/coroutines/sync/MutexKt\n+ 3 SharedPreferences.kt\nandroidx/core/content/SharedPreferencesKt\n*L\n1#1,107:1\n120#2,10:108\n39#3,12:118\n*S KotlinDebug\n*F\n+ 1 RetentionManager.kt\ncom/chuckerteam/chucker/api/RetentionManager\n*L\n47#1:108,10\n67#1:118,12\n*E\n"})
public final class RetentionManager {
    @NotNull
    private static final Companion Companion = new Companion(null);
    private final long period;
    private final long cleanupFrequency;
    @NotNull
    private final Lazy prefs$delegate;
    @NotNull
    private final Mutex maintenanceMutex;
    @NotNull
    private static final String PREFS_NAME = "chucker_preferences";
    @NotNull
    private static final String KEY_LAST_CLEANUP = "last_cleanup";
    private static long lastCleanup;

    @JvmOverloads
    public RetentionManager(@NotNull Context context, @NotNull Period retentionPeriod) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)((Object)retentionPeriod), (String)"retentionPeriod");
        this.period = this.toMillis(retentionPeriod);
        this.prefs$delegate = LazyKt.lazy((Function0)((Function0)new Function0<SharedPreferences>(context){
            final /* synthetic */ Context $context;
            {
                this.$context = $context;
                super(0);
            }

            public final SharedPreferences invoke() {
                return this.$context.getSharedPreferences("chucker_preferences", 0);
            }
        }));
        this.maintenanceMutex = MutexKt.Mutex$default((boolean)false, (int)1, null);
        this.cleanupFrequency = retentionPeriod == Period.ONE_HOUR ? TimeUnit.MINUTES.toMillis(30L) : TimeUnit.HOURS.toMillis(2L);
    }

    public /* synthetic */ RetentionManager(Context context, Period period, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            period = Period.ONE_WEEK;
        }
        this(context, period);
    }

    private final SharedPreferences getPrefs() {
        Lazy lazy = this.prefs$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-prefs>(...)");
        return (SharedPreferences)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Nullable
    public final Object doMaintenance$com_github_ChuckerTeam_Chucker_library(@NotNull Continuation<? super Unit> var1_1) {
        if (!(var1_1 instanceof doMaintenance.1)) ** GOTO lbl-1000
        var10_2 = var1_1;
        if ((var10_2.label & -2147483648) != 0) {
            var10_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var1_1){
                Object L$0;
                Object L$1;
                long J$0;
                /* synthetic */ Object result;
                final /* synthetic */ RetentionManager this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.doMaintenance$com_github_ChuckerTeam_Chucker_library((Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var11_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $this$withLock_u24default$iv = this.maintenanceMutex;
                owner$iv = null;
                $i$f$withLock = false;
                $continuation.L$0 = this;
                $continuation.L$1 = $this$withLock_u24default$iv;
                $continuation.label = 1;
                v0 = $this$withLock_u24default$iv.lock(owner$iv, (Continuation)$continuation);
                if (v0 == var11_4) {
                    return var11_4;
                }
                ** GOTO lbl31
            }
            case 1: {
                $i$f$withLock = false;
                owner$iv = null;
                $this$withLock_u24default$iv = (Mutex)$continuation.L$1;
                this = (RetentionManager)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl31:
                // 3 sources

                $i$a$-withLock$default-RetentionManager$doMaintenance$2 = false;
                if (this.period <= 0L || !this.isCleanupDue(now = System.currentTimeMillis())) ** GOTO lbl56
                Logger.DefaultImpls.info$default(Logger.Companion, "Performing data retention maintenance...", null, 2, null);
                $continuation.L$0 = this;
                $continuation.L$1 = $this$withLock_u24default$iv;
                $continuation.J$0 = now;
                $continuation.label = 2;
                v1 = this.deleteSince(this.getThreshold(now), (Continuation<? super Unit>)$continuation);
                ** if (v1 != var11_4) goto lbl42
lbl41:
                // 1 sources

                return var11_4;
lbl42:
                // 1 sources

                ** GOTO lbl54
            }
            case 2: {
                $i$f$withLock = false;
                $i$a$-withLock$default-RetentionManager$doMaintenance$2 = false;
                now = $continuation.J$0;
                owner$iv = null;
                $this$withLock_u24default$iv = (Mutex)$continuation.L$1;
                this = (RetentionManager)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
lbl54:
                    // 2 sources

                    this.updateLastCleanup(now);
lbl56:
                    // 2 sources

                    var8_13 = Unit.INSTANCE;
                }
                catch (Throwable var8_14) {
                    throw var8_14;
                }
                finally {
                    $this$withLock_u24default$iv.unlock(owner$iv);
                }
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final long getLastCleanup(long fallback) {
        if (lastCleanup == 0L) {
            lastCleanup = this.getPrefs().getLong(KEY_LAST_CLEANUP, fallback);
        }
        return lastCleanup;
    }

    private final void updateLastCleanup(long time) {
        lastCleanup = time;
        SharedPreferences $this$edit_u24default$iv = this.getPrefs();
        boolean commit$iv = false;
        boolean $i$f$edit = false;
        SharedPreferences.Editor editor$iv = $this$edit_u24default$iv.edit();
        Intrinsics.checkNotNullExpressionValue((Object)editor$iv, (String)"editor");
        SharedPreferences.Editor $this$updateLastCleanup_u24lambda_u241 = editor$iv;
        boolean bl = false;
        $this$updateLastCleanup_u24lambda_u241.putLong(KEY_LAST_CLEANUP, time);
        editor$iv.apply();
    }

    private final Object deleteSince(long threshold, Continuation<? super Unit> $completion) {
        Object object = RepositoryProvider.INSTANCE.transaction().deleteOldTransactions(threshold, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    private final boolean isCleanupDue(long now) {
        return now - this.getLastCleanup(now) > this.cleanupFrequency;
    }

    private final long getThreshold(long now) {
        return this.period == 0L ? now : now - this.period;
    }

    private final long toMillis(Period period) {
        long l;
        switch (WhenMappings.$EnumSwitchMapping$0[period.ordinal()]) {
            case 1: {
                l = TimeUnit.HOURS.toMillis(1L);
                break;
            }
            case 2: {
                l = TimeUnit.DAYS.toMillis(1L);
                break;
            }
            case 3: {
                l = TimeUnit.DAYS.toMillis(7L);
                break;
            }
            case 4: {
                l = 0L;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return l;
    }

    @JvmOverloads
    public RetentionManager(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 2, null);
    }

    public static final /* synthetic */ Object access$deleteSince(RetentionManager $this, long threshold, Continuation $completion) {
        return $this.deleteSince(threshold, (Continuation<? super Unit>)$completion);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/chuckerteam/chucker/api/RetentionManager$Companion;", "", "()V", "KEY_LAST_CLEANUP", "", "PREFS_NAME", "lastCleanup", "", "com.github.ChuckerTeam.Chucker.library"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/chuckerteam/chucker/api/RetentionManager$Period;", "", "(Ljava/lang/String;I)V", "ONE_HOUR", "ONE_DAY", "ONE_WEEK", "FOREVER", "com.github.ChuckerTeam.Chucker.library"})
    public static final class Period
    extends Enum<Period> {
        public static final /* enum */ Period ONE_HOUR = new Period();
        public static final /* enum */ Period ONE_DAY = new Period();
        public static final /* enum */ Period ONE_WEEK = new Period();
        public static final /* enum */ Period FOREVER = new Period();
        private static final /* synthetic */ Period[] $VALUES;

        public static Period[] values() {
            return (Period[])$VALUES.clone();
        }

        public static Period valueOf(String value) {
            return Enum.valueOf(Period.class, value);
        }

        static {
            $VALUES = periodArray = new Period[]{Period.ONE_HOUR, Period.ONE_DAY, Period.ONE_WEEK, Period.FOREVER};
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Period.values().length];
            try {
                nArray[Period.ONE_HOUR.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Period.ONE_DAY.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Period.ONE_WEEK.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Period.FOREVER.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

