/*
 * Decompiled with CFR 0.152.
 */
package org.modelmapper.module.jsr310;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.temporal.Temporal;
import java.util.Calendar;
import java.util.Date;
import org.modelmapper.Converter;
import org.modelmapper.internal.Errors;
import org.modelmapper.module.jsr310.Jsr310ModuleConfig;
import org.modelmapper.spi.ConditionalConverter;
import org.modelmapper.spi.MappingContext;

public class FromTemporalConverter
implements ConditionalConverter<Temporal, Object> {
    private Jsr310ModuleConfig config;
    private final LocalDateTimeConverter localDateTimeConverter = new LocalDateTimeConverter();
    private final LocalDateConverter localDateConverter = new LocalDateConverter();
    private final OffsetDateTimeConverter offsetDateTimeConverter = new OffsetDateTimeConverter();
    private final InstantConverter instantConverter = new InstantConverter();

    public FromTemporalConverter(Jsr310ModuleConfig config) {
        this.config = config;
    }

    public ConditionalConverter.MatchResult match(Class<?> sourceType, Class<?> destinationType) {
        return Temporal.class.isAssignableFrom(sourceType) ? ConditionalConverter.MatchResult.FULL : ConditionalConverter.MatchResult.NONE;
    }

    public Object convert(MappingContext<Temporal, Object> mappingContext) {
        if (mappingContext.getSource() == null) {
            return null;
        }
        Class sourceType = mappingContext.getSourceType();
        if (LocalDateTime.class.equals((Object)sourceType)) {
            return this.localDateTimeConverter.convert(mappingContext);
        }
        if (LocalDate.class.equals((Object)sourceType)) {
            return this.localDateConverter.convert(mappingContext);
        }
        if (OffsetDateTime.class.equals((Object)sourceType)) {
            return this.offsetDateTimeConverter.convert(mappingContext);
        }
        if (Instant.class.equals((Object)sourceType)) {
            return this.instantConverter.convert(mappingContext);
        }
        throw new Errors().addMessage("Unsupported mapping types[%s->%s]", new Object[]{LocalDateTime.class.getName(), mappingContext.getDestinationType().getName()}).toMappingException();
    }

    private Object convertLocalDateTime(LocalDateTime source, MappingContext<?, ?> mappingContext) {
        Class destinationType = mappingContext.getDestinationType();
        if (destinationType.equals(String.class)) {
            return this.config.getDateTimeFormatter().format(source);
        }
        Instant instant = source.atZone(this.config.getZoneId()).toInstant();
        return this.convertInstant(instant, mappingContext);
    }

    private Object convertOffsetDateTime(OffsetDateTime source, MappingContext<?, ?> mappingContext) {
        Class destinationType = mappingContext.getDestinationType();
        if (destinationType.equals(String.class)) {
            return this.config.getDateTimeOffsetFormatter().format(source);
        }
        Instant instant = source.toInstant();
        return this.convertInstant(instant, mappingContext);
    }

    private Object convertInstant(Instant source, MappingContext<?, ?> mappingContext) {
        Class destinationType = mappingContext.getDestinationType();
        if (destinationType.equals(String.class)) {
            return this.config.getDateTimeFormatter().withZone(this.config.getZoneId()).format(source);
        }
        if (Date.class.isAssignableFrom(destinationType)) {
            return new Date(this.epochMilliOf(source));
        }
        if (Calendar.class.isAssignableFrom(destinationType)) {
            return this.calendarOf(source);
        }
        if (Long.class.equals((Object)destinationType) || Long.TYPE.equals(destinationType)) {
            return this.epochMilliOf(source);
        }
        if (BigDecimal.class.equals((Object)destinationType)) {
            return new BigDecimal(this.epochMilliOf(source));
        }
        if (BigInteger.class.equals((Object)destinationType)) {
            return BigInteger.valueOf(this.epochMilliOf(source));
        }
        throw new Errors().addMessage("Unsupported mapping types[%s->%s]", new Object[]{mappingContext.getSourceType().getName(), destinationType.getName()}).toMappingException();
    }

    private long epochMilliOf(Instant instant) {
        return instant.toEpochMilli();
    }

    private Calendar calendarOf(Instant instant) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(this.epochMilliOf(instant));
        return calendar;
    }

    private class InstantConverter
    implements Converter<Temporal, Object> {
        private InstantConverter() {
        }

        public Object convert(MappingContext<Temporal, Object> mappingContext) {
            Instant source = (Instant)mappingContext.getSource();
            return FromTemporalConverter.this.convertInstant(source, mappingContext);
        }
    }

    private class OffsetDateTimeConverter
    implements Converter<Temporal, Object> {
        private OffsetDateTimeConverter() {
        }

        public Object convert(MappingContext<Temporal, Object> mappingContext) {
            OffsetDateTime source = (OffsetDateTime)mappingContext.getSource();
            return FromTemporalConverter.this.convertOffsetDateTime(source, mappingContext);
        }
    }

    private class LocalDateConverter
    implements Converter<Temporal, Object> {
        private LocalDateConverter() {
        }

        public Object convert(MappingContext<Temporal, Object> mappingContext) {
            LocalDate source = (LocalDate)mappingContext.getSource();
            Class destinationType = mappingContext.getDestinationType();
            if (destinationType.equals(String.class)) {
                return FromTemporalConverter.this.config.getDateFormatter().format(source);
            }
            LocalDateTime localDateTime = source.atStartOfDay();
            return FromTemporalConverter.this.convertLocalDateTime(localDateTime, mappingContext);
        }
    }

    private class LocalDateTimeConverter
    implements Converter<Temporal, Object> {
        private LocalDateTimeConverter() {
        }

        public Object convert(MappingContext<Temporal, Object> mappingContext) {
            LocalDateTime source = (LocalDateTime)mappingContext.getSource();
            return FromTemporalConverter.this.convertLocalDateTime(source, mappingContext);
        }
    }
}

