/*
 * Decompiled with CFR 0.152.
 */
package org.modelmapper.module.jsr310;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.Temporal;
import java.util.Calendar;
import java.util.Date;
import org.modelmapper.Converter;
import org.modelmapper.internal.Errors;
import org.modelmapper.module.jsr310.Jsr310ModuleConfig;
import org.modelmapper.spi.ConditionalConverter;
import org.modelmapper.spi.MappingContext;

public class ToTemporalConverter
implements ConditionalConverter<Object, Temporal> {
    private Jsr310ModuleConfig config;
    private final LocalDateTimeConverter localDateTimeConverter = new LocalDateTimeConverter();
    private final LocalDateConverter localDateConverter = new LocalDateConverter();
    private final InstantConverter instantConverter = new InstantConverter();

    public ToTemporalConverter(Jsr310ModuleConfig config) {
        this.config = config;
    }

    public ConditionalConverter.MatchResult match(Class<?> sourceType, Class<?> destinationType) {
        return Temporal.class.isAssignableFrom(destinationType) ? ConditionalConverter.MatchResult.FULL : ConditionalConverter.MatchResult.NONE;
    }

    public Temporal convert(MappingContext<Object, Temporal> mappingContext) {
        Class destinationType = mappingContext.getDestinationType();
        if (LocalDateTime.class.equals((Object)destinationType)) {
            return this.localDateTimeConverter.convert((MappingContext)mappingContext);
        }
        if (LocalDate.class.equals((Object)destinationType)) {
            return this.localDateConverter.convert((MappingContext)mappingContext);
        }
        if (Instant.class.equals((Object)destinationType)) {
            return this.instantConverter.convert((MappingContext)mappingContext);
        }
        throw new Errors().addMessage("Unsupported mapping types[%s->%s]", new Object[]{mappingContext.getSourceType().getName(), destinationType.getName()}).toMappingException();
    }

    private LocalDate convertLocalDate(MappingContext<?, ?> mappingContext) {
        Object source = mappingContext.getSource();
        Class<?> sourceType = source.getClass();
        if (sourceType.equals(String.class)) {
            return LocalDate.parse((String)source, DateTimeFormatter.ofPattern(this.config.getDatePattern()));
        }
        return this.convertInstant(mappingContext).atZone(this.config.getZoneId()).toLocalDate();
    }

    private LocalDateTime convertLocalDateTime(MappingContext<?, ?> mappingContext) {
        Object source = mappingContext.getSource();
        Class<?> sourceType = source.getClass();
        if (sourceType.equals(String.class)) {
            return LocalDateTime.parse((String)source, DateTimeFormatter.ofPattern(this.config.getDateTimePattern()));
        }
        return this.convertInstant(mappingContext).atZone(this.config.getZoneId()).toLocalDateTime();
    }

    private Instant convertInstant(MappingContext<?, ?> mappingContext) {
        Object source = mappingContext.getSource();
        Class<?> sourceType = source.getClass();
        if (sourceType.equals(String.class)) {
            return LocalDateTime.parse((String)source, DateTimeFormatter.ofPattern(this.config.getDateTimePattern())).atZone(this.config.getZoneId()).toInstant();
        }
        if (Date.class.isAssignableFrom(sourceType)) {
            return Instant.ofEpochMilli(((Date)source).getTime());
        }
        if (Calendar.class.isAssignableFrom(sourceType)) {
            return Instant.ofEpochMilli(((Calendar)source).getTime().getTime());
        }
        if (Number.class.isAssignableFrom(sourceType)) {
            return Instant.ofEpochMilli(((Number)source).longValue());
        }
        throw new Errors().addMessage("Unsupported mapping types[%s->%s]", new Object[]{sourceType.getName(), mappingContext.getDestinationType().getName()}).toMappingException();
    }

    private class InstantConverter
    implements Converter<Object, Temporal> {
        private InstantConverter() {
        }

        public Temporal convert(MappingContext<Object, Temporal> mappingContext) {
            return ToTemporalConverter.this.convertInstant(mappingContext);
        }
    }

    private class LocalDateConverter
    implements Converter<Object, Temporal> {
        private LocalDateConverter() {
        }

        public Temporal convert(MappingContext<Object, Temporal> mappingContext) {
            return ToTemporalConverter.this.convertLocalDate(mappingContext);
        }
    }

    private class LocalDateTimeConverter
    implements Converter<Object, Temporal> {
        private LocalDateTimeConverter() {
        }

        public Temporal convert(MappingContext<Object, Temporal> mappingContext) {
            return ToTemporalConverter.this.convertLocalDateTime(mappingContext);
        }
    }
}

