/*
 * Decompiled with CFR 0.152.
 */
package com.jiangdg.ausbc.render;

import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.SurfaceTexture;
import android.net.Uri;
import android.opengl.EGLContext;
import android.os.Environment;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Message;
import android.provider.MediaStore;
import android.view.Surface;
import com.jiangdg.ausbc.callback.ICaptureCallBack;
import com.jiangdg.ausbc.callback.IPreviewDataCallBack;
import com.jiangdg.ausbc.render.RenderManager;
import com.jiangdg.ausbc.render.effect.AbstractEffect;
import com.jiangdg.ausbc.render.env.RotateType;
import com.jiangdg.ausbc.render.internal.AbstractFboRender;
import com.jiangdg.ausbc.render.internal.AbstractRender;
import com.jiangdg.ausbc.render.internal.CameraRender;
import com.jiangdg.ausbc.render.internal.CaptureRender;
import com.jiangdg.ausbc.render.internal.EncodeRender;
import com.jiangdg.ausbc.render.internal.ScreenRender;
import com.jiangdg.ausbc.utils.GLBitmapUtils;
import com.jiangdg.ausbc.utils.ImageUtils;
import com.jiangdg.ausbc.utils.Logger;
import com.jiangdg.ausbc.utils.SettableFuture;
import com.jiangdg.ausbc.utils.Utils;
import com.jiangdg.ausbc.utils.bus.EventBus;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u00d0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0014\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 v2\u00020\u00012\u00020\u0002:\u0002uvB/\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0010\b\u0002\u0010\b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010K\u001a\u00020L2\b\u0010M\u001a\u0004\u0018\u00010\u000eJ\u0010\u0010N\u001a\u00020L2\u0006\u0010O\u001a\u00020\u0006H\u0002J\u0018\u0010P\u001a\u00020L2\u0006\u0010Q\u001a\u00020\u00062\u0006\u0010R\u001a\u00020/H\u0002J\b\u0010S\u001a\u00020LH\u0002J\u0016\u0010T\u001a\u0012\u0012\u0004\u0012\u00020\u000e0\rj\b\u0012\u0004\u0012\u00020\u000e`\u000fJ\u0010\u0010U\u001a\u00020V2\u0006\u0010W\u001a\u00020XH\u0016J\u0012\u0010Y\u001a\u00020L2\b\u0010Z\u001a\u0004\u0018\u00010\u0019H\u0016J\u0010\u0010[\u001a\u00020L2\b\u0010M\u001a\u0004\u0018\u00010\u000eJ\u001a\u0010\\\u001a\u00020L2\b\u0010]\u001a\u0004\u0018\u00010\u001b2\b\u0010^\u001a\u0004\u0018\u00010\u0011J\u0012\u0010_\u001a\u00020L2\b\u0010`\u001a\u0004\u0018\u00010\u0011H\u0002J\u0016\u0010a\u001a\u00020L2\u0006\u0010b\u001a\u00020\u00062\u0006\u0010c\u001a\u00020\u0006J\u0010\u0010d\u001a\u00020L2\b\u0010e\u001a\u0004\u0018\u00010fJ\u001e\u0010g\u001a\u00020L2\u0006\u0010h\u001a\u00020i2\u0006\u0010j\u001a\u00020\u00062\u0006\u0010k\u001a\u00020\u0006J \u0010l\u001a\u00020L2\u0006\u0010m\u001a\u00020i2\u0006\u0010b\u001a\u00020\u00062\u0006\u0010c\u001a\u00020\u0006H\u0002J,\u0010n\u001a\u00020L2\u0006\u0010b\u001a\u00020\u00062\u0006\u0010c\u001a\u00020\u00062\b\u0010o\u001a\u0004\u0018\u00010i2\n\b\u0002\u0010p\u001a\u0004\u0018\u00010qJ\u0006\u0010r\u001a\u00020LJ\b\u0010s\u001a\u00020LH\u0002J\u0006\u0010t\u001a\u00020LR\u001e\u0010\f\u001a\u0012\u0012\u0004\u0012\u00020\u000e0\rj\b\u0012\u0004\u0012\u00020\u000e`\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0010\u001a\u00020\u00118BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\u0015\u001a\u0004\b\u0012\u0010\u0013R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u001e\u001a\u00020\u001f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\"\u0010\u0015\u001a\u0004\b \u0010!R\u000e\u0010#\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010$\u001a\u00020%8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b(\u0010\u0015\u001a\u0004\b&\u0010'R\u0012\u0010)\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010*R\u001e\u0010+\u001a\u0012\u0012\u0004\u0012\u00020\u000e0\rj\b\u0012\u0004\u0012\u00020\u000e`\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010,\u001a\u0004\u0018\u00010-X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010.\u001a\u00020/X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00100\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00101\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00102\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u00103\u001a\u0002048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b7\u0010\u0015\u001a\u0004\b5\u00106R\u0010\u00108\u001a\u0004\u0018\u000109X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010:\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010;\u001a\u0004\u0018\u000104X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010<\u001a\u0004\u0018\u00010=X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010>\u001a\u0004\u0018\u000104X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010?\u001a\u0004\u0018\u00010=X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010@\u001a\u0004\u0018\u00010AX\u0082\u000e\u00a2\u0006\u0002\n\u0000R!\u0010B\u001a\b\u0012\u0004\u0012\u00020\u00190C8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\bF\u0010\u0015\u001a\u0004\bD\u0010ER\u000e\u0010G\u001a\u00020/X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010H\u001a\u00020IX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010J\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006w"}, d2={"Lcom/jiangdg/ausbc/render/RenderManager;", "Landroid/graphics/SurfaceTexture$OnFrameAvailableListener;", "Landroid/os/Handler$Callback;", "context", "Landroid/content/Context;", "surfaceWidth", "", "surfaceHeight", "mPreviewDataCbList", "Ljava/util/concurrent/CopyOnWriteArrayList;", "Lcom/jiangdg/ausbc/callback/IPreviewDataCallBack;", "(Landroid/content/Context;IILjava/util/concurrent/CopyOnWriteArrayList;)V", "mCacheEffectList", "Ljava/util/ArrayList;", "Lcom/jiangdg/ausbc/render/effect/AbstractEffect;", "Lkotlin/collections/ArrayList;", "mCameraDir", "", "getMCameraDir", "()Ljava/lang/String;", "mCameraDir$delegate", "Lkotlin/Lazy;", "mCameraRender", "Lcom/jiangdg/ausbc/render/internal/CameraRender;", "mCameraSurfaceTexture", "Landroid/graphics/SurfaceTexture;", "mCaptureDataCb", "Lcom/jiangdg/ausbc/callback/ICaptureCallBack;", "mCaptureRender", "Lcom/jiangdg/ausbc/render/internal/CaptureRender;", "mCaptureState", "Ljava/util/concurrent/atomic/AtomicBoolean;", "getMCaptureState", "()Ljava/util/concurrent/atomic/AtomicBoolean;", "mCaptureState$delegate", "mContext", "mDateFormat", "Ljava/text/SimpleDateFormat;", "getMDateFormat", "()Ljava/text/SimpleDateFormat;", "mDateFormat$delegate", "mEOSTextureId", "Ljava/lang/Integer;", "mEffectList", "mEncodeRender", "Lcom/jiangdg/ausbc/render/internal/EncodeRender;", "mEndTime", "", "mFBOBufferId", "mFrameRate", "mHeight", "mMainHandler", "Landroid/os/Handler;", "getMMainHandler", "()Landroid/os/Handler;", "mMainHandler$delegate", "mPreviewByteBuffer", "Ljava/nio/ByteBuffer;", "mRelativePath", "mRenderCodecHandler", "mRenderCodecThread", "Landroid/os/HandlerThread;", "mRenderHandler", "mRenderThread", "mScreenRender", "Lcom/jiangdg/ausbc/render/internal/ScreenRender;", "mStFuture", "Lcom/jiangdg/ausbc/utils/SettableFuture;", "getMStFuture", "()Lcom/jiangdg/ausbc/utils/SettableFuture;", "mStFuture$delegate", "mStartTime", "mTransformMatrix", "", "mWidth", "addRenderEffect", "", "effect", "drawFrame2Capture", "fboId", "drawFrame2Codec", "textureId", "timeStamps", "emitFrameRate", "getCacheEffectList", "handleMessage", "", "msg", "Landroid/os/Message;", "onFrameAvailable", "surfaceTexture", "removeRenderEffect", "saveImage", "callBack", "path", "saveImageInternal", "savePath", "setRenderSize", "w", "h", "setRotateType", "type", "Lcom/jiangdg/ausbc/render/env/RotateType;", "startRenderCodec", "inputSurface", "Landroid/view/Surface;", "width", "height", "startRenderCodecInternal", "surface", "startRenderScreen", "outSurface", "listener", "Lcom/jiangdg/ausbc/render/RenderManager$CameraSurfaceTextureListener;", "stopRenderCodec", "stopRenderCodecInternal", "stopRenderScreen", "CameraSurfaceTextureListener", "Companion", "libausbc_release"})
public final class RenderManager
implements SurfaceTexture.OnFrameAvailableListener,
Handler.Callback {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int surfaceWidth;
    private final int surfaceHeight;
    @Nullable
    private final CopyOnWriteArrayList<IPreviewDataCallBack> mPreviewDataCbList;
    @Nullable
    private ByteBuffer mPreviewByteBuffer;
    @Nullable
    private Integer mEOSTextureId;
    @Nullable
    private HandlerThread mRenderThread;
    @Nullable
    private Handler mRenderHandler;
    @Nullable
    private HandlerThread mRenderCodecThread;
    @Nullable
    private Handler mRenderCodecHandler;
    @Nullable
    private CameraRender mCameraRender;
    @Nullable
    private ScreenRender mScreenRender;
    @Nullable
    private EncodeRender mEncodeRender;
    @Nullable
    private CaptureRender mCaptureRender;
    @Nullable
    private SurfaceTexture mCameraSurfaceTexture;
    @NotNull
    private float[] mTransformMatrix;
    private int mWidth;
    private int mHeight;
    private int mFBOBufferId;
    @NotNull
    private Context mContext;
    @NotNull
    private ArrayList<AbstractEffect> mEffectList;
    @NotNull
    private ArrayList<AbstractEffect> mCacheEffectList;
    @Nullable
    private ICaptureCallBack mCaptureDataCb;
    private int mFrameRate;
    private long mEndTime;
    private long mStartTime;
    @NotNull
    private final Lazy mStFuture$delegate;
    @NotNull
    private final Lazy mMainHandler$delegate;
    @NotNull
    private final Lazy mCaptureState$delegate;
    @NotNull
    private final Lazy mDateFormat$delegate;
    @NotNull
    private final Lazy mCameraDir$delegate;
    @NotNull
    private final String mRelativePath;
    @NotNull
    private static final String TAG = "RenderManager";
    @NotNull
    private static final String RENDER_THREAD = "gl_render";
    @NotNull
    private static final String RENDER_CODEC_THREAD = "gl_render_codec";
    private static final int MSG_GL_INIT = 0;
    private static final int MSG_GL_DRAW = 1;
    private static final int MSG_GL_RELEASE = 2;
    private static final int MSG_GL_START_RENDER_CODEC = 3;
    private static final int MSG_GL_STOP_RENDER_CODEC = 4;
    private static final int MSG_GL_CHANGED_SIZE = 5;
    private static final int MSG_GL_ADD_EFFECT = 6;
    private static final int MSG_GL_REMOVE_EFFECT = 7;
    private static final int MSG_GL_SAVE_IMAGE = 8;
    private static final int MSG_GL_ROUTE_ANGLE = 9;
    private static final int MSG_GL_RENDER_CODEC_INIT = 17;
    private static final int MSG_GL_RENDER_CODEC_CHANGED_SIZE = 18;
    private static final int MSG_GL_RENDER_CODEC_DRAW = 19;
    private static final int MSG_GL_RENDER_CODEC_RELEASE = 20;

    public RenderManager(@NotNull Context context, int surfaceWidth, int surfaceHeight, @Nullable CopyOnWriteArrayList<IPreviewDataCallBack> mPreviewDataCbList) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.surfaceWidth = surfaceWidth;
        this.surfaceHeight = surfaceHeight;
        this.mPreviewDataCbList = mPreviewDataCbList;
        this.mTransformMatrix = new float[16];
        this.mContext = context;
        boolean bl = false;
        this.mEffectList = new ArrayList();
        bl = false;
        this.mCacheEffectList = new ArrayList();
        this.mStartTime = System.currentTimeMillis();
        this.mStFuture$delegate = LazyKt.lazy((Function0)mStFuture.2.INSTANCE);
        this.mMainHandler$delegate = LazyKt.lazy((Function0)mMainHandler.2.INSTANCE);
        this.mCaptureState$delegate = LazyKt.lazy((Function0)mCaptureState.2.INSTANCE);
        this.mDateFormat$delegate = LazyKt.lazy((Function0)mDateFormat.2.INSTANCE);
        this.mCameraDir$delegate = LazyKt.lazy((Function0)mCameraDir.2.INSTANCE);
        this.mRelativePath = Intrinsics.stringPlus((String)Environment.DIRECTORY_DCIM, (Object)"/Camera");
        this.mCameraRender = new CameraRender(context);
        this.mScreenRender = new ScreenRender(context);
        this.mCaptureRender = new CaptureRender(context);
        Logger.INSTANCE.i(TAG, Intrinsics.stringPlus((String)"create RenderManager, Open ES version is ", (Object)Utils.INSTANCE.getGLESVersion(context)));
    }

    public /* synthetic */ RenderManager(Context context, int n, int n2, CopyOnWriteArrayList copyOnWriteArrayList, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 8) != 0) {
            copyOnWriteArrayList = null;
        }
        this(context, n, n2, copyOnWriteArrayList);
    }

    private final SettableFuture<SurfaceTexture> getMStFuture() {
        Lazy lazy = this.mStFuture$delegate;
        boolean bl = false;
        return (SettableFuture)lazy.getValue();
    }

    private final Handler getMMainHandler() {
        Lazy lazy = this.mMainHandler$delegate;
        boolean bl = false;
        return (Handler)lazy.getValue();
    }

    private final AtomicBoolean getMCaptureState() {
        Lazy lazy = this.mCaptureState$delegate;
        boolean bl = false;
        return (AtomicBoolean)lazy.getValue();
    }

    private final SimpleDateFormat getMDateFormat() {
        Lazy lazy = this.mDateFormat$delegate;
        boolean bl = false;
        return (SimpleDateFormat)lazy.getValue();
    }

    private final String getMCameraDir() {
        Lazy lazy = this.mCameraDir$delegate;
        boolean bl = false;
        return (String)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    public boolean handleMessage(@NotNull Message msg) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        int n = msg.what;
        switch (n) {
            case 0: {
                Integer n2;
                Object object = msg.obj;
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Triple<*, *, *>");
                }
                object = (Triple)object;
                boolean bl = false;
                boolean bl2 = false;
                Object $this$handleMessage_u24lambda_u2d1 = object;
                boolean bl3 = false;
                Object object2 = $this$handleMessage_u24lambda_u2d1.getFirst();
                if (object2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                }
                int w = (Integer)object2;
                Object object3 = $this$handleMessage_u24lambda_u2d1.getSecond();
                if (object3 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                }
                int h = (Integer)object3;
                Object object4 = $this$handleMessage_u24lambda_u2d1.getThird();
                Surface surface2 = object4 instanceof Surface ? (Surface)object4 : null;
                object4 = this.mScreenRender;
                if (object4 != null) {
                    ((ScreenRender)object4).initEGLEvn();
                }
                object4 = this.mScreenRender;
                if (object4 != null) {
                    ((ScreenRender)object4).setupSurface(surface2, w, h);
                }
                object4 = this.mScreenRender;
                if (object4 != null) {
                    ((AbstractRender)object4).initGLES();
                }
                object4 = this.mCameraRender;
                if (object4 != null) {
                    ((AbstractRender)object4).initGLES();
                }
                object4 = this.mCaptureRender;
                if (object4 != null) {
                    ((AbstractRender)object4).initGLES();
                }
                RenderManager renderManager = this;
                object4 = this.mCameraRender;
                if (object4 == null) {
                    n2 = null;
                } else {
                    void $this$handleMessage_u24lambda_u2d1_u24lambda_u2d0;
                    Integer n3;
                    Integer n4 = n3 = Integer.valueOf(((CameraRender)object4).getCameraTextureId());
                    boolean bl4 = false;
                    boolean bl5 = false;
                    int n5 = ((Number)n4).intValue();
                    RenderManager renderManager2 = renderManager;
                    boolean bl6 = false;
                    this.getMStFuture().set(new SurfaceTexture((int)$this$handleMessage_u24lambda_u2d1_u24lambda_u2d0));
                    Unit unit = Unit.INSTANCE;
                    renderManager = renderManager2;
                    n2 = n4;
                }
                renderManager.mEOSTextureId = n2;
                EventBus.INSTANCE.with("render-ready").postMessage(true);
                break;
            }
            case 5: {
                Object object = msg.obj;
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Pair<*, *>");
                }
                object = (Pair)object;
                boolean bl = false;
                boolean bl7 = false;
                Object $this$handleMessage_u24lambda_u2d2 = object;
                boolean bl8 = false;
                Object h = $this$handleMessage_u24lambda_u2d2.getFirst();
                if (h == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                }
                this.mWidth = (Integer)h;
                h = $this$handleMessage_u24lambda_u2d2.getSecond();
                if (h == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                }
                this.mHeight = (Integer)h;
                h = this.mCameraRender;
                if (h != null) {
                    ((AbstractFboRender)h).setSize(this.mWidth, this.mHeight);
                }
                h = this.mScreenRender;
                if (h != null) {
                    ((AbstractRender)h).setSize(this.mWidth, this.mHeight);
                }
                h = this.mCaptureRender;
                if (h != null) {
                    ((AbstractFboRender)h).setSize(this.mWidth, this.mHeight);
                }
                h = this.mCameraSurfaceTexture;
                if (h == null) break;
                h.setDefaultBufferSize(this.mWidth, this.mHeight);
                break;
            }
            case 8: {
                Object object = msg.obj;
                this.saveImageInternal(object instanceof String ? (String)object : null);
                break;
            }
            case 3: {
                Object object = msg.obj;
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Triple<*, *, *>");
                }
                object = (Triple)object;
                boolean bl = false;
                boolean bl9 = false;
                Object $this$handleMessage_u24lambda_u2d3 = object;
                boolean bl10 = false;
                Object h = $this$handleMessage_u24lambda_u2d3.getFirst();
                if (h == null) {
                    throw new NullPointerException("null cannot be cast to non-null type android.view.Surface");
                }
                Surface surface = (Surface)h;
                Object surface2 = $this$handleMessage_u24lambda_u2d3.getSecond();
                if (surface2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                }
                int width = (Integer)surface2;
                Object object5 = $this$handleMessage_u24lambda_u2d3.getThird();
                if (object5 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                }
                int height = (Integer)object5;
                this.startRenderCodecInternal(surface, width, height);
                break;
            }
            case 4: {
                this.stopRenderCodecInternal();
                break;
            }
            case 9: {
                RotateType rotateType;
                Object object = msg.obj;
                RotateType rotateType2 = rotateType = object instanceof RotateType ? (RotateType)((Object)object) : null;
                if (rotateType == null) break;
                object = rotateType;
                boolean bl = false;
                boolean $this$handleMessage_u24lambda_u2d3 = false;
                Object $this$handleMessage_u24lambda_u2d4 = object;
                boolean bl11 = false;
                CameraRender surface = this.mCameraRender;
                if (surface == null) break;
                surface.setRotateAngle((RotateType)((Object)$this$handleMessage_u24lambda_u2d4));
                break;
            }
            case 1: {
                long l;
                int it;
                boolean $this$handleMessage_u24lambda_u2d4;
                Integer n6;
                Integer n7;
                Object object = this.mCameraSurfaceTexture;
                if (object != null) {
                    object.updateTexImage();
                }
                object = this.mCameraSurfaceTexture;
                if (object != null) {
                    object.getTransformMatrix(this.mTransformMatrix);
                }
                object = this.mCameraRender;
                if (object != null) {
                    ((CameraRender)object).setTransformMatrix(this.mTransformMatrix);
                }
                Object object6 = this.mEOSTextureId;
                if (object6 == null) {
                    n7 = null;
                } else {
                    n6 = object6;
                    boolean $this$handleMessage_u24lambda_u2d3 = false;
                    $this$handleMessage_u24lambda_u2d4 = false;
                    it = ((Number)n6).intValue();
                    boolean bl = false;
                    CameraRender height = this.mCameraRender;
                    n7 = height == null ? null : Integer.valueOf(height.drawFrame(it));
                }
                Integer textureId = n7;
                object6 = textureId;
                if (object6 != null) {
                    long l2;
                    Integer $this$handleMessage_u24lambda_u2d3 = object6;
                    $this$handleMessage_u24lambda_u2d4 = false;
                    it = 0;
                    int fboId = ((Number)$this$handleMessage_u24lambda_u2d3).intValue();
                    boolean bl = false;
                    int effectId = 0;
                    effectId = fboId;
                    Iterable $this$forEach$iv = this.mEffectList;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        AbstractEffect effectRender = (AbstractEffect)element$iv;
                        boolean bl12 = false;
                        effectId = effectRender.drawFrame(effectId);
                    }
                    $this$handleMessage_u24lambda_u2d3 = n6 = Integer.valueOf(effectId);
                    $this$handleMessage_u24lambda_u2d4 = false;
                    it = 0;
                    int id2 = ((Number)$this$handleMessage_u24lambda_u2d3).intValue();
                    boolean bl13 = false;
                    ScreenRender screenRender = this.mScreenRender;
                    if (screenRender != null) {
                        screenRender.drawFrame(id2);
                    }
                    this.drawFrame2Capture(id2);
                    screenRender = this.mCameraSurfaceTexture;
                    this.drawFrame2Codec(id2, screenRender == null ? 0L : (l2 = screenRender.getTimestamp()));
                }
                object6 = this.mScreenRender;
                if (object6 == null) break;
                n6 = this.mCameraSurfaceTexture;
                if (n6 == null) {
                    l = 0L;
                } else {
                    Long $this$handleMessage_u24lambda_u2d3 = n6.getTimestamp();
                    l = $this$handleMessage_u24lambda_u2d3;
                }
                ((ScreenRender)object6).swapBuffers(l);
                break;
            }
            case 6: {
                AbstractEffect textureId;
                Object object = msg.obj;
                AbstractEffect abstractEffect = textureId = object instanceof AbstractEffect ? (AbstractEffect)object : null;
                if (textureId == null) break;
                object = textureId;
                boolean bl = false;
                boolean $this$handleMessage_u24lambda_u2d3 = false;
                Object effect = object;
                boolean bl14 = false;
                if (this.mEffectList.contains(effect)) break;
                ((AbstractRender)effect).initGLES();
                ((AbstractFboRender)effect).setSize(this.mWidth, this.mHeight);
                this.mEffectList.add((AbstractEffect)effect);
                this.mCacheEffectList.add((AbstractEffect)effect);
                Logger.INSTANCE.i(TAG, "add effect, name = " + effect.getClass().getSimpleName() + ", size = " + this.mEffectList.size());
                break;
            }
            case 7: {
                AbstractEffect textureId;
                Object object = msg.obj;
                AbstractEffect abstractEffect = textureId = object instanceof AbstractEffect ? (AbstractEffect)object : null;
                if (textureId == null) break;
                object = textureId;
                boolean bl = false;
                boolean $this$handleMessage_u24lambda_u2d3 = false;
                Object it = object;
                boolean bl15 = false;
                if (!this.mEffectList.contains(it)) break;
                ((AbstractRender)it).releaseGLES();
                this.mEffectList.remove(it);
                this.mCacheEffectList.remove(it);
                Logger.INSTANCE.i(TAG, "remove effect, name = " + it.getClass().getSimpleName() + ", size = " + this.mEffectList.size());
                break;
            }
            case 2: {
                EventBus.INSTANCE.with("render-ready").postMessage(false);
                Iterable $this$forEach$iv = this.mEffectList;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    AbstractEffect effect = (AbstractEffect)element$iv;
                    boolean bl = false;
                    effect.releaseGLES();
                }
                this.mEffectList.clear();
                AbstractRender abstractRender = this.mCameraRender;
                if (abstractRender != null) {
                    abstractRender.releaseGLES();
                }
                abstractRender = this.mScreenRender;
                if (abstractRender != null) {
                    abstractRender.releaseGLES();
                }
                abstractRender = this.mCaptureRender;
                if (abstractRender != null) {
                    abstractRender.releaseGLES();
                }
                abstractRender = this.mCameraSurfaceTexture;
                if (abstractRender != null) {
                    abstractRender.setOnFrameAvailableListener(null);
                }
                this.mCameraSurfaceTexture = null;
            }
        }
        return true;
    }

    private final void drawFrame2Capture(int fboId) {
        CaptureRender captureRender = this.mCaptureRender;
        if (captureRender != null) {
            Integer n;
            int n2;
            int n3 = n2 = captureRender.drawFrame(fboId);
            boolean bl = false;
            boolean bl2 = false;
            int it = n3;
            boolean bl3 = false;
            CaptureRender captureRender2 = this.mCaptureRender;
            Intrinsics.checkNotNull((Object)captureRender2);
            Integer n4 = n = Integer.valueOf(captureRender2.getFrameBufferId());
            bl = false;
            bl2 = false;
            int id2 = ((Number)n4).intValue();
            boolean bl4 = false;
            this.mFBOBufferId = id2;
            CaptureRender captureRender3 = this.mCaptureRender;
            Integer n5 = captureRender3 == null ? null : Integer.valueOf(captureRender3.getRenderWidth());
            int renderWidth = n5 == null ? this.mWidth : n5;
            Object object = this.mCaptureRender;
            captureRender3 = object == null ? null : Integer.valueOf(((AbstractRender)object).getRenderHeight());
            int renderHeight = captureRender3 == null ? this.mHeight : (Integer)((Object)captureRender3);
            int rgbaLen = renderWidth * renderHeight * 4;
            object = this.mPreviewDataCbList;
            if (object != null) {
                Iterable $this$forEach$iv = (Iterable)object;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    ByteBuffer byteBuffer;
                    IPreviewDataCallBack callback = (IPreviewDataCallBack)element$iv;
                    boolean bl5 = false;
                    if (!(this.mPreviewByteBuffer != null && ((byteBuffer = this.mPreviewByteBuffer) == null ? false : byteBuffer.remaining() == rgbaLen) || (byteBuffer = (this.mPreviewByteBuffer = ByteBuffer.allocateDirect(rgbaLen))) == null)) {
                        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
                    }
                    if ((byteBuffer = this.mPreviewByteBuffer) == null) continue;
                    ByteBuffer byteBuffer2 = byteBuffer;
                    boolean bl6 = false;
                    boolean bl7 = false;
                    ByteBuffer it2 = byteBuffer2;
                    boolean bl8 = false;
                    it2.clear();
                    GLBitmapUtils.INSTANCE.readPixelToByteBuffer(id2, renderWidth, renderHeight, this.mPreviewByteBuffer);
                    callback.onPreviewData(it2.array(), renderWidth, renderHeight, IPreviewDataCallBack.DataFormat.RGBA);
                }
            }
        }
    }

    public final void startRenderScreen(int w, int h, @Nullable Surface outSurface, @Nullable CameraSurfaceTextureListener listener2) {
        SurfaceTexture surfaceTexture;
        SurfaceTexture surfaceTexture2;
        Message message;
        this.mRenderThread = new HandlerThread(RENDER_THREAD);
        HandlerThread handlerThread = this.mRenderThread;
        if (handlerThread != null) {
            handlerThread.start();
        }
        HandlerThread handlerThread2 = this.mRenderThread;
        Intrinsics.checkNotNull((Object)handlerThread2);
        this.mRenderHandler = new Handler(handlerThread2.getLooper(), (Handler.Callback)this);
        handlerThread = new Triple((Object)w, (Object)h, (Object)outSurface);
        boolean bl = false;
        boolean bl2 = false;
        HandlerThread $this$startRenderScreen_u24lambda_u2d162 = handlerThread;
        boolean bl3 = false;
        Handler handler = this.mRenderHandler;
        if (handler != null && (message = handler.obtainMessage(0, (Object)$this$startRenderScreen_u24lambda_u2d162)) != null) {
            message.sendToTarget();
        }
        try {
            surfaceTexture2 = this.getMStFuture().get(3L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            Logger.INSTANCE.e(TAG, "wait for creating camera SurfaceTexture failed");
            surfaceTexture2 = null;
        }
        handlerThread = surfaceTexture2;
        if (handlerThread == null) {
            surfaceTexture = null;
        } else {
            surfaceTexture2 = handlerThread;
            boolean bl4 = false;
            boolean $this$startRenderScreen_u24lambda_u2d162 = false;
            SurfaceTexture $this$startRenderScreen_u24lambda_u2d17 = surfaceTexture2;
            boolean bl5 = false;
            $this$startRenderScreen_u24lambda_u2d17.setDefaultBufferSize(w, h);
            $this$startRenderScreen_u24lambda_u2d17.setOnFrameAvailableListener((SurfaceTexture.OnFrameAvailableListener)this);
            this.mCameraSurfaceTexture = $this$startRenderScreen_u24lambda_u2d17;
            surfaceTexture = surfaceTexture2;
        }
        handlerThread = surfaceTexture;
        boolean bl6 = false;
        boolean bl7 = false;
        HandlerThread it = handlerThread;
        boolean bl8 = false;
        CameraSurfaceTextureListener cameraSurfaceTextureListener = listener2;
        if (cameraSurfaceTextureListener != null) {
            cameraSurfaceTextureListener.onSurfaceTextureAvailable((SurfaceTexture)it);
        }
        Logger.INSTANCE.i(TAG, Intrinsics.stringPlus((String)"create camera SurfaceTexture: ", (Object)it));
        this.setRenderSize(w, h);
    }

    public static /* synthetic */ void startRenderScreen$default(RenderManager renderManager, int n, int n2, Surface surface, CameraSurfaceTextureListener cameraSurfaceTextureListener, int n3, Object object) {
        if ((n3 & 8) != 0) {
            cameraSurfaceTextureListener = null;
        }
        renderManager.startRenderScreen(n, n2, surface, cameraSurfaceTextureListener);
    }

    public final void stopRenderScreen() {
        Message message;
        Handler handler = this.mRenderHandler;
        if (handler != null && (message = handler.obtainMessage(2)) != null) {
            message.sendToTarget();
        }
        if ((handler = this.mRenderThread) != null) {
            handler.quitSafely();
        }
        this.mRenderThread = null;
        this.mRenderHandler = null;
    }

    public final void startRenderCodec(@NotNull Surface inputSurface, int width, int height) {
        Message message;
        Intrinsics.checkNotNullParameter((Object)inputSurface, (String)"inputSurface");
        Triple triple = new Triple((Object)inputSurface, (Object)width, (Object)height);
        boolean bl = false;
        boolean bl2 = false;
        Triple $this$startRenderCodec_u24lambda_u2d19 = triple;
        boolean bl3 = false;
        Handler handler = this.mRenderHandler;
        if (handler != null && (message = handler.obtainMessage(3, (Object)$this$startRenderCodec_u24lambda_u2d19)) != null) {
            message.sendToTarget();
        }
    }

    public final void stopRenderCodec() {
        Message message;
        Handler handler = this.mRenderHandler;
        if (handler != null && (message = handler.obtainMessage(4)) != null) {
            message.sendToTarget();
        }
    }

    public final void setRenderSize(int w, int h) {
        Message message;
        Handler handler = this.mRenderHandler;
        if (handler != null && (message = handler.obtainMessage(5, (Object)new Pair((Object)w, (Object)h))) != null) {
            message.sendToTarget();
        }
    }

    public final void addRenderEffect(@Nullable AbstractEffect effect) {
        Message message;
        Handler handler = this.mRenderHandler;
        if (handler != null && (message = handler.obtainMessage(6, (Object)effect)) != null) {
            message.sendToTarget();
        }
    }

    public final void removeRenderEffect(@Nullable AbstractEffect effect) {
        Message message;
        Handler handler = this.mRenderHandler;
        if (handler != null && (message = handler.obtainMessage(7, (Object)effect)) != null) {
            message.sendToTarget();
        }
    }

    public final void setRotateType(@Nullable RotateType type) {
        Message message;
        Handler handler = this.mRenderHandler;
        if (handler != null && (message = handler.obtainMessage(9, (Object)type)) != null) {
            message.sendToTarget();
        }
    }

    @NotNull
    public final ArrayList<AbstractEffect> getCacheEffectList() {
        return this.mCacheEffectList;
    }

    public final void saveImage(@Nullable ICaptureCallBack callBack, @Nullable String path) {
        Message message;
        this.mCaptureDataCb = callBack;
        Handler handler = this.mRenderHandler;
        if (handler != null && (message = handler.obtainMessage(8, (Object)path)) != null) {
            message.sendToTarget();
        }
    }

    public void onFrameAvailable(@Nullable SurfaceTexture surfaceTexture) {
        Message message;
        this.emitFrameRate();
        Handler handler = this.mRenderHandler;
        if (handler != null && (message = handler.obtainMessage(1)) != null) {
            message.sendToTarget();
        }
    }

    private final void startRenderCodecInternal(Surface surface, int w, int h) {
        Message message;
        Message message2;
        this.stopRenderCodecInternal();
        this.mRenderCodecThread = new HandlerThread(RENDER_CODEC_THREAD);
        Object object = this.mRenderCodecThread;
        if (object != null) {
            object.start();
        }
        HandlerThread handlerThread = this.mRenderCodecThread;
        Intrinsics.checkNotNull((Object)handlerThread);
        this.mRenderCodecHandler = new Handler(handlerThread.getLooper(), arg_0 -> RenderManager.startRenderCodecInternal$lambda-23(this, arg_0));
        object = this.mScreenRender;
        object = object == null ? null : ((ScreenRender)object).getCurrentContext();
        boolean bl = false;
        boolean bl2 = false;
        Object it = object;
        boolean bl3 = false;
        if (it == null) {
            throw new NullPointerException("Current EGLContext can't be null.");
        }
        Handler handler = this.mRenderCodecHandler;
        if (handler != null && (message2 = handler.obtainMessage(17, (Object)new Pair(it, (Object)surface))) != null) {
            message2.sendToTarget();
        }
        object = this.mRenderCodecHandler;
        if (object != null && (message = object.obtainMessage(18, (Object)new Pair((Object)w, (Object)h))) != null) {
            message.sendToTarget();
        }
    }

    private final void drawFrame2Codec(int textureId, long timeStamps) {
        Message message;
        Pair pair = new Pair((Object)textureId, (Object)timeStamps);
        boolean bl = false;
        boolean bl2 = false;
        Pair $this$drawFrame2Codec_u24lambda_u2d25 = pair;
        boolean bl3 = false;
        Handler handler = this.mRenderCodecHandler;
        if (handler != null && (message = handler.obtainMessage(19, (Object)$this$drawFrame2Codec_u24lambda_u2d25)) != null) {
            message.sendToTarget();
        }
    }

    private final void stopRenderCodecInternal() {
        Message message;
        Handler handler = this.mRenderCodecHandler;
        if (handler != null && (message = handler.obtainMessage(20)) != null) {
            message.sendToTarget();
        }
        if ((handler = this.mRenderCodecThread) != null) {
            handler.quitSafely();
        }
        this.mRenderCodecThread = null;
        this.mRenderCodecHandler = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void saveImageInternal(String savePath) {
        if (this.getMCaptureState().get()) {
            return;
        }
        this.getMCaptureState().set(true);
        this.getMMainHandler().post(() -> RenderManager.saveImageInternal$lambda-26(this));
        String date = this.getMDateFormat().format(System.currentTimeMillis());
        String title = Intrinsics.stringPlus((String)"IMG_", (Object)date);
        String displayName = Intrinsics.stringPlus((String)title, (Object)".jpg");
        int width = this.mWidth;
        int height = this.mHeight;
        ContentValues values = new ContentValues();
        values.put("title", title);
        values.put("_display_name", displayName);
        String string = savePath;
        values.put("relative_path", string == null ? this.mRelativePath : string);
        values.put("datetaken", date);
        values.put("width", Integer.valueOf(width));
        values.put("height", Integer.valueOf(height));
        ContentResolver resolver = this.mContext.getContentResolver();
        Uri imageUri = resolver.insert(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, values);
        if (imageUri == null) {
            this.getMMainHandler().post(() -> RenderManager.saveImageInternal$lambda-30(this));
            return;
        }
        Object object = this.mContext.getContentResolver();
        OutputStream fos = object == null ? null : object.openOutputStream(imageUri);
        try {
            object = GLBitmapUtils.INSTANCE.transFrameBufferToBitmap(this.mFBOBufferId, width, height);
            boolean bl = false;
            boolean bl2 = false;
            ContentResolver $this$saveImageInternal_u24lambda_u2d27 = object;
            boolean bl3 = false;
            OutputStream outputStream = fos;
            Intrinsics.checkNotNull((Object)outputStream);
            $this$saveImageInternal_u24lambda_u2d27.compress(Bitmap.CompressFormat.JPEG, 100, outputStream);
            $this$saveImageInternal_u24lambda_u2d27.recycle();
            try {
                object = fos;
                ((OutputStream)object).close();
            }
            catch (IOException e) {
                Logger.INSTANCE.e(TAG, Intrinsics.stringPlus((String)"Failed to write file, err = ", (Object)e.getLocalizedMessage()), e);
            }
        }
        catch (IOException e) {
            this.getMMainHandler().post(() -> RenderManager.saveImageInternal$lambda-28(this, e));
            Logger.INSTANCE.e(TAG, Intrinsics.stringPlus((String)"Failed to write file, err = ", (Object)e.getLocalizedMessage()), e);
        }
        finally {
            try {
                OutputStream e = fos;
                if (e != null) {
                    e.close();
                }
            }
            catch (IOException e) {
                Logger.INSTANCE.e(TAG, Intrinsics.stringPlus((String)"Failed to write file, err = ", (Object)e.getLocalizedMessage()), e);
            }
        }
        String path = ImageUtils.getImageAbsolutePath(this.mContext, imageUri);
        File file = new File(path);
        if (file.length() == 0L) {
            Logger.INSTANCE.e(TAG, Intrinsics.stringPlus((String)"Failed to save file ", (Object)path));
            file.delete();
            this.getMCaptureState().set(false);
            return;
        }
        this.getMMainHandler().post(() -> RenderManager.saveImageInternal$lambda-29(this, path));
        this.getMCaptureState().set(false);
        if (!Utils.INSTANCE.getDebugCamera()) return;
        Logger.INSTANCE.i(TAG, Intrinsics.stringPlus((String)"captureImageInternal save path = ", (Object)path));
    }

    private final void emitFrameRate() {
        RenderManager renderManager = this;
        int n = renderManager.mFrameRate;
        renderManager.mFrameRate = n + 1;
        this.mEndTime = System.currentTimeMillis();
        if (this.mEndTime - this.mStartTime >= 1000L) {
            if (Utils.INSTANCE.getDebugCamera()) {
                Logger.INSTANCE.i(TAG, "camera render frame rate is " + this.mFrameRate + " fps-->" + Thread.currentThread().getName());
            }
            EventBus.INSTANCE.with("frame-rate").postMessage(this.mFrameRate);
            this.mStartTime = this.mEndTime;
            this.mFrameRate = 0;
        }
    }

    private static final boolean startRenderCodecInternal$lambda-23(RenderManager this$0, Message message) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        int n = message.what;
        switch (n) {
            case 17: {
                Object object = message.obj;
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Pair<*, *>");
                }
                object = (Pair)object;
                boolean bl = false;
                boolean bl2 = false;
                Object $this$startRenderCodecInternal_u24lambda_u2d23_u24lambda_u2d20 = object;
                boolean bl3 = false;
                Object object2 = $this$startRenderCodecInternal_u24lambda_u2d23_u24lambda_u2d20.getFirst();
                if (object2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type android.opengl.EGLContext");
                }
                EGLContext shareContext = (EGLContext)object2;
                Object object3 = $this$startRenderCodecInternal_u24lambda_u2d23_u24lambda_u2d20.getSecond();
                if (object3 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type android.view.Surface");
                }
                Surface inputSurface = (Surface)object3;
                this$0.mEncodeRender = new EncodeRender(this$0.mContext);
                object3 = this$0.mEncodeRender;
                if (object3 != null) {
                    ((EncodeRender)object3).initEGLEvn(shareContext);
                }
                object3 = this$0.mEncodeRender;
                if (object3 != null) {
                    ((EncodeRender)object3).setupSurface(inputSurface);
                }
                object3 = this$0.mEncodeRender;
                if (object3 == null) break;
                ((AbstractRender)object3).initGLES();
                break;
            }
            case 18: {
                Object object = message.obj;
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Pair<*, *>");
                }
                object = (Pair)object;
                boolean bl = false;
                boolean bl4 = false;
                Object $this$startRenderCodecInternal_u24lambda_u2d23_u24lambda_u2d21 = object;
                boolean bl5 = false;
                Object inputSurface = $this$startRenderCodecInternal_u24lambda_u2d23_u24lambda_u2d21.getFirst();
                if (inputSurface == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                }
                int width = (Integer)inputSurface;
                Object object4 = $this$startRenderCodecInternal_u24lambda_u2d23_u24lambda_u2d21.getSecond();
                if (object4 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                }
                int height = (Integer)object4;
                object4 = this$0.mEncodeRender;
                if (object4 == null) break;
                ((AbstractRender)object4).setSize(width, height);
                break;
            }
            case 19: {
                Object object = message.obj;
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Pair<*, *>");
                }
                object = (Pair)object;
                boolean bl = false;
                boolean bl6 = false;
                Object $this$startRenderCodecInternal_u24lambda_u2d23_u24lambda_u2d22 = object;
                boolean bl7 = false;
                Object object5 = $this$startRenderCodecInternal_u24lambda_u2d23_u24lambda_u2d22.getFirst();
                if (object5 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                }
                int textureId = (Integer)object5;
                Object object6 = $this$startRenderCodecInternal_u24lambda_u2d23_u24lambda_u2d22.getSecond();
                if (object6 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Long");
                }
                long timeStamps = (Long)object6;
                object6 = this$0.mEncodeRender;
                if (object6 != null) {
                    ((AbstractRender)object6).drawFrame(textureId);
                }
                object6 = this$0.mEncodeRender;
                if (object6 == null) break;
                ((EncodeRender)object6).swapBuffers(timeStamps);
                break;
            }
            case 20: {
                EncodeRender encodeRender = this$0.mEncodeRender;
                if (encodeRender != null) {
                    encodeRender.releaseGLES();
                }
                this$0.mEncodeRender = null;
            }
        }
        return true;
    }

    private static final void saveImageInternal$lambda-26(RenderManager this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        ICaptureCallBack iCaptureCallBack = this$0.mCaptureDataCb;
        if (iCaptureCallBack != null) {
            iCaptureCallBack.onBegin();
        }
    }

    private static final void saveImageInternal$lambda-28(RenderManager this$0, IOException $e) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$e, (String)"$e");
        ICaptureCallBack iCaptureCallBack = this$0.mCaptureDataCb;
        if (iCaptureCallBack != null) {
            iCaptureCallBack.onError($e.getLocalizedMessage());
        }
    }

    private static final void saveImageInternal$lambda-29(RenderManager this$0, String $path) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        ICaptureCallBack iCaptureCallBack = this$0.mCaptureDataCb;
        if (iCaptureCallBack != null) {
            iCaptureCallBack.onComplete($path);
        }
    }

    private static final void saveImageInternal$lambda-30(RenderManager this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        ICaptureCallBack iCaptureCallBack = this$0.mCaptureDataCb;
        if (iCaptureCallBack != null) {
            iCaptureCallBack.onError("Failed to save image");
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0012\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H&\u00a8\u0006\u0006"}, d2={"Lcom/jiangdg/ausbc/render/RenderManager$CameraSurfaceTextureListener;", "", "onSurfaceTextureAvailable", "", "surfaceTexture", "Landroid/graphics/SurfaceTexture;", "libausbc_release"})
    public static interface CameraSurfaceTextureListener {
        public void onSurfaceTextureAvailable(@Nullable SurfaceTexture var1);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000e\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0013X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0013X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/jiangdg/ausbc/render/RenderManager$Companion;", "", "()V", "MSG_GL_ADD_EFFECT", "", "MSG_GL_CHANGED_SIZE", "MSG_GL_DRAW", "MSG_GL_INIT", "MSG_GL_RELEASE", "MSG_GL_REMOVE_EFFECT", "MSG_GL_RENDER_CODEC_CHANGED_SIZE", "MSG_GL_RENDER_CODEC_DRAW", "MSG_GL_RENDER_CODEC_INIT", "MSG_GL_RENDER_CODEC_RELEASE", "MSG_GL_ROUTE_ANGLE", "MSG_GL_SAVE_IMAGE", "MSG_GL_START_RENDER_CODEC", "MSG_GL_STOP_RENDER_CODEC", "RENDER_CODEC_THREAD", "", "RENDER_THREAD", "TAG", "libausbc_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

