/*
 * Decompiled with CFR 0.152.
 */
package com.jiangdg.ausbc;

import android.content.Context;
import android.graphics.SurfaceTexture;
import android.os.Handler;
import android.os.Looper;
import android.view.Surface;
import androidx.annotation.MainThread;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleEventObserver;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.LifecycleOwner;
import com.jiangdg.ausbc.CameraClient;
import com.jiangdg.ausbc.callback.ICaptureCallBack;
import com.jiangdg.ausbc.callback.IEncodeDataCallBack;
import com.jiangdg.ausbc.callback.IPlayCallBack;
import com.jiangdg.ausbc.callback.IPreviewDataCallBack;
import com.jiangdg.ausbc.camera.CameraUvcStrategy;
import com.jiangdg.ausbc.camera.ICameraStrategy;
import com.jiangdg.ausbc.camera.bean.CameraRequest;
import com.jiangdg.ausbc.camera.bean.CameraStatus;
import com.jiangdg.ausbc.camera.bean.PreviewSize;
import com.jiangdg.ausbc.encode.AACEncodeProcessor;
import com.jiangdg.ausbc.encode.AbstractProcessor;
import com.jiangdg.ausbc.encode.H264EncodeProcessor;
import com.jiangdg.ausbc.encode.audio.AudioStrategySystem;
import com.jiangdg.ausbc.encode.bean.RawData;
import com.jiangdg.ausbc.encode.muxer.Mp4Muxer;
import com.jiangdg.ausbc.render.RenderManager;
import com.jiangdg.ausbc.render.effect.AbstractEffect;
import com.jiangdg.ausbc.render.env.RotateType;
import com.jiangdg.ausbc.utils.CameraUtils;
import com.jiangdg.ausbc.utils.Logger;
import com.jiangdg.ausbc.utils.Utils;
import com.jiangdg.ausbc.utils.bus.EventBus;
import com.jiangdg.ausbc.widget.AspectRatioSurfaceView;
import com.jiangdg.ausbc.widget.AspectRatioTextureView;
import com.jiangdg.ausbc.widget.IAspectRatio;
import com.jiangdg.usb.USBMonitor;
import com.jiangdg.uvc.UVCCamera;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Deprecated(message="Deprecated since version 3.3.0")
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u00ae\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0007\u0018\u0000 d2\u00020\u0001:\u0002cdB\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$J\u0010\u0010%\u001a\u00020\"2\u0006\u0010&\u001a\u00020\u000eH\u0002J\u000e\u0010'\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0001J\u000e\u0010(\u001a\u00020\"2\u0006\u0010)\u001a\u00020\u0010J\u001a\u0010*\u001a\u00020\"2\u0006\u0010#\u001a\u00020+2\n\b\u0002\u0010,\u001a\u0004\u0018\u00010-J\u0006\u0010.\u001a\u00020\"J\u001a\u0010/\u001a\u00020\"2\u0006\u0010#\u001a\u00020+2\n\b\u0002\u00100\u001a\u0004\u0018\u00010-J$\u00101\u001a\u00020\"2\u0006\u0010#\u001a\u00020+2\n\b\u0002\u00100\u001a\u0004\u0018\u00010-2\b\b\u0002\u00102\u001a\u000203J\u0006\u00104\u001a\u00020\"J\u0006\u00105\u001a\u00020\"J\u001f\u00106\u001a\n\u0012\u0004\u0012\u000208\u0018\u0001072\n\b\u0002\u00109\u001a\u0004\u0018\u00010:\u00a2\u0006\u0002\u0010;J\b\u0010<\u001a\u0004\u0018\u00010\u001eJ\b\u0010=\u001a\u0004\u0018\u00010\nJ\b\u0010>\u001a\u0004\u0018\u00010\u0010J\u001a\u0010?\u001a\u0004\u0018\u0001082\u0006\u0010@\u001a\u00020A2\u0006\u0010B\u001a\u00020AH\u0002J\b\u0010C\u001a\u00020\"H\u0002J\r\u0010D\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010EJ*\u0010F\u001a\u00020\"2\b\u0010G\u001a\u0004\u0018\u00010H2\u0006\u0010I\u001a\u00020A2\u0006\u0010J\u001a\u00020A2\u0006\u0010K\u001a\u00020LH\u0016J\u001a\u0010M\u001a\u00020\"2\b\u0010N\u001a\u0004\u0018\u00010\f2\b\b\u0002\u0010O\u001a\u00020\u0006J\b\u0010P\u001a\u00020\"H\u0002J\u000e\u0010Q\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0001J\u000e\u0010R\u001a\u00020\"2\u0006\u0010)\u001a\u00020\u0010J\u0015\u0010S\u001a\u0004\u0018\u00010A2\u0006\u0010T\u001a\u00020A\u00a2\u0006\u0002\u0010UJ\u0016\u0010V\u001a\u00020\"2\u0006\u0010I\u001a\u00020A2\u0006\u0010J\u001a\u00020AJ\u0010\u0010W\u001a\u00020\"2\b\u0010X\u001a\u0004\u0018\u00010\u0012J\u0010\u0010Y\u001a\u00020\"2\b\u0010#\u001a\u0004\u0018\u00010ZJ\u0006\u0010[\u001a\u00020\"J\u0006\u0010\\\u001a\u00020\"J\u0006\u0010]\u001a\u00020\"J\u0012\u0010^\u001a\u00020\"2\n\b\u0002\u0010_\u001a\u0004\u0018\u00010-J\u0018\u0010`\u001a\u00020\"2\u0006\u0010a\u001a\u00020A2\b\u0010)\u001a\u0004\u0018\u00010\u0010J\u0018\u0010b\u001a\u00020\u00062\u0006\u0010I\u001a\u00020A2\u0006\u0010J\u001a\u00020AH\u0007R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0017\u001a\u0004\u0018\u00010\u00188BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001b\u0010\u001c\u001a\u0004\b\u0019\u0010\u001aR\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001f\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006e"}, d2={"Lcom/jiangdg/ausbc/CameraClient;", "Lcom/jiangdg/ausbc/callback/IPreviewDataCallBack;", "builder", "Lcom/jiangdg/ausbc/CameraClient$Builder;", "(Lcom/jiangdg/ausbc/CameraClient$Builder;)V", "isEnableGLEs", "", "mAudioProcess", "Lcom/jiangdg/ausbc/encode/AbstractProcessor;", "mCamera", "Lcom/jiangdg/ausbc/camera/ICameraStrategy;", "mCameraView", "Lcom/jiangdg/ausbc/widget/IAspectRatio;", "mCtx", "Landroid/content/Context;", "mDefaultEffect", "Lcom/jiangdg/ausbc/render/effect/AbstractEffect;", "mDefaultRotateType", "Lcom/jiangdg/ausbc/render/env/RotateType;", "mMainHandler", "Landroid/os/Handler;", "mMediaMuxer", "Lcom/jiangdg/ausbc/encode/muxer/Mp4Muxer;", "mRenderManager", "Lcom/jiangdg/ausbc/render/RenderManager;", "getMRenderManager", "()Lcom/jiangdg/ausbc/render/RenderManager;", "mRenderManager$delegate", "Lkotlin/Lazy;", "mRequest", "Lcom/jiangdg/ausbc/camera/bean/CameraRequest;", "mVideoProcess", "rawImage", "addEncodeDataCallBack", "", "callBack", "Lcom/jiangdg/ausbc/callback/IEncodeDataCallBack;", "addLifecycleObserver", "context", "addPreviewDataCallBack", "addRenderEffect", "effect", "captureAudioStart", "Lcom/jiangdg/ausbc/callback/ICaptureCallBack;", "mp3Path", "", "captureAudioStop", "captureImage", "path", "captureVideoStart", "durationInSec", "", "captureVideoStop", "closeCamera", "getAllPreviewSizes", "", "Lcom/jiangdg/ausbc/camera/bean/PreviewSize;", "aspectRatio", "", "(Ljava/lang/Double;)Ljava/util/List;", "getCameraRequest", "getCameraStrategy", "getDefaultEffect", "getSuitableSize", "maxWidth", "", "maxHeight", "initEncodeProcessor", "isCameraOpened", "()Ljava/lang/Boolean;", "onPreviewData", "data", "", "width", "height", "format", "Lcom/jiangdg/ausbc/callback/IPreviewDataCallBack$DataFormat;", "openCamera", "cameraView", "isReboot", "releaseEncodeProcessor", "removePreviewDataCallBack", "removeRenderEffect", "sendCameraCommand", "command", "(I)Ljava/lang/Integer;", "setRenderSize", "setRotateType", "type", "startPlayMic", "Lcom/jiangdg/ausbc/callback/IPlayCallBack;", "startPush", "stopPlayMic", "stopPush", "switchCamera", "cameraId", "updateRenderEffect", "classifyId", "updateResolution", "Builder", "Companion", "libausbc_release"})
public final class CameraClient
implements IPreviewDataCallBack {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final Context mCtx;
    private final boolean isEnableGLEs;
    private final boolean rawImage;
    @Nullable
    private final ICameraStrategy mCamera;
    @Nullable
    private IAspectRatio mCameraView;
    @Nullable
    private CameraRequest mRequest;
    @Nullable
    private AbstractEffect mDefaultEffect;
    @Nullable
    private final RotateType mDefaultRotateType;
    @Nullable
    private AbstractProcessor mAudioProcess;
    @Nullable
    private AbstractProcessor mVideoProcess;
    @Nullable
    private Mp4Muxer mMediaMuxer;
    @NotNull
    private final Handler mMainHandler;
    @NotNull
    private final Lazy mRenderManager$delegate;
    @NotNull
    private static final String TAG = "CameraClient";

    public CameraClient(@NotNull Builder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        this.mCtx = builder.getContext$libausbc_release();
        this.isEnableGLEs = builder.getEnableGLEs$libausbc_release();
        this.rawImage = builder.getRawImage$libausbc_release();
        this.mCamera = builder.getCamera$libausbc_release();
        this.mRequest = builder.getCameraRequest$libausbc_release();
        this.mDefaultEffect = builder.getDefaultEffect$libausbc_release();
        this.mDefaultRotateType = builder.getDefaultRotateType$libausbc_release();
        this.mMainHandler = new Handler(Looper.getMainLooper());
        this.mRenderManager$delegate = LazyKt.lazy((Function0)((Function0)new Function0<RenderManager>(this){
            final /* synthetic */ CameraClient this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final RenderManager invoke() {
                Context context = CameraClient.access$getMCtx$p(this.this$0);
                Intrinsics.checkNotNull((Object)context);
                CameraRequest cameraRequest = CameraClient.access$getMRequest$p(this.this$0);
                Intrinsics.checkNotNull((Object)cameraRequest);
                int n = cameraRequest.getPreviewWidth();
                CameraRequest cameraRequest2 = CameraClient.access$getMRequest$p(this.this$0);
                Intrinsics.checkNotNull((Object)cameraRequest2);
                return new RenderManager(context, n, cameraRequest2.getPreviewHeight(), null);
            }
        }));
        CameraRequest cameraRequest = this.mRequest;
        this.mRequest = cameraRequest == null ? new CameraRequest.Builder().create() : cameraRequest;
        cameraRequest = this.mCtx;
        if (cameraRequest != null) {
            CameraRequest cameraRequest2 = cameraRequest;
            boolean bl = false;
            boolean bl2 = false;
            CameraRequest context = cameraRequest2;
            boolean bl3 = false;
            if (!(context instanceof LifecycleOwner)) {
                throw new IllegalArgumentException("context should be subclass of LifecycleOwner!");
            }
            this.addLifecycleObserver((Context)context);
            EventBus.INSTANCE.with("camera-status").observe((LifecycleOwner)context, arg_0 -> CameraClient.lambda-4$lambda-3(this, arg_0));
        }
        if (Utils.INSTANCE.getDebugCamera()) {
            Logger.INSTANCE.i(TAG, Intrinsics.stringPlus((String)"init camera client, camera = ", (Object)this.mCamera));
        }
    }

    private final RenderManager getMRenderManager() {
        Lazy lazy = this.mRenderManager$delegate;
        boolean bl = false;
        return (RenderManager)lazy.getValue();
    }

    @Override
    public void onPreviewData(@Nullable byte[] data, int width, int height, @NotNull IPreviewDataCallBack.DataFormat format) {
        Intrinsics.checkNotNullParameter((Object)((Object)format), (String)"format");
        byte[] byArray = data;
        if (byArray != null) {
            byte[] byArray2 = byArray;
            boolean bl = false;
            boolean bl2 = false;
            byte[] it = byArray2;
            boolean bl3 = false;
            if (data.length != width * height * 3 / 2) {
                return;
            }
            AbstractProcessor abstractProcessor = this.mVideoProcess;
            if (abstractProcessor != null) {
                abstractProcessor.putRawData(new RawData(it, it.length));
            }
        }
    }

    public final void openCamera(@Nullable IAspectRatio cameraView, boolean isReboot) {
        IAspectRatio iAspectRatio;
        if (this.mCtx != null && Utils.INSTANCE.isTargetSdkOverP(this.mCtx) && !CameraUtils.INSTANCE.hasCameraPermission(this.mCtx)) {
            Logger.INSTANCE.e(TAG, "open camera failed, need Manifest.permission.CAMERA permission");
            return;
        }
        this.initEncodeProcessor();
        Logger.INSTANCE.i(TAG, "start open camera request = " + this.mRequest + ", gl = " + this.isEnableGLEs);
        CameraRequest cameraRequest = this.mRequest;
        Intrinsics.checkNotNull((Object)cameraRequest);
        int previewWidth = cameraRequest.getPreviewWidth();
        CameraRequest cameraRequest2 = this.mRequest;
        Intrinsics.checkNotNull((Object)cameraRequest2);
        int previewHeight = cameraRequest2.getPreviewHeight();
        IAspectRatio iAspectRatio2 = cameraView;
        if (iAspectRatio2 instanceof AspectRatioSurfaceView) {
            if (!this.isEnableGLEs) {
                ((AspectRatioSurfaceView)cameraView).postUITask((Function0<Unit>)((Function0)new Function0<Unit>(this, cameraView){
                    final /* synthetic */ CameraClient this$0;
                    final /* synthetic */ IAspectRatio $cameraView;
                    {
                        this.this$0 = $receiver;
                        this.$cameraView = $cameraView;
                        super(0);
                    }

                    public final void invoke() {
                        ICameraStrategy iCameraStrategy = CameraClient.access$getMCamera$p(this.this$0);
                        if (iCameraStrategy != null) {
                            CameraRequest cameraRequest = CameraClient.access$getMRequest$p(this.this$0);
                            Intrinsics.checkNotNull((Object)cameraRequest);
                            iCameraStrategy.startPreview(cameraRequest, ((AspectRatioSurfaceView)this.$cameraView).getHolder());
                        }
                        iCameraStrategy = CameraClient.access$getMCamera$p(this.this$0);
                        if (iCameraStrategy != null) {
                            iCameraStrategy.addPreviewDataCallBack(this.this$0);
                        }
                    }
                }));
            }
            ((AspectRatioSurfaceView)cameraView).setAspectRatio(previewWidth, previewHeight);
            iAspectRatio = cameraView;
        } else if (iAspectRatio2 instanceof AspectRatioTextureView) {
            if (!this.isEnableGLEs) {
                ((AspectRatioTextureView)cameraView).postUITask((Function0<Unit>)((Function0)new Function0<Unit>(this, cameraView){
                    final /* synthetic */ CameraClient this$0;
                    final /* synthetic */ IAspectRatio $cameraView;
                    {
                        this.this$0 = $receiver;
                        this.$cameraView = $cameraView;
                        super(0);
                    }

                    public final void invoke() {
                        ICameraStrategy iCameraStrategy = CameraClient.access$getMCamera$p(this.this$0);
                        if (iCameraStrategy != null) {
                            CameraRequest cameraRequest = CameraClient.access$getMRequest$p(this.this$0);
                            Intrinsics.checkNotNull((Object)cameraRequest);
                            iCameraStrategy.startPreview(cameraRequest, ((AspectRatioTextureView)this.$cameraView).getSurfaceTexture());
                        }
                        iCameraStrategy = CameraClient.access$getMCamera$p(this.this$0);
                        if (iCameraStrategy != null) {
                            iCameraStrategy.addPreviewDataCallBack(this.this$0);
                        }
                    }
                }));
            }
            ((AspectRatioTextureView)cameraView).setAspectRatio(previewWidth, previewHeight);
            iAspectRatio = cameraView;
        } else {
            iAspectRatio = cameraView;
        }
        iAspectRatio2 = iAspectRatio;
        boolean bl = false;
        boolean bl2 = false;
        IAspectRatio view = iAspectRatio2;
        boolean bl3 = false;
        IAspectRatio iAspectRatio3 = view;
        IAspectRatio iAspectRatio4 = this.mCameraView = iAspectRatio3 == null ? this.mCameraView : iAspectRatio3;
        if (!this.isEnableGLEs) {
            return;
        }
        iAspectRatio3 = view;
        boolean bl4 = false;
        boolean bl5 = false;
        IAspectRatio $this$openCamera_u24lambda_u2d8_u24lambda_u2d7 = iAspectRatio3;
        boolean bl6 = false;
        RenderManager.CameraSurfaceTextureListener listener2 = new RenderManager.CameraSurfaceTextureListener(this){
            final /* synthetic */ CameraClient this$0;
            {
                this.this$0 = $receiver;
            }

            public void onSurfaceTextureAvailable(@Nullable SurfaceTexture surfaceTexture) {
                SurfaceTexture surfaceTexture2 = surfaceTexture;
                if (surfaceTexture2 != null) {
                    SurfaceTexture surfaceTexture3 = surfaceTexture2;
                    CameraClient cameraClient = this.this$0;
                    boolean bl = false;
                    boolean bl2 = false;
                    SurfaceTexture it = surfaceTexture3;
                    boolean bl3 = false;
                    ICameraStrategy iCameraStrategy = CameraClient.access$getMCamera$p(cameraClient);
                    if (iCameraStrategy != null) {
                        CameraRequest cameraRequest = CameraClient.access$getMRequest$p(cameraClient);
                        Intrinsics.checkNotNull((Object)cameraRequest);
                        iCameraStrategy.startPreview(cameraRequest, it);
                    }
                    iCameraStrategy = CameraClient.access$getMCamera$p(cameraClient);
                    if (iCameraStrategy != null) {
                        iCameraStrategy.addPreviewDataCallBack(cameraClient);
                    }
                }
            }
        };
        if ($this$openCamera_u24lambda_u2d8_u24lambda_u2d7 == null) {
            Logger.INSTANCE.i(TAG, "Offscreen render, width=" + previewWidth + ", height=" + previewHeight);
            RenderManager renderManager = this.getMRenderManager();
            if (renderManager != null) {
                renderManager.startRenderScreen(previewWidth, previewHeight, null, listener2);
            }
            if (isReboot) {
                ArrayList<AbstractEffect> arrayList;
                renderManager = this.getMRenderManager();
                if (renderManager != null && (arrayList = renderManager.getCacheEffectList()) != null) {
                    Iterable $this$forEach$iv = arrayList;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        AbstractEffect effect = (AbstractEffect)element$iv;
                        boolean bl7 = false;
                        RenderManager renderManager2 = this.getMRenderManager();
                        if (renderManager2 == null) continue;
                        renderManager2.addRenderEffect(effect);
                    }
                }
            } else {
                renderManager = this.getMRenderManager();
                if (renderManager != null) {
                    renderManager.addRenderEffect(this.mDefaultEffect);
                }
            }
        } else {
            $this$openCamera_u24lambda_u2d8_u24lambda_u2d7.postUITask((Function0<Unit>)((Function0)new Function0<Unit>($this$openCamera_u24lambda_u2d8_u24lambda_u2d7, this, listener2, isReboot){
                final /* synthetic */ IAspectRatio $this_apply;
                final /* synthetic */ CameraClient this$0;
                final /* synthetic */ openCamera.3.1.listener.1 $listener;
                final /* synthetic */ boolean $isReboot;
                {
                    this.$this_apply = $receiver;
                    this.this$0 = $receiver2;
                    this.$listener = $listener;
                    this.$isReboot = $isReboot;
                    super(0);
                }

                /*
                 * WARNING - void declaration
                 */
                public final void invoke() {
                    int surfaceWidth = this.$this_apply.getSurfaceWidth();
                    int surfaceHeight = this.$this_apply.getSurfaceHeight();
                    Surface surface = this.$this_apply.getSurface();
                    RenderManager renderManager = CameraClient.access$getMRenderManager(this.this$0);
                    if (renderManager != null) {
                        renderManager.startRenderScreen(surfaceWidth, surfaceHeight, surface, this.$listener);
                    }
                    renderManager = CameraClient.access$getMRenderManager(this.this$0);
                    if (renderManager != null) {
                        renderManager.setRotateType(CameraClient.access$getMDefaultRotateType$p(this.this$0));
                    }
                    if (this.$isReboot) {
                        ArrayList<AbstractEffect> arrayList;
                        renderManager = CameraClient.access$getMRenderManager(this.this$0);
                        if (renderManager != null && (arrayList = renderManager.getCacheEffectList()) != null) {
                            void $this$forEach$iv;
                            Iterable iterable = arrayList;
                            CameraClient cameraClient = this.this$0;
                            boolean $i$f$forEach = false;
                            for (T element$iv : $this$forEach$iv) {
                                AbstractEffect effect = (AbstractEffect)element$iv;
                                boolean bl = false;
                                RenderManager renderManager2 = CameraClient.access$getMRenderManager(cameraClient);
                                if (renderManager2 == null) continue;
                                renderManager2.addRenderEffect(effect);
                            }
                        }
                        return;
                    }
                    renderManager = CameraClient.access$getMRenderManager(this.this$0);
                    if (renderManager != null) {
                        renderManager.addRenderEffect(CameraClient.access$getMDefaultEffect$p(this.this$0));
                    }
                    Logger.INSTANCE.i("CameraClient", "Display render, width=" + surfaceWidth + ", height=" + surfaceHeight);
                }
            }));
        }
    }

    public static /* synthetic */ void openCamera$default(CameraClient cameraClient, IAspectRatio iAspectRatio, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        cameraClient.openCamera(iAspectRatio, bl);
    }

    public final void closeCamera() {
        Object object;
        if (Utils.INSTANCE.getDebugCamera()) {
            Logger.INSTANCE.i(TAG, "closeCamera...");
        }
        this.releaseEncodeProcessor();
        if (this.isEnableGLEs && (object = this.getMRenderManager()) != null) {
            ((RenderManager)object).stopRenderScreen();
        }
        if ((object = this.mCamera) != null) {
            ((ICameraStrategy)object).stopPreview();
        }
    }

    public final void setRotateType(@Nullable RotateType type) {
        RenderManager renderManager = this.getMRenderManager();
        if (renderManager != null) {
            renderManager.setRotateType(type);
        }
    }

    public final void setRenderSize(int width, int height) {
        RenderManager renderManager = this.getMRenderManager();
        if (renderManager != null) {
            renderManager.setRenderSize(width, height);
        }
    }

    public final void addRenderEffect(@NotNull AbstractEffect effect) {
        Intrinsics.checkNotNullParameter((Object)effect, (String)"effect");
        RenderManager renderManager = this.getMRenderManager();
        if (renderManager != null) {
            renderManager.addRenderEffect(effect);
        }
    }

    public final void removeRenderEffect(@NotNull AbstractEffect effect) {
        Intrinsics.checkNotNullParameter((Object)effect, (String)"effect");
        RenderManager renderManager = this.getMRenderManager();
        if (renderManager != null) {
            renderManager.removeRenderEffect(effect);
        }
    }

    public final void updateRenderEffect(int classifyId, @Nullable AbstractEffect effect) {
        ArrayList<AbstractEffect> arrayList;
        Object object = this.getMRenderManager();
        if (object != null && (arrayList = ((RenderManager)object).getCacheEffectList()) != null) {
            Object v0;
            boolean bl;
            Object object2;
            block4: {
                object2 = arrayList;
                bl = false;
                Iterable iterable = object2;
                boolean bl2 = false;
                for (Object t : iterable) {
                    AbstractEffect it = (AbstractEffect)t;
                    boolean bl3 = false;
                    if (!(it.getClassifyId() == classifyId)) continue;
                    v0 = t;
                    break block4;
                }
                v0 = null;
            }
            AbstractEffect abstractEffect = v0;
            if (abstractEffect != null) {
                object2 = abstractEffect;
                bl = false;
                boolean bl4 = false;
                Object it = object2;
                boolean bl5 = false;
                this.removeRenderEffect((AbstractEffect)it);
            }
        }
        if ((object = effect) == null) {
            return;
        }
        this.addRenderEffect(effect);
    }

    public final void switchCamera(@Nullable String cameraId) {
        ICameraStrategy iCameraStrategy;
        if (Utils.INSTANCE.getDebugCamera()) {
            Logger.INSTANCE.i(TAG, Intrinsics.stringPlus((String)"switchCamera, id = ", (Object)cameraId));
        }
        if ((iCameraStrategy = this.mCamera) != null) {
            iCameraStrategy.switchCamera(cameraId);
        }
    }

    public static /* synthetic */ void switchCamera$default(CameraClient cameraClient, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        cameraClient.switchCamera(string);
    }

    public final void captureImage(@NotNull ICaptureCallBack callBack, @Nullable String path) {
        Intrinsics.checkNotNullParameter((Object)callBack, (String)"callBack");
        if (Utils.INSTANCE.getDebugCamera()) {
            Logger.INSTANCE.i(TAG, "captureImage...");
        }
        if (this.isEnableGLEs && !this.rawImage) {
            RenderManager renderManager = this.getMRenderManager();
            if (renderManager != null) {
                renderManager.saveImage(callBack, path);
            }
            return;
        }
        ICameraStrategy iCameraStrategy = this.mCamera;
        if (iCameraStrategy != null) {
            iCameraStrategy.captureImage(callBack, path);
        }
    }

    public static /* synthetic */ void captureImage$default(CameraClient cameraClient, ICaptureCallBack iCaptureCallBack, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = null;
        }
        cameraClient.captureImage(iCaptureCallBack, string);
    }

    @Nullable
    public final Boolean isCameraOpened() {
        ICameraStrategy iCameraStrategy = this.mCamera;
        return iCameraStrategy == null ? null : Boolean.valueOf(iCameraStrategy.isCameraOpened());
    }

    public final void startPlayMic(@Nullable IPlayCallBack callBack) {
        AACEncodeProcessor aACEncodeProcessor;
        AbstractProcessor abstractProcessor = this.mAudioProcess;
        AACEncodeProcessor aACEncodeProcessor2 = aACEncodeProcessor = abstractProcessor instanceof AACEncodeProcessor ? (AACEncodeProcessor)abstractProcessor : null;
        if (aACEncodeProcessor != null) {
            aACEncodeProcessor.playAudioStart(callBack);
        }
    }

    public final void stopPlayMic() {
        AACEncodeProcessor aACEncodeProcessor;
        AbstractProcessor abstractProcessor = this.mAudioProcess;
        AACEncodeProcessor aACEncodeProcessor2 = aACEncodeProcessor = abstractProcessor instanceof AACEncodeProcessor ? (AACEncodeProcessor)abstractProcessor : null;
        if (aACEncodeProcessor != null) {
            aACEncodeProcessor.playAudioStop();
        }
    }

    public final void startPush() {
        AbstractProcessor abstractProcessor = this.mVideoProcess;
        if (abstractProcessor != null) {
            abstractProcessor.startEncode();
        }
        abstractProcessor = this.mAudioProcess;
        if (abstractProcessor != null) {
            abstractProcessor.startEncode();
        }
    }

    public final void captureAudioStart(@NotNull ICaptureCallBack callBack, @Nullable String mp3Path) {
        File file;
        Intrinsics.checkNotNullParameter((Object)callBack, (String)"callBack");
        Object object = mp3Path;
        boolean bl = false;
        boolean bl2 = false;
        String path = object == null || object.length() == 0 ? ((object = this.mCtx) == null ? null : ((file = object.getExternalFilesDir(null)) == null ? null : file.getPath())) + '/' + System.currentTimeMillis() + ".mp3" : mp3Path;
        AbstractProcessor abstractProcessor = this.mAudioProcess;
        Object object2 = object = abstractProcessor instanceof AACEncodeProcessor ? (AACEncodeProcessor)abstractProcessor : null;
        if (object != null) {
            ((AACEncodeProcessor)object).recordMp3Start(path, callBack);
        }
    }

    public static /* synthetic */ void captureAudioStart$default(CameraClient cameraClient, ICaptureCallBack iCaptureCallBack, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = null;
        }
        cameraClient.captureAudioStart(iCaptureCallBack, string);
    }

    public final void captureAudioStop() {
        AACEncodeProcessor aACEncodeProcessor;
        AbstractProcessor abstractProcessor = this.mAudioProcess;
        AACEncodeProcessor aACEncodeProcessor2 = aACEncodeProcessor = abstractProcessor instanceof AACEncodeProcessor ? (AACEncodeProcessor)abstractProcessor : null;
        if (aACEncodeProcessor != null) {
            aACEncodeProcessor.recordMp3Stop();
        }
    }

    public final void stopPush() {
        AbstractProcessor abstractProcessor = this.mVideoProcess;
        if (abstractProcessor != null) {
            abstractProcessor.stopEncode();
        }
        abstractProcessor = this.mAudioProcess;
        if (abstractProcessor != null) {
            abstractProcessor.stopEncode();
        }
    }

    public final void addEncodeDataCallBack(@NotNull IEncodeDataCallBack callBack) {
        Intrinsics.checkNotNullParameter((Object)callBack, (String)"callBack");
        AbstractProcessor abstractProcessor = this.mVideoProcess;
        if (abstractProcessor != null) {
            abstractProcessor.setEncodeDataCallBack(callBack);
        }
        abstractProcessor = this.mAudioProcess;
        if (abstractProcessor != null) {
            abstractProcessor.setEncodeDataCallBack(callBack);
        }
    }

    public final void addPreviewDataCallBack(@NotNull IPreviewDataCallBack callBack) {
        Intrinsics.checkNotNullParameter((Object)callBack, (String)"callBack");
        ICameraStrategy iCameraStrategy = this.mCamera;
        if (iCameraStrategy != null) {
            iCameraStrategy.addPreviewDataCallBack(callBack);
        }
    }

    public final void removePreviewDataCallBack(@NotNull IPreviewDataCallBack callBack) {
        Intrinsics.checkNotNullParameter((Object)callBack, (String)"callBack");
        ICameraStrategy iCameraStrategy = this.mCamera;
        if (iCameraStrategy != null) {
            iCameraStrategy.removePreviewDataCallBack(callBack);
        }
    }

    public final void captureVideoStart(@NotNull ICaptureCallBack callBack, @Nullable String path, long durationInSec) {
        boolean bl;
        boolean bl2;
        AbstractProcessor abstractProcessor;
        Intrinsics.checkNotNullParameter((Object)callBack, (String)"callBack");
        this.mMediaMuxer = new Mp4Muxer(this.mCtx, callBack, path, durationInSec, false, 16, null);
        AbstractProcessor abstractProcessor2 = this.mVideoProcess;
        H264EncodeProcessor h264EncodeProcessor = abstractProcessor = abstractProcessor2 instanceof H264EncodeProcessor ? (H264EncodeProcessor)abstractProcessor2 : null;
        if (abstractProcessor != null) {
            abstractProcessor2 = abstractProcessor;
            bl2 = false;
            bl = false;
            AbstractProcessor $this$captureVideoStart_u24lambda_u2d11 = abstractProcessor2;
            boolean bl3 = false;
            $this$captureVideoStart_u24lambda_u2d11.startEncode();
            Mp4Muxer mp4Muxer = this.mMediaMuxer;
            Intrinsics.checkNotNull((Object)mp4Muxer);
            $this$captureVideoStart_u24lambda_u2d11.setMp4Muxer(mp4Muxer);
            ((H264EncodeProcessor)$this$captureVideoStart_u24lambda_u2d11).setOnEncodeReadyListener(new H264EncodeProcessor.OnEncodeReadyListener(this, (H264EncodeProcessor)$this$captureVideoStart_u24lambda_u2d11){
                final /* synthetic */ CameraClient this$0;
                final /* synthetic */ H264EncodeProcessor $this_apply;
                {
                    this.this$0 = $receiver;
                    this.$this_apply = $receiver2;
                }

                public void onReady(@Nullable Surface surface) {
                    if (!CameraClient.access$isEnableGLEs$p(this.this$0)) {
                        return;
                    }
                    if (surface == null) {
                        Logger.INSTANCE.e("CameraClient", "Input surface can't be null.");
                        return;
                    }
                    RenderManager renderManager = CameraClient.access$getMRenderManager(this.this$0);
                    if (renderManager != null) {
                        renderManager.startRenderCodec(surface, this.$this_apply.getWidth(), this.$this_apply.getHeight());
                    }
                }
            });
        }
        abstractProcessor2 = this.mAudioProcess;
        AbstractProcessor abstractProcessor3 = abstractProcessor = abstractProcessor2 instanceof AACEncodeProcessor ? (AACEncodeProcessor)abstractProcessor2 : null;
        if (abstractProcessor != null) {
            abstractProcessor2 = abstractProcessor;
            bl2 = false;
            bl = false;
            AbstractProcessor $this$captureVideoStart_u24lambda_u2d12 = abstractProcessor2;
            boolean bl4 = false;
            $this$captureVideoStart_u24lambda_u2d12.startEncode();
            Mp4Muxer mp4Muxer = this.mMediaMuxer;
            Intrinsics.checkNotNull((Object)mp4Muxer);
            $this$captureVideoStart_u24lambda_u2d12.setMp4Muxer(mp4Muxer);
        }
    }

    public static /* synthetic */ void captureVideoStart$default(CameraClient cameraClient, ICaptureCallBack iCaptureCallBack, String string, long l, int n, Object object) {
        if ((n & 2) != 0) {
            string = null;
        }
        if ((n & 4) != 0) {
            l = 0L;
        }
        cameraClient.captureVideoStart(iCaptureCallBack, string, l);
    }

    public final void captureVideoStop() {
        Object object = this.getMRenderManager();
        if (object != null) {
            ((RenderManager)object).stopRenderCodec();
        }
        object = this.mMediaMuxer;
        if (object != null) {
            ((Mp4Muxer)object).release();
        }
        object = this.mVideoProcess;
        if (object != null) {
            ((AbstractProcessor)object).stopEncode();
        }
        object = this.mAudioProcess;
        if (object != null) {
            ((AbstractProcessor)object).stopEncode();
        }
        this.mMediaMuxer = null;
    }

    @MainThread
    public final boolean updateResolution(int width, int height) {
        if (Utils.INSTANCE.getDebugCamera()) {
            Logger.INSTANCE.i(TAG, "updateResolution size = " + width + 'x' + height);
        }
        CameraRequest cameraRequest = this.getCameraRequest();
        boolean bl = false;
        boolean bl2 = false;
        CameraRequest $this$updateResolution_u24lambda_u2d14 = cameraRequest;
        boolean bl3 = false;
        if ($this$updateResolution_u24lambda_u2d14 == null) {
            Logger.INSTANCE.e(TAG, "updateResolution failed, camera request is null.");
            return false;
        }
        AbstractProcessor abstractProcessor = this.mVideoProcess;
        if (abstractProcessor == null ? false : abstractProcessor.isEncoding()) {
            Logger.INSTANCE.e(TAG, "updateResolution failed, video recording...");
            return false;
        }
        $this$updateResolution_u24lambda_u2d14.setPreviewWidth(width);
        $this$updateResolution_u24lambda_u2d14.setPreviewHeight(height);
        this.closeCamera();
        this.mMainHandler.postDelayed(() -> CameraClient.updateResolution$lambda-14$lambda-13(this), 500L);
        return true;
    }

    @Nullable
    public final List<PreviewSize> getAllPreviewSizes(@Nullable Double aspectRatio) {
        ICameraStrategy iCameraStrategy = this.mCamera;
        return iCameraStrategy == null ? null : iCameraStrategy.getAllPreviewSizes(aspectRatio);
    }

    public static /* synthetic */ List getAllPreviewSizes$default(CameraClient cameraClient, Double d, int n, Object object) {
        if ((n & 1) != 0) {
            d = null;
        }
        return cameraClient.getAllPreviewSizes(d);
    }

    @Nullable
    public final CameraRequest getCameraRequest() {
        return this.mRequest;
    }

    @Nullable
    public final ICameraStrategy getCameraStrategy() {
        return this.mCamera;
    }

    @Nullable
    public final AbstractEffect getDefaultEffect() {
        return this.mDefaultEffect;
    }

    @Nullable
    public final Integer sendCameraCommand(int command) {
        if (!(this.mCamera instanceof CameraUvcStrategy)) {
            return null;
        }
        return ((CameraUvcStrategy)this.mCamera).sendCameraCommand(command);
    }

    private final void initEncodeProcessor() {
        int n;
        int encodeWidth;
        int n2;
        this.releaseEncodeProcessor();
        if (this.isEnableGLEs) {
            CameraRequest cameraRequest = this.mRequest;
            Intrinsics.checkNotNull((Object)cameraRequest);
            n2 = cameraRequest.getPreviewHeight();
        } else {
            CameraRequest cameraRequest = this.mRequest;
            Intrinsics.checkNotNull((Object)cameraRequest);
            n2 = encodeWidth = cameraRequest.getPreviewWidth();
        }
        if (this.isEnableGLEs) {
            CameraRequest cameraRequest = this.mRequest;
            Intrinsics.checkNotNull((Object)cameraRequest);
            n = cameraRequest.getPreviewWidth();
        } else {
            CameraRequest cameraRequest = this.mRequest;
            Intrinsics.checkNotNull((Object)cameraRequest);
            n = cameraRequest.getPreviewHeight();
        }
        int encodeHeight = n;
        this.mAudioProcess = new AACEncodeProcessor(new AudioStrategySystem());
        this.mVideoProcess = new H264EncodeProcessor(encodeWidth, encodeHeight, this.isEnableGLEs, false, 8, null);
    }

    private final void releaseEncodeProcessor() {
        AbstractProcessor abstractProcessor;
        AbstractProcessor abstractProcessor2 = this.mAudioProcess;
        AbstractProcessor abstractProcessor3 = abstractProcessor = abstractProcessor2 instanceof AACEncodeProcessor ? (AACEncodeProcessor)abstractProcessor2 : null;
        if (abstractProcessor != null) {
            ((AACEncodeProcessor)abstractProcessor).playAudioStop();
        }
        abstractProcessor = this.mVideoProcess;
        if (abstractProcessor != null) {
            abstractProcessor.stopEncode();
        }
        abstractProcessor = this.mAudioProcess;
        if (abstractProcessor != null) {
            abstractProcessor.stopEncode();
        }
        this.mVideoProcess = null;
        this.mAudioProcess = null;
    }

    private final void addLifecycleObserver(Context context) {
        ((LifecycleOwner)context).getLifecycle().addObserver((LifecycleObserver)new LifecycleEventObserver(this){
            final /* synthetic */ CameraClient this$0;
            {
                this.this$0 = $receiver;
            }

            public void onStateChanged(@NotNull LifecycleOwner source, @NotNull Lifecycle.Event event) {
                Intrinsics.checkNotNullParameter((Object)source, (String)"source");
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                Lifecycle.Event event2 = event;
                int n = addLifecycleObserver.WhenMappings.$EnumSwitchMapping$0[event2.ordinal()];
                if (n == 1) {
                    this.this$0.captureVideoStop();
                    this.this$0.closeCamera();
                }
            }
        });
    }

    private final PreviewSize getSuitableSize(int maxWidth, int maxHeight) {
        PreviewSize previewSize;
        PreviewSize it;
        Object object2;
        boolean bl;
        PreviewSize previewSize2;
        List sizeList = CameraClient.getAllPreviewSizes$default(this, null, 1, null);
        List list = sizeList;
        if (list == null) {
            previewSize2 = null;
        } else {
            Object v1;
            block10: {
                Iterable iterable = list;
                bl = false;
                Iterable iterable2 = iterable;
                boolean bl2 = false;
                for (Object object2 : iterable2) {
                    it = (PreviewSize)object2;
                    boolean bl3 = false;
                    if (!(it.getWidth() == maxWidth && it.getHeight() == maxHeight)) continue;
                    v1 = object2;
                    break block10;
                }
                v1 = null;
            }
            previewSize2 = v1;
        }
        list = previewSize2;
        boolean bl4 = false;
        bl = false;
        List size = list;
        boolean bl52 = false;
        List list2 = size;
        if (list2 != null) {
            return size;
        }
        float aspectRatio = (float)maxWidth / (float)maxHeight;
        List list3 = sizeList;
        if (list3 == null) {
            previewSize = null;
        } else {
            PreviewSize previewSize3;
            block11: {
                Iterable iterable = list3;
                boolean bl6 = false;
                Iterable bl52 = iterable;
                boolean bl7 = false;
                object2 = bl52.iterator();
                while (object2.hasNext()) {
                    int h;
                    PreviewSize it2 = it = object2.next();
                    boolean bl8 = false;
                    int w = it2.getWidth();
                    float ratio = (float)w / (float)(h = it2.getHeight());
                    if (!(ratio == aspectRatio && w <= maxWidth && h <= maxHeight)) continue;
                    previewSize3 = it;
                    break block11;
                }
                previewSize3 = null;
            }
            previewSize = previewSize3;
        }
        list3 = previewSize;
        boolean bl9 = false;
        boolean bl10 = false;
        List size2 = list3;
        boolean bl11 = false;
        object2 = size2;
        if (object2 != null) {
            return size2;
        }
        int minDistance = 0;
        minDistance = maxWidth;
        PreviewSize closetSize = null;
        List list4 = sizeList;
        if (list4 != null) {
            Iterable $this$forEach$iv = list4;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                PreviewSize size3 = (PreviewSize)element$iv;
                boolean bl12 = false;
                int n = maxWidth - size3.getWidth();
                boolean bl13 = false;
                if (minDistance < Math.abs(n)) continue;
                n = maxWidth - size3.getWidth();
                bl13 = false;
                minDistance = Math.abs(n);
                closetSize = size3;
            }
        }
        return closetSize;
    }

    private static final void lambda-4$lambda-3(CameraClient this$0, CameraStatus status) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        int n = status.getCode();
        switch (n) {
            case -1: {
                ICameraStrategy iCameraStrategy = this$0.mCamera;
                if (iCameraStrategy == null) break;
                iCameraStrategy.stopPreview();
                break;
            }
            case -2: {
                CameraRequest cameraRequest = this$0.mRequest;
                if (cameraRequest == null) break;
                CameraRequest cameraRequest2 = cameraRequest;
                boolean bl = false;
                boolean bl2 = false;
                CameraRequest request = cameraRequest2;
                boolean bl3 = false;
                int oldPreviewWidth = request.getPreviewWidth();
                int oldPreviewHeight = request.getPreviewHeight();
                PreviewSize previewSize = this$0.getSuitableSize(oldPreviewWidth, oldPreviewHeight);
                boolean bl4 = false;
                boolean bl5 = false;
                PreviewSize it = previewSize;
                boolean bl6 = false;
                PreviewSize previewSize2 = it;
                if (previewSize2 == null) {
                    return;
                }
                previewSize = previewSize2;
                bl4 = false;
                bl5 = false;
                it = previewSize;
                boolean bl7 = false;
                Logger.INSTANCE.i(TAG, "Automatically select the appropriate resolution (" + it.getWidth() + 'x' + it.getHeight() + ')');
                this$0.updateResolution(it.getWidth(), it.getHeight());
            }
        }
    }

    private static final void updateResolution$lambda-14$lambda-13(CameraClient this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.openCamera(this$0.mCameraView, true);
    }

    @JvmStatic
    @NotNull
    public static final Builder newBuilder(@NotNull Context ctx) {
        return Companion.newBuilder(ctx);
    }

    public static final /* synthetic */ ICameraStrategy access$getMCamera$p(CameraClient $this) {
        return $this.mCamera;
    }

    public static final /* synthetic */ CameraRequest access$getMRequest$p(CameraClient $this) {
        return $this.mRequest;
    }

    public static final /* synthetic */ RenderManager access$getMRenderManager(CameraClient $this) {
        return $this.getMRenderManager();
    }

    public static final /* synthetic */ RotateType access$getMDefaultRotateType$p(CameraClient $this) {
        return $this.mDefaultRotateType;
    }

    public static final /* synthetic */ AbstractEffect access$getMDefaultEffect$p(CameraClient $this) {
        return $this.mDefaultEffect;
    }

    public static final /* synthetic */ boolean access$isEnableGLEs$p(CameraClient $this) {
        return $this.isEnableGLEs;
    }

    public static final /* synthetic */ Context access$getMCtx$p(CameraClient $this) {
        return $this.mCtx;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/jiangdg/ausbc/CameraClient$Companion;", "", "()V", "TAG", "", "newBuilder", "Lcom/jiangdg/ausbc/CameraClient$Builder;", "ctx", "Landroid/content/Context;", "libausbc_release"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final Builder newBuilder(@NotNull Context ctx) {
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            return new Builder(ctx);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0005\u00a2\u0006\u0002\u0010\u0005J\u0006\u00104\u001a\u000205J\u000e\u00106\u001a\u00020\u00002\u0006\u00107\u001a\u00020\"J\u000e\u00108\u001a\u00020\u00002\u0006\u00109\u001a\u00020\rJ\u0010\u0010:\u001a\u00020\u00002\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007J\u000e\u0010;\u001a\u00020\u00002\u0006\u0010<\u001a\u00020\u0016J\u0010\u0010=\u001a\u00020\u00002\b\u0010>\u001a\u0004\u0018\u00010\u001cJ\u000e\u0010?\u001a\u00020\u00002\u0006\u0010@\u001a\u00020\"J\u000e\u0010A\u001a\u00020\u00002\u0006\u0010'\u001a\u00020\"J\u0010\u0010B\u001a\u00020\u00002\u0006\u0010C\u001a\u00020+H\u0007J\u0010\u0010D\u001a\u00020\u00002\u0006\u0010E\u001a\u00020+H\u0007J\b\u0010F\u001a\u00020GH\u0016R\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001c\u0010\f\u001a\u0004\u0018\u00010\rX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001c\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0004R\u001c\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001c\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u001a\u0010!\u001a\u00020\"X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R\u001a\u0010'\u001a\u00020\"X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010$\"\u0004\b)\u0010&R\u001e\u0010*\u001a\u0004\u0018\u00010+X\u0080\u000e\u00a2\u0006\u0010\n\u0002\u00100\u001a\u0004\b,\u0010-\"\u0004\b.\u0010/R\u001e\u00101\u001a\u0004\u0018\u00010+X\u0080\u000e\u00a2\u0006\u0010\n\u0002\u00100\u001a\u0004\b2\u0010-\"\u0004\b3\u0010/\u00a8\u0006H"}, d2={"Lcom/jiangdg/ausbc/CameraClient$Builder;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "()V", "camera", "Lcom/jiangdg/ausbc/camera/ICameraStrategy;", "getCamera$libausbc_release", "()Lcom/jiangdg/ausbc/camera/ICameraStrategy;", "setCamera$libausbc_release", "(Lcom/jiangdg/ausbc/camera/ICameraStrategy;)V", "cameraRequest", "Lcom/jiangdg/ausbc/camera/bean/CameraRequest;", "getCameraRequest$libausbc_release", "()Lcom/jiangdg/ausbc/camera/bean/CameraRequest;", "setCameraRequest$libausbc_release", "(Lcom/jiangdg/ausbc/camera/bean/CameraRequest;)V", "getContext$libausbc_release", "()Landroid/content/Context;", "setContext$libausbc_release", "defaultEffect", "Lcom/jiangdg/ausbc/render/effect/AbstractEffect;", "getDefaultEffect$libausbc_release", "()Lcom/jiangdg/ausbc/render/effect/AbstractEffect;", "setDefaultEffect$libausbc_release", "(Lcom/jiangdg/ausbc/render/effect/AbstractEffect;)V", "defaultRotateType", "Lcom/jiangdg/ausbc/render/env/RotateType;", "getDefaultRotateType$libausbc_release", "()Lcom/jiangdg/ausbc/render/env/RotateType;", "setDefaultRotateType$libausbc_release", "(Lcom/jiangdg/ausbc/render/env/RotateType;)V", "enableGLEs", "", "getEnableGLEs$libausbc_release", "()Z", "setEnableGLEs$libausbc_release", "(Z)V", "rawImage", "getRawImage$libausbc_release", "setRawImage$libausbc_release", "videoEncodeBitRate", "", "getVideoEncodeBitRate$libausbc_release", "()Ljava/lang/Integer;", "setVideoEncodeBitRate$libausbc_release", "(Ljava/lang/Integer;)V", "Ljava/lang/Integer;", "videoEncodeFrameRate", "getVideoEncodeFrameRate$libausbc_release", "setVideoEncodeFrameRate$libausbc_release", "build", "Lcom/jiangdg/ausbc/CameraClient;", "openDebug", "debug", "setCameraRequest", "request", "setCameraStrategy", "setDefaultEffect", "effect", "setDefaultRotateType", "type", "setEnableGLES", "enable", "setRawImage", "setVideoEncodeBitRate", "bitRate", "setVideoEncodeFrameRate", "frameRate", "toString", "", "libausbc_release"})
    public static final class Builder {
        @Nullable
        private Context context;
        @Nullable
        private CameraRequest cameraRequest;
        private boolean enableGLEs;
        private boolean rawImage;
        @Nullable
        private ICameraStrategy camera;
        @Nullable
        private AbstractEffect defaultEffect;
        @Nullable
        private Integer videoEncodeBitRate;
        @Nullable
        private Integer videoEncodeFrameRate;
        @Nullable
        private RotateType defaultRotateType;

        public Builder() {
            this.enableGLEs = true;
            this.rawImage = true;
        }

        @Nullable
        public final Context getContext$libausbc_release() {
            return this.context;
        }

        public final void setContext$libausbc_release(@Nullable Context context) {
            this.context = context;
        }

        @Nullable
        public final CameraRequest getCameraRequest$libausbc_release() {
            return this.cameraRequest;
        }

        public final void setCameraRequest$libausbc_release(@Nullable CameraRequest cameraRequest) {
            this.cameraRequest = cameraRequest;
        }

        public final boolean getEnableGLEs$libausbc_release() {
            return this.enableGLEs;
        }

        public final void setEnableGLEs$libausbc_release(boolean bl) {
            this.enableGLEs = bl;
        }

        public final boolean getRawImage$libausbc_release() {
            return this.rawImage;
        }

        public final void setRawImage$libausbc_release(boolean bl) {
            this.rawImage = bl;
        }

        @Nullable
        public final ICameraStrategy getCamera$libausbc_release() {
            return this.camera;
        }

        public final void setCamera$libausbc_release(@Nullable ICameraStrategy iCameraStrategy) {
            this.camera = iCameraStrategy;
        }

        @Nullable
        public final AbstractEffect getDefaultEffect$libausbc_release() {
            return this.defaultEffect;
        }

        public final void setDefaultEffect$libausbc_release(@Nullable AbstractEffect abstractEffect) {
            this.defaultEffect = abstractEffect;
        }

        @Nullable
        public final Integer getVideoEncodeBitRate$libausbc_release() {
            return this.videoEncodeBitRate;
        }

        public final void setVideoEncodeBitRate$libausbc_release(@Nullable Integer n) {
            this.videoEncodeBitRate = n;
        }

        @Nullable
        public final Integer getVideoEncodeFrameRate$libausbc_release() {
            return this.videoEncodeFrameRate;
        }

        public final void setVideoEncodeFrameRate$libausbc_release(@Nullable Integer n) {
            this.videoEncodeFrameRate = n;
        }

        @Nullable
        public final RotateType getDefaultRotateType$libausbc_release() {
            return this.defaultRotateType;
        }

        public final void setDefaultRotateType$libausbc_release(@Nullable RotateType rotateType) {
            this.defaultRotateType = rotateType;
        }

        public Builder(@NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            this();
            this.context = context;
        }

        @NotNull
        public final Builder setCameraStrategy(@Nullable ICameraStrategy camera) {
            this.camera = camera;
            return this;
        }

        @NotNull
        public final Builder setCameraRequest(@NotNull CameraRequest request) {
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            this.cameraRequest = request;
            return this;
        }

        @NotNull
        public final Builder setEnableGLES(boolean enable) {
            this.enableGLEs = enable;
            return this;
        }

        @NotNull
        public final Builder setRawImage(boolean rawImage) {
            this.rawImage = rawImage;
            return this;
        }

        @NotNull
        public final Builder setDefaultEffect(@NotNull AbstractEffect effect) {
            Intrinsics.checkNotNullParameter((Object)effect, (String)"effect");
            this.defaultEffect = effect;
            return this;
        }

        @Deprecated(message="Not realized")
        @NotNull
        public final Builder setVideoEncodeBitRate(int bitRate) {
            this.videoEncodeBitRate = bitRate;
            return this;
        }

        @Deprecated(message="Not realized")
        @NotNull
        public final Builder setVideoEncodeFrameRate(int frameRate) {
            this.videoEncodeFrameRate = frameRate;
            return this;
        }

        @NotNull
        public final Builder openDebug(boolean debug) {
            UVCCamera.DEBUG = debug;
            USBMonitor.DEBUG = debug;
            Utils.INSTANCE.setDebugCamera(debug);
            return this;
        }

        @NotNull
        public final Builder setDefaultRotateType(@Nullable RotateType type) {
            this.defaultRotateType = type;
            return this;
        }

        @NotNull
        public String toString() {
            return "Builder(context=" + this.context + ", cameraType=" + this.camera + ", cameraRequest=" + this.cameraRequest + ", glEsVersion=" + this.enableGLEs + ')';
        }

        @NotNull
        public final CameraClient build() {
            return new CameraClient(this);
        }
    }
}

