/*
 * Decompiled with CFR 0.152.
 */
package com.github.chenglei1986.statusbar;

import android.app.Activity;
import android.content.Context;
import android.graphics.Rect;
import android.os.Build;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.Window;
import android.view.WindowManager;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class StatusBarUtil {
    public static int getStatusHeight(Activity activity) {
        Rect localRect = new Rect();
        activity.getWindow().getDecorView().getWindowVisibleDisplayFrame(localRect);
        int statusHeight = localRect.top;
        if (0 == statusHeight) {
            try {
                Class<?> localClass = Class.forName("com.android.internal.R$dimen");
                Object localObject = localClass.newInstance();
                int id2 = Integer.parseInt(localClass.getField("status_bar_height").get(localObject).toString());
                statusHeight = activity.getResources().getDimensionPixelSize(id2);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return statusHeight;
    }

    public static boolean setMiuiStatusBarIconDarkMode(Activity activity, boolean dark) {
        boolean result = false;
        Class<?> clazz = activity.getWindow().getClass();
        try {
            int darkModeFlag = 0;
            Class<?> layoutParams = Class.forName("android.view.MiuiWindowManager$LayoutParams");
            Field field = layoutParams.getField("EXTRA_FLAG_STATUS_BAR_DARK_MODE");
            darkModeFlag = field.getInt(layoutParams);
            Method extraFlagField = clazz.getMethod("setExtraFlags", Integer.TYPE, Integer.TYPE);
            extraFlagField.invoke((Object)activity.getWindow(), dark ? darkModeFlag : 0, darkModeFlag);
            result = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public static boolean setFlymeStatusBarIconDarkMode(Activity activity, boolean dark) {
        boolean result = false;
        try {
            Window window = activity.getWindow();
            WindowManager.LayoutParams lp = window.getAttributes();
            Field darkFlag = WindowManager.LayoutParams.class.getDeclaredField("MEIZU_FLAG_DARK_STATUS_BAR_ICON");
            Field meizuFlags = WindowManager.LayoutParams.class.getDeclaredField("meizuFlags");
            darkFlag.setAccessible(true);
            meizuFlags.setAccessible(true);
            int bit = darkFlag.getInt(null);
            int value = meizuFlags.getInt(lp);
            value = dark ? (value |= bit) : (value &= ~bit);
            meizuFlags.setInt(lp, value);
            window.setAttributes(lp);
            result = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public static void setWindowFlag(Activity activity, int bits, boolean on) {
        Window win = activity.getWindow();
        WindowManager.LayoutParams winParams = win.getAttributes();
        winParams.flags = on ? (winParams.flags |= bits) : (winParams.flags &= ~bits);
        win.setAttributes(winParams);
    }

    public static void setTranslucentStatus(Activity activity) {
        if (Build.VERSION.SDK_INT >= 19 && Build.VERSION.SDK_INT < 21) {
            StatusBarUtil.setWindowFlag(activity, 0x4000000, true);
        }
        if (Build.VERSION.SDK_INT >= 21) {
            activity.getWindow().getDecorView().setSystemUiVisibility(1280);
            StatusBarUtil.setWindowFlag(activity, 0x4000000, false);
            activity.getWindow().setStatusBarColor(0);
        }
    }

    public static int getActionBarHeight(Context context) {
        int result = 0;
        if (Build.VERSION.SDK_INT >= 14) {
            TypedValue tv = new TypedValue();
            context.getTheme().resolveAttribute(16843499, tv, true);
            result = TypedValue.complexToDimensionPixelSize((int)tv.data, (DisplayMetrics)context.getResources().getDisplayMetrics());
        }
        return result;
    }
}

