/*
 * Decompiled with CFR 0.152.
 */
package com.github.chen0040.embeddings.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClient
implements Serializable {
    private static final String DATA_ENCODING = "UTF-8";
    private static final Logger logger = LoggerFactory.getLogger(HttpClient.class);
    private static final long serialVersionUID = 4661645115933875389L;

    private static CloseableHttpClient buildClient() {
        int timeout = 60;
        RequestConfig config = RequestConfig.custom().setSocketTimeout(timeout * 1000).setConnectionRequestTimeout(timeout * 1000).setConnectTimeout(timeout * 1000).build();
        return HttpClients.custom().setDefaultRequestConfig(config).build();
    }

    public static void formPost(String uri, Map<String, String> parameters) throws IOException {
        logger.info("form post to {}", (Object)uri);
        HttpPost httpPost = new HttpPost(uri);
        CloseableHttpClient client = HttpClient.buildClient();
        ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
        for (Map.Entry<String, String> entry : parameters.entrySet()) {
            params.add(new BasicNameValuePair(entry.getKey(), entry.getValue()));
        }
        httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(params));
        CloseableHttpResponse response = client.execute((HttpUriRequest)httpPost);
        int statusCode = response.getStatusLine().getStatusCode();
        logger.info("status code: {}", (Object)statusCode);
    }

    public static String jsonPost(String url, Map<String, String> parameters) {
        CloseableHttpClient httpClient = HttpClient.buildClient();
        String json = "";
        String body = JSON.toJSONString(parameters);
        try {
            HttpPost request = new HttpPost(url);
            StringEntity params = new StringEntity(body);
            request.addHeader("content-type", "application/json");
            request.setEntity((HttpEntity)params);
            CloseableHttpResponse result = httpClient.execute((HttpUriRequest)request);
            if (result.getEntity() != null) {
                json = EntityUtils.toString((HttpEntity)result.getEntity(), (String)DATA_ENCODING);
            }
            result.close();
            httpClient.close();
        }
        catch (IOException ex) {
            json = ex.getMessage();
        }
        return json;
    }

    public static <T> String postArray(String url, List<T> a) {
        String json = JSON.toJSONString(a, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.BrowserCompatible});
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        return HttpClient.post(url, json, headers);
    }

    public static String post(String url, String body, Map<String, String> headers) {
        CloseableHttpClient httpClient = HttpClient.buildClient();
        String json = "";
        try {
            HttpPost request = new HttpPost(url);
            StringEntity params = new StringEntity(body);
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                request.addHeader(entry.getKey(), entry.getValue());
            }
            request.setEntity((HttpEntity)params);
            CloseableHttpResponse result = httpClient.execute((HttpUriRequest)request);
            if (result.getEntity() != null) {
                json = EntityUtils.toString((HttpEntity)result.getEntity(), (String)DATA_ENCODING);
            }
            result.close();
            httpClient.close();
        }
        catch (IOException ex) {
            json = ex.getMessage();
        }
        return json;
    }

    public static String put(String url, String body, Map<String, String> headers) {
        CloseableHttpClient httpClient = HttpClient.buildClient();
        String json = "";
        try {
            HttpPut request = new HttpPut(url);
            StringEntity params = new StringEntity(body);
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                request.addHeader(entry.getKey(), entry.getValue());
            }
            request.setEntity((HttpEntity)params);
            CloseableHttpResponse result = httpClient.execute((HttpUriRequest)request);
            if (result.getEntity() != null) {
                json = EntityUtils.toString((HttpEntity)result.getEntity(), (String)DATA_ENCODING);
            }
            result.close();
            httpClient.close();
        }
        catch (IOException ex) {
            json = ex.getMessage();
        }
        return json;
    }

    public static String delete(String url, Map<String, String> headers) {
        CloseableHttpClient httpClient = HttpClient.buildClient();
        String json = "";
        try {
            HttpDelete request = new HttpDelete(url);
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                request.addHeader(entry.getKey(), entry.getValue());
            }
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)request);
            if (response.getEntity() != null) {
                json = EntityUtils.toString((HttpEntity)response.getEntity(), (String)DATA_ENCODING);
            }
            response.close();
            httpClient.close();
        }
        catch (IOException ex) {
            json = ex.getMessage();
        }
        return json;
    }

    public static String delete(String url) {
        CloseableHttpClient httpClient = HttpClient.buildClient();
        String json = "";
        try {
            HttpDelete request = new HttpDelete(url);
            request.addHeader("content-type", "application/json");
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)request);
            if (response.getEntity() != null) {
                json = EntityUtils.toString((HttpEntity)response.getEntity(), (String)DATA_ENCODING);
            }
            response.close();
            httpClient.close();
        }
        catch (IOException ex) {
            json = ex.getMessage();
        }
        return json;
    }

    public static String getJson(String url) {
        String json = "";
        try {
            CloseableHttpClient httpClient = HttpClient.buildClient();
            HttpGet request = new HttpGet(url);
            request.addHeader("content-type", "application/json");
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)request);
            if (response.getEntity() != null) {
                json = EntityUtils.toString((HttpEntity)response.getEntity(), (String)DATA_ENCODING);
            }
        }
        catch (Exception ex2) {
            json = ex2.getMessage();
        }
        return json;
    }

    public static <T> T getObject(String url, Class<T> clazz) {
        String json = HttpClient.getJson(url);
        try {
            return (T)JSON.parseObject((String)json, clazz);
        }
        catch (Exception ex) {
            logger.error("Failed to parse json " + json, (Throwable)ex);
            return null;
        }
    }

    public static <T> List<T> getArray(String url, Class<T> clazz) {
        String json = HttpClient.getJson(url);
        try {
            return JSON.parseArray((String)json, clazz);
        }
        catch (Exception ex) {
            logger.error("Failed to parse json " + json, (Throwable)ex);
            return null;
        }
    }

    public static boolean downloadFile(String url, String save_to_file) {
        return HttpClient.downloadFile(url, save_to_file, new HashMap<String, String>());
    }

    public static boolean downloadFile(String url, String save_to_file, Map<String, String> headers) {
        try {
            CloseableHttpClient httpClient = HttpClient.buildClient();
            HttpGet request = new HttpGet(url);
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                request.addHeader(entry.getKey(), entry.getValue());
            }
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)request);
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                try (FileOutputStream outstream = new FileOutputStream(new File(save_to_file));){
                    entity.writeTo((OutputStream)outstream);
                }
                catch (Exception ex1) {
                    logger.error("Failed to write the data from " + url + " to file " + save_to_file, (Throwable)ex1);
                    return false;
                }
                return true;
            }
            return false;
        }
        catch (Exception ex2) {
            logger.error("Failed to download the file from " + url, (Throwable)ex2);
            return false;
        }
    }

    public static String get(String url, Map<String, String> headers) {
        String json = "";
        try {
            CloseableHttpClient httpClient = HttpClient.buildClient();
            HttpGet request = new HttpGet(url);
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                request.addHeader(entry.getKey(), entry.getValue());
            }
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)request);
            if (response.getEntity() != null) {
                json = EntityUtils.toString((HttpEntity)response.getEntity(), (String)DATA_ENCODING);
            }
        }
        catch (Exception ex2) {
            json = ex2.getMessage();
        }
        return json;
    }
}

