/*
 * Decompiled with CFR 0.152.
 */
package com.checkout.validation.validator;

import com.checkout.tokenization.model.Phone;
import com.checkout.validation.error.ValidationError;
import com.checkout.validation.model.PhoneValidationRequest;
import com.checkout.validation.model.ValidationResult;
import com.checkout.validation.validator.contract.Validator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u00062\u0006\u0010\u0007\u001a\u00020\u0002H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0003H\u0002\u00a8\u0006\u000b"}, d2={"Lcom/checkout/validation/validator/PhoneValidator;", "Lcom/checkout/validation/validator/contract/Validator;", "Lcom/checkout/validation/model/PhoneValidationRequest;", "Lcom/checkout/tokenization/model/Phone;", "()V", "validate", "Lcom/checkout/validation/model/ValidationResult;", "data", "validatePhone", "", "phone", "checkout_release"})
public final class PhoneValidator
implements Validator<PhoneValidationRequest, Phone> {
    @Override
    @NotNull
    public ValidationResult<Phone> validate(@NotNull PhoneValidationRequest data) {
        ValidationResult validationResult;
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        try {
            Phone phone = new Phone(data.getNumber(), data.getCountry());
            this.validatePhone(phone);
            validationResult = new ValidationResult.Success<Phone>(phone);
        }
        catch (ValidationError e) {
            validationResult = new ValidationResult.Failure(e);
        }
        return validationResult;
    }

    private final void validatePhone(Phone phone) throws ValidationError {
        if (phone.getNumber().length() < 6 || phone.getNumber().length() > 25) {
            throw new ValidationError("ValidationError:1018", "Invalid length of phone number", null, 4, null);
        }
    }
}

