/*
 * Decompiled with CFR 0.152.
 */
package com.checkout.validation.validator;

import com.checkout.tokenization.mapper.request.AddressValidationRequestToAddressDataMapper;
import com.checkout.tokenization.model.Address;
import com.checkout.validation.error.ValidationError;
import com.checkout.validation.model.AddressValidationRequest;
import com.checkout.validation.model.ValidationResult;
import com.checkout.validation.validator.contract.Validator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u00062\u0006\u0010\u0007\u001a\u00020\u0002H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0003H\u0002\u00a8\u0006\u000b"}, d2={"Lcom/checkout/validation/validator/AddressValidator;", "Lcom/checkout/validation/validator/contract/Validator;", "Lcom/checkout/validation/model/AddressValidationRequest;", "Lcom/checkout/tokenization/model/Address;", "()V", "validate", "Lcom/checkout/validation/model/ValidationResult;", "data", "validateAddress", "", "address", "checkout_release"})
public final class AddressValidator
implements Validator<AddressValidationRequest, Address> {
    @Override
    @NotNull
    public ValidationResult<Address> validate(@NotNull AddressValidationRequest data) {
        ValidationResult validationResult;
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        try {
            Address address = new AddressValidationRequestToAddressDataMapper().map(data);
            this.validateAddress(address);
            validationResult = new ValidationResult.Success<Address>(address);
        }
        catch (ValidationError e) {
            validationResult = new ValidationResult.Failure(e);
        }
        return validationResult;
    }

    private final void validateAddress(Address address) throws ValidationError {
        if (address.getAddressLine1().length() > 200) {
            throw new ValidationError("ValidationError:1012", "Address line 1 exceeding minimum length of characters", null, 4, null);
        }
        if (address.getAddressLine2().length() > 200) {
            throw new ValidationError("ValidationError:1013", "Address line 2 exceeding minimum length of characters", null, 4, null);
        }
        if (address.getCity().length() > 50) {
            throw new ValidationError("ValidationError:1014", "City exceeding minimum length of characters", null, 4, null);
        }
        if (address.getState().length() > 50) {
            throw new ValidationError("ValidationError:1016", "State exceeding minimum length of characters", null, 4, null);
        }
        if (address.getZip().length() > 50) {
            throw new ValidationError("ValidationError:1017", "Zipcode exceeding minimum length of characters", null, 4, null);
        }
    }
}

