/*
 * Decompiled with CFR 0.152.
 */
package com.checkout.tokenization.repository;

import androidx.annotation.VisibleForTesting;
import com.checkout.base.mapper.Mapper;
import com.checkout.base.usecase.UseCase;
import com.checkout.network.response.NetworkApiResponse;
import com.checkout.tokenization.NetworkApiClient;
import com.checkout.tokenization.entity.GooglePayEntity;
import com.checkout.tokenization.error.TokenizationError;
import com.checkout.tokenization.logging.TokenizationLogger;
import com.checkout.tokenization.mapper.TokenizationNetworkDataMapper;
import com.checkout.tokenization.model.CVVTokenDetails;
import com.checkout.tokenization.model.CVVTokenizationRequest;
import com.checkout.tokenization.model.CVVTokenizationResultHandler;
import com.checkout.tokenization.model.Card;
import com.checkout.tokenization.model.CardTokenRequest;
import com.checkout.tokenization.model.GooglePayTokenRequest;
import com.checkout.tokenization.model.TokenDetails;
import com.checkout.tokenization.model.TokenResult;
import com.checkout.tokenization.model.ValidateCVVTokenizationRequest;
import com.checkout.tokenization.repository.TokenRepository;
import com.checkout.tokenization.repository.TokenRepositoryImpl;
import com.checkout.tokenization.request.CVVTokenNetworkRequest;
import com.checkout.tokenization.request.GooglePayTokenNetworkRequest;
import com.checkout.tokenization.request.TokenRequest;
import com.checkout.tokenization.response.CVVTokenDetailsResponse;
import com.checkout.tokenization.response.TokenDetailsResponse;
import com.checkout.tokenization.usecase.RiskSdkUseCase;
import com.checkout.validation.model.ValidationResult;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.CoroutineName;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.NonCancellable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00a8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u00a7\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\u0005\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u0012\u0018\u0010\u000e\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u00100\u000f\u0012\u0018\u0010\u0012\u001a\u0014\u0012\u0004\u0012\u00020\u0013\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u00100\u000f\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u0012\u0006\u0010\u0016\u001a\u00020\u0017\u0012\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\f\u0012\u0006\u0010\u001a\u001a\u00020\u001b\u0012\b\b\u0002\u0010\u001c\u001a\u00020\u001d\u00a2\u0006\u0002\u0010\u001eJ\u0010\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u0017H\u0007Jm\u0010*\u001a\u00020\u00112\u0006\u0010+\u001a\u00020\u00172\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\r0-2!\u0010.\u001a\u001d\u0012\u0013\u0012\u00110\r\u00a2\u0006\f\b0\u0012\b\b1\u0012\u0004\b\b(2\u0012\u0004\u0012\u00020\u00110/2!\u00103\u001a\u001d\u0012\u0013\u0012\u00110\u0017\u00a2\u0006\f\b0\u0012\b\b1\u0012\u0004\b\b(4\u0012\u0004\u0012\u00020\u00110/H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00105J\u0016\u00106\u001a\u00020\u00112\f\u00107\u001a\b\u0012\u0004\u0012\u00020908H\u0002J\u001e\u0010:\u001a\u00020\u00112\f\u00107\u001a\b\u0012\u0004\u0012\u00020;082\u0006\u0010+\u001a\u00020\u0017H\u0002J\u0010\u0010<\u001a\u00020\u00112\u0006\u0010=\u001a\u00020\tH\u0016J\u0010\u0010>\u001a\u00020\u00112\u0006\u0010?\u001a\u00020@H\u0016J\u0010\u0010A\u001a\u00020\u00112\u0006\u0010B\u001a\u00020CH\u0016R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u001f\u001a\u00020 8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b!\u0010\"\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0012\u001a\u0014\u0012\u0004\u0012\u00020\u0013\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u000e\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006D"}, d2={"Lcom/checkout/tokenization/repository/TokenRepositoryImpl;", "Lcom/checkout/tokenization/repository/TokenRepository;", "networkApiClient", "Lcom/checkout/tokenization/NetworkApiClient;", "cardToTokenRequestMapper", "Lcom/checkout/base/mapper/Mapper;", "Lcom/checkout/tokenization/model/Card;", "Lcom/checkout/tokenization/request/TokenRequest;", "cvvToTokenNetworkRequestMapper", "Lcom/checkout/tokenization/model/CVVTokenizationRequest;", "Lcom/checkout/tokenization/request/CVVTokenNetworkRequest;", "cardTokenizationNetworkDataMapper", "Lcom/checkout/tokenization/mapper/TokenizationNetworkDataMapper;", "Lcom/checkout/tokenization/model/TokenDetails;", "validateTokenizationDataUseCase", "Lcom/checkout/base/usecase/UseCase;", "Lcom/checkout/validation/model/ValidationResult;", "", "validateCVVTokenizationDataUseCase", "Lcom/checkout/tokenization/model/ValidateCVVTokenizationRequest;", "logger", "Lcom/checkout/tokenization/logging/TokenizationLogger;", "publicKey", "", "cvvTokenizationNetworkDataMapper", "Lcom/checkout/tokenization/model/CVVTokenDetails;", "riskSdkUseCase", "Lcom/checkout/tokenization/usecase/RiskSdkUseCase;", "dispatcher", "Lkotlinx/coroutines/CoroutineDispatcher;", "(Lcom/checkout/tokenization/NetworkApiClient;Lcom/checkout/base/mapper/Mapper;Lcom/checkout/base/mapper/Mapper;Lcom/checkout/tokenization/mapper/TokenizationNetworkDataMapper;Lcom/checkout/base/usecase/UseCase;Lcom/checkout/base/usecase/UseCase;Lcom/checkout/tokenization/logging/TokenizationLogger;Ljava/lang/String;Lcom/checkout/tokenization/mapper/TokenizationNetworkDataMapper;Lcom/checkout/tokenization/usecase/RiskSdkUseCase;Lkotlinx/coroutines/CoroutineDispatcher;)V", "networkCoroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "getNetworkCoroutineScope$annotations", "()V", "getNetworkCoroutineScope", "()Lkotlinx/coroutines/CoroutineScope;", "setNetworkCoroutineScope", "(Lkotlinx/coroutines/CoroutineScope;)V", "creatingTokenData", "Lcom/checkout/tokenization/entity/GooglePayEntity;", "tokenJsonPayload", "handleResponse", "tokenType", "tokenResult", "Lcom/checkout/tokenization/model/TokenResult;", "success", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "tokenDetails", "failure", "errorMessage", "(Ljava/lang/String;Lcom/checkout/tokenization/model/TokenResult;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "logCVVTokenizationResponse", "response", "Lcom/checkout/network/response/NetworkApiResponse;", "Lcom/checkout/tokenization/response/CVVTokenDetailsResponse;", "logResponse", "Lcom/checkout/tokenization/response/TokenDetailsResponse;", "sendCVVTokenizationRequest", "cvvTokenizationRequest", "sendCardTokenRequest", "cardTokenRequest", "Lcom/checkout/tokenization/model/CardTokenRequest;", "sendGooglePayTokenRequest", "googlePayTokenRequest", "Lcom/checkout/tokenization/model/GooglePayTokenRequest;", "checkout_release"})
@SourceDebugExtension(value={"SMAP\nTokenRepositoryImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TokenRepositoryImpl.kt\ncom/checkout/tokenization/repository/TokenRepositoryImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,281:1\n1#2:282\n*E\n"})
public final class TokenRepositoryImpl
implements TokenRepository {
    @NotNull
    private final NetworkApiClient networkApiClient;
    @NotNull
    private final Mapper<Card, TokenRequest> cardToTokenRequestMapper;
    @NotNull
    private final Mapper<CVVTokenizationRequest, CVVTokenNetworkRequest> cvvToTokenNetworkRequestMapper;
    @NotNull
    private final TokenizationNetworkDataMapper<TokenDetails> cardTokenizationNetworkDataMapper;
    @NotNull
    private final UseCase<Card, ValidationResult<Unit>> validateTokenizationDataUseCase;
    @NotNull
    private final UseCase<ValidateCVVTokenizationRequest, ValidationResult<Unit>> validateCVVTokenizationDataUseCase;
    @NotNull
    private final TokenizationLogger logger;
    @NotNull
    private final String publicKey;
    @NotNull
    private final TokenizationNetworkDataMapper<CVVTokenDetails> cvvTokenizationNetworkDataMapper;
    @NotNull
    private final RiskSdkUseCase riskSdkUseCase;
    @NotNull
    private final CoroutineDispatcher dispatcher;
    @NotNull
    private CoroutineScope networkCoroutineScope;

    public TokenRepositoryImpl(@NotNull NetworkApiClient networkApiClient, @NotNull Mapper<Card, TokenRequest> cardToTokenRequestMapper, @NotNull Mapper<CVVTokenizationRequest, CVVTokenNetworkRequest> cvvToTokenNetworkRequestMapper, @NotNull TokenizationNetworkDataMapper<TokenDetails> cardTokenizationNetworkDataMapper, @NotNull UseCase<Card, ValidationResult<Unit>> validateTokenizationDataUseCase, @NotNull UseCase<ValidateCVVTokenizationRequest, ValidationResult<Unit>> validateCVVTokenizationDataUseCase, @NotNull TokenizationLogger logger, @NotNull String publicKey, @NotNull TokenizationNetworkDataMapper<CVVTokenDetails> cvvTokenizationNetworkDataMapper, @NotNull RiskSdkUseCase riskSdkUseCase, @NotNull CoroutineDispatcher dispatcher) {
        Intrinsics.checkNotNullParameter((Object)networkApiClient, (String)"networkApiClient");
        Intrinsics.checkNotNullParameter(cardToTokenRequestMapper, (String)"cardToTokenRequestMapper");
        Intrinsics.checkNotNullParameter(cvvToTokenNetworkRequestMapper, (String)"cvvToTokenNetworkRequestMapper");
        Intrinsics.checkNotNullParameter(cardTokenizationNetworkDataMapper, (String)"cardTokenizationNetworkDataMapper");
        Intrinsics.checkNotNullParameter(validateTokenizationDataUseCase, (String)"validateTokenizationDataUseCase");
        Intrinsics.checkNotNullParameter(validateCVVTokenizationDataUseCase, (String)"validateCVVTokenizationDataUseCase");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)publicKey, (String)"publicKey");
        Intrinsics.checkNotNullParameter(cvvTokenizationNetworkDataMapper, (String)"cvvTokenizationNetworkDataMapper");
        Intrinsics.checkNotNullParameter((Object)riskSdkUseCase, (String)"riskSdkUseCase");
        Intrinsics.checkNotNullParameter((Object)dispatcher, (String)"dispatcher");
        this.networkApiClient = networkApiClient;
        this.cardToTokenRequestMapper = cardToTokenRequestMapper;
        this.cvvToTokenNetworkRequestMapper = cvvToTokenNetworkRequestMapper;
        this.cardTokenizationNetworkDataMapper = cardTokenizationNetworkDataMapper;
        this.validateTokenizationDataUseCase = validateTokenizationDataUseCase;
        this.validateCVVTokenizationDataUseCase = validateCVVTokenizationDataUseCase;
        this.logger = logger;
        this.publicKey = publicKey;
        this.cvvTokenizationNetworkDataMapper = cvvTokenizationNetworkDataMapper;
        this.riskSdkUseCase = riskSdkUseCase;
        this.dispatcher = dispatcher;
        this.networkCoroutineScope = CoroutineScopeKt.CoroutineScope((CoroutineContext)new CoroutineName("com.checkout.checkout-android").plus((CoroutineContext)Dispatchers.getIO()).plus((CoroutineContext)NonCancellable.INSTANCE));
    }

    public /* synthetic */ TokenRepositoryImpl(NetworkApiClient networkApiClient, Mapper mapper, Mapper mapper2, TokenizationNetworkDataMapper tokenizationNetworkDataMapper, UseCase useCase, UseCase useCase2, TokenizationLogger tokenizationLogger, String string, TokenizationNetworkDataMapper tokenizationNetworkDataMapper2, RiskSdkUseCase riskSdkUseCase, CoroutineDispatcher coroutineDispatcher, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x400) != 0) {
            coroutineDispatcher = Dispatchers.getIO();
        }
        this(networkApiClient, mapper, mapper2, tokenizationNetworkDataMapper, useCase, useCase2, tokenizationLogger, string, tokenizationNetworkDataMapper2, riskSdkUseCase, coroutineDispatcher);
    }

    @NotNull
    public final CoroutineScope getNetworkCoroutineScope() {
        return this.networkCoroutineScope;
    }

    public final void setNetworkCoroutineScope(@NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"<set-?>");
        this.networkCoroutineScope = coroutineScope;
    }

    @VisibleForTesting
    public static /* synthetic */ void getNetworkCoroutineScope$annotations() {
    }

    @Override
    public void sendCardTokenRequest(@NotNull CardTokenRequest cardTokenRequest) {
        Intrinsics.checkNotNullParameter((Object)cardTokenRequest, (String)"cardTokenRequest");
        Ref.ObjectRef response = new Ref.ObjectRef();
        String tokenType = "card";
        BuildersKt.launch$default((CoroutineScope)this.networkCoroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, cardTokenRequest, (Ref.ObjectRef<NetworkApiResponse<TokenDetailsResponse>>)response, tokenType, null){
            Object L$1;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ TokenRepositoryImpl this$0;
            final /* synthetic */ CardTokenRequest $cardTokenRequest;
            final /* synthetic */ Ref.ObjectRef<NetworkApiResponse<TokenDetailsResponse>> $response;
            final /* synthetic */ String $tokenType;
            {
                this.this$0 = $receiver;
                this.$cardTokenRequest = $cardTokenRequest;
                this.$response = $response;
                this.$tokenType = $tokenType;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                block5: {
                    var6_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
                            $this$launch = (CoroutineScope)this.L$0;
                            var4_5 = validationTokenizationDataResult = (ValidationResult)TokenRepositoryImpl.access$getValidateTokenizationDataUseCase$p(this.this$0).execute(this.$cardTokenRequest.getCard());
                            if (!(var4_5 instanceof ValidationResult.Failure)) ** GOTO lbl10
                            this.$response.element = new NetworkApiResponse.InternalError(((ValidationResult.Failure)validationTokenizationDataResult).getError());
                            break block5;
lbl10:
                            // 1 sources

                            if (!(var4_5 instanceof ValidationResult.Success)) break;
                            TokenRepositoryImpl.access$getLogger$p(this.this$0).logTokenRequestEvent("card", TokenRepositoryImpl.access$getPublicKey$p(this.this$0));
                            var5_6 = this.$response;
                            this.L$0 = $this$launch;
                            this.L$1 = var5_6;
                            this.label = 1;
                            v0 = TokenRepositoryImpl.access$getNetworkApiClient$p(this.this$0).sendCardTokenRequest((TokenRequest)TokenRepositoryImpl.access$getCardToTokenRequestMapper$p(this.this$0).map(this.$cardTokenRequest.getCard()), (Continuation<? super NetworkApiResponse<TokenDetailsResponse>>)((Continuation)this));
                            if (v0 == var6_2) {
                                return var6_2;
                            }
                            ** GOTO lbl25
                        }
                        case 1: {
                            var5_6 = (Ref.ObjectRef<NetworkApiResponse<TokenDetailsResponse>>)this.L$1;
                            $this$launch = (CoroutineScope)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl25:
                            // 2 sources

                            var5_6.element = v0;
                            TokenRepositoryImpl.access$logResponse(this.this$0, (NetworkApiResponse)this.$response.element, "card");
                            TokenRepositoryImpl.access$getLogger$p(this.this$0).resetSession();
                            break block5;
                        }
                    }
                    throw new NoWhenBranchMatchedException();
                }
                tokenResult = TokenRepositoryImpl.access$getCardTokenizationNetworkDataMapper$p(this.this$0).toTokenResult((NetworkApiResponse)this.$response.element);
                BuildersKt.launch$default((CoroutineScope)$this$launch, (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, this.$tokenType, tokenResult, this.$cardTokenRequest, null){
                    int label;
                    final /* synthetic */ TokenRepositoryImpl this$0;
                    final /* synthetic */ String $tokenType;
                    final /* synthetic */ TokenResult<TokenDetails> $tokenResult;
                    final /* synthetic */ CardTokenRequest $cardTokenRequest;
                    {
                        this.this$0 = $receiver;
                        this.$tokenType = $tokenType;
                        this.$tokenResult = $tokenResult;
                        this.$cardTokenRequest = $cardTokenRequest;
                        super(2, $completion);
                    }

                    /*
                     * WARNING - void declaration
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                this.label = 1;
                                Object object3 = TokenRepositoryImpl.access$handleResponse(this.this$0, this.$tokenType, this.$tokenResult, this.$cardTokenRequest.getOnSuccess(), this.$cardTokenRequest.getOnFailure(), (Continuation)this);
                                if (object3 != object2) return Unit.INSTANCE;
                                return object2;
                            }
                            case 1: {
                                void $result;
                                ResultKt.throwOnFailure((Object)$result);
                                Object object3 = $result;
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)2, null);
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    @Override
    public void sendCVVTokenizationRequest(@NotNull CVVTokenizationRequest cvvTokenizationRequest) {
        Intrinsics.checkNotNullParameter((Object)cvvTokenizationRequest, (String)"cvvTokenizationRequest");
        Ref.ObjectRef response = new Ref.ObjectRef();
        CVVTokenizationRequest $this$sendCVVTokenizationRequest_u24lambda_u240 = cvvTokenizationRequest;
        boolean bl = false;
        BuildersKt.launch$default((CoroutineScope)this.networkCoroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>($this$sendCVVTokenizationRequest_u24lambda_u240, this, (Ref.ObjectRef<NetworkApiResponse<CVVTokenDetailsResponse>>)response, cvvTokenizationRequest, null){
            Object L$1;
            Object L$2;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ CVVTokenizationRequest $this_with;
            final /* synthetic */ TokenRepositoryImpl this$0;
            final /* synthetic */ Ref.ObjectRef<NetworkApiResponse<CVVTokenDetailsResponse>> $response;
            final /* synthetic */ CVVTokenizationRequest $cvvTokenizationRequest;
            {
                this.$this_with = $receiver;
                this.this$0 = $receiver2;
                this.$response = $response;
                this.$cvvTokenizationRequest = $cvvTokenizationRequest;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                block5: {
                    var8_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
                            $this$launch = (CoroutineScope)this.L$0;
                            tokenType = "cvv";
                            validateCVVRequest = new ValidateCVVTokenizationRequest(this.$this_with.getCvv(), this.$this_with.getCardScheme());
                            var6_7 = validationTokenizationDataResult = (ValidationResult)TokenRepositoryImpl.access$getValidateCVVTokenizationDataUseCase$p(this.this$0).execute(validateCVVRequest);
                            if (!(var6_7 instanceof ValidationResult.Failure)) ** GOTO lbl12
                            this.$response.element = new NetworkApiResponse.InternalError(((ValidationResult.Failure)validationTokenizationDataResult).getError());
                            break block5;
lbl12:
                            // 1 sources

                            if (!(var6_7 instanceof ValidationResult.Success)) break;
                            TokenRepositoryImpl.access$getLogger$p(this.this$0).logTokenRequestEvent(tokenType, TokenRepositoryImpl.access$getPublicKey$p(this.this$0));
                            var7_8 = this.$response;
                            this.L$0 = $this$launch;
                            this.L$1 = tokenType;
                            this.L$2 = var7_8;
                            this.label = 1;
                            v0 = TokenRepositoryImpl.access$getNetworkApiClient$p(this.this$0).sendCVVTokenRequest((CVVTokenNetworkRequest)TokenRepositoryImpl.access$getCvvToTokenNetworkRequestMapper$p(this.this$0).map(this.$cvvTokenizationRequest), (Continuation<? super NetworkApiResponse<CVVTokenDetailsResponse>>)((Continuation)this));
                            if (v0 == var8_2) {
                                return var8_2;
                            }
                            ** GOTO lbl29
                        }
                        case 1: {
                            var7_8 = (Ref.ObjectRef<NetworkApiResponse<CVVTokenDetailsResponse>>)this.L$2;
                            tokenType = (String)this.L$1;
                            $this$launch = (CoroutineScope)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl29:
                            // 2 sources

                            var7_8.element = v0;
                            TokenRepositoryImpl.access$logCVVTokenizationResponse(this.this$0, (NetworkApiResponse)this.$response.element);
                            TokenRepositoryImpl.access$getLogger$p(this.this$0).resetSession();
                            break block5;
                        }
                    }
                    throw new NoWhenBranchMatchedException();
                }
                tokenResult = TokenRepositoryImpl.access$getCvvTokenizationNetworkDataMapper$p(this.this$0).toTokenResult((NetworkApiResponse)this.$response.element);
                BuildersKt.launch$default((CoroutineScope)$this$launch, (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(tokenResult, this.this$0, tokenType, this.$this_with, null){
                    int label;
                    final /* synthetic */ TokenResult<CVVTokenDetails> $tokenResult;
                    final /* synthetic */ TokenRepositoryImpl this$0;
                    final /* synthetic */ String $tokenType;
                    final /* synthetic */ CVVTokenizationRequest $this_with;
                    {
                        this.$tokenResult = $tokenResult;
                        this.this$0 = $receiver;
                        this.$tokenType = $tokenType;
                        this.$this_with = $receiver2;
                        super(2, $completion);
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     * Unable to fully structure code
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object var1_1) {
                        block13: {
                            var8_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)var1_1);
                                    var2_3 = this.$tokenResult;
                                    if (!(var2_3 instanceof TokenResult.Success)) break;
                                    this.label = 1;
                                    v0 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)TokenRepositoryImpl.access$getDispatcher$p(this.this$0)), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, this.$tokenResult, null){
                                        int label;
                                        final /* synthetic */ TokenRepositoryImpl this$0;
                                        final /* synthetic */ TokenResult<CVVTokenDetails> $tokenResult;
                                        {
                                            this.this$0 = $receiver;
                                            this.$tokenResult = $tokenResult;
                                            super(2, $completion);
                                        }

                                        /*
                                         * WARNING - void declaration
                                         * Enabled force condition propagation
                                         * Lifted jumps to return sites
                                         */
                                        @Nullable
                                        public final Object invokeSuspend(@NotNull Object object) {
                                            Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                            switch (this.label) {
                                                case 0: {
                                                    ResultKt.throwOnFailure((Object)object);
                                                    this.label = 1;
                                                    Object object3 = TokenRepositoryImpl.access$getRiskSdkUseCase$p(this.this$0).execute((TokenResult<String>)new TokenResult.Success<String>(((CVVTokenDetails)((TokenResult.Success)this.$tokenResult).getResult()).getToken()), (Continuation<? super Unit>)((Continuation)this));
                                                    if (object3 != object2) return Unit.INSTANCE;
                                                    return object2;
                                                }
                                                case 1: {
                                                    void $result;
                                                    ResultKt.throwOnFailure((Object)$result);
                                                    Object object3 = $result;
                                                    return Unit.INSTANCE;
                                                }
                                            }
                                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                        }

                                        @NotNull
                                        public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                        }

                                        @Nullable
                                        public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                        }
                                    }), (Continuation)((Continuation)this));
                                    ** if (v0 != var8_2) goto lbl13
lbl12:
                                    // 1 sources

                                    return var8_2;
lbl13:
                                    // 1 sources

                                    ** GOTO lbl19
                                }
                                case 1: {
                                    try {
                                        ResultKt.throwOnFailure((Object)$result);
                                        v0 = $result;
                                    }
                                    catch (Exception exception) {
                                        TokenRepositoryImpl.access$getLogger$p(this.this$0).logErrorOnTokenRequestedEvent(this.$tokenType, TokenRepositoryImpl.access$getPublicKey$p(this.this$0), exception);
                                        break block13;
                                    }
lbl19:
                                    // 2 sources

                                    this.$this_with.getResultHandler().invoke((Object)new CVVTokenizationResultHandler.Success((CVVTokenDetails)((TokenResult.Success)this.$tokenResult).getResult()));
                                    break block13;
                                }
                                {
                                    finally {
                                        this.$this_with.getResultHandler().invoke((Object)new CVVTokenizationResultHandler.Success((CVVTokenDetails)((TokenResult.Success)this.$tokenResult).getResult()));
                                    }
                                }
                            }
                            if (var2_3 instanceof TokenResult.Failure) {
                                v1 = ((TokenResult.Failure)this.$tokenResult).getError().getMessage();
                                if (v1 != null) {
                                    var4_6 = v1;
                                    var5_7 = this.$this_with;
                                    it = var4_6;
                                    $i$a$-let-TokenRepositoryImpl$sendCVVTokenizationRequest$1$1$1$2 = false;
                                    var5_7.getResultHandler().invoke((Object)new CVVTokenizationResultHandler.Failure(it));
                                }
                            }
                        }
                        return Unit.INSTANCE;
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)2, null);
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    @Override
    public void sendGooglePayTokenRequest(@NotNull GooglePayTokenRequest googlePayTokenRequest) {
        Intrinsics.checkNotNullParameter((Object)googlePayTokenRequest, (String)"googlePayTokenRequest");
        Ref.ObjectRef response = new Ref.ObjectRef();
        String tokenType = "googlepay";
        BuildersKt.launch$default((CoroutineScope)this.networkCoroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, googlePayTokenRequest, (Ref.ObjectRef<NetworkApiResponse<TokenDetailsResponse>>)response, tokenType, null){
            Object L$1;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ TokenRepositoryImpl this$0;
            final /* synthetic */ GooglePayTokenRequest $googlePayTokenRequest;
            final /* synthetic */ Ref.ObjectRef<NetworkApiResponse<TokenDetailsResponse>> $response;
            final /* synthetic */ String $tokenType;
            {
                this.this$0 = $receiver;
                this.$googlePayTokenRequest = $googlePayTokenRequest;
                this.$response = $response;
                this.$tokenType = $tokenType;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var6_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        $this$launch = (CoroutineScope)this.L$0;
                        request = new GooglePayTokenNetworkRequest("googlepay", this.this$0.creatingTokenData(this.$googlePayTokenRequest.getTokenJsonPayload()));
                        TokenRepositoryImpl.access$getLogger$p(this.this$0).logTokenRequestEvent("googlepay", TokenRepositoryImpl.access$getPublicKey$p(this.this$0));
                        var5_6 = this.$response;
                        this.L$0 = $this$launch;
                        this.L$1 = var5_6;
                        this.label = 1;
                        v0 = TokenRepositoryImpl.access$getNetworkApiClient$p(this.this$0).sendGooglePayTokenRequest(request, (Continuation<? super NetworkApiResponse<TokenDetailsResponse>>)((Continuation)this));
                        ** if (v0 != var6_2) goto lbl17
lbl16:
                        // 1 sources

                        return var6_2;
lbl17:
                        // 1 sources

                        ** GOTO lbl25
                    }
                    case 1: {
                        var5_6 = (Ref.ObjectRef<NetworkApiResponse<TokenDetailsResponse>>)this.L$1;
                        $this$launch = (CoroutineScope)this.L$0;
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl25:
                            // 2 sources

                            var5_6.element = v0;
                            TokenRepositoryImpl.access$logResponse(this.this$0, (NetworkApiResponse)this.$response.element, "googlepay");
                            TokenRepositoryImpl.access$getLogger$p(this.this$0).resetSession();
                        }
                        catch (Exception exception) {
                            error = new TokenizationError("TokenizationError.Server:3005", exception.getMessage(), exception.getCause());
                            this.$response.element = new NetworkApiResponse.InternalError(error);
                            TokenRepositoryImpl.access$getLogger$p(this.this$0).logErrorOnTokenRequestedEvent("googlepay", TokenRepositoryImpl.access$getPublicKey$p(this.this$0), error);
                        }
                        tokenResult = TokenRepositoryImpl.access$getCardTokenizationNetworkDataMapper$p(this.this$0).toTokenResult((NetworkApiResponse)this.$response.element);
                        BuildersKt.launch$default((CoroutineScope)$this$launch, (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, this.$tokenType, tokenResult, this.$googlePayTokenRequest, null){
                            int label;
                            final /* synthetic */ TokenRepositoryImpl this$0;
                            final /* synthetic */ String $tokenType;
                            final /* synthetic */ TokenResult<TokenDetails> $tokenResult;
                            final /* synthetic */ GooglePayTokenRequest $googlePayTokenRequest;
                            {
                                this.this$0 = $receiver;
                                this.$tokenType = $tokenType;
                                this.$tokenResult = $tokenResult;
                                this.$googlePayTokenRequest = $googlePayTokenRequest;
                                super(2, $completion);
                            }

                            /*
                             * WARNING - void declaration
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            @Nullable
                            public final Object invokeSuspend(@NotNull Object object) {
                                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        this.label = 1;
                                        Object object3 = TokenRepositoryImpl.access$handleResponse(this.this$0, this.$tokenType, this.$tokenResult, this.$googlePayTokenRequest.getOnSuccess(), this.$googlePayTokenRequest.getOnFailure(), (Continuation)this);
                                        if (object3 != object2) return Unit.INSTANCE;
                                        return object2;
                                    }
                                    case 1: {
                                        void $result;
                                        ResultKt.throwOnFailure((Object)$result);
                                        Object object3 = $result;
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            @NotNull
                            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            @Nullable
                            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (int)2, null);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    @VisibleForTesting
    @NotNull
    public final GooglePayEntity creatingTokenData(@NotNull String tokenJsonPayload) throws JSONException {
        Intrinsics.checkNotNullParameter((Object)tokenJsonPayload, (String)"tokenJsonPayload");
        JSONObject tokenDataJsonObject = new JSONObject(tokenJsonPayload);
        return new GooglePayEntity(tokenDataJsonObject.getString("signature"), tokenDataJsonObject.getString("protocolVersion"), tokenDataJsonObject.getString("signedMessage"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private final Object handleResponse(String var1_1, TokenResult<TokenDetails> var2_2, Function1<? super TokenDetails, Unit> var3_3, Function1<? super String, Unit> var4_4, Continuation<? super Unit> var5_5) {
        block15: {
            if (!(var5_5 instanceof handleResponse.1)) ** GOTO lbl-1000
            var11_6 = var5_5;
            if ((var11_6.label & -2147483648) != 0) {
                var11_6.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, var5_5){
                    Object L$0;
                    Object L$1;
                    Object L$2;
                    Object L$3;
                    /* synthetic */ Object result;
                    final /* synthetic */ TokenRepositoryImpl this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return TokenRepositoryImpl.access$handleResponse(this.this$0, null, null, null, null, (Continuation)this);
                    }
                };
            }
            $result = $continuation.result;
            var12_8 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    var6_9 = tokenResult;
                    if (!(var6_9 instanceof TokenResult.Success)) break;
                    $continuation.L$0 = this;
                    $continuation.L$1 = tokenType;
                    $continuation.L$2 = tokenResult;
                    $continuation.L$3 = success;
                    $continuation.label = 1;
                    v0 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)this.dispatcher), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, (TokenResult<TokenDetails>)tokenResult, null){
                        int label;
                        final /* synthetic */ TokenRepositoryImpl this$0;
                        final /* synthetic */ TokenResult<TokenDetails> $tokenResult;
                        {
                            this.this$0 = $receiver;
                            this.$tokenResult = $tokenResult;
                            super(2, $completion);
                        }

                        /*
                         * WARNING - void declaration
                         * Enabled force condition propagation
                         * Lifted jumps to return sites
                         */
                        @Nullable
                        public final Object invokeSuspend(@NotNull Object object) {
                            Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)object);
                                    this.label = 1;
                                    Object object3 = TokenRepositoryImpl.access$getRiskSdkUseCase$p(this.this$0).execute((TokenResult<String>)new TokenResult.Success<String>(((TokenDetails)((TokenResult.Success)this.$tokenResult).getResult()).getToken()), (Continuation<? super Unit>)((Continuation)this));
                                    if (object3 != object2) return Unit.INSTANCE;
                                    return object2;
                                }
                                case 1: {
                                    void $result;
                                    ResultKt.throwOnFailure((Object)$result);
                                    Object object3 = $result;
                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        @NotNull
                        public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                        }

                        @Nullable
                        public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }), (Continuation)$continuation);
                    ** if (v0 != var12_8) goto lbl24
lbl23:
                    // 1 sources

                    return var12_8;
lbl24:
                    // 1 sources

                    ** GOTO lbl34
                }
                case 1: {
                    success = (Function1)$continuation.L$3;
                    tokenResult = (TokenResult)$continuation.L$2;
                    tokenType = (String)$continuation.L$1;
                    this = (TokenRepositoryImpl)$continuation.L$0;
                    try {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
                    }
                    catch (Exception exception) {
                        this.logger.logErrorOnTokenRequestedEvent(tokenType, this.publicKey, exception);
                        break block15;
                    }
lbl34:
                    // 2 sources

                    success.invoke(((TokenResult.Success)tokenResult).getResult());
                    break block15;
                }
                {
                    finally {
                        success.invoke(((TokenResult.Success)tokenResult).getResult());
                    }
                }
            }
            if (var6_9 instanceof TokenResult.Failure) {
                v1 = ((TokenResult.Failure)tokenResult).getError().getMessage();
                if (v1 != null) {
                    it = v1;
                    $i$a$-let-TokenRepositoryImpl$handleResponse$3 = false;
                    failure.invoke((Object)it);
                }
            }
        }
        return Unit.INSTANCE;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final void logResponse(NetworkApiResponse<TokenDetailsResponse> response, String tokenType) {
        NetworkApiResponse<TokenDetailsResponse> networkApiResponse = response;
        if (networkApiResponse instanceof NetworkApiResponse.ServerError) {
            this.logger.logTokenResponseEvent(tokenType, this.publicKey, null, null, ((NetworkApiResponse.ServerError)response).getCode(), ((NetworkApiResponse.ServerError)response).getBody());
        } else if (networkApiResponse instanceof NetworkApiResponse.Success) {
            TokenizationLogger.DefaultImpls.logTokenResponseEvent$default(this.logger, tokenType, this.publicKey, (TokenDetailsResponse)((NetworkApiResponse.Success)response).getBody(), null, null, null, 56, null);
        }
    }

    private final void logCVVTokenizationResponse(NetworkApiResponse<CVVTokenDetailsResponse> response) {
        NetworkApiResponse<CVVTokenDetailsResponse> networkApiResponse = response;
        if (networkApiResponse instanceof NetworkApiResponse.ServerError) {
            this.logger.logTokenResponseEvent("cvv", this.publicKey, null, null, ((NetworkApiResponse.ServerError)response).getCode(), ((NetworkApiResponse.ServerError)response).getBody());
        } else if (networkApiResponse instanceof NetworkApiResponse.Success) {
            TokenizationLogger.DefaultImpls.logTokenResponseEvent$default(this.logger, "cvv", this.publicKey, null, (CVVTokenDetailsResponse)((NetworkApiResponse.Success)response).getBody(), null, null, 48, null);
        }
    }

    public static final /* synthetic */ UseCase access$getValidateTokenizationDataUseCase$p(TokenRepositoryImpl $this) {
        return $this.validateTokenizationDataUseCase;
    }

    public static final /* synthetic */ TokenizationLogger access$getLogger$p(TokenRepositoryImpl $this) {
        return $this.logger;
    }

    public static final /* synthetic */ String access$getPublicKey$p(TokenRepositoryImpl $this) {
        return $this.publicKey;
    }

    public static final /* synthetic */ NetworkApiClient access$getNetworkApiClient$p(TokenRepositoryImpl $this) {
        return $this.networkApiClient;
    }

    public static final /* synthetic */ Mapper access$getCardToTokenRequestMapper$p(TokenRepositoryImpl $this) {
        return $this.cardToTokenRequestMapper;
    }

    public static final /* synthetic */ void access$logResponse(TokenRepositoryImpl $this, NetworkApiResponse response, String tokenType) {
        $this.logResponse(response, tokenType);
    }

    public static final /* synthetic */ TokenizationNetworkDataMapper access$getCardTokenizationNetworkDataMapper$p(TokenRepositoryImpl $this) {
        return $this.cardTokenizationNetworkDataMapper;
    }

    public static final /* synthetic */ Object access$handleResponse(TokenRepositoryImpl $this, String tokenType, TokenResult tokenResult, Function1 success, Function1 failure, Continuation $completion) {
        return $this.handleResponse(tokenType, tokenResult, (Function1<? super TokenDetails, Unit>)success, (Function1<? super String, Unit>)failure, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ RiskSdkUseCase access$getRiskSdkUseCase$p(TokenRepositoryImpl $this) {
        return $this.riskSdkUseCase;
    }

    public static final /* synthetic */ UseCase access$getValidateCVVTokenizationDataUseCase$p(TokenRepositoryImpl $this) {
        return $this.validateCVVTokenizationDataUseCase;
    }

    public static final /* synthetic */ Mapper access$getCvvToTokenNetworkRequestMapper$p(TokenRepositoryImpl $this) {
        return $this.cvvToTokenNetworkRequestMapper;
    }

    public static final /* synthetic */ void access$logCVVTokenizationResponse(TokenRepositoryImpl $this, NetworkApiResponse response) {
        $this.logCVVTokenizationResponse(response);
    }

    public static final /* synthetic */ TokenizationNetworkDataMapper access$getCvvTokenizationNetworkDataMapper$p(TokenRepositoryImpl $this) {
        return $this.cvvTokenizationNetworkDataMapper;
    }

    public static final /* synthetic */ CoroutineDispatcher access$getDispatcher$p(TokenRepositoryImpl $this) {
        return $this.dispatcher;
    }
}

