/*
 * Decompiled with CFR 0.152.
 */
package com.checkout.tokenization;

import com.checkout.base.error.CheckoutError;
import com.checkout.network.extension.OkHttpClientExtensionKt;
import com.checkout.network.response.ErrorResponse;
import com.checkout.network.response.NetworkApiResponse;
import com.checkout.tokenization.NetworkApiClient;
import com.checkout.tokenization.request.CVVTokenNetworkRequest;
import com.checkout.tokenization.request.GooglePayTokenNetworkRequest;
import com.checkout.tokenization.request.TokenRequest;
import com.checkout.tokenization.response.CVVTokenDetailsResponse;
import com.checkout.tokenization.response.TokenDetailsResponse;
import com.checkout.tokenization.utils.TokenizationConstants;
import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.Moshi;
import java.io.Closeable;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.BufferedSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000eJ\u001f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\n2\u0006\u0010\u0011\u001a\u00020\u0012H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0013J\u001f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00100\n2\u0006\u0010\u0015\u001a\u00020\u0016H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0017R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0018"}, d2={"Lcom/checkout/tokenization/TokenNetworkApiClient;", "Lcom/checkout/tokenization/NetworkApiClient;", "url", "", "okHttpClient", "Lokhttp3/OkHttpClient;", "moshiClient", "Lcom/squareup/moshi/Moshi;", "(Ljava/lang/String;Lokhttp3/OkHttpClient;Lcom/squareup/moshi/Moshi;)V", "sendCVVTokenRequest", "Lcom/checkout/network/response/NetworkApiResponse;", "Lcom/checkout/tokenization/response/CVVTokenDetailsResponse;", "cvvTokenNetworkRequest", "Lcom/checkout/tokenization/request/CVVTokenNetworkRequest;", "(Lcom/checkout/tokenization/request/CVVTokenNetworkRequest;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "sendCardTokenRequest", "Lcom/checkout/tokenization/response/TokenDetailsResponse;", "cardTokenRequest", "Lcom/checkout/tokenization/request/TokenRequest;", "(Lcom/checkout/tokenization/request/TokenRequest;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "sendGooglePayTokenRequest", "googlePayTokenNetworkRequest", "Lcom/checkout/tokenization/request/GooglePayTokenNetworkRequest;", "(Lcom/checkout/tokenization/request/GooglePayTokenNetworkRequest;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "checkout_release"})
@SourceDebugExtension(value={"SMAP\nTokenNetworkApiClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TokenNetworkApiClient.kt\ncom/checkout/tokenization/TokenNetworkApiClient\n+ 2 OkHttpClientExtension.kt\ncom/checkout/network/extension/OkHttpClientExtensionKt\n*L\n1#1,88:1\n27#2,6:89\n46#2,8:95\n34#2,5:103\n27#2,6:108\n46#2,8:114\n34#2,5:122\n27#2,6:127\n46#2,8:133\n34#2,5:141\n*S KotlinDebug\n*F\n+ 1 TokenNetworkApiClient.kt\ncom/checkout/tokenization/TokenNetworkApiClient\n*L\n39#1:89,6\n39#1:95,8\n39#1:103,5\n59#1:108,6\n59#1:114,8\n59#1:122,5\n81#1:127,6\n81#1:133,8\n81#1:141,5\n*E\n"})
public final class TokenNetworkApiClient
implements NetworkApiClient {
    @NotNull
    private final String url;
    @NotNull
    private final OkHttpClient okHttpClient;
    @NotNull
    private final Moshi moshiClient;

    public TokenNetworkApiClient(@NotNull String url, @NotNull OkHttpClient okHttpClient, @NotNull Moshi moshiClient) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)okHttpClient, (String)"okHttpClient");
        Intrinsics.checkNotNullParameter((Object)moshiClient, (String)"moshiClient");
        this.url = url;
        this.okHttpClient = okHttpClient;
        this.moshiClient = moshiClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @Nullable
    public Object sendCardTokenRequest(@NotNull TokenRequest cardTokenRequest, @NotNull Continuation<? super NetworkApiResponse<TokenDetailsResponse>> $completion) {
        JsonAdapter jsonTokenRequestAdapter = this.moshiClient.adapter(TokenRequest.class);
        String string = jsonTokenRequestAdapter.toJson((Object)cardTokenRequest);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toJson(...)");
        RequestBody requestBody = RequestBody.Companion.create(string, TokenizationConstants.INSTANCE.getJsonMediaType());
        Request request = new Request.Builder().url(this.url).post(requestBody).build();
        OkHttpClient okHttpClient = this.okHttpClient;
        JsonAdapter jsonAdapter = this.moshiClient.adapter(TokenDetailsResponse.class);
        Intrinsics.checkNotNullExpressionValue((Object)jsonAdapter, (String)"adapter(...)");
        JsonAdapter jsonAdapter2 = jsonAdapter;
        JsonAdapter jsonAdapter3 = this.moshiClient.adapter(ErrorResponse.class);
        Intrinsics.checkNotNullExpressionValue((Object)jsonAdapter3, (String)"adapter(...)");
        JsonAdapter jsonAdapter4 = jsonAdapter3;
        boolean $i$f$executeHttpRequest = false;
        try {
            void $this$executeHttpRequest$iv;
            Closeable closeable = (Closeable)$this$executeHttpRequest$iv.newCall(request).execute();
            Throwable throwable = null;
            try {
                NetworkApiResponse networkApiResponse;
                Response it$iv = (Response)closeable;
                boolean bl = false;
                if (it$iv.isSuccessful()) {
                    NetworkApiResponse.Success<Object> success;
                    void successAdapter$iv;
                    boolean $i$f$provideSuccessResult = false;
                    ResponseBody responseBody = it$iv.body();
                    ResponseBody responseBody2 = responseBody;
                    if (responseBody == null) throw new CheckoutError("NetworkError:2007", "Success response is null, can not be parsed", null, 4, null);
                    BufferedSource bufferedSource = responseBody2.source();
                    responseBody2 = bufferedSource;
                    if (bufferedSource == null) throw new CheckoutError("NetworkError:2007", "Success response is null, can not be parsed", null, 4, null);
                    ResponseBody it$iv$iv = responseBody2;
                    boolean bl2 = false;
                    Object object = successAdapter$iv.fromJson((BufferedSource)it$iv$iv);
                    if (object != null) {
                        Object successResponse$iv$iv = object;
                        boolean bl3 = false;
                        Intrinsics.checkNotNull((Object)successResponse$iv$iv);
                        success = new NetworkApiResponse.Success<Object>(successResponse$iv$iv);
                    } else {
                        success = null;
                    }
                    responseBody2 = success;
                    if (success == null) throw new CheckoutError("NetworkError:2007", "Success response is null, can not be parsed", null, 4, null);
                    networkApiResponse = (NetworkApiResponse)responseBody2;
                } else {
                    void errorAdapter$iv;
                    networkApiResponse = OkHttpClientExtensionKt.access$provideErrorResult(it$iv, (JsonAdapter)errorAdapter$iv);
                }
                NetworkApiResponse networkApiResponse2 = networkApiResponse;
                return networkApiResponse2;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (Throwable e$iv) {
            return new NetworkApiResponse.NetworkError(e$iv);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @Nullable
    public Object sendCVVTokenRequest(@NotNull CVVTokenNetworkRequest cvvTokenNetworkRequest, @NotNull Continuation<? super NetworkApiResponse<CVVTokenDetailsResponse>> $completion) {
        JsonAdapter jsonTokenRequestAdapter = this.moshiClient.adapter(CVVTokenNetworkRequest.class);
        String string = jsonTokenRequestAdapter.toJson((Object)cvvTokenNetworkRequest);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toJson(...)");
        RequestBody requestBody = RequestBody.Companion.create(string, TokenizationConstants.INSTANCE.getJsonMediaType());
        Request request = new Request.Builder().url(this.url).post(requestBody).build();
        OkHttpClient okHttpClient = this.okHttpClient;
        JsonAdapter jsonAdapter = this.moshiClient.adapter(CVVTokenDetailsResponse.class);
        Intrinsics.checkNotNullExpressionValue((Object)jsonAdapter, (String)"adapter(...)");
        JsonAdapter jsonAdapter2 = jsonAdapter;
        JsonAdapter jsonAdapter3 = this.moshiClient.adapter(ErrorResponse.class);
        Intrinsics.checkNotNullExpressionValue((Object)jsonAdapter3, (String)"adapter(...)");
        JsonAdapter jsonAdapter4 = jsonAdapter3;
        boolean $i$f$executeHttpRequest = false;
        try {
            void $this$executeHttpRequest$iv;
            Closeable closeable = (Closeable)$this$executeHttpRequest$iv.newCall(request).execute();
            Throwable throwable = null;
            try {
                NetworkApiResponse networkApiResponse;
                Response it$iv = (Response)closeable;
                boolean bl = false;
                if (it$iv.isSuccessful()) {
                    NetworkApiResponse.Success<Object> success;
                    void successAdapter$iv;
                    boolean $i$f$provideSuccessResult = false;
                    ResponseBody responseBody = it$iv.body();
                    ResponseBody responseBody2 = responseBody;
                    if (responseBody == null) throw new CheckoutError("NetworkError:2007", "Success response is null, can not be parsed", null, 4, null);
                    BufferedSource bufferedSource = responseBody2.source();
                    responseBody2 = bufferedSource;
                    if (bufferedSource == null) throw new CheckoutError("NetworkError:2007", "Success response is null, can not be parsed", null, 4, null);
                    ResponseBody it$iv$iv = responseBody2;
                    boolean bl2 = false;
                    Object object = successAdapter$iv.fromJson((BufferedSource)it$iv$iv);
                    if (object != null) {
                        Object successResponse$iv$iv = object;
                        boolean bl3 = false;
                        Intrinsics.checkNotNull((Object)successResponse$iv$iv);
                        success = new NetworkApiResponse.Success<Object>(successResponse$iv$iv);
                    } else {
                        success = null;
                    }
                    responseBody2 = success;
                    if (success == null) throw new CheckoutError("NetworkError:2007", "Success response is null, can not be parsed", null, 4, null);
                    networkApiResponse = (NetworkApiResponse)responseBody2;
                } else {
                    void errorAdapter$iv;
                    networkApiResponse = OkHttpClientExtensionKt.access$provideErrorResult(it$iv, (JsonAdapter)errorAdapter$iv);
                }
                NetworkApiResponse networkApiResponse2 = networkApiResponse;
                return networkApiResponse2;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (Throwable e$iv) {
            return new NetworkApiResponse.NetworkError(e$iv);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @Nullable
    public Object sendGooglePayTokenRequest(@NotNull GooglePayTokenNetworkRequest googlePayTokenNetworkRequest, @NotNull Continuation<? super NetworkApiResponse<TokenDetailsResponse>> $completion) {
        JsonAdapter jsonGooglePayTokenRequestAdapter = this.moshiClient.adapter(GooglePayTokenNetworkRequest.class);
        String string = jsonGooglePayTokenRequestAdapter.toJson((Object)googlePayTokenNetworkRequest);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toJson(...)");
        RequestBody requestBody = RequestBody.Companion.create(string, TokenizationConstants.INSTANCE.getJsonMediaType());
        Request request = new Request.Builder().url(this.url).post(requestBody).build();
        OkHttpClient okHttpClient = this.okHttpClient;
        JsonAdapter jsonAdapter = this.moshiClient.adapter(TokenDetailsResponse.class);
        Intrinsics.checkNotNullExpressionValue((Object)jsonAdapter, (String)"adapter(...)");
        JsonAdapter jsonAdapter2 = jsonAdapter;
        JsonAdapter jsonAdapter3 = this.moshiClient.adapter(ErrorResponse.class);
        Intrinsics.checkNotNullExpressionValue((Object)jsonAdapter3, (String)"adapter(...)");
        JsonAdapter jsonAdapter4 = jsonAdapter3;
        boolean $i$f$executeHttpRequest = false;
        try {
            void $this$executeHttpRequest$iv;
            Closeable closeable = (Closeable)$this$executeHttpRequest$iv.newCall(request).execute();
            Throwable throwable = null;
            try {
                NetworkApiResponse networkApiResponse;
                Response it$iv = (Response)closeable;
                boolean bl = false;
                if (it$iv.isSuccessful()) {
                    NetworkApiResponse.Success<Object> success;
                    void successAdapter$iv;
                    boolean $i$f$provideSuccessResult = false;
                    ResponseBody responseBody = it$iv.body();
                    ResponseBody responseBody2 = responseBody;
                    if (responseBody == null) throw new CheckoutError("NetworkError:2007", "Success response is null, can not be parsed", null, 4, null);
                    BufferedSource bufferedSource = responseBody2.source();
                    responseBody2 = bufferedSource;
                    if (bufferedSource == null) throw new CheckoutError("NetworkError:2007", "Success response is null, can not be parsed", null, 4, null);
                    ResponseBody it$iv$iv = responseBody2;
                    boolean bl2 = false;
                    Object object = successAdapter$iv.fromJson((BufferedSource)it$iv$iv);
                    if (object != null) {
                        Object successResponse$iv$iv = object;
                        boolean bl3 = false;
                        Intrinsics.checkNotNull((Object)successResponse$iv$iv);
                        success = new NetworkApiResponse.Success<Object>(successResponse$iv$iv);
                    } else {
                        success = null;
                    }
                    responseBody2 = success;
                    if (success == null) throw new CheckoutError("NetworkError:2007", "Success response is null, can not be parsed", null, 4, null);
                    networkApiResponse = (NetworkApiResponse)responseBody2;
                } else {
                    void errorAdapter$iv;
                    networkApiResponse = OkHttpClientExtensionKt.access$provideErrorResult(it$iv, (JsonAdapter)errorAdapter$iv);
                }
                NetworkApiResponse networkApiResponse2 = networkApiResponse;
                return networkApiResponse2;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (Throwable e$iv) {
            return new NetworkApiResponse.NetworkError(e$iv);
        }
    }
}

