/*
 * Decompiled with CFR 0.152.
 */
package com.checkout.logging;

import android.content.Context;
import androidx.annotation.VisibleForTesting;
import com.checkout.base.model.Environment;
import com.checkout.eventlogger.CheckoutEventLogger;
import com.checkout.eventlogger.domain.model.Event;
import com.checkout.eventlogger.domain.model.RemoteProcessorMetadata;
import com.checkout.logging.Logger;
import com.checkout.logging.model.LoggingEvent;
import com.checkout.logging.utils.EnvironmentExtensionKt;
import java.util.HashSet;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0002H\u0016J\u0010\u0010\u001e\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0002H\u0016J(\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u00072\u0006\u0010&\u001a\u00020\u0007H\u0002J\b\u0010'\u001a\u00020\u001cH\u0016J(\u0010(\u001a\u00020\u001c2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u00072\u0006\u0010&\u001a\u00020\u0007H\u0016R$\u0010\u0006\u001a\u00020\u00078\u0016@\u0016X\u0097.\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\b\u0010\t\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u000e\u001a\u00020\u000f8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u0010\u0010\t\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R,\u0010\u0015\u001a\u0012\u0012\u0004\u0012\u00020\u00070\u0016j\b\u0012\u0004\u0012\u00020\u0007`\u00178\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0018\u0010\t\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006)"}, d2={"Lcom/checkout/logging/EventLogger;", "Lcom/checkout/logging/Logger;", "Lcom/checkout/logging/model/LoggingEvent;", "logger", "Lcom/checkout/eventlogger/CheckoutEventLogger;", "(Lcom/checkout/eventlogger/CheckoutEventLogger;)V", "correlationId", "", "getCorrelationId$annotations", "()V", "getCorrelationId", "()Ljava/lang/String;", "setCorrelationId", "(Ljava/lang/String;)V", "needToSetup", "", "getNeedToSetup$annotations", "getNeedToSetup", "()Z", "setNeedToSetup", "(Z)V", "sentLogs", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "getSentLogs$annotations", "getSentLogs", "()Ljava/util/HashSet;", "log", "", "event", "logOnce", "provideProcessorMetadata", "Lcom/checkout/eventlogger/domain/model/RemoteProcessorMetadata;", "context", "Landroid/content/Context;", "environment", "Lcom/checkout/base/model/Environment;", "identifier", "version", "resetSession", "setup", "checkout_release"})
public final class EventLogger
implements Logger<LoggingEvent> {
    @NotNull
    private final CheckoutEventLogger logger;
    @NotNull
    private final HashSet<String> sentLogs;
    private boolean needToSetup;
    public String correlationId;

    public EventLogger(@NotNull CheckoutEventLogger logger) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.logger = logger;
        this.sentLogs = new HashSet();
        this.needToSetup = true;
    }

    @NotNull
    public final HashSet<String> getSentLogs() {
        return this.sentLogs;
    }

    @VisibleForTesting
    public static /* synthetic */ void getSentLogs$annotations() {
    }

    public final boolean getNeedToSetup() {
        return this.needToSetup;
    }

    public final void setNeedToSetup(boolean bl) {
        this.needToSetup = bl;
    }

    @VisibleForTesting
    public static /* synthetic */ void getNeedToSetup$annotations() {
    }

    @Override
    @NotNull
    public String getCorrelationId() {
        String string = this.correlationId;
        if (string != null) {
            return string;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"correlationId");
        return null;
    }

    @Override
    public void setCorrelationId(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.correlationId = string;
    }

    @VisibleForTesting
    public static /* synthetic */ void getCorrelationId$annotations() {
    }

    @Override
    public void setup(@NotNull Context context, @NotNull Environment environment, @NotNull String identifier, @NotNull String version) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)((Object)environment), (String)"environment");
        Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        if (this.needToSetup) {
            this.logger.enableRemoteProcessor(EnvironmentExtensionKt.toLoggingEnvironment(environment), this.provideProcessorMetadata(context, environment, identifier, version));
            this.resetSession();
            this.needToSetup = false;
        }
    }

    @Override
    public void resetSession() {
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        this.setCorrelationId(string);
        this.logger.addMetadata("CORRELATION_ID", this.getCorrelationId());
        this.sentLogs.clear();
    }

    @Override
    public void log(@NotNull LoggingEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Event[] eventArray = new Event[]{event};
        this.logger.logEvent(eventArray);
    }

    @Override
    public void logOnce(@NotNull LoggingEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (this.sentLogs.add(event.getEventType$checkout_release().getEventId())) {
            this.log(event);
        }
    }

    private final RemoteProcessorMetadata provideProcessorMetadata(Context context, Environment environment, String identifier, String version) {
        return RemoteProcessorMetadata.Companion.from(context, EnvironmentExtensionKt.toLoggingName(environment), identifier, version);
    }
}

