/*
 * Decompiled with CFR 0.152.
 */
package com.checkout.validation.validator;

import com.checkout.validation.validator.contract.Checker;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016J\u0010\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0002H\u0002\u00a8\u0006\t"}, d2={"Lcom/checkout/validation/validator/LuhnChecker;", "Lcom/checkout/validation/validator/contract/Checker;", "", "()V", "check", "", "data", "checkLuhn", "number", "checkout_release"})
public final class LuhnChecker
implements Checker<String> {
    @Override
    public boolean check(@NotNull String data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return this.checkLuhn(data);
    }

    private final boolean checkLuhn(String number) {
        String reversedNumber = ((Object)StringsKt.reversed((CharSequence)number)).toString();
        int oddSum = 0;
        int evenSum = 0;
        int n = reversedNumber.length();
        for (int i = 0; i < n; ++i) {
            Integer n2 = CharsKt.digitToIntOrNull((char)reversedNumber.charAt(i));
            if (n2 == null) {
                return false;
            }
            int digit = n2;
            if (i % 2 == 0) {
                oddSum += digit;
                continue;
            }
            evenSum += digit / 5 + 2 * digit % 10;
        }
        return (oddSum + evenSum) % 10 == 0;
    }
}

