/*
 * Decompiled with CFR 0.152.
 */
package com.checkout.tokenization.usecase;

import com.checkout.base.mapper.Mapper;
import com.checkout.base.model.CardScheme;
import com.checkout.base.usecase.UseCase;
import com.checkout.tokenization.model.Address;
import com.checkout.tokenization.model.Card;
import com.checkout.tokenization.model.ExpiryDate;
import com.checkout.tokenization.model.Phone;
import com.checkout.validation.api.CardValidator;
import com.checkout.validation.model.AddressValidationRequest;
import com.checkout.validation.model.PhoneValidationRequest;
import com.checkout.validation.model.ValidationResult;
import com.checkout.validation.validator.contract.Validator;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0000\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u0001BI\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b\u0012\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\b\u0012\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\t0\u000f\u00a2\u0006\u0002\u0010\u0010J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0012\u001a\u00020\u0002H\u0016J\u0014\u0010\u0013\u001a\u0004\u0018\u00010\t2\b\u0010\u0014\u001a\u0004\u0018\u00010\nH\u0002J\u0014\u0010\u0015\u001a\u0004\u0018\u00010\f2\b\u0010\u0016\u001a\u0004\u0018\u00010\rH\u0002R\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\t0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/checkout/tokenization/usecase/ValidateTokenizationDataUseCase;", "Lcom/checkout/base/usecase/UseCase;", "Lcom/checkout/tokenization/model/Card;", "Lcom/checkout/validation/model/ValidationResult;", "", "cardValidator", "Lcom/checkout/validation/api/CardValidator;", "addressValidator", "Lcom/checkout/validation/validator/contract/Validator;", "Lcom/checkout/validation/model/AddressValidationRequest;", "Lcom/checkout/tokenization/model/Address;", "phoneValidator", "Lcom/checkout/validation/model/PhoneValidationRequest;", "Lcom/checkout/tokenization/model/Phone;", "addressToAddressValidationRequestDataMapper", "Lcom/checkout/base/mapper/Mapper;", "(Lcom/checkout/validation/api/CardValidator;Lcom/checkout/validation/validator/contract/Validator;Lcom/checkout/validation/validator/contract/Validator;Lcom/checkout/base/mapper/Mapper;)V", "execute", "data", "provideAddressValidationRequest", "address", "providePhoneValidationRequest", "phone", "checkout_release"})
public final class ValidateTokenizationDataUseCase
implements UseCase<Card, ValidationResult<? extends Unit>> {
    @NotNull
    private final CardValidator cardValidator;
    @NotNull
    private final Validator<AddressValidationRequest, Address> addressValidator;
    @NotNull
    private final Validator<PhoneValidationRequest, Phone> phoneValidator;
    @NotNull
    private final Mapper<Address, AddressValidationRequest> addressToAddressValidationRequestDataMapper;

    public ValidateTokenizationDataUseCase(@NotNull CardValidator cardValidator, @NotNull Validator<AddressValidationRequest, Address> addressValidator, @NotNull Validator<PhoneValidationRequest, Phone> phoneValidator, @NotNull Mapper<Address, AddressValidationRequest> addressToAddressValidationRequestDataMapper) {
        Intrinsics.checkNotNullParameter((Object)cardValidator, (String)"cardValidator");
        Intrinsics.checkNotNullParameter(addressValidator, (String)"addressValidator");
        Intrinsics.checkNotNullParameter(phoneValidator, (String)"phoneValidator");
        Intrinsics.checkNotNullParameter(addressToAddressValidationRequestDataMapper, (String)"addressToAddressValidationRequestDataMapper");
        this.cardValidator = cardValidator;
        this.addressValidator = addressValidator;
        this.phoneValidator = phoneValidator;
        this.addressToAddressValidationRequestDataMapper = addressToAddressValidationRequestDataMapper;
    }

    @Override
    @NotNull
    public ValidationResult<Unit> execute(@NotNull Card data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Object scheme = null;
        ValidationResult<CardScheme> $this$execute_u24lambda_u2d0 = this.cardValidator.validateCardNumber(data.getNumber());
        boolean bl = false;
        Object object = $this$execute_u24lambda_u2d0;
        if (object instanceof ValidationResult.Failure) {
            return $this$execute_u24lambda_u2d0;
        }
        if (!(object instanceof ValidationResult.Success)) {
            throw new NoWhenBranchMatchedException();
        }
        scheme = ((ValidationResult.Success)$this$execute_u24lambda_u2d0).getValue();
        ValidationResult<ExpiryDate> $this$execute_u24lambda_u2d1 = this.cardValidator.validateExpiryDate(data.getExpiryDate().getExpiryMonth(), data.getExpiryDate().getExpiryYear());
        boolean bl2 = false;
        if ($this$execute_u24lambda_u2d1 instanceof ValidationResult.Failure) {
            return $this$execute_u24lambda_u2d1;
        }
        String string = data.getCvv();
        if (string == null) {
            string = "";
        }
        ValidationResult<Unit> $this$execute_u24lambda_u2d2 = this.cardValidator.validateCvv(string, scheme);
        boolean bl3 = false;
        if ($this$execute_u24lambda_u2d2 instanceof ValidationResult.Failure && !((object = (CharSequence)data.getCvv()) == null || object.length() == 0)) {
            return $this$execute_u24lambda_u2d2;
        }
        AddressValidationRequest addressValidationRequest = this.provideAddressValidationRequest(data.getBillingAddress());
        if (addressValidationRequest != null) {
            AddressValidationRequest it = addressValidationRequest;
            boolean bl4 = false;
            ValidationResult<Address> $this$execute_u24lambda_u2d4_u24lambda_u2d3 = this.addressValidator.validate(it);
            boolean bl5 = false;
            if ($this$execute_u24lambda_u2d4_u24lambda_u2d3 instanceof ValidationResult.Failure) {
                return $this$execute_u24lambda_u2d4_u24lambda_u2d3;
            }
        }
        PhoneValidationRequest phoneValidationRequest = this.providePhoneValidationRequest(data.getPhone());
        if (phoneValidationRequest != null) {
            PhoneValidationRequest it = phoneValidationRequest;
            boolean bl6 = false;
            ValidationResult<Phone> $this$execute_u24lambda_u2d6_u24lambda_u2d5 = this.phoneValidator.validate(it);
            boolean bl7 = false;
            if ($this$execute_u24lambda_u2d6_u24lambda_u2d5 instanceof ValidationResult.Failure) {
                return $this$execute_u24lambda_u2d6_u24lambda_u2d5;
            }
        }
        return new ValidationResult.Success<Unit>(Unit.INSTANCE);
    }

    private final AddressValidationRequest provideAddressValidationRequest(Address address) {
        AddressValidationRequest addressValidationRequest;
        Address address2 = address;
        if (address2 != null) {
            Address it = address2;
            boolean bl = false;
            addressValidationRequest = this.addressToAddressValidationRequestDataMapper.map(it);
        } else {
            addressValidationRequest = null;
        }
        return addressValidationRequest;
    }

    private final PhoneValidationRequest providePhoneValidationRequest(Phone phone) {
        PhoneValidationRequest phoneValidationRequest;
        Phone phone2 = phone;
        if (phone2 != null) {
            Phone it = phone2;
            boolean bl = false;
            phoneValidationRequest = new PhoneValidationRequest(it.getNumber(), it.getCountry());
        } else {
            phoneValidationRequest = null;
        }
        return phoneValidationRequest;
    }
}

