/*
 * Decompiled with CFR 0.152.
 */
package com.cx.restclient;

import com.checkmarx.sdk.config.AstProperties;
import com.checkmarx.sdk.dto.ast.ASTResults;
import com.checkmarx.sdk.dto.ast.ASTResultsWrapper;
import com.checkmarx.sdk.dto.ast.SCAResults;
import com.checkmarx.sdk.dto.ast.ScanParams;
import com.checkmarx.sdk.exception.ASTRuntimeException;
import com.cx.restclient.AbstractAstClient;
import com.cx.restclient.ast.dto.common.ASTConfig;
import com.cx.restclient.ast.dto.sast.AstSastConfig;
import com.cx.restclient.ast.dto.sast.AstSastResults;
import com.cx.restclient.ast.dto.sast.report.AstSastSummaryResults;
import com.cx.restclient.configuration.CxScanConfig;
import com.cx.restclient.dto.ScanResults;
import com.cx.restclient.dto.ScannerType;
import org.modelmapper.ModelMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class AstClientImpl
extends AbstractAstClient {
    private static final Logger log = LoggerFactory.getLogger(AstClientImpl.class);
    private final AstProperties astProperties;

    @Override
    protected void applyFilterToResults(ASTResultsWrapper combinedResults, ScanParams scanParams) {
    }

    @Override
    protected ASTResultsWrapper toResults(ScanResults scanResults) {
        this.validateNotNull(scanResults.getAstResults());
        ModelMapper mapper = new ModelMapper();
        ASTResults astResults = (ASTResults)mapper.map((Object)scanResults.getAstResults(), ASTResults.class);
        return new ASTResultsWrapper(new SCAResults(), astResults);
    }

    @Override
    public ASTResultsWrapper getLatestScanResults(ScanParams scanParams) {
        log.warn("Getting latest AST scan results is not implemented yet.");
        return new ASTResultsWrapper();
    }

    private void validateNotNull(AstSastResults astResults) {
        if (astResults == null) {
            throw new ASTRuntimeException("AST results are missing.");
        }
        AstSastSummaryResults summary = astResults.getSummary();
        if (summary == null) {
            throw new ASTRuntimeException("AST results don't contain a summary.");
        }
    }

    @Override
    protected CxScanConfig getScanConfig(ScanParams scanParams) {
        CxScanConfig cxScanConfig = new CxScanConfig();
        cxScanConfig.addScannerType(ScannerType.AST_SAST);
        cxScanConfig.setSastEnabled(false);
        cxScanConfig.setProjectName(scanParams.getProjectName());
        AstSastConfig astConfig = this.getAstSpecificConfig();
        AstClientImpl.setSourceLocation(scanParams, cxScanConfig, (ASTConfig)astConfig);
        cxScanConfig.setAstSastConfig(astConfig);
        return cxScanConfig;
    }

    private AstSastConfig getAstSpecificConfig() {
        return ((AstSastConfig.AstSastConfigBuilder)((AstSastConfig.AstSastConfigBuilder)AstSastConfig.builder().apiUrl(this.astProperties.getApiUrl())).webAppUrl(this.astProperties.getWebAppUrl())).clientId(this.astProperties.getClientId()).clientSecret(this.astProperties.getClientSecret()).presetName(this.astProperties.getPreset()).incremental(Boolean.parseBoolean(this.astProperties.getIncremental())).build();
    }

    @Override
    protected void validate(ScanParams scanParams) {
        if (scanParams == null) {
            throw new ASTRuntimeException(String.format("%s Scan parameters weren't provided.", "Scan cannot be initiated."));
        }
        this.validateNotEmpty(this.astProperties.getApiUrl(), "AST API URL");
        this.validateNotEmpty(this.astProperties.getClientId(), "AST client ID");
        this.validateNotEmpty(this.astProperties.getClientSecret(), "AST client secret");
        this.validateNotEmpty(this.astProperties.getPreset(), "AST preset");
        this.validateNotEmpty(this.astProperties.getIncremental(), "Is Incremental flag");
    }

    public AstClientImpl(AstProperties astProperties) {
        this.astProperties = astProperties;
    }
}

