/*
 * Decompiled with CFR 0.152.
 */
package com.checkmarx.sdk.utils;

import com.checkmarx.sdk.dto.CxConfig;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.List;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScanUtils {
    private static final Logger log = LoggerFactory.getLogger(ScanUtils.class);

    protected static boolean fileListContains(List<String> list, String value) {
        for (String s : list) {
            if (!s.endsWith(value)) continue;
            return true;
        }
        return false;
    }

    public static boolean empty(String str) {
        return str == null || str.isEmpty();
    }

    protected static boolean anyEmpty(String ... str) {
        for (String s : str) {
            if (!ScanUtils.empty(s)) continue;
            return true;
        }
        return false;
    }

    public static boolean empty(List list) {
        if (list == null) {
            return true;
        }
        return list.isEmpty();
    }

    public static boolean emptyObj(Object object) {
        if (object == null) {
            return true;
        }
        if (object instanceof List) {
            return ScanUtils.empty((List)object);
        }
        if (object instanceof String) {
            return ScanUtils.empty((String)object);
        }
        return false;
    }

    public static String cleanStringUTF8(String dirty) {
        log.debug("" + dirty.length());
        return new String(dirty.getBytes(), 0, dirty.length(), StandardCharsets.UTF_8);
    }

    public static String cleanStringUTF8_2(String dirty) {
        return new String(dirty.getBytes(), StandardCharsets.UTF_8);
    }

    public static void writeByte(String filename, byte[] bytes) {
        try {
            FileOutputStream os = new FileOutputStream(new File(filename));
            ((OutputStream)os).write(bytes);
            ((OutputStream)os).close();
        }
        catch (IOException e) {
            log.error("Error while writing file {} - {}", (Object)filename, (Object)ExceptionUtils.getMessage((Throwable)e));
        }
    }

    public static String getHostWithProtocol(String url) {
        String hostWithProtocol = null;
        try {
            URI uri = new URI(url);
            int port = uri.getPort();
            hostWithProtocol = uri.getScheme() + "://" + uri.getHost() + (port > 0 ? ":" + port : "");
        }
        catch (URISyntaxException e) {
            log.debug("Could not parse given URL" + url, (Throwable)e);
        }
        return hostWithProtocol;
    }

    public static CxConfig getConfigAsCode(File jsonConfig) {
        try {
            String config = new String(Files.readAllBytes(jsonConfig.toPath()));
            return ScanUtils.getConfigAsCode(config);
        }
        catch (IOException e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
            return null;
        }
    }

    public static CxConfig getConfigAsCode(String jsonConfig) {
        log.debug("Loading CxConfig: {}", (Object)jsonConfig);
        CxConfig cxConfig = null;
        ObjectMapper mapper = new ObjectMapper();
        try {
            cxConfig = (CxConfig)mapper.readValue(jsonConfig, CxConfig.class);
        }
        catch (IOException e) {
            log.warn("Error parsing CxConfig file: {}", (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
        }
        return cxConfig;
    }
}

