/*
 * Decompiled with CFR 0.152.
 */
package com.checkmarx.sdk.dto.filtering;

import com.checkmarx.sdk.dto.Filter;
import com.checkmarx.sdk.dto.filtering.EngineFilterConfiguration;
import java.util.List;

public class FilterConfiguration {
    private EngineFilterConfiguration sastFilters;
    private EngineFilterConfiguration scaFilters;

    public static FilterConfiguration fromSimpleFilters(List<Filter> simpleFilters) {
        return FilterConfiguration.builder().sastFilters(EngineFilterConfiguration.builder().simpleFilters(simpleFilters).build()).build();
    }

    FilterConfiguration(EngineFilterConfiguration sastFilters, EngineFilterConfiguration scaFilters) {
        this.sastFilters = sastFilters;
        this.scaFilters = scaFilters;
    }

    public static FilterConfigurationBuilder builder() {
        return new FilterConfigurationBuilder();
    }

    public EngineFilterConfiguration getSastFilters() {
        return this.sastFilters;
    }

    public EngineFilterConfiguration getScaFilters() {
        return this.scaFilters;
    }

    public void setSastFilters(EngineFilterConfiguration sastFilters) {
        this.sastFilters = sastFilters;
    }

    public void setScaFilters(EngineFilterConfiguration scaFilters) {
        this.scaFilters = scaFilters;
    }

    public String toString() {
        return "FilterConfiguration(sastFilters=" + this.getSastFilters() + ", scaFilters=" + this.getScaFilters() + ")";
    }

    public static class FilterConfigurationBuilder {
        private EngineFilterConfiguration sastFilters;
        private EngineFilterConfiguration scaFilters;

        FilterConfigurationBuilder() {
        }

        public FilterConfigurationBuilder sastFilters(EngineFilterConfiguration sastFilters) {
            this.sastFilters = sastFilters;
            return this;
        }

        public FilterConfigurationBuilder scaFilters(EngineFilterConfiguration scaFilters) {
            this.scaFilters = scaFilters;
            return this;
        }

        public FilterConfiguration build() {
            return new FilterConfiguration(this.sastFilters, this.scaFilters);
        }

        public String toString() {
            return "FilterConfiguration.FilterConfigurationBuilder(sastFilters=" + this.sastFilters + ", scaFilters=" + this.scaFilters + ")";
        }
    }
}

