/*
 * Decompiled with CFR 0.152.
 */
package com.chartbeat.androidsdk;

import android.content.Context;
import android.content.SharedPreferences;
import com.chartbeat.androidsdk.Logger;
import com.chartbeat.androidsdk.SecurityUtils;
import com.chartbeat.androidsdk.SubscriptionState;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import rx.Observable;
import rx.Observer;
import rx.schedulers.Schedulers;

final class UserInfo {
    private static final String TAG = "Chartbeat userdata";
    private static final int USER_ID_CHAR_LENGTH = 18;
    private static final int DAYS_TO_TRACK_VISITS = 16;
    private static final int DAYS_TO_REMEMBER_USER = 30;
    private static final int MINUTES_TO_TRACK_NEW_USER = 30;
    private static final String KEY_USER_ID = "userid";
    private static final String KEY_USER_CREATION_BY_ID = "created-";
    private static final String KEY_USER_LAST_VISIT_TIME_BY_ID = "visits-";
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd", Locale.US);
    protected SharedPreferences prefs;
    private final String userID;
    private GregorianCalendar userCreated;
    private boolean isNewUser;
    private SubscriptionState subscriptionState;
    private TreeSet<GregorianCalendar> visitedDates;

    UserInfo(Context context) {
        GregorianCalendar creationDate;
        if (context == null) {
            throw new NullPointerException("Activity or application context cannot be null");
        }
        this.prefs = context.getSharedPreferences("com.chartbeat.androidsdk.user", 0);
        String storedUserID = this.prefs.getString(KEY_USER_ID, null);
        String userCreatedString = this.prefs.getString(KEY_USER_CREATION_BY_ID + storedUserID, null);
        if (storedUserID == null || userCreatedString == null) {
            storedUserID = this.createUser();
            creationDate = UserInfo.today();
            this.storeUser(storedUserID, creationDate);
            this.isNewUser = true;
        } else {
            GregorianCalendar thirtyDaysAgo;
            creationDate = this.getCreationDate(userCreatedString);
            if (creationDate.compareTo(thirtyDaysAgo = UserInfo.pastDate(30, 0, 0)) >= 0) {
                this.isNewUser = false;
            } else {
                this.isNewUser = true;
                if (storedUserID == null) {
                    storedUserID = this.createUser();
                }
                this.storeUser(storedUserID, UserInfo.today());
                Observable.timer((long)30L, (TimeUnit)TimeUnit.MINUTES).subscribeOn(Schedulers.io()).observeOn(Schedulers.io()).subscribe((Observer)new Observer<Long>(){

                    public void onCompleted() {
                    }

                    public void onError(Throwable e) {
                        e.printStackTrace();
                    }

                    public void onNext(Long aLong) {
                        UserInfo.this.markUserAsOld();
                    }
                });
            }
        }
        this.userID = storedUserID;
        this.userCreated = creationDate;
        this.visitedDates = this.getVisitDates(this.userID);
    }

    private String createUser() {
        String newUserID = SecurityUtils.randomChars(18);
        return newUserID;
    }

    private void storeUser(String userID, GregorianCalendar userCreated) {
        String usrCreatedString = DATE_FORMAT.format(userCreated.getTime());
        SharedPreferences.Editor editor = this.prefs.edit();
        editor.putString(KEY_USER_ID, userID);
        editor.putString(KEY_USER_CREATION_BY_ID + userID, usrCreatedString);
        editor.commit();
    }

    private GregorianCalendar getCreationDate(String createdDateString) {
        GregorianCalendar creationDate = new GregorianCalendar();
        try {
            creationDate.setTime(DATE_FORMAT.parse(createdDateString));
        }
        catch (ParseException pe) {
            Logger.e(TAG, "Date created has become corrupt: " + createdDateString);
            creationDate = UserInfo.today();
        }
        return creationDate;
    }

    private TreeSet<GregorianCalendar> getVisitDates(String userID) {
        String[] visitStrings;
        TreeSet<GregorianCalendar> visits = new TreeSet<GregorianCalendar>();
        String storedVisits = this.prefs.getString(KEY_USER_LAST_VISIT_TIME_BY_ID + userID, null);
        if (storedVisits == null) {
            return visits;
        }
        GregorianCalendar startDate = UserInfo.today();
        startDate.add(5, -16);
        Logger.d(TAG, "Retrieving user visited dates: " + storedVisits);
        for (String dateString : visitStrings = storedVisits.split(",")) {
            GregorianCalendar calendar = new GregorianCalendar();
            try {
                calendar.setTime(DATE_FORMAT.parse(dateString));
                if (!calendar.after(startDate)) continue;
                visits.add(calendar);
            }
            catch (ParseException e) {
                Logger.e(TAG, "error reading date in user info: " + e);
            }
        }
        return visits;
    }

    private static String encodeVisitDates(Set<GregorianCalendar> dates) {
        boolean isFirstEntry = true;
        String encodedString = "";
        for (GregorianCalendar calendar : dates) {
            String dateString = DATE_FORMAT.format(calendar.getTime());
            if (isFirstEntry) {
                encodedString = dateString;
                isFirstEntry = false;
                continue;
            }
            encodedString = encodedString + "," + dateString;
        }
        return encodedString;
    }

    boolean isNewUser() {
        return this.isNewUser;
    }

    String getUserID() {
        return this.userID;
    }

    SubscriptionState getSubscriptionState() {
        return this.subscriptionState;
    }

    void setSubscriptionState(SubscriptionState subState) {
        this.subscriptionState = subState;
    }

    void visited() {
        GregorianCalendar visitDate = UserInfo.today();
        if (this.visitedDates.add(visitDate)) {
            String encodedDateString = UserInfo.encodeVisitDates(this.visitedDates);
            Logger.d(TAG, "Storing user visited dates: " + encodedDateString);
            SharedPreferences.Editor editor = this.prefs.edit();
            editor.putString(KEY_USER_LAST_VISIT_TIME_BY_ID + this.userID, encodedDateString);
            editor.commit();
        }
    }

    String getUserVisitFrequencyString() {
        GregorianCalendar today = UserInfo.today();
        GregorianCalendar[] cal = new GregorianCalendar[16];
        int validDates = 0;
        for (int i = 0; i < 16; ++i) {
            cal[i] = (GregorianCalendar)today.clone();
            cal[i].add(5, -i);
            if (cal[i].compareTo(this.userCreated) < 0) continue;
            validDates = i;
        }
        int b = (this.visitedDates.contains(cal[15]) ? 1 : 0) << 3 | (this.visitedDates.contains(cal[14]) ? 1 : 0) << 2 | (this.visitedDates.contains(cal[13]) ? 1 : 0) << 1 | (this.visitedDates.contains(cal[12]) ? 1 : 0) << 0;
        int c = (this.visitedDates.contains(cal[11]) ? 1 : 0) << 3 | (this.visitedDates.contains(cal[10]) ? 1 : 0) << 2 | (this.visitedDates.contains(cal[9]) ? 1 : 0) << 1 | (this.visitedDates.contains(cal[8]) ? 1 : 0) << 0;
        int d = (this.visitedDates.contains(cal[7]) ? 1 : 0) << 3 | (this.visitedDates.contains(cal[6]) ? 1 : 0) << 2 | (this.visitedDates.contains(cal[5]) ? 1 : 0) << 1 | (this.visitedDates.contains(cal[4]) ? 1 : 0) << 0;
        int e = (this.visitedDates.contains(cal[3]) ? 1 : 0) << 3 | (this.visitedDates.contains(cal[2]) ? 1 : 0) << 2 | (this.visitedDates.contains(cal[1]) ? 1 : 0) << 1 | (this.visitedDates.contains(cal[0]) ? 1 : 0) << 0;
        return new String(new char[]{UserInfo.toHexDigit(validDates), UserInfo.toHexDigit(b), UserInfo.toHexDigit(c), UserInfo.toHexDigit(d), UserInfo.toHexDigit(e)});
    }

    private static GregorianCalendar today() {
        GregorianCalendar gc = new GregorianCalendar();
        gc = new GregorianCalendar(gc.get(1), gc.get(2), gc.get(5));
        return gc;
    }

    private static GregorianCalendar pastDate(final int daysInPast, final int hoursInPast, final int minutesInPast) {
        return new GregorianCalendar(){
            {
                this.add(6, -daysInPast);
                this.set(11, -hoursInPast);
                this.set(12, -minutesInPast);
                this.set(13, 0);
                this.set(14, 0);
            }
        };
    }

    static final char toHexDigit(int i) {
        if (i <= 9 && i >= 0) {
            return (char)(48 + i);
        }
        if (i > 9 && i < 16) {
            return (char)(65 + i - 10);
        }
        throw new RuntimeException("I is not in hex digit range: " + i);
    }

    void markUserAsOld() {
        this.isNewUser = false;
    }
}

