/*
 * Decompiled with CFR 0.152.
 */
package com.chartbeat.androidsdk;

import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.text.TextUtils;
import com.chartbeat.androidsdk.AwsLogger;
import com.chartbeat.androidsdk.ChartbeatService;
import com.chartbeat.androidsdk.ForegroundTracker;
import com.chartbeat.androidsdk.Logger;
import com.chartbeat.androidsdk.StringUtils;
import com.chartbeat.androidsdk.SubscriptionState;
import java.io.Serializable;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import rx.Observable;
import rx.Subscriber;
import rx.Subscription;
import rx.schedulers.Schedulers;

public final class Tracker {
    private static final String TAG = "ChartBeat Tracker";
    public static boolean DEBUG_MODE = false;
    private static final int BACKGROUND_IDLE_WAIT_LIMIT_MS = 4000;
    private static Subscription appIdleSubscription;
    private static Context appContext;
    private static String accountID;
    private static String domain;
    static final String KEY_SDK_ACTION_TYPE = "KEY_SDK_ACTION_TYPE";
    static final String ACTION_INIT_TRACKER = "ACTION_INIT_TRACKER";
    static final String ACTION_SET_APP_REFERRER = "ACTION_SET_APP_REFERRER";
    static final String ACTION_STOP_TRACKER = "ACTION_STOP_TRACKER";
    static final String ACTION_TRACK_VIEW = "ACTION_TRACK_VIEW";
    static final String ACTION_LEFT_VIEW = "ACTION_LEFT_VIEW";
    static final String ACTION_USER_INTERACTED = "ACTION_USER_INTERACTED";
    static final String ACTION_USER_TYPED = "ACTION_USER_TYPED";
    static final String ACTION_SET_DOMAIN = "ACTION_SET_DOMAIN";
    static final String ACTION_SET_SUBDOMAIN = "ACTION_SET_SUBDOMAIN";
    static final String ACTION_SET_ZONES = "ACTION_SET_ZONES";
    static final String ACTION_SET_AUTHORS = "ACTION_SET_AUTHORS";
    static final String ACTION_SET_SECTIONS = "ACTION_SET_SECTIONS";
    static final String ACTION_SET_SUBSCRIPTION_STATE = "ACTION_SET_SUBSCRIPTION_STATE";
    static final String ACTION_SET_VIEW_LOADING_TIME = "ACTION_SET_VIEW_LOADING_TIME";
    static final String ACTION_SET_POSITION = "ACTION_SET_POSITION";
    static final String ACTION_PAUSE_TRACKER = "ACTION_PAUSE_TRACKER";
    static final String ACTION_RESTART_PING_SERVICE = "ACTION_RESTART_PING_SERVICE";
    static final String ACTION_BACKGROUND_TRACKER = "ACTION_BACKGROUND_TRACKER";
    static final String KEY_ACCOUNT_ID = "KEY_ACCOUNT_ID";
    static final String KEY_DOMAIN = "KEY_DOMAIN";
    static final String KEY_APP_REFERRER = "KEY_APP_REFERRER";
    static final String KEY_VIEW_ID = "KEY_VIEW_ID";
    static final String KEY_VIEW_TITLE = "KEY_VIEW_TITLE";
    static final String KEY_SUBDOMAIN = "KEY_SUBDOMAIN";
    static final String KEY_ZONES = "KEY_ZONES";
    static final String KEY_SUBSCRIPTION_STATE = "KEY_SUBSCRIPTION_STATE";
    static final String KEY_AUTHORS = "KEY_AUTHORS";
    static final String KEY_SECTIONS = "KEY_SECTIONS";
    static final String KEY_VIEW_LOADING_TIME = "KEY_VIEW_LOADING_TIME";
    static final String KEY_POSITION_TOP = "KEY_POSITION_TOP";
    static final String KEY_WINDOW_HEIGHT = "KEY_WINDOW_HEIGHT";
    static final String KEY_CONTENT_HEIGHT = "KEY_CONTENT_HEIGHT";
    static final String KEY_DOC_WIDTH = "KEY_DOC_WIDTH";
    private static Subscription userInteractSubscription;
    private static final int USER_INTERACT_WINDOW_IN_MILLISECONDS = 500;

    public static void setupTracker(String accountId, String domain, Context context) {
        if (accountId == null) {
            throw new NullPointerException("accountId cannot be null");
        }
        if (context == null) {
            throw new NullPointerException("context cannot be null");
        }
        if (!(context instanceof Application)) {
            throw new IllegalArgumentException("Application level context is required to initialize Chartbeat Android SDK");
        }
        AwsLogger.initInstance(context, accountId, domain);
        Tracker.startSDK(accountId, domain, context);
    }

    private static void startSDK(String accountID, String domain, Context context) {
        try {
            appContext = context.getApplicationContext();
            Tracker.monitorAppStatus();
            Tracker.accountID = accountID;
            Tracker.domain = domain;
            Intent intent = new Intent(context.getApplicationContext(), ChartbeatService.class);
            intent.putExtra(KEY_SDK_ACTION_TYPE, ACTION_INIT_TRACKER);
            intent.putExtra(KEY_ACCOUNT_ID, accountID);
            if (domain != null) {
                intent.putExtra(KEY_DOMAIN, domain);
            }
            Tracker.sendServiceSignal(intent);
        }
        catch (Exception e) {
            AwsLogger.getInstance().logError(e);
        }
    }

    public static void restartPingService(Context context) {
        try {
            Intent intent = new Intent(context.getApplicationContext(), ChartbeatService.class);
            intent.putExtra(KEY_SDK_ACTION_TYPE, ACTION_RESTART_PING_SERVICE);
            Tracker.sendServiceSignal(intent);
        }
        catch (Exception e) {
            AwsLogger.getInstance().logError(e);
        }
    }

    private static void monitorAppStatus() {
        try {
            ForegroundTracker.init((Application)appContext);
            ForegroundTracker.get(appContext).addListener(new ForegroundTracker.Listener(){

                @Override
                public void onForegrounded() {
                    Tracker.restartPingService(appContext);
                    if (appIdleSubscription != null && !appIdleSubscription.isUnsubscribed()) {
                        appIdleSubscription.unsubscribe();
                    }
                }

                @Override
                public void onBackgrounded() {
                    if (appIdleSubscription == null || appIdleSubscription.isUnsubscribed()) {
                        appIdleSubscription = Observable.timer((long)4000L, (TimeUnit)TimeUnit.MILLISECONDS).subscribe((Subscriber)new Subscriber<Long>(){

                            public void onCompleted() {
                            }

                            public void onError(Throwable e) {
                            }

                            public void onNext(Long aLong) {
                                Tracker.backgroundTracker();
                            }
                        });
                    }
                }
            });
        }
        catch (Exception e) {
            AwsLogger.getInstance().logError(e);
        }
    }

    public static void setAppReferrer(String appReferrer) {
        Tracker.didInit();
        Intent intent = new Intent(appContext, ChartbeatService.class);
        intent.putExtra(KEY_SDK_ACTION_TYPE, ACTION_SET_APP_REFERRER);
        intent.putExtra(KEY_APP_REFERRER, appReferrer);
        Tracker.sendServiceSignal(intent);
    }

    public static void setPushReferrer(String pushReferrer) {
        pushReferrer = Uri.encode((String)pushReferrer);
        pushReferrer = "push/?id=" + pushReferrer;
        Tracker.setAppReferrer(pushReferrer);
    }

    public static void stopTracker() {
        if (appContext == null) {
            return;
        }
        Intent intent = new Intent(appContext, ChartbeatService.class);
        intent.putExtra(KEY_SDK_ACTION_TYPE, ACTION_STOP_TRACKER);
        Tracker.sendServiceSignal(intent);
    }

    public static void pauseTracker() {
        if (appContext == null) {
            return;
        }
        Intent intent = new Intent(appContext, ChartbeatService.class);
        intent.putExtra(KEY_SDK_ACTION_TYPE, ACTION_PAUSE_TRACKER);
        Tracker.sendServiceSignal(intent);
    }

    public static void backgroundTracker() {
        if (appContext == null) {
            return;
        }
        Intent intent = new Intent(appContext, ChartbeatService.class);
        intent.putExtra(KEY_SDK_ACTION_TYPE, ACTION_BACKGROUND_TRACKER);
        Tracker.sendServiceSignal(intent);
    }

    public static void trackView(Context context, String viewId, String viewTitle) {
        try {
            Tracker.didInit();
            if (context == null) {
                throw new NullPointerException("context cannot be null");
            }
            if (viewId == null) {
                throw new NullPointerException("viewId cannot be null");
            }
            Tracker.resetUserInteractionMonitor();
            if (viewTitle == null) {
                viewTitle = viewId;
            }
            appContext = context.getApplicationContext();
            Intent intent = new Intent(appContext, ChartbeatService.class);
            intent.putExtra(KEY_SDK_ACTION_TYPE, ACTION_TRACK_VIEW);
            intent.putExtra(KEY_VIEW_ID, viewId);
            intent.putExtra(KEY_VIEW_TITLE, viewTitle);
            Tracker.sendServiceSignal(intent);
        }
        catch (Exception e) {
            AwsLogger.getInstance().logError(e);
        }
    }

    public static void trackView(Context context, String viewId, String viewTitle, int scrollPositionTop, int scrollWindowHeight, int totalContentHeight, int fullyRenderedDocWidth) {
        try {
            Tracker.didInit();
            if (context == null) {
                throw new NullPointerException("context cannot be null");
            }
            if (viewId == null) {
                throw new NullPointerException("viewId cannot be null");
            }
            Tracker.resetUserInteractionMonitor();
            if (TextUtils.isEmpty((CharSequence)viewTitle)) {
                viewTitle = viewId;
            }
            appContext = context.getApplicationContext();
            Intent intent = new Intent(appContext, ChartbeatService.class);
            intent.putExtra(KEY_SDK_ACTION_TYPE, ACTION_TRACK_VIEW);
            intent.putExtra(KEY_VIEW_ID, viewId);
            intent.putExtra(KEY_VIEW_TITLE, viewTitle);
            intent.putExtra(KEY_POSITION_TOP, scrollPositionTop);
            intent.putExtra(KEY_WINDOW_HEIGHT, scrollWindowHeight);
            intent.putExtra(KEY_CONTENT_HEIGHT, totalContentHeight);
            intent.putExtra(KEY_DOC_WIDTH, fullyRenderedDocWidth);
            Tracker.sendServiceSignal(intent);
        }
        catch (Exception e) {
            AwsLogger.getInstance().logError(e);
        }
    }

    private static void resetUserInteractionMonitor() {
        if (userInteractSubscription != null && !userInteractSubscription.isUnsubscribed()) {
            userInteractSubscription.unsubscribe();
        }
    }

    public static void userLeftView(String viewId) {
        try {
            Tracker.didInit();
            Tracker.didStartTracking();
            if (viewId == null) {
                throw new NullPointerException("viewId cannot be null");
            }
            Tracker.resetUserInteractionMonitor();
            Intent intent = new Intent(appContext, ChartbeatService.class);
            intent.putExtra(KEY_SDK_ACTION_TYPE, ACTION_LEFT_VIEW);
            intent.putExtra(KEY_VIEW_ID, viewId);
            Tracker.sendServiceSignal(intent);
        }
        catch (Exception e) {
            AwsLogger.getInstance().logError(e);
        }
    }

    public static void userInteracted() {
        try {
            Tracker.didInit();
            Tracker.didStartTracking();
            Tracker.startUserInteractTimer();
        }
        catch (Exception e) {
            AwsLogger.getInstance().logError(e);
        }
    }

    private static void startUserInteractTimer() {
        try {
            if (userInteractSubscription != null && !userInteractSubscription.isUnsubscribed()) {
                return;
            }
            Intent intent = new Intent(appContext, ChartbeatService.class);
            intent.putExtra(KEY_SDK_ACTION_TYPE, ACTION_USER_INTERACTED);
            Tracker.sendServiceSignal(intent);
            userInteractSubscription = Observable.timer((long)500L, (TimeUnit)TimeUnit.MILLISECONDS).observeOn(Schedulers.io()).subscribe((Subscriber)new Subscriber<Long>(){

                public void onCompleted() {
                }

                public void onError(Throwable e) {
                    Logger.e(Tracker.TAG, e.getMessage());
                }

                public void onNext(Long aLong) {
                }
            });
        }
        catch (Exception e) {
            AwsLogger.getInstance().logError(e);
        }
    }

    public static void userTyped() {
        try {
            Tracker.didInit();
            Tracker.didStartTracking();
            Intent intent = new Intent(appContext, ChartbeatService.class);
            intent.putExtra(KEY_SDK_ACTION_TYPE, ACTION_USER_TYPED);
            Tracker.sendServiceSignal(intent);
        }
        catch (Exception e) {
            AwsLogger.getInstance().logError(e);
        }
    }

    public static void setDomain(String domain) {
        try {
            Tracker.didInit();
            Tracker.didStartTracking();
            Intent intent = new Intent(appContext, ChartbeatService.class);
            intent.putExtra(KEY_SDK_ACTION_TYPE, ACTION_SET_DOMAIN);
            intent.putExtra(KEY_DOMAIN, domain);
            Tracker.sendServiceSignal(intent);
        }
        catch (Exception e) {
            AwsLogger.getInstance().logError(e);
        }
    }

    public static void setSubdomain(String subdomain) {
        try {
            Tracker.didInit();
            Tracker.didStartTracking();
            Intent intent = new Intent(appContext, ChartbeatService.class);
            intent.putExtra(KEY_SDK_ACTION_TYPE, ACTION_SET_SUBDOMAIN);
            intent.putExtra(KEY_SUBDOMAIN, subdomain);
            Tracker.sendServiceSignal(intent);
        }
        catch (Exception e) {
            AwsLogger.getInstance().logError(e);
        }
    }

    public static void setZones(String zones) {
        try {
            Tracker.didInit();
            Tracker.didStartTracking();
            Tracker.setZonesImpl(zones);
        }
        catch (Exception e) {
            AwsLogger.getInstance().logError(e);
        }
    }

    public static void setZones(Collection<String> zones) {
        try {
            Tracker.didInit();
            Tracker.didStartTracking();
            Tracker.setZonesImpl(StringUtils.collectionToCommaString(zones));
        }
        catch (Exception e) {
            AwsLogger.getInstance().logError(e);
        }
    }

    private static void setZonesImpl(String zones) {
        try {
            Tracker.didInit();
            Intent intent = new Intent(appContext, ChartbeatService.class);
            intent.putExtra(KEY_SDK_ACTION_TYPE, ACTION_SET_ZONES);
            intent.putExtra(KEY_ZONES, zones);
            Tracker.sendServiceSignal(intent);
        }
        catch (Exception e) {
            AwsLogger.getInstance().logError(e);
        }
    }

    public static void setUserPaid() {
        Tracker.setUserSubscriptionImpl(SubscriptionState.PAID);
    }

    public static void setUserLoggedIn() {
        Tracker.setUserSubscriptionImpl(SubscriptionState.LOGGED_IN);
    }

    public static void setUserAnonymous() {
        Tracker.setUserSubscriptionImpl(SubscriptionState.ANONYMOUS);
    }

    private static void setUserSubscriptionImpl(SubscriptionState subState) {
        try {
            Tracker.didInit();
            Tracker.didStartTracking();
            Intent intent = new Intent(appContext, ChartbeatService.class);
            intent.putExtra(KEY_SDK_ACTION_TYPE, ACTION_SET_SUBSCRIPTION_STATE);
            intent.putExtra(KEY_SUBSCRIPTION_STATE, (Serializable)((Object)subState));
            Tracker.sendServiceSignal(intent);
        }
        catch (Exception e) {
            AwsLogger.getInstance().logError(e);
        }
    }

    public static void setAuthors(String authors) {
        try {
            Tracker.didInit();
            Tracker.didStartTracking();
            Tracker.setAuthorsImpl(authors);
        }
        catch (Exception e) {
            AwsLogger.getInstance().logError(e);
        }
    }

    public static void setAuthors(Collection<String> authors) {
        try {
            Tracker.didInit();
            Tracker.didStartTracking();
            Tracker.setAuthorsImpl(StringUtils.collectionToCommaString(authors));
        }
        catch (Exception e) {
            AwsLogger.getInstance().logError(e);
        }
    }

    private static void setAuthorsImpl(String authors) {
        try {
            Intent intent = new Intent(appContext, ChartbeatService.class);
            intent.putExtra(KEY_SDK_ACTION_TYPE, ACTION_SET_AUTHORS);
            intent.putExtra(KEY_AUTHORS, authors);
            Tracker.sendServiceSignal(intent);
        }
        catch (Exception e) {
            AwsLogger.getInstance().logError(e);
        }
    }

    public static void setSections(String sections) {
        try {
            Tracker.didInit();
            Tracker.didStartTracking();
            Tracker.setSectionsImpl(sections);
        }
        catch (Exception e) {
            AwsLogger.getInstance().logError(e);
        }
    }

    public static void setSections(Collection<String> sections) {
        try {
            Tracker.didInit();
            Tracker.didStartTracking();
            Tracker.setSectionsImpl(StringUtils.collectionToCommaString(sections));
        }
        catch (Exception e) {
            AwsLogger.getInstance().logError(e);
        }
    }

    private static void setSectionsImpl(String sections) {
        try {
            Intent intent = new Intent(appContext, ChartbeatService.class);
            intent.putExtra(KEY_SDK_ACTION_TYPE, ACTION_SET_SECTIONS);
            intent.putExtra(KEY_SECTIONS, sections);
            Tracker.sendServiceSignal(intent);
        }
        catch (Exception e) {
            AwsLogger.getInstance().logError(e);
        }
    }

    public static void setViewLoadTime(float pageLoadTime) {
        try {
            Tracker.didInit();
            Tracker.didStartTracking();
            if (pageLoadTime < 0.0f) {
                Logger.e(TAG, "Page load time cannot be negative");
                return;
            }
            Intent intent = new Intent(appContext, ChartbeatService.class);
            intent.putExtra(KEY_SDK_ACTION_TYPE, ACTION_SET_VIEW_LOADING_TIME);
            intent.putExtra(KEY_VIEW_LOADING_TIME, pageLoadTime);
            Tracker.sendServiceSignal(intent);
        }
        catch (Exception e) {
            AwsLogger.getInstance().logError(e);
        }
    }

    public static void setPosition(int scrollPositionTop, int scrollWindowHeight, int totalContentHeight, int fullyRenderedDocWidth) {
        try {
            Tracker.didInit();
            Tracker.didStartTracking();
            Intent intent = new Intent(appContext, ChartbeatService.class);
            intent.putExtra(KEY_SDK_ACTION_TYPE, ACTION_SET_POSITION);
            intent.putExtra(KEY_POSITION_TOP, scrollPositionTop);
            intent.putExtra(KEY_WINDOW_HEIGHT, scrollWindowHeight);
            intent.putExtra(KEY_CONTENT_HEIGHT, totalContentHeight);
            intent.putExtra(KEY_DOC_WIDTH, fullyRenderedDocWidth);
            Tracker.sendServiceSignal(intent);
        }
        catch (Exception e) {
            AwsLogger.getInstance().logError(e);
        }
    }

    public static void didInit() {
        if (appContext == null && TextUtils.isEmpty((CharSequence)accountID)) {
            throw new IllegalStateException("Chartbeat: SDK has not been initialized with an Account ID");
        }
    }

    public static void didStartTracking() {
        if (appContext == null) {
            throw new IllegalStateException("Chartbeat: View tracking hasn't started, please call Tracker.trackView() in onResume() first");
        }
    }

    private static void sendServiceSignal(Intent intent) {
        try {
            appContext.startService(intent);
        }
        catch (Exception e) {
            AwsLogger.getInstance().logError(e);
        }
    }
}

