/*
 * Decompiled with CFR 0.152.
 */
package com.chartbeat.androidsdk;

import android.os.Handler;
import android.os.Looper;
import com.chartbeat.androidsdk.AwsLogger;
import com.chartbeat.androidsdk.ChartBeatTracker;
import com.chartbeat.androidsdk.Logger;
import java.util.concurrent.TimeUnit;
import rx.Observable;
import rx.Observer;
import rx.Subscription;
import rx.functions.Func1;

final class PingManager {
    private static final String TAG = PingManager.class.getSimpleName();
    private static final long SECOND = 1000L;
    private static final long MINUTE = 60000L;
    private static final long HOUR = 3600000L;
    private static final long MAX_SDK_RUN_TIME = 0x6DDD00L;
    private static final long SERVER_BUSY_WAIT_WINDOW = 600000L;
    private static final int DEFAULT_PING_INTERVAL_IN_SECONDS = 15;
    private static final int DEFAULT_PING_DECAY = 30;
    private static final String DEFAULT_EXIT_VIEW_DECAY_TIME_IN_SECONDS = "90";
    private final ChartBeatTracker tracker;
    private static Handler handler;
    private Observer pingObserver;
    private Subscription pingSubscription;
    private int pingInterval;
    private boolean inBackground;
    private boolean wasInBackground;
    private volatile long lastActiveTimestamp = System.currentTimeMillis();
    private volatile boolean isSuspended;
    private volatile long suspensionTime;

    PingManager(ChartBeatTracker tracker, Looper looper) {
        this.tracker = tracker;
        this.pingInterval = 15;
        this.isSuspended = false;
        this.suspensionTime = 0L;
        this.wasInBackground = false;
        this.inBackground = false;
        try {
            handler = new Handler(looper);
            this.pingObserver = new Observer(){

                public void onCompleted() {
                }

                public void onError(Throwable e) {
                    e.printStackTrace();
                }

                public void onNext(Object o) {
                    if (handler.getLooper().getThread().isAlive()) {
                        handler.post(new Runnable(){

                            @Override
                            public void run() {
                                PingManager.this.runTask();
                            }
                        });
                    }
                }
            };
        }
        catch (Exception e) {
            e.printStackTrace();
            AwsLogger.getInstance().logError(e);
        }
    }

    void restart() {
        this.inBackground = false;
        this.stop();
        this.start(this.pingInterval);
    }

    private void restartForBackground() {
        this.stop();
        this.alive();
        this.start(this.pingInterval * 2);
    }

    void stop() {
        if (this.pingSubscription != null) {
            this.pingSubscription.unsubscribe();
        }
    }

    void retryImmediately() {
        this.restart();
    }

    long getPingInterval() {
        return this.pingInterval;
    }

    int expectedNextIntervalInSeconds() {
        return this.pingInterval;
    }

    void setInBackground(boolean isInBackground) {
        this.inBackground = isInBackground;
    }

    void suspendDueToServerBusy() {
        this.suspensionTime = System.currentTimeMillis();
        this.isSuspended = true;
    }

    void alive() {
        this.lastActiveTimestamp = System.currentTimeMillis();
        if (this.inBackground) {
            this.restart();
        }
    }

    private boolean isServerSuspended() {
        long timePassedSinceSuspension;
        if (this.isSuspended && (timePassedSinceSuspension = System.currentTimeMillis() - this.suspensionTime) > 600000L) {
            this.isSuspended = false;
        }
        return this.isSuspended;
    }

    private void start(int interval) {
        try {
            this.pingSubscription = Observable.interval((long)0L, (long)interval, (TimeUnit)TimeUnit.SECONDS).filter((Func1)new Func1<Long, Boolean>(){

                public Boolean call(Long aLong) {
                    if (PingManager.this.isServerSuspended()) {
                        return false;
                    }
                    return true;
                }
            }).filter((Func1)new Func1<Long, Boolean>(){

                public Boolean call(Long aLong) {
                    if (PingManager.this.isDormant()) {
                        return false;
                    }
                    return true;
                }
            }).subscribe(this.pingObserver);
        }
        catch (Exception e) {
            e.printStackTrace();
            AwsLogger.getInstance().logError(e);
        }
    }

    private void runTask() {
        try {
            if (this.inBackground) {
                this.wasInBackground = true;
                return;
            }
            int decayTime = 30;
            this.tracker.ping(this.wasInBackground, String.valueOf(decayTime));
            this.wasInBackground = false;
        }
        catch (Exception e) {
            Logger.e(TAG, "Problem executing: " + e.getLocalizedMessage());
            e.printStackTrace();
            AwsLogger.getInstance().logError(e);
        }
    }

    private boolean isDormant() {
        long idlingTime = System.currentTimeMillis() - this.lastActiveTimestamp;
        return idlingTime > 0x6DDD00L;
    }
}

