/*
 * Decompiled with CFR 0.152.
 */
package com.chartbeat.androidsdk;

import com.chartbeat.androidsdk.AwsLogger;
import com.chartbeat.androidsdk.Logger;
import com.chartbeat.androidsdk.RequestInterceptor;
import okhttp3.OkHttpClient;
import okhttp3.logging.HttpLoggingInterceptor;
import retrofit2.CallAdapter;
import retrofit2.Retrofit;
import retrofit2.adapter.rxjava.RxJavaCallAdapterFactory;

class PingClient {
    private static String TAG = PingClient.class.getSimpleName();
    private Retrofit retrofit;

    PingClient(String endpoint, String host, String userAgent) {
        try {
            OkHttpClient.Builder clientBuilder = new OkHttpClient.Builder();
            clientBuilder.interceptors().add(PingClient.getLoggingInterceptor());
            clientBuilder.interceptors().add(new RequestInterceptor(host, userAgent));
            OkHttpClient httpClient = clientBuilder.build();
            Retrofit.Builder builder = new Retrofit.Builder().baseUrl(endpoint).addCallAdapterFactory((CallAdapter.Factory)RxJavaCallAdapterFactory.create());
            this.retrofit = builder.client(httpClient).build();
        }
        catch (Exception e) {
            AwsLogger.getInstance().logError(e);
        }
    }

    <S> S createService(Class<S> serviceClass) {
        return (S)this.retrofit.create(serviceClass);
    }

    private static HttpLoggingInterceptor getLoggingInterceptor() {
        HttpLoggingInterceptor httpLoggingInterceptor = new HttpLoggingInterceptor(new HttpLoggingInterceptor.Logger(){

            public void log(String message) {
                Logger.d(TAG, message);
            }
        });
        httpLoggingInterceptor.setLevel(HttpLoggingInterceptor.Level.BASIC);
        return httpLoggingInterceptor;
    }
}

