/*
 * Decompiled with CFR 0.152.
 */
package com.chartbeat.androidsdk;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.os.Bundle;
import com.chartbeat.androidsdk.AwsLogger;
import com.chartbeat.androidsdk.Logger;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import rx.Observable;
import rx.Subscriber;
import rx.Subscription;

class ForegroundTracker
implements Application.ActivityLifecycleCallbacks {
    private static final long CHECK_STATUS_DELAY_MS = 500L;
    private static final String TAG = ForegroundTracker.class.getSimpleName();
    private static ForegroundTracker instance;
    private boolean isForeground = true;
    private boolean paused = false;
    private List<Listener> listeners = new CopyOnWriteArrayList<Listener>();
    private Subscription enteredBackgroundSubscription;
    private static Object mutex;

    ForegroundTracker() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ForegroundTracker init(Application application) {
        Object object = mutex;
        synchronized (object) {
            if (instance == null) {
                instance = new ForegroundTracker();
                application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)instance);
            }
        }
        return instance;
    }

    static ForegroundTracker get(Application application) {
        if (instance == null) {
            ForegroundTracker.init(application);
        }
        return instance;
    }

    static ForegroundTracker get(Context context) {
        if (instance == null) {
            Context appContext = context.getApplicationContext();
            if (appContext instanceof Application) {
                ForegroundTracker.init((Application)appContext);
            }
            throw new IllegalStateException("ForegroundMonitor is not initialised and cannot obtain the Application context");
        }
        return instance;
    }

    static ForegroundTracker get() {
        if (instance == null) {
            throw new IllegalStateException("ForegroundMonitor is not initialised - invoke at least once with parameterised init/get");
        }
        return instance;
    }

    boolean appIsForeground() {
        return this.isForeground;
    }

    boolean isInBackground() {
        return !this.isForeground;
    }

    void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    void removeListener(Listener listener) {
        this.listeners.remove(listener);
    }

    public void onActivityResumed(Activity activity) {
        try {
            this.paused = false;
            boolean wasBackground = !this.isForeground;
            this.isForeground = true;
            if (this.enteredBackgroundSubscription != null && !this.enteredBackgroundSubscription.isUnsubscribed()) {
                this.enteredBackgroundSubscription.unsubscribe();
                this.enteredBackgroundSubscription = null;
            }
            if (wasBackground) {
                Logger.d(TAG, "went foreground");
                for (Listener l : this.listeners) {
                    try {
                        l.onForegrounded();
                    }
                    catch (Exception e) {
                        Logger.d(TAG, e.getMessage());
                    }
                }
            } else {
                Logger.d(TAG, "still foreground");
            }
        }
        catch (Exception ex) {
            AwsLogger.getInstance().logError(ex);
        }
    }

    public void onActivityPaused(Activity activity) {
        try {
            this.paused = true;
            if (this.enteredBackgroundSubscription != null && !this.enteredBackgroundSubscription.isUnsubscribed()) {
                this.enteredBackgroundSubscription.unsubscribe();
            }
            this.enteredBackgroundSubscription = Observable.timer((long)500L, (TimeUnit)TimeUnit.MILLISECONDS).subscribe((Subscriber)new Subscriber<Long>(){

                public void onCompleted() {
                }

                public void onError(Throwable e) {
                    Logger.d(TAG, e.getMessage());
                }

                public void onNext(Long aLong) {
                    if (ForegroundTracker.this.isForeground && ForegroundTracker.this.paused) {
                        ForegroundTracker.this.isForeground = false;
                        Logger.d(TAG, "went background");
                        for (Listener l : ForegroundTracker.this.listeners) {
                            try {
                                l.onBackgrounded();
                            }
                            catch (Exception e) {
                                Logger.d(TAG, e.getMessage());
                            }
                        }
                    } else {
                        Logger.d(TAG, "still appIsForeground");
                    }
                }
            });
        }
        catch (Exception ex) {
            AwsLogger.getInstance().logError(ex);
        }
    }

    public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
    }

    public void onActivityStarted(Activity activity) {
    }

    public void onActivityStopped(Activity activity) {
    }

    public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
    }

    public void onActivityDestroyed(Activity activity) {
    }

    static {
        mutex = new Object();
    }

    public static interface Listener {
        public void onForegrounded();

        public void onBackgrounded();
    }
}

