/*
 * Decompiled with CFR 0.152.
 */
package com.chartbeat.androidsdk;

import com.chartbeat.androidsdk.AwsLogger;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicLong;

final class EngagementTracker {
    private static final String TAG = EngagementTracker.class.getSimpleName();
    private static final String ENGAGEMENT_TRACKING_THREAD_NAME = "Engagement_Timer";
    private static final int SECOND = 1000;
    private static final int INITIAL_DELAY = 0;
    private static final int ENGAGEMENT_CHECK_PERIOD = 1000;
    private boolean engaged = false;
    private boolean typed = false;
    private Timer timer;
    private EngagementTask engagementTask = new EngagementTask();

    EngagementTracker() {
    }

    synchronized void userEnteredView() {
        try {
            this.stop();
            this.engagementTask = new EngagementTask();
            this.timer = new Timer(ENGAGEMENT_TRACKING_THREAD_NAME);
            this.timer.schedule((TimerTask)this.engagementTask, 0L, 1000L);
        }
        catch (Exception e) {
            AwsLogger.getInstance().logError(e);
        }
    }

    synchronized void userLeftView() {
        this.stop();
    }

    synchronized void stop() {
        if (this.timer != null) {
            this.timer.cancel();
            this.timer.purge();
        }
    }

    synchronized void userEngaged() {
        this.engaged = true;
        this.engagementTask.engage();
    }

    synchronized void userTyped() {
        this.typed = true;
        this.engagementTask.engage();
    }

    synchronized void lastPingFailed(EngagementSnapshot ed) {
        this.engaged |= ed.engaged;
        this.typed |= ed.typed;
    }

    synchronized EngagementSnapshot getEngagementSnapshot() {
        EngagementSnapshot data = new EngagementSnapshot(this.engagementTask.getTotalEngagementCount(), this.engagementTask.getEngagementSinceLastPing(), this.engaged, this.typed);
        this.engaged = false;
        this.typed = false;
        return data;
    }

    static final class EngagementSnapshot {
        final boolean engaged;
        final boolean typed;
        final boolean reading;
        final boolean idle;
        final long totalEngagement;
        final long engagementSinceLastPing;

        public EngagementSnapshot(long totalEngagement, long engagementSinceLastPing, boolean engaged, boolean typed) {
            this.engaged = engaged;
            this.typed = typed;
            this.reading = engaged && !typed;
            this.idle = !engaged;
            this.engagementSinceLastPing = engagementSinceLastPing;
            this.totalEngagement = totalEngagement;
        }
    }

    private static final class EngagementTask
    extends TimerTask {
        private static final int SECOND = 1000;
        private static final int ENGAGEMENT_WINDOW = 5000;
        private static final int INITIAL_ENGAGEMENT_WINDOW = 5000;
        private final long startTime = System.currentTimeMillis();
        private long lastEngagedTime = 0L;
        private AtomicLong totalEngagementCount = new AtomicLong(0L);
        private AtomicLong engagementSinceLastPing = new AtomicLong(0L);

        @Override
        public void run() {
            long now = System.currentTimeMillis();
            long engagedPeriod = now - this.lastEngagedTime;
            long engagedTimeSinceEnteringView = now - this.startTime;
            if (engagedPeriod < 5000L || engagedTimeSinceEnteringView < 5000L) {
                this.totalEngagementCount.incrementAndGet();
                this.engagementSinceLastPing.incrementAndGet();
            }
        }

        public void engage() {
            this.lastEngagedTime = System.currentTimeMillis();
        }

        public long getTotalEngagementCount() {
            return this.totalEngagementCount.longValue();
        }

        public long getEngagementSinceLastPing() {
            long lastEngagementPeriod = this.engagementSinceLastPing.longValue();
            this.engagementSinceLastPing.set(0L);
            return lastEngagementPeriod;
        }
    }
}

