/*
 * Decompiled with CFR 0.152.
 */
package com.chartbeat.androidsdk;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import com.chartbeat.androidsdk.AppInfo;
import com.chartbeat.androidsdk.AwsLogger;
import com.chartbeat.androidsdk.EngagementTracker;
import com.chartbeat.androidsdk.ForegroundTracker;
import com.chartbeat.androidsdk.Logger;
import com.chartbeat.androidsdk.PingManager;
import com.chartbeat.androidsdk.PingParams;
import com.chartbeat.androidsdk.PingService;
import com.chartbeat.androidsdk.SecurityUtils;
import com.chartbeat.androidsdk.SiteVisitTracker;
import com.chartbeat.androidsdk.SubscriptionState;
import com.chartbeat.androidsdk.SystemUtils;
import com.chartbeat.androidsdk.UserInfo;
import com.chartbeat.androidsdk.ViewDimension;
import com.chartbeat.androidsdk.ViewTracker;
import java.lang.ref.WeakReference;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.TimeZone;
import rx.Observer;

final class ChartBeatTracker {
    private static final String TAG = ChartBeatTracker.class.getSimpleName();
    public static final String CHARTBEAT_PREFS = "com.chartbeat.androidsdk.user";
    private static final int SESSION_TOKEN_LENGTH = 30;
    private static final long MILLISECONDS_IN_ONE_SECOND = 1000L;
    private static final int PING_ENDPOINT_VERSION = 1;
    private static Handler handler;
    private static boolean firstPing;
    private static PingService pingService;
    private final WeakReference<Context> context;
    private final AppInfo appInfo;
    private final UserInfo userInfo;
    private final EngagementTracker engagementTracker;
    private final SiteVisitTracker siteVisitTracker;
    private String previousToken;
    private String externalReferrer;
    private ViewTracker currentViewTracker;
    private boolean isClientPaused = false;
    private PingParams pingParams;
    public static final boolean SIMULATE_VERY_SLOW_SERVER = false;
    private final PingManager pingManager;
    private long lastSuccessfulPingTime = 0L;
    private long lastDecayTime = 0L;
    private int sequentialErrors;

    ChartBeatTracker(WeakReference<Context> context, String accountID, String domain, String userAgent, Looper looper) {
        this.context = context;
        if (handler == null) {
            handler = new Handler(looper);
        }
        pingService = new PingService(userAgent);
        this.appInfo = new AppInfo((Context)context.get(), accountID, domain);
        this.userInfo = new UserInfo((Context)context.get());
        this.currentViewTracker = null;
        this.pingManager = new PingManager(this, looper);
        this.engagementTracker = new EngagementTracker();
        this.siteVisitTracker = new SiteVisitTracker((Context)context.get());
        this.pingParams = new PingParams();
        Logger.d(TAG, this.appInfo.toString());
    }

    synchronized void stopTracker() {
        this.pingManager.stop();
        this.engagementTracker.stop();
        this.isClientPaused = true;
    }

    synchronized void backgroundTracker() {
        this.pingManager.stop();
        this.engagementTracker.stop();
    }

    synchronized Boolean isClientPaused() {
        return this.isClientPaused;
    }

    synchronized void restartPinger() {
        if (!this.isClientPaused) {
            this.pingManager.restart();
        }
        this.pingParams.pingReset();
    }

    synchronized void setExternalReferrer(String externalReferrer) {
        this.externalReferrer = externalReferrer;
        if (this.currentViewTracker != null) {
            this.currentViewTracker.updateExternalReferrer(externalReferrer);
        }
        this.pingParams.addOneTimeParameter("r");
    }

    synchronized boolean isNotTrackingAnyView() {
        return this.currentViewTracker == null;
    }

    synchronized void trackViewImpl(String viewId, String viewTitle, int x, int w, int y, int o) {
        try {
            this.engagementTracker.userEnteredView();
            this.userInfo.visited();
            if (this.currentViewTracker == null || !this.currentViewTracker.isSameView(viewId)) {
                this.trackNewView(viewId, viewTitle, x, w, y, o);
                this.siteVisitTracker.trackSiteVisit(this.currentViewTracker.getExternalReferrer());
            } else {
                if (this.isClientPaused) {
                    this.pingManager.restart();
                }
                this.isClientPaused = false;
                if (this.userInfo.isNewUser() && this.currentViewTracker.wasReferredFromAnotherView()) {
                    this.userInfo.markUserAsOld();
                }
                this.pingManager.alive();
            }
        }
        catch (Exception e) {
            AwsLogger.getInstance().logError(e);
        }
    }

    private void trackNewView(String viewId, String viewTitle, int x, int w, int y, int o) {
        try {
            String domain = null;
            String subdomain = null;
            String internalReferrer = null;
            String externalReferrer = null;
            this.isClientPaused = false;
            if (this.externalReferrer != null) {
                externalReferrer = this.externalReferrer;
                this.externalReferrer = null;
            }
            if (this.currentViewTracker != null) {
                domain = this.currentViewTracker.getDomain();
                subdomain = this.currentViewTracker.getSubdomain();
                internalReferrer = this.currentViewTracker.getViewId();
                this.previousToken = this.currentViewTracker.getToken();
            }
            String generatedToken = SecurityUtils.randomChars(30);
            ViewDimension viewDimension = new ViewDimension(x, w, y, o, x);
            this.currentViewTracker = new ViewTracker(viewId, viewTitle, domain, subdomain, internalReferrer, externalReferrer, generatedToken, viewDimension);
            this.pingParams.newView();
            Logger.d(TAG, this.appInfo.toString() + " :: TRACK VIEW :: " + viewId);
            this.pingParams.addOneTimeParameter("D");
            this.pingParams.addOneTimeParameter("x");
            this.pingParams.addOneTimeParameter("y");
            this.pingParams.addOneTimeParameter("w");
            this.pingParams.addOneTimeParameter("o");
            this.pingParams.addOneTimeParameter("m");
            this.pingManager.restart();
        }
        catch (Exception e) {
            AwsLogger.getInstance().logError(e);
        }
    }

    synchronized void userInteractedImpl() {
        this.engagementTracker.userEngaged();
        this.userInfo.visited();
        this.pingManager.alive();
        Logger.d(TAG, this.appInfo.toString() + " :: USER INTERACTED");
    }

    synchronized void userTypedImpl() {
        this.engagementTracker.userTyped();
        this.userInfo.visited();
        this.pingManager.alive();
        Logger.d(TAG, this.appInfo.toString() + " :: USER TYPED");
    }

    synchronized void userLeftViewImpl(String viewId) {
        this.pingManager.setInBackground(true);
        this.engagementTracker.userLeftView();
        Logger.d(TAG, this.appInfo.toString() + " :: USER LEFT");
    }

    synchronized void updateSubscriptionState(SubscriptionState subState) {
        this.userInfo.setSubscriptionState(subState);
    }

    synchronized void updateViewDimensions(int scrollPositionTop, int scrollWindowHeight, int totalContentHeight, int fullyRenderedDocWidth) {
        this.currentViewTracker.updateDimension(scrollPositionTop, scrollWindowHeight, totalContentHeight, fullyRenderedDocWidth);
        this.pingParams.addOneTimeParameter("x");
        this.pingParams.addOneTimeParameter("y");
        this.pingParams.addOneTimeParameter("w");
        this.pingParams.addOneTimeParameter("o");
        this.pingParams.addOneTimeParameter("m");
        this.pingManager.alive();
    }

    synchronized void updateSubdomain(String subdomain) {
        this.currentViewTracker.updateSubdomain(subdomain);
        this.pingManager.alive();
    }

    synchronized void updateDomain(String domain) {
        this.currentViewTracker.updateDomain(domain);
        this.pingManager.alive();
    }

    synchronized void updateExternalReferrer(String externalReferrer) {
        this.currentViewTracker.updateExternalReferrer(externalReferrer);
        this.pingManager.alive();
    }

    synchronized void updateInternalReferrer(String internalReferrer) {
        this.currentViewTracker.updateInternalReferrer(internalReferrer);
        this.pingManager.alive();
    }

    synchronized void updateZones(String zones) {
        this.currentViewTracker.updateZones(zones);
        this.pingParams.addOneTimeParameter("g2");
        this.pingManager.alive();
    }

    synchronized void updateSections(String sections) {
        this.currentViewTracker.updateSections(sections);
        this.pingParams.addOneTimeParameter("g0");
        this.pingManager.alive();
    }

    synchronized void updateAuthors(String authors) {
        this.currentViewTracker.updateAuthors(authors);
        this.pingParams.addOneTimeParameter("g1");
        this.pingManager.alive();
    }

    synchronized void updatePageLoadingTime(float pageLoadTime) {
        this.currentViewTracker.updatePageLoadingTime(pageLoadTime);
        this.pingManager.alive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void ping(boolean needsFullPingHint, String decay) {
        block21: {
            try {
                EngagementTracker.EngagementSnapshot engagementSnapshot;
                LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>(30);
                ChartBeatTracker chartBeatTracker = this;
                synchronized (chartBeatTracker) {
                    if (this.currentViewTracker == null) {
                        return;
                    }
                    if (needsFullPingHint) {
                        this.pingParams.pingReset();
                    }
                    if (this.currentViewTracker.getDomain() != null) {
                        this.addParameterIfRequired(parameters, "h", this.currentViewTracker.getDomain());
                    } else {
                        this.addParameterIfRequired(parameters, "h", this.appInfo.getDomain());
                    }
                    this.addParameterIfRequired(parameters, "p", this.currentViewTracker.getViewId());
                    this.addParameterIfRequired(parameters, "u", this.userInfo.getUserID());
                    if (this.currentViewTracker.getSubdomain() != null) {
                        this.addParameterIfRequired(parameters, "d", this.currentViewTracker.getSubdomain());
                    } else {
                        this.addParameterIfRequired(parameters, "d", this.appInfo.getDomain());
                    }
                    this.addParameterIfRequired(parameters, "g", this.appInfo.getAccountID());
                    if (this.userInfo.getSubscriptionState() != null) {
                        this.addParameterIfRequired(parameters, "_acct", this.userInfo.getSubscriptionState().toString());
                    }
                    this.addParametersIfRequired(parameters, this.currentViewTracker.getContentParams());
                    this.addParameterIfRequired(parameters, "n", this.userInfo.isNewUser() ? "1" : "0");
                    this.addParameterIfRequired(parameters, "f", this.userInfo.getUserVisitFrequencyString());
                    this.addParameterIfRequired(parameters, "c", this.currentViewTracker.getMinutesInView());
                    this.addParametersIfRequired(parameters, this.currentViewTracker.getDimensionParams());
                    this.addParameterIfRequired(parameters, "j", decay);
                    engagementSnapshot = this.engagementTracker.getEngagementSnapshot();
                    parameters.put("R", engagementSnapshot.reading ? "1" : "0");
                    parameters.put("W", engagementSnapshot.typed ? "1" : "0");
                    parameters.put("I", engagementSnapshot.idle ? "1" : "0");
                    parameters.put("E", String.valueOf(engagementSnapshot.totalEngagement));
                    parameters.put("e", String.valueOf(engagementSnapshot.engagementSinceLastPing));
                    if (this.currentViewTracker.getInternalReferrer() != null) {
                        this.addParameterIfRequired(parameters, "v", this.currentViewTracker.getInternalReferrer());
                    }
                    if (this.currentViewTracker.getExternalReferrer() != null) {
                        this.addParameterIfRequired(parameters, "r", this.currentViewTracker.getExternalReferrer());
                    }
                    if (this.currentViewTracker.getInternalReferrer() == null && this.currentViewTracker.getExternalReferrer() == null) {
                        this.addParameterIfRequired(parameters, "r", "");
                    }
                    this.addParameterIfRequired(parameters, "t", this.currentViewTracker.getToken());
                    this.addParameterIfRequired(parameters, "V", this.appInfo.getSdkVersion());
                    if (this.previousToken != null) {
                        this.addParameterIfRequired(parameters, "D", this.previousToken);
                    }
                    this.lastDecayTime = (long)(this.pingManager.expectedNextIntervalInSeconds() * 2) * 1000L;
                    this.addParameterIfRequired(parameters, "i", this.currentViewTracker.getViewTitle());
                    int timezoneOffset = -(TimeZone.getDefault().getOffset(new Date().getTime()) / 1000 / 60);
                    parameters.put("tz", String.valueOf(timezoneOffset));
                    this.addParameterIfRequired(parameters, "S", this.appInfo.getDeviceScreenWidth());
                    this.addParameterIfRequired(parameters, "Z", String.valueOf(1));
                    if (this.siteVisitTracker.getSiteVisitDepth() > 0) {
                        this.addParameterIfRequired(parameters, "sr", this.siteVisitTracker.getSiteVisitReferrer());
                        this.addParameterIfRequired(parameters, "sd", Integer.toString(this.siteVisitTracker.getSiteVisitDepth()));
                        this.addParameterIfRequired(parameters, "sv", this.siteVisitTracker.getSiteVisitId());
                    }
                    parameters.put("_", "");
                    Logger.d(TAG, "PING! User Data: " + parameters);
                }
                if (SystemUtils.isNetworkAvailable((Context)this.context.get())) {
                    pingService.ping(parameters).subscribe((Observer)new Observer<Integer>(){

                        public void onCompleted() {
                        }

                        public void onError(final Throwable e) {
                            if (handler.getLooper().getThread().isAlive()) {
                                handler.post(new Runnable(){

                                    @Override
                                    public void run() {
                                        ChartBeatTracker.this.handlePingError(e.getLocalizedMessage(), engagementSnapshot);
                                    }
                                });
                            }
                        }

                        public void onNext(final Integer code) {
                            if (handler.getLooper().getThread().isAlive()) {
                                handler.post(new Runnable(){

                                    @Override
                                    public void run() {
                                        ChartBeatTracker.this.handlePingResponseCode(code, engagementSnapshot);
                                    }
                                });
                            }
                        }
                    });
                    break block21;
                }
                chartBeatTracker = this;
                synchronized (chartBeatTracker) {
                    Logger.e(TAG, "Not pinging: no network connection detected.");
                    this.pingParams.pingReset();
                    this.engagementTracker.lastPingFailed(engagementSnapshot);
                }
            }
            catch (Exception e) {
                AwsLogger.getInstance().logError(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handlePingResponseCode(int code, EngagementTracker.EngagementSnapshot engagementSnapshot) {
        try {
            ChartBeatTracker chartBeatTracker = this;
            synchronized (chartBeatTracker) {
                if (handler.getLooper().getThread().isAlive()) {
                    boolean isInBackground;
                    try {
                        isInBackground = ForegroundTracker.get().isInBackground();
                    }
                    catch (IllegalStateException e) {
                        return;
                    }
                    this.pingParams.pingComplete(code);
                    this.sequentialErrors = code == 503 ? ++this.sequentialErrors : 0;
                    if (this.sequentialErrors == 3) {
                        this.sequentialErrors = 0;
                        this.pingParams.pingError();
                        this.pingManager.suspendDueToServerBusy();
                    }
                    this.pingManager.setInBackground(isInBackground);
                    if (code == 500 || code == 400 || code == 202) {
                        this.engagementTracker.lastPingFailed(engagementSnapshot);
                        this.pingManager.retryImmediately();
                    }
                    if (code == 200) {
                        this.lastSuccessfulPingTime = System.currentTimeMillis();
                        if (firstPing) {
                            firstPing = false;
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            AwsLogger.getInstance().logError(e);
        }
    }

    private void handlePingError(String errorMessage, EngagementTracker.EngagementSnapshot engagementSnapshot) {
        this.pingParams.pingError();
        Logger.e(TAG, "Error pinging Chartbeat: " + errorMessage);
        this.engagementTracker.lastPingFailed(engagementSnapshot);
    }

    private synchronized void addParametersIfRequired(LinkedHashMap<String, String> parameters, LinkedHashMap<String, String> additionalParameters) {
        for (String key : additionalParameters.keySet()) {
            this.addParameterIfRequired(parameters, key, additionalParameters.get(key));
        }
    }

    private synchronized void addParameterIfRequired(LinkedHashMap<String, String> parameters, String key, String value) {
        if (key != null && value != null) {
            this.addParameterIfRequired(parameters, this.pingParams, key, value);
        }
    }

    private synchronized void addParameterIfRequired(LinkedHashMap<String, String> parameters, PingParams pingInfo, String key, String value) {
        if (pingInfo.includeParameter(key)) {
            parameters.put(key, value);
        }
    }

    static {
        firstPing = true;
    }
}

