/*
 * Decompiled with CFR 0.152.
 */
package com.chartbeat.androidsdk;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.os.Build;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.CognitoCachingCredentialsProvider;
import com.amazonaws.mobileconnectors.s3.transferutility.TransferListener;
import com.amazonaws.mobileconnectors.s3.transferutility.TransferObserver;
import com.amazonaws.mobileconnectors.s3.transferutility.TransferState;
import com.amazonaws.mobileconnectors.s3.transferutility.TransferUtility;
import com.amazonaws.regions.Region;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3Client;
import com.chartbeat.androidsdk.Logger;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import org.json.JSONObject;

public class AwsLogger {
    private String DEFAULT_BUCKET = "chartbeat-sdk";
    private String IDENTITYPOOLID = "us-east-1:89109093-5e56-4960-928b-5edc0e63a985";
    private Regions S3__REGIONS = Regions.US_EAST_1;
    private Regions IDENTITY_POOL_REGIONS = Regions.US_EAST_1;
    private TransferUtility transferUtility;
    private String cacheDirectory = "";
    private static AwsLogger single_instance = null;
    private String accountId = "";
    private String domain = "";
    private String version_code = "";
    private String version_name = "";
    private String sdk_version_code = "";
    private String sdk_version_name = "";
    private String os_version = "";
    private String manufacturer = "";
    private String model = "";
    private String hardware = "";
    private String codename = "";
    private String sdk_int = "";
    private String incremental = "";
    private String release = "";
    private String security_patch = "";

    private AwsLogger(Context context, String accountId, String domain) {
        this.accountId = accountId;
        this.domain = domain;
        CognitoCachingCredentialsProvider credentialsProvider = new CognitoCachingCredentialsProvider(context, this.IDENTITYPOOLID, this.IDENTITY_POOL_REGIONS);
        AmazonS3Client s3 = new AmazonS3Client((AWSCredentialsProvider)credentialsProvider);
        s3.setRegion(Region.getRegion((Regions)this.S3__REGIONS));
        this.transferUtility = TransferUtility.builder().context(context).s3Client((AmazonS3)s3).defaultBucket(this.DEFAULT_BUCKET).build();
        try {
            PackageInfo pInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
            String versionName = pInfo.versionName;
            int versionCode = pInfo.versionCode;
            this.setVersion_code(versionCode + "");
            this.setVersion_name(versionName);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setSdk_Version_code("12");
        this.setSdk_Version_name("2.0");
        this.setOs_version(System.getProperty("os.version"));
        this.setManufacturer(Build.MANUFACTURER);
        this.setModel(Build.MODEL);
        this.setHardware(Build.HARDWARE);
        this.setSdk_int(Build.VERSION.SDK_INT + "");
        this.setCodename(Build.VERSION.CODENAME);
        this.setIncremental(Build.VERSION.INCREMENTAL);
        this.setRelease(Build.VERSION.RELEASE);
        if (Build.VERSION.SDK_INT > 22) {
            this.setSecurity_patch(Build.VERSION.SECURITY_PATCH);
        }
        this.setCacheDirectory(context.getCacheDir().getPath());
    }

    public static AwsLogger initInstance(Context context, String accountId, String domain) {
        if (single_instance == null) {
            single_instance = new AwsLogger(context, accountId, domain);
        }
        return single_instance;
    }

    public static AwsLogger getInstance() {
        if (single_instance == null) {
            throw new NullPointerException("AwsLogger not initialized.  Call initInstance");
        }
        return single_instance;
    }

    private String getFileName() {
        if (this.domain == "") {
            this.domain = "no_domain";
        }
        if (this.accountId == "") {
            this.accountId = "no_accountId";
        }
        String basePath = "andoroid_sdk/" + this.domain + "/" + this.accountId + "/exceptions/";
        Date date = new Date();
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int year = cal.get(1);
        int month = cal.get(2) + 1;
        int day = cal.get(5);
        int hour = cal.get(11);
        int min = cal.get(12);
        String minstr = "00";
        if (min >= 30) {
            minstr = "30";
        }
        basePath = basePath + year + "/" + month + "/" + day + "/" + hour + "/" + minstr + "/" + System.currentTimeMillis() + "_" + this.accountId + ".json";
        return basePath;
    }

    private File getLogFile(Exception e) {
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        String exceptionAsString = sw.toString();
        Date date = new Date();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("APP_VERSION_CODE", this.version_code);
        map.put("APP_VERSION_NAME", this.version_name);
        map.put("SDK_VERSION_CODE", this.sdk_version_code);
        map.put("SDK_VERSION_NAME", this.sdk_version_name);
        map.put("os.version", this.os_version);
        map.put("MANUFACTURER", this.manufacturer);
        map.put("MODEL", this.model);
        map.put("HARDWARE", this.hardware);
        map.put("SDK_INT", this.sdk_int);
        map.put("CODENAME", this.codename);
        map.put("INCREMENTAL", this.incremental);
        map.put("RELEASE", this.release);
        map.put("SECURITY_PATCH", this.security_patch);
        map.put("EXCEPTION DATE", date);
        map.put("EXCEPTION", exceptionAsString);
        JSONObject json = new JSONObject(map);
        String text = json.toString();
        File tempFile = new File(this.cacheDirectory + System.currentTimeMillis() + "_tmp.json");
        try {
            FileWriter writer = null;
            writer = new FileWriter(tempFile);
            writer.write(text);
            writer.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return tempFile;
    }

    public void logError(Exception e) {
        try {
            final File errorLog = this.getLogFile(e);
            TransferObserver uploadObserver = this.transferUtility.upload(this.DEFAULT_BUCKET, this.getFileName(), errorLog);
            uploadObserver.setTransferListener(new TransferListener(){

                public void onStateChanged(int id, TransferState state) {
                    if (TransferState.COMPLETED == state) {
                        Logger.d("AWS Logger", "Upload to S3 completed");
                        errorLog.delete();
                    }
                }

                public void onProgressChanged(int id, long bytesCurrent, long bytesTotal) {
                }

                public void onError(int id, Exception ex) {
                    ex.printStackTrace();
                }
            });
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public String getCacheDirectory() {
        return this.cacheDirectory;
    }

    public void setCacheDirectory(String cacheDirectory) {
        this.cacheDirectory = cacheDirectory;
    }

    public void setVersion_code(String version_code) {
        this.version_code = version_code;
    }

    public void setVersion_name(String version_name) {
        this.version_name = version_name;
    }

    public void setSdk_Version_code(String version_code) {
        this.sdk_version_code = version_code;
    }

    public void setSdk_Version_name(String version_name) {
        this.sdk_version_name = version_name;
    }

    public void setOs_version(String os_version) {
        this.os_version = os_version;
    }

    public void setManufacturer(String manufacturer) {
        this.manufacturer = manufacturer;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public void setHardware(String hardware) {
        this.hardware = hardware;
    }

    public void setCodename(String codename) {
        this.codename = codename;
    }

    public void setSdk_int(String sdk_int) {
        this.sdk_int = sdk_int;
    }

    public void setIncremental(String incremental) {
        this.incremental = incremental;
    }

    public void setRelease(String release) {
        this.release = release;
    }

    public void setSecurity_patch(String security_patch) {
        this.security_patch = security_patch;
    }
}

